// This is a wrapper over canvas that adds our own drawing functions.
class Stylus extends SLInfo;

var Canvas c;
var int xoff, yoff;
// Center x and y coords.
var float cx, cy;
var float clipx, clipy;

// Resets the canvas. Stores center coords. Checks for a resize.
function bool setCanvas(Canvas newc) 
{
	local bool resized;

	c = newc;
	cx = c.clipx / 2;
	cy = c.clipy / 2;

	resized = !(clipx == c.clipx);
	clipx = c.clipx;
	clipy = c.clipy;
	return resized;
}

function setOffsets(int x, int y) 
{
	xoff = x;
	yoff = y;
}

/** Styles:

	0: normal.
	1: rounded.
	2: missing upper right wing.
	3: missing lower right wing.
	4: No top or bot lines.
	5: No right side.
*/
function drawFrame(int x, int y, int w, int h, optional int style, optional bool fill, optional bool truexy) 
{
	local int re;

	if (style == 1)
		re = w - 2;
	else
		re = w - 1;

	setPos(x + 1, y, truexy);
	if (style == 4) 
	{
		pix(1, 1);
		setPos(x + w - 1, y, truexy);
		pix(1, 1);
		setPos(x + 1, y + h - 1, truexy);
		pix(1, 1);
		setPos(x + w - 1, y + h - 1, truexy);
		pix(1, 1);
	} 
	else 
	{
		if (style == 2)
			re--;
		pix(re, 1);
		if (style == 2)
			re++;

		setPos(x + 1, y + h - 1, truexy);
		if (style == 3)
			re--;
		pix(re, 1);
	}

	setPos(x, y + 1, truexy);
	if (style == 1)
		re = w;
	else
		re = w - 1;

	if (fill) 
		pix(re, h - 2);
	else
	{
		pix(1, h - 2);
		if (style != 5) 
		{
			setPos(x + re - 1, y + 1, truexy);
			pix(1, h - 2);
		}
	}
}

// Fill wrapper.
function pix(int w, int h) 
{
	c.drawRect(Texture'SLV2Textures.slhud.levelpixel', w, h);
}

// Set position with offsets.
function setPos(int x, int y, optional bool truexy) 
{
	if (truexy) 
		c.setPos(x, y);
	else c.setPos(x + xoff, y + yoff);
}


// We don't normally want text to wrap, so we make a wrapper for	drawText().
function drawText(coerce string text) 
{
	if (c.curx < c.clipx ) 
		c.drawTextClipped(text);
}

// Return the line height.
function float lineh() 
{
	local float xl, yl;

	c.textSize("TEST", xl, yl);
	return yl;
}

// Return the string width.
function float strw(String s) 
{
	local float xl, yl;

	c.textSize(s, xl, yl);
	return xl;
}

function Color blendc(Color c1, Color c2, float x) 
{
	local Color newc;

	if (x > 1.0)
		x = 1.0;

	newc = c1 * (1.0 - x) + c2 * x;
	return newc;
}

defaultproperties
{
}
