// Bits 'o rocket.
class Wreckage extends EjectedBrass;

#exec OBJ LOAD FILE=..\System\SLV2Models.u PACKAGE=SLV2Models

var() Mesh chunks[8];
var bool smokin;
var() Class<Effects> smokeClass;

simulated function postBeginPlay() 
{
	// No detail drop.
	mesh = chunks[rand(8)];
	drawScale = 1.0 + (frand() * 2.0);

	smokin = true;
	setTimer(0.01, false);
}

simulated function hitWall(vector hn, Actor wall) 
{
	local DirectionalBlast db;

	super.hitWall(hn, wall);
	// Spawn some marks of our passage.
	if (!level.bDropDetail && level.netmode != NM_DedicatedServer) 
	{
		db = spawn(Class'DScar', self);
		if (db != none) 
		{
			db.drawScale = drawScale * 0.25 + 0.25 * frand();
			db.directionalAttach(velocity, hn);
		}
	}
}

simulated function landed(vector hn) 
{
	// Clear smoke timer.
	smokin = false;
	setTimer(0.0, false);
	super.landed(hn);
}

simulated function timer() 
{
	local Effects puff;

	if (smokin) 
	{
		if (!level.bDropDetail)
		{
			puff = spawn(smokeClass,,, location + vrand() * 15);

			if (puff != None)
				puff.drawScale += (lifespan / default.lifespan) - 1.2 * frand();
		}
		if (vsize(velocity) != 0)
			// The faster we're going, the faster we emit smoke.
			setTimer(fmax(0.9 - vsize(velocity) / 600.0, 0.01), false);
	}
	else super.timer();
}

defaultproperties
{
   chunks(0)=SkeletalMesh'SLV2Models.Chunk1'
   chunks(1)=SkeletalMesh'SLV2Models.Chunk2'
   chunks(2)=SkeletalMesh'SLV2Models.Chunk3'
   chunks(3)=SkeletalMesh'SLV2Models.Chunk4'
   chunks(4)=SkeletalMesh'SLV2Models.chunk5'
   chunks(5)=SkeletalMesh'SLV2Models.chunk6'
   chunks(6)=SkeletalMesh'SLV2Models.chunk7'
   chunks(7)=SkeletalMesh'SLV2Models.chunk8'
   bLevel=False
   sinkfudge=40.000000
   HitSounds(0)=Sound'Bounce1'
   HitSounds(1)=Sound'bounce21'
   HitSounds(2)=Sound'bounce31'
   HitSounds(3)=Sound'bounce41'
   HitSounds(4)=Sound'bounce51'
   Num=5
   RemoteRole=ROLE_None
   LifeSpan=5.000000
   Mesh=SkeletalMesh'SLV2Models.Chunk1'
   CollisionRadius=6.000000
   CollisionHeight=6.000000
}
