class XSFRed expands Projectile;

var() byte Team;
var() int Pos, MaxTrails;		// Position in trail & maximum number of trails
var() XSFRed Next;		// Next part of the trail, Owner is used to keep track of previous part of trail
var() float lagBy;		// Time delay to lag the trail updating by
var() float cntr;
var() class<XSFRed>XSFRedClass;	// What to Spawn as trails
var() vector TrailOffset; 	// Location on a cylinder around the object being trailed that trail should appear from
				// X = radius, Y = elevation, Z = angle, e.g. 10UUs directly behind at same Level would be vector(10,0,180)

replication 
{
	reliable if (role == ROLE_Authority)
		Team;

   unreliable if (Role == ROLE_Authority && bNetOwner)
     Pos;
}

simulated function Destroyed()		// Make sure the whole trail gets Destroyed at once
{
  Super.Destroyed();

  if (Next != None)
    Next.Destroy();
}

simulated function Update()	// Update the trailer
{
	local vector Offset;
  	local float Alpha, X, Y;

   if (Next != None)		 // Call Update() on next trail
    	Next.Update();

  	if (Pos == 0)		 // Move to where the previous part of the trail was (or player location for that matter)
  	{
    	Alpha = Owner.Rotation.Yaw / 10430.2192;		  // Convert Owner horizontal Rotation into radians
    	Alpha += (TrailOffset.Z / 180 * Pi);		  // Rotate it through TrailOffset.Z
    	if (Alpha > 2 * Pi)
      	Alpha -= 2 * Pi;

    	X = TrailOffset.X * Cos(Alpha);		 // Calculate cylinder coordinates
    	Y = TrailOffset.X * Sin(Alpha);
    	Offset.X = X;
    	Offset.Y = Y;
    	Offset.Z = TrailOffset.Y;
    	SetLocation(Owner.Location + Offset);
  	}
  	else
  		SetLocation(Owner.Location);
  	SetRotation(Owner.Rotation);

  	if (Pos < MaxTrails && Next == None)		// Spawn additional trails as necessary
  	{
  	 	Next = Spawn(XSFRedClass, self,, Location, Rotation);
  		Next.Pos = Pos + 1;
  	}
}

simulated function Tick(float DeltaTime)	// Handle updating of trail location
{
  	// Destroy if there's no owner
  	if (Owner == None)
    	Destroy();

  	if (Pos > 0)						 // First trail should tell next trail to update & so on
    	return;

  	cntr += DeltaTime;

  	if (cntr >= lagBy)					// Lag location update by lagBy ticks
  	{
    	cntr = 0.0;
    	Update();
  	}
}

defaultproperties
{
   XSFRedClass=Class'XSFRed'
   bOnlyOwnerSee=True
   bNetTemporary=False
   RemoteRole=ROLE_SimulatedProxy
   LifeSpan=0.000000
   Style=STY_Translucent
   Texture=None
   Mesh=JetXRed
   DrawScale=3.000000
   AmbientGlow=75
   bGameRelevant=False
   bCollideActors=False
   bCollideWorld=False
   bFixedRotationDir=True
   NetPriority=3.000000
   Texture=XShinyWindowRed
}
