class vxFragAknMessage extends LocalMessagePlus;

#exec AUDIO IMPORT NAME="XSlaughter" FILE=SOUNDS\XSlaughter.wav GROUP="FragAkn"
#exec AUDIO IMPORT NAME="XBloodbath" FILE=SOUNDS\XBloodbath.wav GROUP="FragAkn"
#exec AUDIO IMPORT NAME="XAnnhilation" FILE=SOUNDS\XAnnhilation.wav GROUP="FragAkn"
#exec AUDIO IMPORT NAME="XErradication" FILE=SOUNDS\XErradication.wav GROUP="FragAkn"
#exec AUDIO IMPORT NAME="XExtermination" FILE=SOUNDS\XExtermination.wav GROUP="FragAkn"
#exec AUDIO IMPORT NAME="XTermination" FILE=SOUNDS\XTermination.wav GROUP="FragAkn"

var(Messages)   localized string    SlaughterString;
var(Messages)   localized string    BloodbathString;
var(Messages)   localized string    AnnhilationString;
var(Messages)   localized string    ErradicationString;
var(Messages)   localized string    ExterminationString;
var(Messages)   localized string    TerminationString;

static function float GetOffset(int Switch, float YL, float ClipY )
{
   return (Default.YPos/768.0) * ClipY - 3*YL;
}

static function string GetString(optional int Switch,optional PlayerReplicationInfo RelatedPRI_1,
   optional PlayerReplicationInfo RelatedPRI_2,optional Object OptionalObject)
{
   switch (Switch)
   {
      case 1:
         return Default.SlaughterString;
      break;
	
		case 2:
         return Default.BloodbathString;
      break;
	
		case 3:
         return Default.AnnhilationString;
      break;
	
		case 4:
         return Default.ErradicationString;
      break;
	
		case 5:
         return Default.ExterminationString;
      break;
	
		case 6:
         return Default.TerminationString;
      break;
   }
   return "";
}

static simulated function ClientReceive( PlayerPawn P,optional int Switch,optional PlayerReplicationInfo RelatedPRI_1,
   optional PlayerReplicationInfo RelatedPRI_2,optional Object OptionalObject)
{
   Super.ClientReceive(P, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);

   switch (Switch)
   {
      case 1:
         P.ClientPlaySound(sound'XSlaughter',, true);
      break;
		
		case 2:
      	P.ClientPlaySound(sound'XBloodbath',, true);
      break;
		
		case 3:
         P.ClientPlaySound(sound'XAnnhilation',, true);
      break;
		
		case 4:
         P.ClientPlaySound(sound'XErradication',, true);
      break;
		
		case 5:
         P.ClientPlaySound(sound'XExtermination',, true);
      break;
	
		case 6:
         P.ClientPlaySound(sound'XTermination',, true);
      break;
   }
}

defaultproperties
{
	bFadeMessage=True
 	bIsSpecial=True
	bIsUnique=True
	Lifetime=3
	bBeep=False
	DrawColor=(R=255,G=128,B=0)
	bCenter=True
	FontSize=2
	YPos=196
	SlaughterString="- = SLauGHTeR = -"
	BloodbathString="- = BLooDBaTH = -"
	AnnhilationString="- = ANNHILATION = -"
	ErradicationString="- ! ERRADICATION ! -"
	ExterminationString="- = E X T E R M I N A T I O N = -"
	TerminationString="- ! T E R M I N A T I O N ! -"
}
