class vxMultiKillMessage extends LocalMessagePlus;

#exec AUDIO IMPORT NAME="TripleKill" FILE=SOUNDS\TripleKill.wav GROUP="SpecialAnnouncer"
#exec AUDIO IMPORT NAME="MegaKill" FILE=SOUNDS\MegaKill.wav GROUP="SpecialAnnouncer"
#exec AUDIO IMPORT NAME="LudicrousKill" FILE=SOUNDS\LudicrousKill.wav GROUP="SpecialAnnouncer"
#exec AUDIO IMPORT NAME="HolyShit" FILE=SOUNDS\HolyShit.wav GROUP="SpecialAnnouncer"

var(Messages)   localized string    DoubleKillString;
var(Messages)   localized string    TripleKillString;
var(Messages)   localized string    MultiKillString;
var(Messages)   localized string    MegaKillString;
var(Messages)   localized string    UltraKillString;
var(Messages)   localized string    MonsterKillString;
var(Messages)   localized string    LudicrousKillString;
var(Messages)   localized string    HolyShitString;


static function float GetOffset(int Switch, float YL, float ClipY )
{
   return (Default.YPos/768.0) * ClipY + YL;
}

static function int GetFontSize( int Switch )
{
   if ( Switch > 0 && Switch < 3)
      return Default.FontSize;
   else
      return 2;
}

static function string GetString(optional int Switch,optional PlayerReplicationInfo RelatedPRI_1,
   optional PlayerReplicationInfo RelatedPRI_2,optional Object OptionalObject)
{
	if (Switch > 0)
	{
    	switch (Switch)
    	{
        	case 1:
         	return Default.DoubleKillString;
         break;
			
			case 2:
            return Default.TripleKillString;
         break;
        	
			case 3:
            return Default.MultiKillString;
         break;
			
			case 4:
            return Default.MegaKillString;
         break;
        	
			case 5:
            return Default.UltraKillString;
         break;
			
			case 6:
            return Default.MonsterKillString;
         break;
			
			case 7:
            return Default.LudicrousKillString;
         break;
			
			default:
            return Default.HolyShitString;
         break;
    	}
	}
   return "";
}

static simulated function ClientReceive( PlayerPawn P,optional int Switch,optional PlayerReplicationInfo RelatedPRI_1,
   optional PlayerReplicationInfo RelatedPRI_2,optional Object OptionalObject)
{
   Super.ClientReceive(P, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);

	if (Switch > 0)
	{
    	switch (Switch)
    	{
        	case 1:
            P.ClientPlaySound(sound'Announcer.DoubleKill',, true);
         break;
        	
			case 2:
	    		P.ClientPlaySound(sound'TripleKill',, true);
         break;
 			
			 case 3:
            P.ClientPlaySound(sound'Announcer.MultiKill',, true);
         break;
			
			case 4:
            P.ClientPlaySound(sound'MegaKill',, true);
         break;
        	
			case 5:
            P.ClientPlaySound(sound'Announcer.UltraKill',, true);
         break;
        	
			case 6:
            P.ClientPlaySound(sound'Announcer.MonsterKill',, true);
         break;
			
			case 7:
	    		P.ClientPlaySound(sound'LudicrousKill',, true);
         break;
			
			default:
            P.ClientPlaySound(sound'HolyShit',, true);
         break;
    	}
	}
}

defaultproperties
{
	bFadeMessage=True
 	bIsSpecial=True
	bIsUnique=True
	Lifetime=3
	bBeep=False
	DrawColor=(R=255,G=0,B=0)
	bCenter=True
	FontSize=1
	YPos=196
	DoubleKillString="Double Kill!"
	TripleKillString="Triple Kill!"
	MultiKillString="Multi Kill!"
	MegaKillString="MEGA Kill!!"
	UltraKillString="ULTRA KILL!!"
	MonsterKillString="M O N S T E R  K I L L !!!"
	LudicrousKillString="L U D I C R O U S  K I L L !!!"
	HolyShitString="! ! !  H O L Y  S H I T  ! ! !"
}
