class vxSpecialFragEvent extends LocalMessagePlus;

#exec AUDIO IMPORT NAME="BurnOut" FILE=SOUNDS\BurnOut.wav GROUP="SpecialFrags"
#exec AUDIO IMPORT NAME="CannonBall" FILE=SOUNDS\CannonBall.wav GROUP="SpecialFrags"
#exec AUDIO IMPORT NAME="EagleEye" FILE=SOUNDS\EagleEye.wav GROUP="SpecialFrags"
#exec AUDIO IMPORT NAME="Ginsu" FILE=SOUNDS\Ginsu.wav GROUP="SpecialFrags"
#exec AUDIO IMPORT NAME="HitAndRun" FILE=SOUNDS\HitAndRun.wav GROUP="SpecialFrags"
#exec AUDIO IMPORT NAME="Instagib" FILE=SOUNDS\Instagib.wav GROUP="SpecialFrags"
#exec AUDIO IMPORT NAME="LockAndLoad" FILE=SOUNDS\LockAndLoad.wav GROUP="SpecialFrags"
#exec AUDIO IMPORT NAME="LockOn" FILE=SOUNDS\LockOn.wav GROUP="SpecialFrags"
#exec AUDIO IMPORT NAME="Ownage" FILE=SOUNDS\Ownage.wav GROUP="SpecialFrags"
#exec AUDIO IMPORT NAME="Pancake" FILE=SOUNDS\Pancake.wav GROUP="SpecialFrags"
#exec AUDIO IMPORT NAME="Rage" FILE=SOUNDS\Rage.wav GROUP="SpecialFrags"
#exec AUDIO IMPORT NAME="TopGun" FILE=SOUNDS\TopGun.wav GROUP="SpecialFrags"
#exec AUDIO IMPORT NAME="ComboWhore" FILE=SOUNDS\ComboWhore.wav GROUP="SpecialFrags"
#exec AUDIO IMPORT NAME="Denied" FILE=SOUNDS\Denied.wav GROUP="SpecialFrags"
#exec AUDIO IMPORT NAME="Silencer" FILE=SOUNDS\Silencer.wav GROUP="SpecialFrags"

var(Messages)   localized string    BurnOutString;
var(Messages)   localized string    CannonBallString;
var(Messages)   localized string    EagleEyeString;
var(Messages)   localized string    GinsuString;
var(Messages)   localized string    HitAndRunString;
var(Messages)   localized string    InstagibString;
var(Messages)   localized string    LockAndLoadString;
var(Messages)   localized string    LockOnString;
var(Messages)   localized string    OwnageString;
var(Messages)   localized string    PancakeString;
var(Messages)   localized string    RageString;
var(Messages)   localized string    TopGunString;
var(Messages)   localized string    ComboString;
var(Messages)   localized string    DeniedString;
var(Messages)   localized string    SilencerString;


static function float GetOffset(int Switch, float YL, float ClipY )
{
   return (Default.YPos/768.0) * ClipY + 2*YL;
}

static function string GetString
(
   optional int Switch,
   optional PlayerReplicationInfo RelatedPRI_1,
   optional PlayerReplicationInfo RelatedPRI_2,
   optional Object OptionalObject
)
{
	if (class'Strangemutator'.default.enableSpecialFragEvents)
	{
    	switch (Switch)
    	{
        	case 1:
	    	if (class'Strangemutator'.default.bBurnOutEvent)
            return Default.BurnOutString;
         break;

			case 2:
	   	if (class'Strangemutator'.default.bCannonBallEvent)
            return Default.CannonBallString;
         break;

        	case 3:
	    	if (class'Strangemutator'.default.bEagleEyeEvent)
           	return Default.EagleEyeString;
         break;

			case 4:
	    	if (class'Strangemutator'.default.bBurnOutEvent)
            return Default.GinsuString;
         break;

        	case 5:
	    	if (class'Strangemutator'.default.bHitNRunEvent)
	    		return Default.HitAndRunString;
         break;

		  	case 6:
	    	if (class'Strangemutator'.default.bHitNRunEvent)
	    		return Default.PancakeString;
         break;
        
		  	case 7:
		 	if (class'Strangemutator'.default.bHitNRunEvent)
	    		return Default.RageString;
         break;
	
			case 8:
	    	if (class'Strangemutator'.default.bInstagibEvent)
            return Default.InstagibString;
         break;
	
			case 9:
	    	if (class'Strangemutator'.default.bLockOnEvent)
	   		return Default.LockAndLoadString;
         break;
	
			case 10:
	    	if (class'Strangemutator'.default.bLockOnEvent)
	    		return Default.LockOnString;
         break;
	
			case 11:
	    	if (class'Strangemutator'.default.bOwnageEvent)
            return Default.OwnageString;
         break;
	
			case 12:
	    	if (class'Strangemutator'.default.bTopGunEvent)
            return Default.TopGunString;
         break;
	
			case 13:
	    	if (class'Strangemutator'.default.bComboEvent)
            return Default.ComboString;
         break;
	
			case 14:
	    	if (class'Strangemutator'.default.bDeniedEvent)
            return Default.DeniedString;
         break;
	
			case 15:
	    	if (class'Strangemutator'.default.bSilencerEvent)
            return Default.SilencerString;
         break;
    	}
	}
   return "";
}

static simulated function ClientReceive(PlayerPawn P,optional int Switch,optional PlayerReplicationInfo RelatedPRI_1,
	optional PlayerReplicationInfo RelatedPRI_2,optional Object OptionalObject)
{
   Super.ClientReceive(P, Switch, RelatedPRI_1, RelatedPRI_2, OptionalObject);

	if (class'Strangemutator'.default.enableSpecialFragEvents)
	{
    	switch (Switch)
    	{
        	case 1:
	    	if (class'Strangemutator'.default.bBurnOutEvent)
            P.ClientPlaySound(sound'BurnOut',, true);
         break;

        	case 2:
	    	if (class'Strangemutator'.default.bCannonBallEvent)
	    		P.ClientPlaySound(sound'CannonBall',, true);
         break;

 			case 3:
	    	if (class'Strangemutator'.default.bEagleEyeEvent)
            P.ClientPlaySound(sound'EagleEye',, true);
         break;

			case 4:
	    	if (class'Strangemutator'.default.bBurnOutEvent)
            P.ClientPlaySound(sound'Ginsu',, true);
         break;

        	case 5:
	    	if (class'Strangemutator'.default.bHitNRunEvent)
            P.ClientPlaySound(sound'HitAndRun',, true);
         break;
        
		  	case 6:
	    	if (class'Strangemutator'.default.bHitNRunEvent)
            P.ClientPlaySound(sound'Pancake',, true);
         break;
	
			case 7:
	    	if (class'Strangemutator'.default.bHitNRunEvent)
	    		P.ClientPlaySound(sound'Rage',, true);
         break;
	
			case 8:
	    	if (class'Strangemutator'.default.bInstagibEvent)
            P.ClientPlaySound(sound'Instagib',, true);
         break;
	
			case 9:
	    	if (class'Strangemutator'.default.bLockOnEvent)
            P.ClientPlaySound(sound'LockAndLoad',, true);
         break;
	
			case 10:
	    	if (class'Strangemutator'.default.bLockOnEvent)
            P.ClientPlaySound(sound'LockOn',, true);
         break;
	
			case 11:
	    	if (class'Strangemutator'.default.bOwnageEvent)
            P.ClientPlaySound(sound'Ownage',, true);
         break;
	
			case 12:
	    	if (class'Strangemutator'.default.bTopGunEvent)
            P.ClientPlaySound(sound'TopGun',, true);
         break;
	
			case 13:
	    	if (class'Strangemutator'.default.bComboEvent)
            P.ClientPlaySound(sound'ComboWhore',, true);
         break;
	
			case 14:
	    	if (class'Strangemutator'.default.bDeniedEvent)
            P.ClientPlaySound(sound'Denied',, true);
         break;
	
			case 15:
	    	if (class'Strangemutator'.default.bSilencerEvent)
            P.ClientPlaySound(sound'Silencer',, true);
         break;
    	}
	}
}

defaultproperties
{
	bFadeMessage=True
 	bIsSpecial=True
	bIsUnique=True
	Lifetime=3
	bBeep=False
	DrawColor=(R=255,G=0,B=0)
	bCenter=True
	FontSize=2
	YPos=196
	BurnOutString="BURN OUT"
	CannonBallString="CANNON BALL"
	EagleEyeString="EAGLE EYE"
	GinsuString="GINSU"
	HitAndRunString="HIT AND RUN"
	InstagibString="INSTAGIB"
	LockAndLoadString="LOCK AND LOAD"
	LockOnString="LOCK ON"
	OwnageString="OWNAGE"
	PancakeString="PANCAKE"
	RageString="RAGE"
	TopGunString="TOP GUN"
	ComboString="COMBO WHORE"
	DeniedString="DENIED"
	SilencerString="SILENCER"
}
