
class SLV2Models extends Info;


// fcore
#exec MESH MODELIMPORT MESH=fcore MODELFILE=Models\fuelcore.PSK
#exec MESH ORIGIN MESH=fcore X=0 Y=0 Z=0 YAW=64 PITCH=0 ROLL=64
#exec MESHMAP SCALE MESHMAP=fcore X=4.0 Y=4.0 Z=4.0

#exec ANIM IMPORT ANIM=fcoreAnims ANIMFILE=Models\fuelcore.PSA COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=1
#exec MESH DEFAULTANIM MESH=fcore ANIM=fcoreAnims
#exec ANIM SEQUENCE ANIM=fcoreAnims SEQ=all		STARTFRAME=0 NUMFRAMES=39 GROUP=none
#exec ANIM SEQUENCE ANIM=fcoreAnims SEQ=still	STARTFRAME=0 NUMFRAMES=1 RATE=15.0 GROUP=none
#exec ANIM SEQUENCE ANIM=fcoreAnims SEQ=hover	STARTFRAME=1 NUMFRAMES=18 RATE=15.0 GROUP=none
#exec ANIM SEQUENCE ANIM=fcoreAnims SEQ=rise		STARTFRAME=19 NUMFRAMES=9 RATE=15.0 GROUP=none
#exec ANIM SEQUENCE ANIM=fcoreAnims SEQ=drop		STARTFRAME=28 NUMFRAMES=9 RATE=15.0 GROUP=none
#exec ANIM DIGEST ANIM=fcoreAnims VERBOSE

#exec TEXTURE IMPORT NAME=coreskin FILE=Models\core_Twosided.pcx GROUP=skins LODSET=2
#exec MESHMAP SETTEXTURE MESHMAP=fcore NUM=0 TEXTURE=coreskin


// fpod
#exec MESH MODELIMPORT MESH=fpod MODELFILE=Models\fuelpod.PSK
#exec MESH ORIGIN MESH=fpod X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=64
#exec MESHMAP SCALE MESHMAP=fpod X=5.0 Y=5.0 Z=5.0

#exec ANIM IMPORT ANIM=fpodAnims ANIMFILE=Models\fuelpod.PSA COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=1
#exec MESH DEFAULTANIM MESH=fpod ANIM=fpodAnims
#exec ANIM SEQUENCE ANIM=fpodAnims SEQ=all		STARTFRAME=0 NUMFRAMES=8 GROUP=none
#exec ANIM SEQUENCE ANIM=fpodAnims SEQ=closed	STARTFRAME=0 NUMFRAMES=1 RATE=15.0 GROUP=none
#exec ANIM SEQUENCE ANIM=fpodAnims SEQ=opening	STARTFRAME=1 NUMFRAMES=8 RATE=15.0 GROUP=none
#exec ANIM SEQUENCE ANIM=fpodAnims SEQ=open		STARTFRAME=9 NUMFRAMES=1 RATE=15.0 GROUP=none 
#exec ANIM SEQUENCE ANIM=fpodAnims SEQ=closing	STARTFRAME=10 NUMFRAMES=8 RATE=15.0 GROUP=none
#exec ANIM DIGEST ANIM=fpodAnims VERBOSE

#exec TEXTURE IMPORT NAME=podskin FILE=Models\pod_Twosided.pcx GROUP=skins
#exec MESHMAP SETTEXTURE MESHMAP=fpod NUM=0 TEXTURE=podskin


// rocket
#exec MESH MODELIMPORT MESH=rocket MODELFILE=Models\rocket.PSK
#exec MESH ORIGIN MESH=rocket X=0 Y=60 Z=0 YAW=-64 PITCH=0 ROLL=128
#exec MESHMAP SCALE MESHMAP=rocket X=1.0 Y=1.0 Z=1.0

#exec ANIM IMPORT ANIM=rocketAnims ANIMFILE=Models\rocket.PSA COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=1
#exec MESH DEFAULTANIM MESH=rocket ANIM=rocketAnims
#exec ANIM DIGEST ANIM=rocketAnims VERBOSE

#exec TEXTURE IMPORT NAME=rocketSkin0 FILE=Models\rocket01.pcx GROUP=skins
#exec TEXTURE IMPORT NAME=rocketSkin1 FILE=Models\rocket00.pcx GROUP=skins
#exec MESHMAP SETTEXTURE MESHMAP=rocket NUM=0 TEXTURE=rocketSkin0
#exec MESHMAP SETTEXTURE MESHMAP=rocket NUM=1 TEXTURE=rocketSkin1


// rocket 2
#exec MESH MODELIMPORT MESH=rocket2 MODELFILE=Models\rocket2.PSK
#exec MESH ORIGIN MESH=rocket2 X=0 Y=0 Z=50 YAW=-64 PITCH=0 ROLL=64
#exec MESHMAP SCALE MESHMAP=rocket2 X=1.2 Y=1.2 Z=1.4

#exec ANIM IMPORT ANIM=rocket2Anims ANIMFILE=Models\rocket2.PSA COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=1
#exec MESH DEFAULTANIM MESH=rocket2 ANIM=rocket2Anims
#exec ANIM DIGEST ANIM=rocket2Anims VERBOSE

#exec TEXTURE IMPORT NAME=rocket2Skin0 FILE=Models\rocket2wings.pcx GROUP=skins
#exec TEXTURE IMPORT NAME=rocket2Skin1 FILE=Models\rocket2body.pcx GROUP=skins
#exec MESHMAP SETTEXTURE MESHMAP=rocket2 NUM=0 TEXTURE=rocket2Skin0
#exec MESHMAP SETTEXTURE MESHMAP=rocket2 NUM=1 TEXTURE=rocket2Skin1


// slview - konglauncher 1st person
#exec MESH MODELIMPORT MESH=slview MODELFILE=Models\slview.PSK
#exec MESH ORIGIN MESH=slview X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=64
#exec MESHMAP SCALE MESHMAP=slview X=0.6 Y=0.6 Z=0.6

#exec ANIM IMPORT ANIM=slviewAnims ANIMFILE=Models\slview.PSA COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=1
#exec MESH DEFAULTANIM MESH=slview ANIM=slviewAnims
#exec ANIM SEQUENCE ANIM=slviewAnims SEQ=still STARTFRAME=0 NUMFRAMES=1 RATE=15.0 GROUP=still
#exec ANIM SEQUENCE ANIM=slviewAnims SEQ=idle STARTFRAME=1 NUMFRAMES=15 RATE=5.0 GROUP=idle
#exec ANIM SEQUENCE ANIM=slviewAnims SEQ=fire STARTFRAME=16 NUMFRAMES=3 RATE=15.0 GROUP=fire
#exec ANIM SEQUENCE ANIM=slviewAnims SEQ=select STARTFRAME=19 NUMFRAMES=5 RATE=15.0 GROUP=select
#exec ANIM SEQUENCE ANIM=slviewAnims SEQ=down STARTFRAME=24 NUMFRAMES=5 RATE=15.0 GROUP=down
#exec ANIM SEQUENCE ANIM=slviewAnims SEQ=all STARTFRAME=0 NUMFRAMES=29
#exec ANIM DIGEST ANIM=slviewAnims VERBOSE

#exec TEXTURE IMPORT NAME=slvskin0 FILE=Models\kong4.pcx GROUP=skins
#exec TEXTURE IMPORT NAME=slvskin1 FILE=Models\kong1.pcx GROUP=skins
#exec TEXTURE IMPORT NAME=slvskin2 FILE=Models\kong3.pcx GROUP=skins
#exec TEXTURE IMPORT NAME=slvskin3 FILE=Models\kong2.pcx GROUP=skins

#exec MESHMAP SETTEXTURE MESHMAP=slview NUM=0 TEXTURE=slvskin0
#exec MESHMAP SETTEXTURE MESHMAP=slview NUM=1 TEXTURE=slvskin1
#exec MESHMAP SETTEXTURE MESHMAP=slview NUM=2 TEXTURE=slvskin2
#exec MESHMAP SETTEXTURE MESHMAP=slview NUM=3 TEXTURE=slvskin3


// lslview - konglauncher 1st person (left handed)
#exec MESH MODELIMPORT MESH=lslview MODELFILE=Models\lslview.PSK
#exec MESH ORIGIN MESH=lslview X=0 Y=0 Z=0 YAW=-64 PITCH=0 ROLL=64
#exec MESHMAP SCALE MESHMAP=lslview X=0.6 Y=0.6 Z=0.6

#exec ANIM IMPORT ANIM=lslviewAnims ANIMFILE=Models\lslview.PSA COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=1
#exec ANIM SEQUENCE ANIM=lslviewAnims SEQ=still STARTFRAME=0 NUMFRAMES=1 RATE=15.0 GROUP=still
#exec ANIM SEQUENCE ANIM=lslviewAnims SEQ=idle STARTFRAME=1 NUMFRAMES=15 RATE=5.0 GROUP=idle
#exec ANIM SEQUENCE ANIM=lslviewAnims SEQ=fire STARTFRAME=16 NUMFRAMES=3 RATE=15.0 GROUP=fire
#exec ANIM SEQUENCE ANIM=lslviewAnims SEQ=select STARTFRAME=19 NUMFRAMES=5 RATE=15.0 GROUP=select
#exec ANIM SEQUENCE ANIM=lslviewAnims SEQ=down STARTFRAME=24 NUMFRAMES=5 RATE=15.0 GROUP=down
#exec ANIM SEQUENCE ANIM=lslviewAnims SEQ=all STARTFRAME=0 NUMFRAMES=29
#exec MESH DEFAULTANIM MESH=lslview ANIM=slviewAnims
#exec ANIM DIGEST ANIM=lslviewAnims VERBOSE

#exec MESHMAP SETTEXTURE MESHMAP=lslview NUM=0 TEXTURE=slvskin0
#exec MESHMAP SETTEXTURE MESHMAP=lslview NUM=1 TEXTURE=slvskin1
#exec MESHMAP SETTEXTURE MESHMAP=lslview NUM=2 TEXTURE=slvskin2
#exec MESHMAP SETTEXTURE MESHMAP=lslview NUM=3 TEXTURE=slvskin3


// slpickup - konglauncher 3rd person pickup
#exec MESH MODELIMPORT MESH=slpickup MODELFILE=Models\slpickup.PSK
#exec MESH ORIGIN MESH=slpickup X=0 Y=0 Z=8 YAW=-64 PITCH=0 ROLL=64 // The center is near the handle...
#exec MESHMAP SCALE MESHMAP=slpickup X=3.2 Y=3.2 Z=3.2
#exec ANIM IMPORT ANIM=slpickupAnims ANIMFILE=Models\slpickup.PSA COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=1
#exec MESH DEFAULTANIM MESH=slpickup ANIM=slpickupAnims
#exec ANIM DIGEST ANIM=slpickupAnims VERBOSE
#exec TEXTURE IMPORT NAME=slpskin FILE=Models\kongsmall.pcx GROUP=skins
#exec MESHMAP SETTEXTURE MESHMAP=slpickup NUM=0 TEXTURE=slpskin


// slhand - konglauncher 3rd person in-hand
#exec MESH MODELIMPORT MESH=slhand MODELFILE=Models\slhand.PSK
#exec MESH ORIGIN MESH=slhand X=0 Y=1 Z=0 YAW=-64 PITCH=0 ROLL=64
#exec MESHMAP SCALE MESHMAP=slhand X=2.35 Y=2.35 Z=2.35
#exec ANIM IMPORT ANIM=slhandAnims ANIMFILE=Models\slhand.PSA COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=1
#exec MESH DEFAULTANIM MESH=slhand ANIM=slhandAnims
#exec ANIM DIGEST ANIM=slhandAnims VERBOSE
#exec MESHMAP SETTEXTURE MESHMAP=slhand NUM=0 TEXTURE=slpskin


// sarmview

#exec MESH MODELIMPORT MESH=sarmview MODELFILE=Models\sarmview.PSK
#exec MESH ORIGIN MESH=sarmview X=0 Y=0 Z=0 YAW=64 PITCH=12 ROLL=64
#exec MESHMAP SCALE MESHMAP=sarmview X=0.5 Y=0.5 Z=0.5

#exec ANIM IMPORT ANIM=sarmviewAnims ANIMFILE=Models\sarmview.PSA COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=0
#exec MESH DEFAULTANIM MESH=sarmview ANIM=sarmviewAnims

#exec ANIM SEQUENCE ANIM=sarmviewAnims SEQ=still STARTFRAME=0 NUMFRAMES=1 RATE=30.000000 GROUP=None
#exec ANIM SEQUENCE ANIM=sarmviewAnims SEQ=fire STARTFRAME=1 NUMFRAMES=31 RATE=30.000000 GROUP=None
#exec ANIM SEQUENCE ANIM=sarmviewAnims SEQ=select STARTFRAME=32 NUMFRAMES=21 RATE=30.000000 GROUP=None
#exec ANIM SEQUENCE ANIM=sarmviewAnims SEQ=down STARTFRAME=53 NUMFRAMES=21 RATE=30.000000 GROUP=None
#exec ANIM SEQUENCE ANIM=sarmviewAnims SEQ=idle STARTFRAME=74 NUMFRAMES=61 RATE=30.000000 GROUP=None
#exec ANIM SEQUENCE ANIM=sarmviewAnims SEQ=altfire STARTFRAME=135 NUMFRAMES=18 RATE=30.000000 GROUP=None
#exec ANIM SEQUENCE ANIM=sarmviewAnims SEQ=reload STARTFRAME=153 NUMFRAMES=30 RATE=30.000000 GROUP=None
#exec ANIM SEQUENCE ANIM=sarmviewAnims SEQ=all STARTFRAME=0 NUMFRAMES=183

#exec ANIM DIGEST ANIM=sarmviewAnims VERBOSE

#exec TEXTURE IMPORT NAME=sarm0 FILE=Models\sarm1.pcx GROUP=skins LODSET=2
#exec TEXTURE IMPORT NAME=sarm1 FILE=Models\sarm2.pcx GROUP=skins LODSET=2
#exec TEXTURE IMPORT NAME=sarm2 FILE=Models\sarm3.pcx GROUP=skins LODSET=2
#exec TEXTURE IMPORT NAME=sarm3 FILE=Models\sarm4.pcx GROUP=skins LODSET=2

#exec MESHMAP SETTEXTURE MESHMAP=sarmview NUM=0 TEXTURE=sarm0
#exec MESHMAP SETTEXTURE MESHMAP=sarmview NUM=1 TEXTURE=sarm1
#exec MESHMAP SETTEXTURE MESHMAP=sarmview NUM=2 TEXTURE=sarm2
#exec MESHMAP SETTEXTURE MESHMAP=sarmview NUM=3 TEXTURE=sarm3


// rsarmview - right handed
#exec MESH MODELIMPORT MESH=rsarmview MODELFILE=Models\rsarmview.PSK
#exec MESH ORIGIN MESH=rsarmview X=0 Y=0 Z=0 YAW=64 PITCH=-12 ROLL=64
#exec MESHMAP SCALE MESHMAP=rsarmview X=0.5 Y=0.5 Z=0.5

#exec ANIM IMPORT ANIM=rsarmviewAnims ANIMFILE=Models\rsarmview.PSA COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=0
#exec MESH DEFAULTANIM MESH=rsarmview ANIM=rsarmviewAnims

#exec ANIM SEQUENCE ANIM=rsarmviewAnims SEQ=still STARTFRAME=0 NUMFRAMES=1 RATE=30.0 GROUP=None
#exec ANIM SEQUENCE ANIM=rsarmviewAnims SEQ=fire STARTFRAME=1 NUMFRAMES=31 RATE=30.0 GROUP=None
#exec ANIM SEQUENCE ANIM=rsarmviewAnims SEQ=select STARTFRAME=32 NUMFRAMES=21 RATE=30.0 GROUP=None
#exec ANIM SEQUENCE ANIM=rsarmviewAnims SEQ=down STARTFRAME=53 NUMFRAMES=21 RATE=30.0 GROUP=None
#exec ANIM SEQUENCE ANIM=rsarmviewAnims SEQ=idle STARTFRAME=74 NUMFRAMES=61 RATE=30.0 GROUP=None
#exec ANIM SEQUENCE ANIM=rsarmviewAnims SEQ=altfire STARTFRAME=135 NUMFRAMES=18 RATE=30.0 GROUP=None
#exec ANIM SEQUENCE ANIM=rsarmviewAnims SEQ=reload STARTFRAME=153 NUMFRAMES=30 RATE=30.0 GROUP=None
#exec ANIM SEQUENCE ANIM=rsarmviewAnims SEQ=all STARTFRAME=0 NUMFRAMES=183

#exec ANIM DIGEST ANIM=rsarmviewAnims VERBOSE

#exec MESHMAP SETTEXTURE MESHMAP=rsarmview NUM=0 TEXTURE=sarm0
#exec MESHMAP SETTEXTURE MESHMAP=rsarmview NUM=1 TEXTURE=sarm1
#exec MESHMAP SETTEXTURE MESHMAP=rsarmview NUM=2 TEXTURE=sarm2
#exec MESHMAP SETTEXTURE MESHMAP=rsarmview NUM=3 TEXTURE=sarm3


// sarmpickup
#exec MESH MODELIMPORT MESH=sarmpickup MODELFILE=Models\sarmpickup.PSK
#exec MESH ORIGIN MESH=sarmpickup X=0 Y=0 Z=0 YAW=64 PITCH=-64 ROLL=64
#exec MESHMAP SCALE MESHMAP=sarmpickup X=1.0 Y=1.0 Z=1.0
#exec ANIM IMPORT ANIM=sarmpickupAnims ANIMFILE=Models\sarmpickup.PSA COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=1
#exec MESH DEFAULTANIM MESH=sarmpickup ANIM=sarmpickupAnims
#exec ANIM DIGEST ANIM=sarmpickupAnims VERBOSE
#exec TEXTURE IMPORT NAME=sarmpskin FILE=Models\sidearmsmall.pcx GROUPS=skins
#exec MESHMAP SETTEXTURE MESHMAP=sarmpickup NUM=0 TEXTURE=sarmpskin


// sarmhand
// x is up. y is left. z is forward.
#exec MESH MODELIMPORT MESH=sarmhand MODELFILE=Models\sarmhand.PSK
#exec MESH ORIGIN MESH=sarmhand X=0 Y=0 Z=-5 YAW=60 PITCH=-64 ROLL=64
#exec MESHMAP SCALE MESHMAP=sarmhand X=0.8 Y=0.8 Z=0.8
#exec ANIM IMPORT ANIM=sarmhandAnims ANIMFILE=Models\sarmhand.PSA COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=1
#exec MESH DEFAULTANIM MESH=sarmhand ANIM=sarmhandAnims
#exec ANIM DIGEST ANIM=sarmhandAnims VERBOSE
#exec MESHMAP SETTEXTURE MESHMAP=sarmhand NUM=0 TEXTURE=sarmpskin


// sarmclip
#exec MESH MODELIMPORT MESH=sarmclip MODELFILE=Models\sarmclip.PSK
#exec MESH ORIGIN MESH=sarmclip X=0 Y=0 Z=0 YAW=0 PITCH=64 ROLL=64
#exec MESHMAP SCALE MESHMAP=sarmclip X=0.2 Y=0.35 Z=0.35
#exec ANIM IMPORT ANIM=sarmclipAnims ANIMFILE=Models\sarmclip.PSA COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=1
#exec MESH DEFAULTANIM MESH=sarmclip ANIM=sarmclipAnims
#exec ANIM DIGEST ANIM=sarmclipAnims VERBOSE
#exec TEXTURE IMPORT NAME=sarmclipSkin FILE=Models\sarmclip.pcx GROUP=skins
#exec MESHMAP SETTEXTURE MESHMAP=sarmclip NUM=0 TEXTURE=sarmclipSkin


// contrail segment
#exec MESH MODELIMPORT MESH=contrailM MODELFILE=Models\contrail.PSK
#exec MESH ORIGIN MESH=contrailM X=0 Y=0 Z=0 YAW=0 PITCH=0 ROLL=0
#exec MESHMAP SCALE MESHMAP=contrailM X=1.0 Y=1.0 Z=1.0
#exec TEXTURE IMPORT NAME=contrailSkin FILE=Models\contrail.pcx GROUP=skins
#exec TEXTURE IMPORT NAME=contrailEnd FILE=Models\contrail2.pcx GROUP=skins
#exec MESHMAP SETTEXTURE MESHMAP=contrailM NUM=0 TEXTURE=contrailSkin FLAGS=2


// thermo
#exec MESH MODELIMPORT MESH=thermo MODELFILE=Models\thermo.PSK
#exec MESH ORIGIN MESH=thermo X=0 Y=0 Z=0 YAW=0 PITCH=0 ROLL=0
#exec MESHMAP SCALE MESHMAP=thermo X=1.0 Y=1.0 Z=1.0
#exec ANIM IMPORT ANIM=thermoAnims ANIMFILE=Models\thermo.PSA COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=1
#exec MESH DEFAULTANIM MESH=thermo ANIM=thermoAnims
#exec ANIM DIGEST ANIM=thermoAnims VERBOSE
#exec TEXTURE IMPORT NAME=thermoSkin FILE=Models\thermo.pcx GROUP=skins
#exec MESHMAP SETTEXTURE MESHMAP=thermo NUM=0 TEXTURE=thermoSkin


// brass
#exec MESH MODELIMPORT MESH=brass MODELFILE=Models\brass.PSK
#exec MESH ORIGIN MESH=brass X=0 Y=0 Z=0 YAW=0 PITCH=64 ROLL=0
#exec MESHMAP SCALE MESHMAP=brass X=0.1 Y=0.1 Z=0.1
#exec ANIM IMPORT ANIM=brassAnims ANIMFILE=Models\brass.PSA COMPRESS=1 MAXKEYS=999999 IMPORTSEQS=1
#exec MESH DEFAULTANIM MESH=brass ANIM=brassAnims
#exec ANIM DIGEST ANIM=brassAnims VERBOSE
#exec TEXTURE IMPORT NAME=brassSkin FILE=Models\ejectedbrass.pcx GROUP=skins
#exec MESHMAP SETTEXTURE MESHMAP=brass NUM=0 TEXTURE=brassSkin


// chunks (wreckage)
#exec TEXTURE IMPORT NAME=chunkskin FILE=Models\wreckskin.pcx GROUP=skins

#exec MESH MODELIMPORT MESH=chunk1 MODELFILE=Models\chunk1.PSK
#exec MESH ORIGIN MESH=chunk1 X=0 Y=0 Z=0 YAW=0 PITCH=0 ROLL=0
#exec MESHMAP SCALE MESHMAP=chunk1 X=1.0 Y=1.0 Z=1.0
#exec MESHMAP SETTEXTURE MESHMAP=chunk1 NUM=0 TEXTURE=chunkskin

#exec MESH MODELIMPORT MESH=chunk2 MODELFILE=Models\chunk2.PSK
#exec MESH ORIGIN MESH=chunk2 X=0 Y=0 Z=0 YAW=0 PITCH=0 ROLL=0
#exec MESHMAP SCALE MESHMAP=chunk2 X=1.0 Y=1.0 Z=1.0
#exec MESHMAP SETTEXTURE MESHMAP=chunk2 NUM=0 TEXTURE=chunkskin

#exec MESH MODELIMPORT MESH=chunk3 MODELFILE=Models\chunk3.PSK
#exec MESH ORIGIN MESH=chunk3 X=0 Y=0 Z=0 YAW=0 PITCH=0 ROLL=0
#exec MESHMAP SCALE MESHMAP=chunk3 X=1.0 Y=1.0 Z=1.0
#exec MESHMAP SETTEXTURE MESHMAP=chunk3 NUM=0 TEXTURE=chunkskin

#exec MESH MODELIMPORT MESH=chunk4 MODELFILE=Models\chunk4.PSK
#exec MESH ORIGIN MESH=chunk4 X=0 Y=0 Z=0 YAW=0 PITCH=0 ROLL=0
#exec MESHMAP SCALE MESHMAP=chunk4 X=1.0 Y=1.0 Z=1.0
#exec MESHMAP SETTEXTURE MESHMAP=chunk4 NUM=0 TEXTURE=chunkskin

#exec MESH MODELIMPORT MESH=chunk5 MODELFILE=Models\chunk5.PSK
#exec MESH ORIGIN MESH=chunk5 X=0 Y=0 Z=0 YAW=0 PITCH=0 ROLL=0
#exec MESHMAP SCALE MESHMAP=chunk5 X=1.0 Y=1.0 Z=1.0
#exec MESHMAP SETTEXTURE MESHMAP=chunk5 NUM=0 TEXTURE=chunkskin

#exec MESH MODELIMPORT MESH=chunk6 MODELFILE=Models\chunk6.PSK
#exec MESH ORIGIN MESH=chunk6 X=0 Y=0 Z=0 YAW=0 PITCH=0 ROLL=0
#exec MESHMAP SCALE MESHMAP=chunk6 X=1.0 Y=1.0 Z=1.0
#exec MESHMAP SETTEXTURE MESHMAP=chunk6 NUM=0 TEXTURE=chunkskin

#exec MESH MODELIMPORT MESH=chunk7 MODELFILE=Models\chunk7.PSK
#exec MESH ORIGIN MESH=chunk7 X=0 Y=0 Z=0 YAW=0 PITCH=0 ROLL=0
#exec MESHMAP SCALE MESHMAP=chunk7 X=1.0 Y=1.0 Z=1.0
#exec MESHMAP SETTEXTURE MESHMAP=chunk7 NUM=0 TEXTURE=chunkskin

#exec MESH MODELIMPORT MESH=chunk8 MODELFILE=Models\chunk8.PSK
#exec MESH ORIGIN MESH=chunk8 X=0 Y=0 Z=0 YAW=0 PITCH=0 ROLL=0
#exec MESHMAP SCALE MESHMAP=chunk8 X=1.0 Y=1.0 Z=1.0
#exec MESHMAP SETTEXTURE MESHMAP=chunk8 NUM=0 TEXTURE=chunkskin

defaultproperties
{
}
