
class XRayGlasses extends TournamentWeapon;

//Needed text for radar
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontSmall"  Height=8  USize=256 VSize=128 CharactersPerPage=256
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontMedium" Height=10 USize=256 VSize=128 CharactersPerPage=256
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontLarge"  Height=12 USize=256 VSize=256 CharactersPerPage=256
#exec Texture Import Name=TeamBeacon2 File="Textures\TeamBeacon2.bmp" Flags=2
#exec Texture Import Name=XRayGlassesBox File="Textures\XRayGlassesBox.bmp"

//var color GreenColor, BeaconColor;
var Texture TeamBeaconIcon;
var int d;

function Fire( float Value )
{
}

function AltFire( float Value )
{
}

simulated function PostRender( canvas Canvas )
{
   local Pawn thisPawn;
   local vector X, Y, Z, CamLoc, TargetDir, Dir, XY;
   local rotator CamRot;
   local Actor Camera;
   local float BaseBeaconScale, BeaconScale, Dist, DistScale;
   local float TanFOVx, TanFOVy;
   local float TanX, TanY;
   local float dx, dy, FontY;
   local string BeaconText;
   
   Canvas.Style = ERenderStyle.STY_Masked;

   if (Canvas.ClipX > 1024)
      Canvas.Font = Font'BeaconNameFontLarge';
   else if (Canvas.ClipX > 640)
      Canvas.Font = Font'BeaconNameFontMedium';
   else
      Canvas.Font = Font'BeaconNameFontSmall';
	
   Canvas.SetPos(0, 0);
   Canvas.TextSize("X", dx, FontY);
   BaseBeaconScale = 1.5 * FontY / Texture'TeamBeacon2'.VSize;

   Canvas.ViewPort.Actor.PlayerCalcView(Camera, CamLoc, CamRot);

   TanFOVx = Tan(Canvas.ViewPort.Actor.FOVAngle / 114.591559);
   TanFOVy = (Canvas.ClipY / Canvas.ClipX) * TanFOVx;
   GetAxes(CamRot, X, Y, Z);

   Canvas.bNoSmooth = False;
   Canvas.Style = ERenderStyle.STY_Masked;

   foreach RadiusActors(class 'Pawn', thisPawn, 7000)
   {
      if ( thisPawn != none && thisPawn != Camera && thisPawn.Health > 0 && !thisPawn.bHidden)
      {
         TargetDir = thisPawn.Location - CamLoc;
	 		Dist = VSize(TargetDir) * FMin(TanFOVx, 1.0);
	 		TargetDir = Normal(TargetDir + vect(0,0,1) * thisPawn.CollisionHeight);
	 		DistScale = FMin(100.0 * thisPawn.CollisionRadius / Dist, 1.0);
	 		d = Dist;

	 		if (DistScale > 0.0 && TargetDir dot X > 0) 
			// These checks removed to allow wall hack
			// && (FastTrace(thisPawn.Location, CamLoc) || FastTrace(thisPawn.Location + vect(0,0,0.8) * thisPawn.CollisionHeight, CamLoc)))
         {
	    		BeaconScale = BaseBeaconScale * DistScale;
	   	 	Dir = X * (X dot TargetDir);
	    		XY = TargetDir - Dir;

	    		dx = Canvas.ClipX * 0.5 * (1.0 + (XY dot Y) / (VSize(Dir) * TanFOVx));
	    		dy = Canvas.ClipY * 0.5 * (1.0 - (XY dot Z) / (VSize(Dir) * TanFOVy));

	    		Canvas.SetPos(dx - 0.5 * BeaconScale * TeamBeaconIcon.USize, dy - 2 * FontY * DistScale);

	    		if (DistScale <= 1.0)
            {
	       		if (Canvas.ClipX > 600)
		  				BeaconText = "" $ d $ "";
               Canvas.DrawIcon(texture'CrossHair6', 1.0);
	       		Canvas.SetPos(dx + 0.6 * BeaconScale * TeamBeaconIcon.USize + 1, dy - 1.75 * FontY + 1);
	       		Canvas.DrawTextClipped(BeaconText, False);
            }
         }
      }
   }
}

defaultproperties
{
//BeaconColor=(R=0,G=150,B=0,A=0),
//GreenColor=(R=0,G=255,B=0,A=0),
TeamBeaconIcon=Texture'TeamBeacon2'
   WeaponDescription="Classification: XRay Glasses\n\nUsage: Equip them to see your enemies."

//   SelectSound=Sound'Botpack.ChainSaw.ChainPickup'
   PickupMessage="These glasses look...weird. I wonder what they do."
   ItemName="XRay Glasses"
   PlayerViewOffset=(X=2.000000,Y=-1.100000,Z=-0.900000)
//   PlayerViewMesh=LodMesh'Botpack.chainsawM'
   PickupViewMesh=LodMesh'UnrealShare.WoodenBoxM'
//   ThirdPersonMesh=LodMesh'Botpack.CSHand'
//   StatusIcon=Texture'Botpack.Icons.UseSaw'
   PickupSound=Sound'UnrealShare.Pickups.WeaponPickup'
//   Icon=Texture'Botpack.Icons.UseSaw'
   Mesh=LodMesh'UnrealShare.WoodenBoxM'
   bNoSmooth=False
   MultiSkins(0)=Texture'XRayGlassesBox'
   MultiSkins(1)=Texture'XRayGlassesBox'
}