class ZeroVTele extends Teleporter;

simulated function bool Accept( actor Incoming, Actor Source )
{
    local rotator newRot, oldRot;
    local int oldYaw;
    local float mag;
    local vector oldDir;
    local pawn P;

    // Move the actor here.
    Disable('Touch');
    newRot = Incoming.Rotation;
    if (bChangesYaw)
    {
        oldRot = Incoming.Rotation;
        newRot.Yaw = Rotation.Yaw;
        if ( Source != None )
            newRot.Yaw += (32768 + Incoming.Rotation.Yaw - Source.Rotation.Yaw);
    }

    if ( Pawn(Incoming) != None )
    {
        //tell enemies about teleport
        if ( Role == ROLE_Authority )
        {
            P = Level.PawnList;
            While ( P != None )
            {
                if (P.Enemy == Incoming)
                    P.LastSeenPos = Incoming.Location;
                P = P.nextPawn;
            }
        }
        Pawn(Incoming).SetLocation(Location);
        if ( (Role == ROLE_Authority) 
            || (Level.TimeSeconds - LastFired > 0.5) )
        {
            Pawn(Incoming).SetRotation(newRot);
            Pawn(Incoming).ViewRotation = newRot;
            Pawn(Incoming).Velocity = (Pawn(Incoming).Velocity * 0);
            LastFired = Level.TimeSeconds;
        }
        Pawn(Incoming).MoveTimer = -1.0;
        Pawn(Incoming).MoveTarget = self;
        PlayTeleportEffect( Incoming, false);
    }
    else
    {
        if ( !Incoming.SetLocation(Location) )
        {
            Enable('Touch');
            return false;
        }
        if ( bChangesYaw )
            Incoming.SetRotation(newRot);
    }

    Enable('Touch');

    
    if (bChangesVelocity)
        Incoming.Velocity = TargetVelocity;
    else
    {
        if ( bChangesYaw )
        {
            if ( Incoming.Physics == PHYS_Walking )
                OldRot.Pitch = 0;
            oldDir = vector(OldRot);
            mag = Incoming.Velocity Dot oldDir;     
            Incoming.Velocity = Incoming.Velocity - mag * oldDir + mag * vector(Incoming.Rotation);
        } 
        if ( bReversesX )
            Incoming.Velocity.X *= -1.0;
        if ( bReversesY )
            Incoming.Velocity.Y *= -1.0;
        if ( bReversesZ )
            Incoming.Velocity.Z *= -1.0;
    }   

    // Play teleport-in effect.

    return true;
}


