
class KeepItClean expands Mutator config(theSeeker3);

struct InfractionRecord   // player Infraction records
{
	var bool bInitialized;
	var int PID;
	var string PlayerName;
	var bool bLastToSentSet;
	var string LastToSent;
	var bool bLastToReceivedSet;
	var string LastToReceived;
	var string LastMessageSent;
	var bool bTextChanged;
	var int LastMessageSentTime;
	var int CensorTime;
	var int InfractionCount;
	var string IP;
};

var InfractionRecord InfractionRecords[256];
var int LastCurrentTime;
var int NextNameTime;

var bool Initialized;

var config bool ChangeName;
var config bool ChangeTalk;
var config bool KickPlayerForName;
var config bool KickPlayerForTalk;
var config bool AllowSpectatorsToSendPrivateMessage;
var config string NameMessage;
var config string TalkMessage;
var config string CheckedWords[100];
var config bool LogAllMessages;
var config string LogPrefix;
var config int MaxInfractions;
var config int MaxIPInfractions;
var config int CensorTime;
var config bool StrictTextParsing;
var config string ChatDenyIP[100];
var config string ChatAdminIP[20];

var string Replacements[100];
var string Checks[100];



function PreBeginPlay()
{
    local int i;

    InitializeWords();

    for (i = 0; i < 256; i++)
    {
	InfractionRecords[ i ].bInitialized = false;
    }
}

function InitializeWords()
{
    local int i;
    local int pos;

	for ( i = 0; i < 100; i++ )
	    {
		if (Len( CheckedWords[ i ] ) > 0 )
			{
			pos = InStr(CheckedWords[i], ":");
			if (pos >= 0) // replacement found, so pull it out
				{
				Checks[i] = Caps(Left(CheckedWords[i], pos));
				Replacements[i] = Mid(CheckedWords[i], pos + 1);
				}
			else
				{
				Checks[i] = Caps(CheckedWords[i]);
				Replacements[i] = "";
				}
			}
		else
			{
			Checks[i] = "";
			Replacements[i] = "";
			}
	    }
}

function PostBeginPlay()
{
	if (!Initialized)
    {
    	Initialized = true;
    	Level.Game.RegisterMessageMutator(Self); // register ourselves as a message mutator
        settimer(1.0, true); // call us every 7 seconds...
		NextNameTime = Level.TimeSeconds;
    }
}

function Timer()
{
local int i;
local int Seconds;
local int CurrentTime;

	CurrentTime = Level.TimeSeconds;
	if ( CurrentTime >= NextNameTime )
		{
		NextNameTime = CurrentTime + 7;
		FindNewPlayers();
		}

	if ( CurrentTime > LastCurrentTime )
		{
		Seconds = CurrentTime - LastCurrentTime;
		LastCurrentTime = CurrentTime;
		for (i = 0; i < 256; i++)
			{
			if ( InfractionRecords[ i ].bInitialized )
				{
				if ( InfractionRecords[ i ].CensorTime > 0 )
					{
					InfractionRecords[ i ].CensorTime -= Seconds;
					if ( InfractionRecords[ i ].CensorTime < 0 )
						InfractionRecords[ i ].CensorTime = 0;
					}
				}
			}
		}
}

function FindNewPlayers()
{
local int		  i
				, iInfractionRecord
				, iColon
				;
local string	  outName
				, PawnIP
				, IP
				;
local Pawn		  pPawn
				;

	for (pPawn = Level.PawnList; pPawn != None; pPawn = pPawn.NextPawn)
		{
		if (!pPawn.IsA('PlayerPawn'))
			{
			continue;
			}
		if (FastCleanUpText(pPawn.PlayerReplicationInfo.PlayerName, outName)) // name was bad?
			{
			if (KickPlayerForName)
				{
				KickThePlayer(PlayerPawn(pPawn), NameMessage);
				}
			else
				{
				if (Len(NameMessage) > 0)
					{
					pPawn.ClientMessage(NameMessage, 'Event', true);
					}
				if (ChangeName)
					{
					Log("Player name changed from '" $ pPawn.PlayerReplicationInfo.PlayerName $ "' to '" $ outName $ "'");
					pPawn.PlayerReplicationInfo.PlayerName = outName;
					}
				}
			}

		// Make sure the pawn has an infraction record
		if ( pPawn.bIsPlayer
			&&	(PlayerPawn(pPawn)==None || NetConnection(PlayerPawn(pPawn).Player)!=None ) )
			{
			IP = PlayerPawn(pPawn).GetPlayerNetworkAddress();
			iColon = InStr( IP, ":" );
			PawnIP = Left( IP, iColon );
			}
		iInfractionRecord = GetInfractionIndex( pPawn.PlayerReplicationInfo, PawnIP );
		if ( iInfractionRecord < 0 )
			iInfractionRecord = CreateInfractionRecord( pPawn.PlayerReplicationInfo, PawnIP );
		}
}

function Mutate(string MutateString, PlayerPawn Sender)
{
local int		  i
				, i2
				, iInfractionRecord
				, iColon
				;
local bool		  bAdmin
				, bSpectator
				, bKICAdmin
				;
local string	  CommandString
				, IPString
				, ParameterString
				, SenderIP
				, PlayerList
				;

	if ( NextMutator != None )
		NextMutator.Mutate(MutateString, Sender);

	bAdmin = Sender.PlayerReplicationInfo.bAdmin;
	bSpectator = Sender.IsA('Spectator');
	bKICAdmin = false;

	if ( ( Sender.bIsPlayer ) && ( NetConnection(Sender.Player)!=None ) )
		{
		IPString = Sender.GetPlayerNetworkAddress();
		iColon = InStr( IPString, ":" );
		SenderIP = Left( IPString, iColon );
		bKICAdmin = CheckChatAdminIP( SenderIP );
		}
	else
		bKICAdmin = true;		// No net connection - assume this person has privs

	//if ( ! bAdmin )
	//	return; // Only allow spectators access to the commands

	if ( ( Caps(MutateString) == "KEEPITCLEAN" ) || ( Caps(MutateString) == "KIC" ) )
		{
		Sender.ClientMessage("KeepItClean Usage: Start a SAY or TeamSay command with the following:");
		Sender.ClientMessage("  'TO <PlayerName>:' to send a private message to a specific player.");
		Sender.ClientMessage("  '&' to send another private message to the last player you sent a private message too.");
		Sender.ClientMessage("  '<' to send a reply to a player that sent a private message.");
		Sender.ClientMessage("  *Note: Use an * to terminate the name to send a private message to a group of people in the same clan.");
		Sender.ClientMessage("   i.e. 'Say To [CTCR]*: Hello CTCR!'  would send 'Hello CTCR!' to all players with [CTCR] prefixes.");
		Sender.ClientMessage("KeepItClean Commands:");
		Sender.ClientMessage("  Mutate KIC - This command list");
		Sender.ClientMessage("  Mutate KIC ListPlayers - Lists all players that have played in this level.");
		Sender.ClientMessage("  Mutate KIC ListWords - Lists the Banned Words");
		Sender.ClientMessage("  Mutate KIC AddWord [Word:Replacement] - Add a new word to ban");
		Sender.ClientMessage("  Mutate KIC RemoveWord [Word:Replacement] - Remove an existing Word from the banned list");
		Sender.ClientMessage("  Mutate KIC ListBans - Lists the current Chat Banned IPs");
		Sender.ClientMessage("  Mutate KIC AddBan <Player Name > | <IP> - Add a new Chat Banned IP by Player Name or IP");
		Sender.ClientMessage("  Mutate KIC RemoveBan <Player Name > | <IP> - Remove an existing Chat Banned IP by Player Name or IP");
		Sender.ClientMessage("  Mutate KIC ListAdmins - Lists the current Chat Admin IPs");
		Sender.ClientMessage("  Mutate KIC AddAdmin <Player Name > | <IP> - Add a new Chat Admin IP by Player Name or IP");
		Sender.ClientMessage("  Mutate KIC RemoveAdmin <Player Name > | <IP> - Remove an existing Chat Admin IP by Player Name or IP");
		Sender.ClientMessage("  *Note: KIC can be replaced, in all commands with KeepItClean");
		}
	else if ( ( Left(Caps(MutateString),12) == "KEEPITCLEAN " ) || ( Left(Caps(MutateString),4) == "KIC " ) )
		{
		if ( Left(Caps(MutateString),12) == "KEEPITCLEAN " )
			CommandString = Mid(MutateString,12);
		else
			CommandString = Mid(MutateString,4);

		if ( Left(Caps(CommandString),8) == "ADDWORD " )
			{
			if ( ( bAdmin ) || ( bKICAdmin ) )
				{
				ParameterString = Mid(CommandString,8);
				for ( i = 0; ( ( i < 100 ) && ( Len( CheckedWords[ i ] ) > 0 ) ); i++ );
				if ( i < 100 )
					{
					Sender.ClientMessage("Adding "@ParameterString@"to the list of banned words.");
					CheckedWords[ i ] = ParameterString;
					default.CheckedWords[ i ] = ParameterString;
					SaveConfig();
					InitializeWords();
					}
				CommandString = "LISTWORDS";
				}
			else
				Sender.ClientMessage("This command is restricted to Chat Admins.");
			}
		else if ( Left(Caps(CommandString),11) == "REMOVEWORD " )
			{
			if ( ( bAdmin ) || ( bKICAdmin ) )
				{
				ParameterString = Mid(CommandString,11);
				for ( i = 0; ( ( i < 100 ) && ( Len( CheckedWords[ i ] ) > 0 ) && ( CheckedWords[ i ] != ParameterString ) ); i++ );
				if ( Caps(CheckedWords[ i ]) == Caps(ParameterString) )
					{
					Sender.ClientMessage("Removing"@ParameterString@"from the list of banned words");
					for ( i = i; ( ( i < 99 ) && ( Len( CheckedWords[ i + 1 ] ) > 0 ) ); i++ )
						{
						CheckedWords[ i ] = CheckedWords[ i + 1 ];
						default.CheckedWords[ i ] = CheckedWords[ i + 1 ];
						}
					CheckedWords[ i ] = "";
					default.CheckedWords[ i ] = "";
					SaveConfig();
					InitializeWords();
					}
				else
					Sender.ClientMessage("Banned Wwrd"@ParameterString@"not found.");
				CommandString = "LISTWORDS";
				}
			else
				Sender.ClientMessage("This command is restricted to Chat Admins.");
			}
		else if ( Left(Caps(CommandString),7) == "ADDBAN " )
			{
			if ( ( bAdmin ) || ( bKICAdmin ) )
				{
				ParameterString = Mid(CommandString,7);
				iInfractionRecord = GetInfractionIndexByName( ParameterString );
				IPString = "";
				if ( iInfractionRecord >= 0 )
					IPString = InfractionRecords[ iInfractionRecord ].IP;
				else
					{
					i = Int( ParameterString );
					if ( i > 0 )
						IPString = ParameterString;
					}
				if ( IPString == "" )
					Sender.ClientMessage( "Player"@ParameterString@"not found (or has no IP listed)." );
				else
					{
					for ( i = 0; ( ( i < 100 ) && ( Len( ChatDenyIP[ i ] ) > 0 ) ); i++ );
					if ( i < 100 )
						{
						Sender.ClientMessage("Chat Banning IP"@IPString);
						ChatDenyIP[ i ] = IPString;
						default.ChatDenyIP[ i ] = IPString;
						SaveConfig();
						}
					CommandString = "LISTBANS";
					}
				}
			else
				Sender.ClientMessage("This command is restricted to Chat Admins.");
			}
		else if ( Left(Caps(CommandString),10) == "REMOVEBAN " )
			{
			if ( ( bAdmin ) || ( bKICAdmin ) )
				{
				ParameterString = Mid(CommandString,10);
				iInfractionRecord = GetInfractionIndexByName( ParameterString );
				if ( iInfractionRecord >= 0 )
					IPString = InfractionRecords[ iInfractionRecord ].IP;
				else
					{
					i = Int( ParameterString );
					if ( i > 0 )
						IPString = ParameterString;
					}
				if ( IPString == "" )
					Sender.ClientMessage( "Player"@ParameterString@"not found (or has no IP listed)." );
				else
					{
					for ( i = 0; ( ( i < 100 ) && ( Len( ChatDenyIP[ i ] ) > 0 ) && ( ChatDenyIP[ i ] != IPString ) ); i++ );
					if ( ChatDenyIP[ i ] ~= IPString )
						{
						Sender.ClientMessage("Removing Chat Ban for IP"@IPString);
						for ( i = i; ( ( i < 99 ) && ( Len( ChatDenyIP[ i + 1 ] ) > 0 ) ); i++ )
							{
							ChatDenyIP[ i ] = ChatDenyIP[ i + 1 ];
							default.ChatDenyIP[ i ] = ChatDenyIP[ i + 1 ];
							}
						ChatDenyIP[ i ] = "";
						default.ChatDenyIP[ i ] = "";
						SaveConfig();
						}
					CommandString = "LISTBANS";
					}
				}
			else
				Sender.ClientMessage("This command is restricted to Chat Admins.");
			}
		else if ( Left(Caps(CommandString),9) == "ADDADMIN " )
			{
			if ( bAdmin )
				{
				ParameterString = Mid(CommandString,9);
				iInfractionRecord = GetInfractionIndexByName( ParameterString );
				if ( iInfractionRecord >= 0 )
					IPString = InfractionRecords[ iInfractionRecord ].IP;
				else
					{
					i = Int( ParameterString );
					if ( i > 0 )
						IPString = ParameterString;
					}
				if ( IPString == "" )
					Sender.ClientMessage( "Player"@ParameterString@"not found not found (or has no IP listed)." );
				else
					{
					for ( i = 0; ( ( i < 20 ) && ( Len( ChatAdminIP[ i ] ) > 0 ) ); i++ );
					if ( i < 20 )
						{
						Sender.ClientMessage("Adding Chat Admin IP"@IPString);
						ChatAdminIP[ i ] = IPString;
						default.ChatAdminIP[ i ] = IPString;
						SaveConfig();
						}
					CommandString = "LISTADMINS";
					}
				}
			else
				Sender.ClientMessage("This command is restricted to Server Admins.");
			}
		else if ( ( Left(Caps(CommandString),12) == "REMOVEADMIN " ) && ( bAdmin ) )
			{
			if ( bAdmin )
				{
				ParameterString = Mid(CommandString,12);
				iInfractionRecord = GetInfractionIndexByName( ParameterString );
				if ( iInfractionRecord >= 0 )
					IPString = InfractionRecords[ iInfractionRecord ].IP;
				else
					{
					i = Int( ParameterString );
					if ( i > 0 )
						IPString = ParameterString;
					}
				if ( IPString == "" )
					Sender.ClientMessage( "Player"@ParameterString@"not found (or has no IP listed)." );
				else
					{
					for ( i = 0; ( ( i < 20 ) && ( Len( ChatAdminIP[ i ] ) > 0 ) && ( ChatAdminIP[ i ] != IPString ) ); i++ );
					if ( ChatAdminIP[ i ] ~= IPString )
						{
						Sender.ClientMessage("Removing Chat Admin IP"@IPString);
						for ( i = i; ( ( i < 99 ) && ( Len( ChatAdminIP[ i + 1 ] ) > 0 ) ); i++ )
							{
							ChatAdminIP[ i ] = ChatAdminIP[ i + 1 ];
							default.ChatAdminIP[ i ] = ChatAdminIP[ i + 1 ];
							}
						ChatAdminIP[ i ] = "";
						default.ChatAdminIP[ i ] = "";
						SaveConfig();
						}
					CommandString = "LISTADMINS";
					}
				}
			else
				Sender.ClientMessage("This command is restricted to Server Admins.");
			}

		if ( Left(Caps(CommandString),9) == "LISTWORDS" )
			{
			Sender.ClientMessage("Current Banned Words:");
			for ( i = 0; ( ( i < 100 ) && ( Len( CheckedWords[ i ] ) > 0 ) ); i++ )
				{
				Sender.ClientMessage(CheckedWords[ i ]);
				}
			}

		if ( Left(Caps(CommandString),11) == "LISTPLAYERS" )
			{
			FindNewPlayers();
			Sender.ClientMessage("Players:");
			for (i = 0; i < 256; i++)
				{
				if ( InfractionRecords[ i ].bInitialized )
					{
					PlayerList = "";
					if ( ( bAdmin ) || ( bKICAdmin ) )
						PlayerList = InfractionRecords[ i ].IP@"";
					PlayerList = PlayerList$InfractionRecords[ i ].PlayerName@"Offenses="$InfractionRecords[ i ].InfractionCount@"CensorTime="$InfractionRecords[ i ].CensorTime;
					Sender.ClientMessage(PlayerList);
					}
				}
			}

		if ( Left(Caps(CommandString),8) == "LISTBANS" ) 
			{
			if ( ( bAdmin ) || ( bKICAdmin ) )
				{
				Sender.ClientMessage("Current Chat Bans:");
				for ( i = 0; ( ( i < 100 ) && ( Len( ChatDenyIP[ i ] ) > 0 ) ); i++ )
					{
					Sender.ClientMessage(ChatDenyIP[ i ]);
					i2 = 1;
					While ( i2 > 0 )
						{
						iInfractionRecord = GetInfractionIndexByIP( ChatDenyIP[ i ], i2 );
						if ( iInfractionRecord >= 0 )
							{
							Sender.ClientMessage("  "$InfractionRecords[ iInfractionRecord ].PlayerName@InfractionRecords[ iInfractionRecord ].IP);
							i2++;
							}
						else
							i2 = 0;
						}
					}
				}
			else
				Sender.ClientMessage("This command is restricted to Chat Admins.");
			}
		if ( Left(Caps(CommandString),10) == "LISTADMINS" )
			{
			if ( bAdmin )
				{
				Sender.ClientMessage("Current Chat Admins:");
				for ( i = 0; ( ( i < 20 ) && ( Len( ChatAdminIP[ i ] ) > 0 ) ); i++ )
					{
					Sender.ClientMessage(ChatAdminIP[ i ]);
					i2 = 1;
					While ( i2 > 0 )
						{
						iInfractionRecord = GetInfractionIndexByIP( ChatAdminIP[ i ], i2 );
						if ( iInfractionRecord >= 0 )
							{
							if ( ( bAdmin ) || ( bKICAdmin ) )
								Sender.ClientMessage("  "$InfractionRecords[ iInfractionRecord ].PlayerName@InfractionRecords[ iInfractionRecord ].IP);
							else
								Sender.ClientMessage("  "$InfractionRecords[ iInfractionRecord ].PlayerName);
							i2++;
							}
						else
							i2 = 0;
						}
					}
				}
			else
				Sender.ClientMessage("This command is restricted to Server Admins.");
			}
		}
}

function bool StrictCleanUpText(string InText, out string OutText)
{
local string checkText;
local string nameCaps;
local int i;
local int pos;
local int aiCharacterOffset[ 1024 ];
local int iCheckedWordLen;
local int iDestOffset;
local int iSourceOffset;
local string strSourceChr;
local string strCheck;
local int iCheckLen;
local bool bDone;
local int iLen;
local string strCompressedSource;
local int iStartPos;
local int iFrontSeparatorCount;
local int iCompressedSourceLen;

    checkText = InText;
    nameCaps = Caps(checkText);
    OutText = checkText;
	for ( i = 0; ( ( i < 100 ) && ( Len( Checks[ i ] ) > 0 ) ); i++ )
    {
		iLen = Len( Checks[ i ] );
		iDestOffset = 0;
		strCheck = "";
		for( iSourceOffset = 0; iSourceOffset < iLen; iSourceOffset++ )
		{
			strSourceChr = Mid( Checks[ i ], iSourceOffset, 1 );
			if ( ( strSourceChr >= "A" ) && ( strSourceChr <= "Z" ) )
			{
				strCheck = strCheck $ strSourceChr;
				iDestOffset++;
			}
		}
		iCheckLen = iDestOffset;
	//	Log( "Checks[ i ] ="@Checks[ i ]$", strCheck ="@strCheck$", CheckLen ="@iCheckLen );

		iStartPos = 0;
		bDone = false;
		while( ! bDone )
		{
			iLen = Len( nameCaps );
			iDestOffset = 0;
			strCompressedSource = "";
			for( iSourceOffset = 0; ( ( iSourceOffset < iLen ) && ( iDestOffset < 1024 ) ); iSourceOffset++ )
			{
				strSourceChr = Mid( nameCaps, iSourceOffset, 1 );
				if ( ( strSourceChr >= "A" ) && ( strSourceChr <= "Z" ) )
				{
					strCompressedSource = strCompressedSource $ strSourceChr;
					aiCharacterOffset[ iDestOffset++ ] = iSourceOffset;
				}
			}
			iCompressedSourceLen = iDestOffset;

		//	Log( "OutText ="@OutText$", strCompressedSource ="@strCompressedSource$", iCompressedSouceLen ="@iCompressedSourceLen );

			pos = InStr(Mid( strCompressedSource, iStartPos ), strCheck);
			if (pos >= 0) // found it...
			{
				iFrontSeparatorCount = 2;
				if ( pos > 0 )
					iFrontSeparatorCount = aiCharacterOffset[ pos + iStartPos ] - aiCharacterOffset[ ( pos + iStartPos ) - 1];
				if ( ( pos == 0 ) || ( iFrontSeparatorCount > 1 ) )
				{	// Word is at the start of the line - or after some sort of terminator
					if ( ( pos + iStartPos + iCheckLen ) < iCompressedSourceLen )
						OutText = Left( checkText, aiCharacterOffset[ pos + iStartPos ] ) $ Replacements[i] $ Mid(checkText, aiCharacterOffset[ pos + iStartPos + iCheckLen - 1 ] + 1 );
					else
					{
						if ( pos + iStartPos < iCompressedSourceLen )
							OutText = Left( checkText, aiCharacterOffset[ pos + iStartPos ] ) $ Replacements[i];
						else	// If we are too big - then exit!
							{
							Log("KeepItClean WARNING: Possible recurrsive substitution error encountered while checking -"@Checks[ i ] $ ":" $ Replacements[i] );
							Log("KeepItClean WARNING: While parsing:"@checkText );
							Log("KeepItClean WARNING: Message deleted." );
							OutText = "KeepItClean Warning: Possible recurrsive substitution error encountered - check the Server log file.";
							bDone = true;
							}
					}
					checkText = OutText;
					nameCaps = Caps(checkText); // to preserve our changes in case some other bad words have been formed... :-)
				}
				iStartPos = pos + 1;
			}
			else
				bDone = true;
        }
    }

    if (InText != OutText)
    {
        return(true);
    }

    return(false);
}

function bool FastCleanUpText(string InText, out string OutText)
{
    local string checkText;
	local string nameCaps;
    local int i;
    local int pos;
    local int oldpos;
    local int oldlen;

    checkText = InText;
    nameCaps = Caps(checkText);
    OutText = checkText;
	for ( i = 0; ( ( i < 100 ) && ( Len( Checks[ i ] ) > 0 ) ); i++ )
    {
        pos = InStr(nameCaps, Checks[i]);
        while (pos >= 0) // found it...
        {
            oldpos = pos;
            OutText = Left(checkText, pos) $ Replacements[i] $ Right(checkText, Len(checkText) - pos - Len(Checks[i]));
            checkText = OutText;
            nameCaps = Caps(checkText); // to preserve our changes in case some other bad words have been formed... :-)
            pos = InStr(Right(nameCaps, Len(nameCaps) - (oldpos + Len(Replacements[i]))), Checks[i]);
            if (pos >= 0)
            {
                pos = pos + oldpos + Len(Replacements[i]);
            }
        }
    }

    if (InText != OutText)
    {
        return(true);
    }

    return(false);
}

function PlayerPawn FindThePlayer(string PlayerName)
{
	local Pawn aPawn;

	for (aPawn = Level.PawnList; aPawn != None; aPawn = aPawn.NextPawn )
    {
		if (aPawn.bIsPlayer && aPawn.IsA('PlayerPawn') && aPawn.PlayerReplicationInfo.PlayerName~=PlayerName)
		{
            return(PlayerPawn(aPawn));
		}
    }

    return(None);
}

function KickThePlayer(PlayerPawn Player, string Msg)
{
    if (Player != None)
    {
        Log("Player '" $ Player.PlayerReplicationInfo.PlayerName $ "' kicked due to language");
        if (Len(Msg) > 0)
        {
            Player.ClientMessage(Msg, 'Event', true);
        }
        if (NetConnection(Player.Player) != None)
        {
            Player.Destroy();
        }
    }
}

function string GetCurrentDateTime()
{
    local string timeStr;

	timeStr = string(Level.Year);
    timeStr = timeStr $ "/" $ Level.Month;
    timeStr = timeStr $ "/" $ Level.Day;
    timeStr = timeStr $ " " $ Level.Hour;
	if (Level.Minute < 10)
		timeStr = timeStr $ ":0" $ Level.Minute;
	else
		timeStr = timeStr $ ":" $ Level.Minute;
	return(timeStr);
}

function bool MutatorBroadcastMessage(Actor Sender, Pawn Receiver, out coerce string Msg, optional bool bBeep, out optional name Type)
{
    if (LogAllMessages && string(Receiver.NextPawn) == "None")
    {
        Log(LogPrefix $ " " $ GetCurrentDateTime() $ " (BROADCAST): " $ Msg);
    }

    if (NextMessageMutator != None)
    {
        return(NextMessageMutator.MutatorBroadcastMessage(Sender, Receiver, Msg, bBeep, Type));
    }
    return(true);
}

function int CreateInfractionRecord( PlayerReplicationInfo PRI, string IP )
{
local bool bCreated;
local bool bFoundPlayer;
local int i;
local int iInfractionRecord;
local int iColon;
local string IPOnly;


	iColon = InStr( IP, ":" );
	if ( iColon > 0 )
		IPOnly = Left( IP, iColon );
	else
		IPOnly = IP;

	bFoundPlayer = false;
	bCreated = false;
	for (i = 0; ( ( i < 256 ) && ( ! bCreated ) ); i++)
	{
		if ( InfractionRecords[ i ].bInitialized )
		{		// Make sure we don't create a record that exists!
			if ( ( IPOnly == InfractionRecords[ i ].IP ) 
				&& ( ( PRI.PlayerID == InfractionRecords[ i ].PID )
					|| ( Caps(PRI.PlayerName) == Caps(InfractionRecords[ i ].PlayerName) ) ) )
			{
				iInfractionRecord = i;
				bFoundPlayer = true;
			}
		}
		else	// if ( ! InfractionRecords[ i ].bInitialized )
		{
			iInfractionRecord = i;
			bCreated = true;
			InfractionRecords[ iInfractionRecord ].bInitialized = true;
			InfractionRecords[ iInfractionRecord ].PlayerName = PRI.PlayerName;
			InfractionRecords[ iInfractionRecord ].bLastToSentSet = false;
			InfractionRecords[ iInfractionRecord ].bLastToReceivedSet = false;
			InfractionRecords[ iInfractionRecord ].PID = PRI.PlayerID;
			InfractionRecords[ iInfractionRecord ].InfractionCount = 0;
			InfractionRecords[ iInfractionRecord ].LastMessageSentTime = 0;
			InfractionRecords[ iInfractionRecord ].bTextChanged = false;
			InfractionRecords[ iInfractionRecord ].CensorTime = 0;
			InfractionRecords[ iInfractionRecord ].IP = IPOnly;
	        Log(LogPrefix
				@GetCurrentDateTime()
				@"(NewPlayer): Creating new Infraction Record"
				@iInfractionRecord
				@"for"
				@InfractionRecords[ iInfractionRecord ].PlayerName
				@InfractionRecords[ iInfractionRecord ].IP
				@InfractionRecords[ iInfractionRecord ].PID
				);
		}
	}
	if ( ( bCreated ) || ( bFoundPlayer ) )
		return( iInfractionRecord );
	else
		return( -1 );
}

function int GetInfractionIndex( PlayerReplicationInfo PRI, string IP )
{
local bool bFoundPlayer;
local int i;
local int iInfractionRecord;
local int iColon;
local string IPOnly;


	iColon = InStr( IP, ":" );
	if ( iColon > 0 )
		IPOnly = Left( IP, iColon );
	else
		IPOnly = IP;

	bFoundPlayer = false;
	for (i = 0; ( ( i < 256 ) && ( ! bFoundPlayer ) ); i++)
	{
		if ( InfractionRecords[ i ].bInitialized )
		{
			if ( ( IPOnly == InfractionRecords[ i ].IP ) 
				&& ( ( PRI.PlayerID == InfractionRecords[ i ].PID )
					|| ( Caps(PRI.PlayerName) == Caps(InfractionRecords[ i ].PlayerName) ) ) )
			{
				iInfractionRecord = i;
				bFoundPlayer = true;
			}
		}
	}
	if ( bFoundPlayer )
		return( iInfractionRecord );
	else
		return( -1 );
}

function int GetInfractionIndexByIP( string IP, int iNumber )
{
local bool bFoundPlayer;
local int i;
local int iCount;
local int iInfractionRecord;
local int iColon;
local string IPOnly;


	iColon = InStr( IP, ":" );
	if ( iColon > 0 )
		IPOnly = Left( IP, iColon );
	else
		IPOnly = IP;

	iCount = 0;
	bFoundPlayer = false;
	for (i = 0; ( ( i < 256 ) && ( ! bFoundPlayer ) ); i++)
		{
		if ( InfractionRecords[ i ].bInitialized )
			{
			if ( IPOnly == InfractionRecords[ i ].IP ) 
				{
				iInfractionRecord = i;
				iCount++;
				if ( iCount >= iNumber )
					{
					bFoundPlayer = true;
					}
				}
			}
		}
	if ( bFoundPlayer )
		return( iInfractionRecord );
	else
		return( -1 );
}

function int GetInfractionIndexByName( string PlayerName )
{
local bool bFoundPlayer;
local int i;
local int iInfractionRecord;

	bFoundPlayer = false;
	for (i = 0; ( ( i < 256 ) && ( ! bFoundPlayer ) ); i++)
	{
		if ( InfractionRecords[ i ].bInitialized )
		{
			if ( Caps(PlayerName) == Caps(InfractionRecords[ i ].PlayerName) ) 
			{
				iInfractionRecord = i;
				bFoundPlayer = true;
			}
		}
	}
	if ( bFoundPlayer )
		return( iInfractionRecord );
	else
		return( -1 );
}

function bool CheckChatDenyIP( string IP )
{
local int i;
local int iAsterick;
local int iColon;
local string IPOnly;


	iColon = InStr( IP, ":" );
	if ( iColon > 0 )
		IPOnly = Left( IP, iColon );
	else
		IPOnly = IP;

	for ( i = 0; ( ( i < 100 ) && ( Len( ChatDenyIP[ i ] ) > 0 ) ); i++ )
		{
		iAsterick = InStr(ChatDenyIP[ i ],"*");
		if ( iAsterick <= 0 )
			iAsterick = Len( ChatDenyIP[ i ] );
		if ( Left(ChatDenyIP[ i ], iAsterick ) == Left(IPOnly, iAsterick ) )
			{
		//	Log( "CheckChatDenyIP is Banning"@IP@"matches"@ChatDenyIP[i]@"entry"@i@"Length"@iAsterick);
			return( true );
			}
		}
	return( false );
}

function bool CheckChatAdminIP( string IP )
{
local int i;
local int iAsterick;
local int iColon;
local string IPOnly;


	iColon = InStr( IP, ":" );
	if ( iColon > 0 )
		IPOnly = Left( IP, iColon );
	else
		IPOnly = IP;

	for ( i = 0; ( ( i < 20 ) && ( Len( ChatAdminIP[ i ] ) > 0 ) ); i++ )
		{
		iAsterick = InStr(ChatAdminIP[ i ],"*");
		if ( iAsterick <= 0 )
			iAsterick = Len( ChatAdminIP[ i ] );
		if ( Left(ChatAdminIP[ i ], iAsterick ) == Left(IPOnly, iAsterick ) )
			{
			return( true );
			}
		}
	return( false );
}

function bool MutatorTeamMessage(Actor Sender, Pawn Receiver, PlayerReplicationInfo PRI, coerce string S, name Type, optional bool bBeep)
{
    local string outText;
	local bool bCensored;
	local bool bCancelOriginalMessage;
	local bool bFoundPlayer;
	local bool bTextChanged;
	local bool bDontLog;
	local bool bRepremanded;
	local bool bUpdateLastToInfo;
	local bool bHaveSenderIP;
	local bool bHaveReceiverIP;
	local bool bBroadcastIP;
	local bool bBanned;
	local string strMessage, ToName, S1, T;
	local int iAsterick;
	local string SenderIP;
	local string ReceiverIP;
	local int iColon;
	local string IP;
	local int CurrentTime;
	local int i;
	local int iInfractionRecord;
	local int iRecipInfractionRecord;
	local bool bFilterMessage;

	bFilterMessage = true;
	bCensored = false;
	bCancelOriginalMessage = false;
	bTextChanged = false;
	bDontLog = false;
	bRepremanded = false;
	bHaveSenderIP = false;
	bHaveReceiverIP = false;
	bBroadcastIP = false;
	bBanned = false;
	CurrentTime = Level.TimeSeconds;

    if (PRI != None && Receiver != None && Sender.IsA('PlayerPawn'))
    {
		if ( PlayerPawn(Sender).bIsPlayer
			&&	(PlayerPawn(Sender)==None || NetConnection(PlayerPawn(Sender).Player)!=None ) )
		{
			bHaveSenderIP = true;
			IP = PlayerPawn(Sender).GetPlayerNetworkAddress();
			iColon = InStr( IP, ":" );
			SenderIP = Left( IP, iColon );
			bBanned = CheckChatDenyIP( SenderIP );
		}
		else
			SenderIP = "";
		bFoundPlayer = false;
		iInfractionRecord = GetInfractionIndex( PRI, SenderIP );
		if ( iInfractionRecord >= 0 )
		{
			bFoundPlayer = true;
			if ( InfractionRecords[ iInfractionRecord ].CensorTime > 0 )
				bCensored = true;
		}
		if ( ! bFoundPlayer )
		{
			iInfractionRecord = CreateInfractionRecord( PRI, SenderIP );
			if ( iInfractionRecord >= 0 )
				bFoundPlayer = true;
		}
		// Try not to filter every message sent.  If this message is being sent within 2 seconds of the last 
		// message that the same player sent - compare it to the previous message and if it is the same
		// then dont re-filter it
		// It would be nice if there was a HOOK into the SAY command - before the loop that sends to all 
		// the clients, so that we could get away with just filtering the message one time.
		if( bFoundPlayer )		// By now it better be true!
		{
			if ( CurrentTime <= InfractionRecords[ iInfractionRecord ].LastMessageSentTime + 2 )
			{
				if ( InfractionRecords[ iInfractionRecord ].LastMessageSent ~= S ) 
				{
					bFilterMessage = false;
				}
			}
		}

		bUpdateLastToInfo = false;
		strMessage = S;
		S1 = S;
		ToName = "";
		if ( (AllowSpectatorsToSendPrivateMessage) || (!(Sender.IsA('Spectator'))) || ( PRI.bAdmin ) )
			{
		//Log( "Processing ="@S );
			if ( Left(Caps(S),3) == "TO " )
			{
				T = Mid(S,3);
				i = InStr(T,":");
				if ( i >= 1 )
				{
		//Log( "In To code" );
					ToName = Left( T, i ); 
					strMessage = Mid( T, i + 1 );
					bUpdateLastToInfo = true;
				}
			}
			else if ( ( Left(S,1) == "&" )			// Send this message to the last person we sent a TO message too
					&& ( bFoundPlayer )
					&& ( InfractionRecords[ iInfractionRecord ].bLastToSentSet ) )
			{
				ToName = InfractionRecords[ iInfractionRecord ].LastToSent;
				strMessage = Mid(S,1);
		//Log( "In Ampersand code" );
			}
			else if ( ( Left(S,1) == "<" )			// Send this message to the last person who sent a TO message to us
					&& ( bFoundPlayer )
					&& ( InfractionRecords[ iInfractionRecord ].bLastToReceivedSet ) )
			{
				ToName = InfractionRecords[ iInfractionRecord ].LastToReceived;
				strMessage = Mid(S,1);
		//Log( "In < code" );
			}
			if ( Len( ToName ) > 0 )
			{
		//Log( "ToName = |" $ ToName $ "| strMessage = |" $ strMessage $ "|" );
		//		if ( Caps(ToName) != Caps(Receiver.PlayerReplicationInfo.PlayerName) )
				iAsterick = InStr(ToName,"*");
				if ( ( ( iAsterick < 0 ) && ( Caps(ToName) != Caps(Receiver.PlayerReplicationInfo.PlayerName) ) )
					|| ( ( iAsterick >= 0 ) && ( Caps(Left(ToName, iAsterick ) ) != Caps(Left(Receiver.PlayerReplicationInfo.PlayerName, iAsterick ) ) ) ) )
					bCancelOriginalMessage = true;
				else if ( ( ! bCensored ) && ( ! bBanned ) )
				{
					PlayerPawn(Sender).ClientMessage( "Message Delivered to" @ Receiver.PlayerReplicationInfo.PlayerName $ ":" $ strMessage, 'Event', true);
					if ( bUpdateLastToInfo )
					{
						if ( bFoundPlayer )
						{
							InfractionRecords[ iInfractionRecord ].LastToSent = ToName;
							InfractionRecords[ iInfractionRecord ].bLastToSentSet = true;
						}
						// Update the recipients record with our name
						if ( Receiver.bIsPlayer
							&&	(PlayerPawn(Receiver)==None || NetConnection(PlayerPawn(Receiver).Player)!=None ) )
						{
							bHaveReceiverIP = true;
							IP = PlayerPawn(Receiver).GetPlayerNetworkAddress();
							iColon = InStr( IP, ":" );
							ReceiverIP = Left( IP, iColon );
						}
						iRecipInfractionRecord = GetInfractionIndex( Receiver.PlayerReplicationInfo, ReceiverIP );
						if ( iRecipInfractionRecord < 0 )
							iRecipInfractionRecord = CreateInfractionRecord( Receiver.PlayerReplicationInfo, ReceiverIP );
						if ( iRecipInfractionRecord >= 0 )
						{
							InfractionRecords[ iRecipInfractionRecord ].LastToReceived = PRI.PlayerName;
							InfractionRecords[ iRecipInfractionRecord ].bLastToReceivedSet = true;
						}
					}
				}
				S1 = "TO " $ ToName $ ":" $ strMessage;
			}
		}
	//Log( "S1 ="@S1 );
		if ( Left(strMessage, 1) == "!" )		// Private message - don't write it to the chat log
			bDontLog = true;
		if ( ( ! bCensored ) && ( ! bBanned ) )
		{
			if ( bFilterMessage )
			{
				if ( StrictTextParsing )
					bTextChanged = StrictCleanUpText(S1, outText); // text was changed?
				else 
					bTextChanged = FastCleanUpText(S1, outText); // text was changed?
				if( bFoundPlayer )
				{
					InfractionRecords[ iInfractionRecord ].bTextChanged = bTextChanged;
					InfractionRecords[ iInfractionRecord ].LastMessageSent = OutText;
					InfractionRecords[ iInfractionRecord ].LastMessageSentTime = CurrentTime;
				}
			}
			else
			{
				bTextChanged = InfractionRecords[ iInfractionRecord ].bTextChanged;
				OutText = InfractionRecords[ iInfractionRecord ].LastMessageSent;
			}
			if ( bTextChanged )
			{
				if (KickPlayerForTalk && string(Receiver.NextPawn) == "None")
				{
					KickThePlayer(PlayerPawn(Sender), TalkMessage);
					return(false);
				}
				if ( ! bCensored )
				{
					if (ChangeTalk)
					{
						if ( ! bCancelOriginalMessage )
							PlayerPawn(Receiver).TeamMessage(PRI, outText, Type, true);
						bCancelOriginalMessage = true;
					//	return(false); // have to cancel the original and send a new one, since we can't change the value of the text...
					}
				}
			}
		}
		if (string(Receiver.NextPawn) == "None")
		{
			if ( bTextChanged )
			{
				if ( bFoundPlayer )
				{
					InfractionRecords[ iInfractionRecord ].InfractionCount++;
					if ( ( MaxInfractions > 0 ) || ( MaxIPInfractions > 0 ) )
					{
						if ( ( bHaveSenderIP ) && ( MaxIPInfractions > 0 ) && ( InfractionRecords[ iInfractionRecord ].InfractionCount >= MaxIPInfractions ) )
						{
							bBroadcastIP = true;
							InfractionRecords[ iInfractionRecord ].CensorTime += CensorTime;
							Log(LogPrefix@GetCurrentDateTime()@"Language Infraction!"@PRI.PlayerName@"at"@SenderIP@" chat messages will be suppressed for"@InfractionRecords[ iInfractionRecord ].CensorTime@"seconds.");
				    		PlayerPawn(Sender).ReceiveLocalizedMessage(class'KeepItCleanMessage', 0);
						}
						else if ( ( bHaveSenderIP ) && ( MaxIPInfractions > 0 ) && ( InfractionRecords[ iInfractionRecord ].InfractionCount == ( MaxIPInfractions - 1 ) ) )
						{
							InfractionRecords[ iInfractionRecord ].CensorTime += CensorTime;
							Log(LogPrefix@GetCurrentDateTime()@"Language Infraction!"@PRI.PlayerName$"'s chat messages will be suppressed for"@InfractionRecords[ iInfractionRecord ].CensorTime@"seconds.");
							PlayerPawn(Sender).ClientMessage("Excessive Language Infractions!  Your IP will be broadcast to all users on your next language infraction! Chat privilege suspended.  You cannot send any chat messages for"@InfractionRecords[ iInfractionRecord ].CensorTime@"seconds.", 'Event', true);
				    		PlayerPawn(Sender).ReceiveLocalizedMessage(class'KeepItCleanMessage', 1);
							bRepremanded = true;
						}
						else if ( ( bHaveSenderIP ) && ( MaxIPInfractions > 0 ) && ( InfractionRecords[ iInfractionRecord ].InfractionCount >= MaxInfractions ) )
						{
							InfractionRecords[ iInfractionRecord ].CensorTime += CensorTime;
							Log(LogPrefix@GetCurrentDateTime()@"Language Infraction!"@PRI.PlayerName$"'s chat messages will be suppressed for"@InfractionRecords[ iInfractionRecord ].CensorTime@"seconds.");
							PlayerPawn(Sender).ClientMessage("Excessive Language Infractions!  If you continue your IP will be broadcast to all users! Chat privilege suspended.  You cannot send any chat messages for"@InfractionRecords[ iInfractionRecord ].CensorTime@"seconds.", 'Event', true);
				    		PlayerPawn(Sender).ReceiveLocalizedMessage(class'KeepItCleanMessage', 2);
							bRepremanded = true;
						}
						else if ( ( MaxInfractions > 0 ) && ( InfractionRecords[ iInfractionRecord ].InfractionCount >= MaxInfractions ) )
						{
							InfractionRecords[ iInfractionRecord ].CensorTime += CensorTime;
							Log(LogPrefix@GetCurrentDateTime()@"Language Infraction!"@PRI.PlayerName$"'s chat messages will be suppressed for"@InfractionRecords[ iInfractionRecord ].CensorTime@"seconds.");
						}
					}
					if ( ( ! bRepremanded ) && ( InfractionRecords[ iInfractionRecord ].CensorTime > 0 ) )
					{
						PlayerPawn(Sender).ClientMessage("Excessive Language Infractions!  You cannot send any chat messages for"@InfractionRecords[ iInfractionRecord ].CensorTime@"seconds.", 'Event', true);
						bRepremanded = true;
					}
				}
				if ( (Len(TalkMessage) > 0) && ( ! bRepremanded ) )
				{
					PlayerPawn(Sender).ClientMessage(TalkMessage, 'Event', true);
				}
			}
			if ( ( LogAllMessages ) && ( ! bDontLog ) )
			{
				if ( bCensored )
				{
					if ( ! bRepremanded )
						PlayerPawn(Sender).ClientMessage("Message NOT sent!  You cannot send any chat messages for " $ InfractionRecords[ iInfractionRecord ].CensorTime $ " more seconds.", 'Event', true);
					Log(LogPrefix@GetCurrentDateTime()@PRI.PlayerName $ ": CENSORED:"@S1);
				}
				else if ( bBanned )
				{
					PlayerPawn(Sender).ClientMessage("Message NOT sent!  You have been banned from sending any chat messages on this server!", 'Event', true);
					Log(LogPrefix@GetCurrentDateTime()@PRI.PlayerName $ ": BANNED:"@S1);
				}
				else
					Log(LogPrefix@GetCurrentDateTime()@PRI.PlayerName $ ":"@S1);
			}
			if ( bFoundPlayer )
			{
				if ( PRI.PlayerName != InfractionRecords[ iInfractionRecord ].PlayerName )
				{
					if ( bBroadcastIP )
						BroadcastMessage( PRI.PlayerName@"(Player #"$InfractionRecords[ iInfractionRecord ].PID@"at IP"@SenderIP$") was previously known as"@InfractionRecords[ iInfractionRecord ].PlayerName );
					else
						BroadcastMessage( PRI.PlayerName@"(Player #"$InfractionRecords[ iInfractionRecord ].PID$") was previously known as"@InfractionRecords[ iInfractionRecord ].PlayerName );
					InfractionRecords[ iInfractionRecord ].PlayerName = PRI.PlayerName;
				}
				else if ( bBroadcastIP )
					BroadcastMessage( PRI.PlayerName@"(Player #"$InfractionRecords[ iInfractionRecord ].PID@"at IP"@SenderIP$") has violated the language rules of this server too many times." );
			}
		}
    }
	if ( ( bBanned ) || ( bCensored ) || ( bCancelOriginalMessage ) )
		return( false );

	if ( bDontLog ) 
		return( true );

	if (NextMessageMutator != None)
    {
		return NextMessageMutator.MutatorTeamMessage(Sender, Receiver, PRI, S, Type, bBeep);
    }
    return(true);
}

defaultproperties
{
    ChangeTalk=True
    LogPrefix=">>SayLog>>"
    StrictTextParsing=True
}
