class KickIdlers expands Mutator config(theSeeker3);

var config int KickTime; // in sec
var config bool OnlyKickWhenFull;
var config bool ShutDownAfterGame;
var config bool AllowKickIdlersCommand;
var config bool AllowShowSlackersCommand;
var config bool Advertise;
var bool Initialized;
var bool Active;
var int NextCheckTime;
var int NextAdvertiseTime;
var int AdvertisementCount;

struct FireRecord   //player fire records
{
	var bool bInitialized;					// Initialized
	var int LastFireTime;					// Last Action Time
	var vector LastViewRotationVector;		// Last View Vector
	var vector LastLocation;				// Last position
};

var FireRecord FireRecords[128]; //keep record of max 32 players

function Mutate(string MutateString, PlayerPawn Sender)
{
local bool bShowIdlers;
local bool bKickIdlers;
local bool bShowSlackers;
local Pawn P;
local int PID;
local int CurTime;
local int Idlers;
local vector CurViewRotationVector;
local int SecondsLeft;
local int SecondsIdle;
local bool LocalAllowKickIdlersCommand;
local bool LocalAllowShowSlackersCommand;
local string strDisplayAction;

	bShowIdlers = False;
	bKickIdlers = False;
	bShowSlackers = False;
	Idlers = 0;

	LocalAllowKickIdlersCommand = AllowKickIdlersCommand;
	if ( Sender.PlayerReplicationInfo.bAdmin )
		LocalAllowKickIdlersCommand = True;

	LocalAllowShowSlackersCommand = AllowShowSlackersCommand;
	if ( Sender.PlayerReplicationInfo.bAdmin )
		LocalAllowShowSlackersCommand = True;

	if ( Left(Caps(MutateString),10) == "SHOWIDLERS" )
		{
		bShowIdlers = True;
		strDisplayAction = "found";
		Log("KickIdlers - " $ Sender.PlayerReplicationInfo.PlayerName $ " has issued the ShowIdlers command.");
		}
	else if ( Left(Caps(MutateString),12) == "SHOWSLACKERS" )
		{
		if ( LocalAllowShowSlackersCommand )
			{
			bShowSlackers = True;
			strDisplayAction = "found";
			}
		}
	else if ( Left(Caps(MutateString),10) == "KICKIDLERS" )
		{
		if ( LocalAllowKickIdlersCommand )
			{
			bKickIdlers = True;
			strDisplayAction = "kicked";
			Log("KickIdlers - " $ Sender.PlayerReplicationInfo.PlayerName $ " has issued the KickIdlers command.");
			}
		}

	if ( ( bKickIdlers ) || ( bShowIdlers ) || ( bShowSlackers ) )
		{
		for(P=level.pawnlist; P!=none ; P=P.nextpawn)
			{	
			if ( P.bIsPlayer 
				&& P.IsA('PlayerPawn') 
				&& !P.PlayerReplicationInfo.bIsABot 
				&& !P.PlayerReplicationInfo.bIsSpectator
				)
				{
				if ( !P.PlayerReplicationInfo.bAdmin )
					{
					PID = P.PlayerReplicationInfo.PlayerID; // get player ID
					if ( FireRecords[PID].bInitialized )
						{
						CurViewRotationVector = Vector(P.ViewRotation);
						CurTime = Level.TimeSeconds;
						if ( (P.bFire != 0) || (P.bAltFire != 0) 
							|| (P.PlayerReplicationInfo.HasFlag != None) 
							|| ( ! FireRecords[PID].bInitialized ) 
							|| ( FireRecords[PID].LastViewRotationVector != CurViewRotationVector ) 
							|| ( FireRecords[PID].LastLocation != P.Location ) 
							)
							{
							FireRecords[PID].bInitialized = True; // This record is initialized
							FireRecords[PID].LastFireTime = CurTime; // restart time
							FireRecords[PID].LastViewRotationVector = CurViewRotationVector;
							FireRecords[PID].LastLocation = P.Location;
							}
						else
							{
							SecondsLeft = KickTime - ( CurTime - FireRecords[PID].LastFireTime );
							SecondsIdle = ( 0 - SecondsLeft ) + KickTime;
							if (SecondsLeft <= 0)
								{
								Idlers++;
								if ( bKickIdlers )
									{
	               					P.ReceiveLocalizedMessage( class'KickIdlersMsg',0 );
        							P.ClientMessage("You've been kicked by " $ Sender.PlayerReplicationInfo.PlayerName $ "'s KickIdlers command for not playing");
									BroadcastMessage(P.PlayerReplicationInfo.PlayerName $ " has been kicked by " $ Sender.PlayerReplicationInfo.PlayerName $ "'s KickIdlers command for not playing");
									Log(P.PlayerReplicationInfo.PlayerName $ " has been kicked by " $ Sender.PlayerReplicationInfo.PlayerName $ "'s KickIdlers command for not playing");
									P.Destroy(); // kick player
									FireRecords[PID].bInitialized = False;
									}
								else
									{
									if ( LocalAllowKickIdlersCommand )
										P.ClientMessage(Sender.PlayerReplicationInfo.PlayerName $ " has issued the ShowIdlers command.  Prepare to be kicked!");
									else
										P.ClientMessage(Sender.PlayerReplicationInfo.PlayerName $ " has issued the ShowIdlers command.");
									Sender.ClientMessage(P.PlayerReplicationInfo.PlayerName $ " has been idle for " $ SecondsIdle );
									Log(P.PlayerReplicationInfo.PlayerName $ " has been Idle for " $ SecondsIdle $ " seconds.");
									}
								}
							else if	( SecondsLeft <= ( KickTime / 2 ) )
								{
								if ( bShowSlackers )
									{
									Sender.ClientMessage(P.PlayerReplicationInfo.PlayerName $ " has been slacking for " $ SecondsIdle $ " seconds, and may become and Idler in " $ SecondsLeft $ " seconds." );
									Log(P.PlayerReplicationInfo.PlayerName $ " has been slacking for " $ SecondsIdle $ " seconds and may become and Idler in " $ SecondsLeft $ " seconds.");
									}
								}
							}
						}
					}
				}
			}
			if ( Idlers == 0 )
				Sender.ClientMessage( "No Idlers " $ strDisplayAction $ "." );
			else if ( Idlers == 1 )
				Sender.ClientMessage( Idlers $ " Idler " $ strDisplayAction $ "." );
			else
				Sender.ClientMessage( Idlers $ " Idlers " $ strDisplayAction $ "." );
		}
	if ( NextMutator != None )
		NextMutator.Mutate(MutateString, Sender);
}

function PostBeginPlay()
{
local int CurrentTime;
local int i;

	if (!Initialized)
	{
		Initialized = True;
		Active = True;
		CurrentTime = Level.TimeSeconds;
		for( i = 0; i < 128; i++ )
			{
			FireRecords[i].bInitialized = False;
			FireRecords[i].LastFireTime = CurrentTime;
			}
		NextCheckTime = CurrentTime + 2;
		NextAdvertiseTime = CurrentTime + 60;
		AdvertisementCount = 0;
		Enable('Tick');
	}
}

function bool HandleEndGame()
{
	if ( ShutDownAfterGame )
		{
		// Do not mess with Assult games in mid game
		if(Level.Game.IsA('Assault'))
			if( !Assault(Level.Game).bDefenseSet )
				return false;

		if ( ! TieGame() ) // If NOT a tie game - stop checking for IDLE players
			{
			Active = False;
			BroadcastMessage( "EOG: KickIdlers is shutting down.");
			}
		}

	SaveConfig();

	if ( NextMutator != None )
		return NextMutator.HandleEndGame();

   return false;
}

function bool TieGame()
{
local TeamInfo Best;
local int i;
local pawn P, BestP;
local PlayerPawn Player;

	if(Level.Game.IsA('Assault'))  //cant have ties in Assault, I think ?
		return false;

	if(Level.Game.IsA('Domination'))  //cant have ties in Domination, I think ?
		return false;

	if(Level.Game.IsA('TeamGamePlus'))  // check for a team game tie
		{
		// find best team
		for( i=0; i<TeamGamePlus(Level.Game).MaxTeams; i++ )
			if( (Best == None) || (Best.Score < TeamGamePlus(Level.Game).Teams[i].Score) )
				Best = TeamGamePlus(Level.Game).Teams[i];

		for( i=0; i<TeamGamePlus(Level.Game).MaxTeams; i++ )
			if( (Best.TeamIndex != i) && (Best.Score == TeamGamePlus(Level.Game).Teams[i].Score) )
				return true;  // teams tied
		}
	else   // check for death match tie
		{
		// find individual winner
		for( P=Level.PawnList; P!=None; P=P.nextPawn )
			if( P.bIsPlayer && ((BestP == None) || (P.PlayerReplicationInfo.Score > BestP.PlayerReplicationInfo.Score)) )
				BestP = P;
		// check for tie
		for ( P=Level.PawnList; P!=None; P=P.nextPawn )
			if ( P.bIsPlayer && (BestP != P) && (P.PlayerReplicationInfo.Score == BestP.PlayerReplicationInfo.Score) )
				return true; // tied
		}
	return false;  // No tie
}

function Tick(float DeltaTime)
{
local int CurrentTime;
local bool AdvertiseIdlers;
local int AdvertisementType;

	if ( Active )
		{
		AdvertiseIdlers = False;
		CurrentTime = Level.TimeSeconds;
		if ( ( Advertise ) && ( NextAdvertiseTime <= CurrentTime ) )
			{
			AdvertisementCount++;
			AdvertisementType = AdvertisementCount % 4;
			if ( AdvertisementType == 1 )		// Display the instructions every 2 minutes
				{
				if ( AllowKickIdlersCommand )
					{
					if ( AllowShowSlackersCommand )
						BroadcastMessage("KickIdlers: Type Mutate ShowIdlers (or ShowSlackers) to show, or Mutate KickIdlers to KICK, the people who aren't playing.");
					else
						BroadcastMessage("KickIdlers: Type Mutate ShowIdlers to show, or Mutate KickIdlers to KICK, the people who aren't playing.");
					}
				else
					{
					if ( AllowShowSlackersCommand )
						BroadcastMessage("KickIdlers: Type Mutate ShowIdlers (or ShowSlackers) to list the people who aren't playing.");
					else
						BroadcastMessage("KickIdlers: Type Mutate ShowIdlers to list the people who aren't playing.");
					}
				}
			AdvertiseIdlers = True;				// Display potential idlers every minute
			NextAdvertiseTime = CurrentTime + 60;
			NextCheckTime = CurrentTime;
			}
		UpdateFireTime();
		if ( CurrentTime >= NextCheckTime)
			{
			CheckFireTime( AdvertiseIdlers );
			NextCheckTime = CurrentTime + 2;		// Check every 2 seconds
			}
		}
}
	
function UpdateFireTime()
{	
local Pawn P;
local int PID;
local int CurTime;
local vector CurViewRotationVector;

	for(P=level.pawnlist; P!=none ; P=P.nextpawn)
		{	
		if ( P.bIsPlayer 
			&& P.IsA('PlayerPawn') 
			&& !P.PlayerReplicationInfo.bIsABot 
			&& !P.PlayerReplicationInfo.bIsSpectator 
			)
			{
			PID = P.PlayerReplicationInfo.PlayerID;
			PID = PID % 128;
			CurViewRotationVector = Vector(p.ViewRotation);
			CurTime = Level.TimeSeconds;
			if ( (P.bFire != 0) || (P.bAltFire != 0) 
				|| (P.PlayerReplicationInfo.HasFlag != None) 
				|| ( ! FireRecords[PID].bInitialized ) 
				|| ( FireRecords[PID].LastViewRotationVector != CurViewRotationVector ) 
				|| ( FireRecords[PID].LastLocation != P.Location ) 
				)
				{
				FireRecords[PID].bInitialized = True;								// This record is initialized
				FireRecords[PID].LastFireTime = CurTime;							// restart timer
				FireRecords[PID].LastViewRotationVector = CurViewRotationVector;	// Save the last vector
				FireRecords[PID].LastLocation = P.Location;
				}
			}
		}
}

function CheckFireTime( bool AdvertiseIdlers )
{	
local Pawn P;
local int PID;
local int CurTime;
local vector CurViewRotationVector;
local int SecondsLeft;
local int SecondsIdle;
local int PlayerCount;
local int Idlers;

	Idlers = 0;
	PlayerCount = 0;
	for(P=level.pawnlist; P!=none ; P=P.nextpawn)
		{	
		if ( P.bIsPlayer 
			&& P.IsA('PlayerPawn') 
			&& !P.PlayerReplicationInfo.bIsABot 
			&& !P.PlayerReplicationInfo.bIsSpectator
			)
			PlayerCount++;
		}

	for(P=level.pawnlist; P!=none ; P=P.nextpawn)
		{	
		if ( P.bIsPlayer 
			&& P.IsA('PlayerPawn') 
			&& !P.PlayerReplicationInfo.bIsABot 
			&& !P.PlayerReplicationInfo.bIsSpectator
			)
			{
			if ( !P.PlayerReplicationInfo.bAdmin )
				{
				PID = P.PlayerReplicationInfo.PlayerID; // get player ID
				if ( FireRecords[PID].bInitialized )
					{
					CurViewRotationVector = Vector(P.ViewRotation);
					CurTime = Level.TimeSeconds;
					if ( (P.bFire != 0) || (P.bAltFire != 0) 
						|| (P.PlayerReplicationInfo.HasFlag != None) 
						|| ( ! FireRecords[PID].bInitialized ) 
						|| ( FireRecords[PID].LastViewRotationVector != CurViewRotationVector ) 
						|| ( FireRecords[PID].LastLocation != P.Location ) 
						)
						{
						FireRecords[PID].bInitialized = True; // This record is initialized
						FireRecords[PID].LastFireTime = CurTime; // restart time
						FireRecords[PID].LastViewRotationVector = CurViewRotationVector;
						FireRecords[PID].LastLocation = P.Location;
						}
					else
						{
						SecondsLeft = KickTime - ( CurTime - FireRecords[PID].LastFireTime );
						SecondsIdle = ( 0 - SecondsLeft ) + KickTime;
						if (SecondsLeft <= 0)
							{
 							if ( ( ! OnlyKickWhenFull )
								|| ( ( OnlyKickWhenFull ) && ( PlayerCount == Level.Game.MaxPlayers ) ) )
								{
	               				P.ReceiveLocalizedMessage( class'KickIdlersMsg',0 );
        						P.ClientMessage("You've been kicked by the KickIdlers mutator for not playing during the last " $ SecondsIdle $ " seconds!");
								BroadcastMessage(P.PlayerReplicationInfo.PlayerName $ " has been kicked by the KickIdlers mutator for not playing for " $ SecondsIdle $ " Seconds");
								P.Destroy(); // kick player
								FireRecords[PID].bInitialized = False;
								}
							else
								{
								Idlers++;
								P.ClientMessage("If the server fills, you will be kicked for not playing during the last " $ SecondsIdle $ " seconds!");
								P.ReceiveLocalizedMessage( class'KickIdlersMsg',2 );
								}
							}
						else if	( SecondsLeft <= ( ( KickTime / 10 ) * 2 ) )
							{
							if ( ( ! OnlyKickWhenFull )
								|| ( ( OnlyKickWhenFull ) && ( PlayerCount == Level.Game.MaxPlayers ) ) )
								{
								P.ClientMessage("You will be kicked for not playing in " $ SecondsLeft $ " seconds!");
								P.ReceiveLocalizedMessage( class'KickIdlersMsg',1 );
								}
							else
								{
								P.ClientMessage("In " $ SecondsLeft $ " seconds, if the server fills, you will be kicked for not playing!");
								P.ReceiveLocalizedMessage( class'KickIdlersMsg',2 );
								}
							}
						}
					}
				}
			}
		}
	if ( AdvertiseIdlers )
		{
		if ( Idlers == 1 )
			BroadcastMessage( "KickIdlers: There is an idle player!" );
		else if ( Idlers > 1 )
			BroadcastMessage( "KickIdlers: There are " $ Idlers $ " idle players." );
		}
}

defaultproperties
{
    KickTime=300
    OnlyKickWhenFull=True
    ShutDownAfterGame=True
    AllowKickIdlersCommand=True
    AllowShowSlackersCommand=True
    Advertise=True
}
