
class MH2ScoreBoard1 extends TournamentScoreBoard config(theSeeker3);

#exec TEXTURE IMPORT NAME=Blackness FILE=Textures\Blackness.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Whiteness FILE=Textures\Whiteness.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_cpu FILE=Textures\Icon_cpu.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Con1 FILE=Textures\Icon_Con1.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Con2 FILE=Textures\Icon_Con2.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Con3 FILE=Textures\Icon_Con3.bmp Group=HUD MIPS=ON
#exec TEXTURE IMPORT NAME=Icon_Con4 FILE=Textures\Icon_Con4.bmp Group=HUD MIPS=ON

#exec TEXTURE IMPORT NAME=Scroll2 FILE=Textures\Scroll2.bmp Group=HUD MIPS=ON
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontLarge"  Height=12 USize=256 VSize=256 CharactersPerPage=256

var color GreenColor, WhiteColor, GoldColor, BlueColor, LightCyanColor, SilverColor, BronzeColor, CyanColor, RedColor,
          LightGreenColor, DarkGreenColor, BlackColor, BColor, ParchmentColor, FrigginDarkColor;

var string ScoreBoardText, ScoreBoardText1, ScoreBoardText2, ScoreBoardText3, ScoreBoardText4,
           ScoreBoardText5, ScoreBoardText6, ScoreBoardText7, ScoreBoardText8, GameOverText, MeatsGameType1;

var int TipText;

function DrawHeader( canvas Canvas )
{
	local GameReplicationInfo GRI;
	local float XL, YL;
	local font CanvasFont;

	Canvas.DrawColor = DarkGreenColor;
	GRI = PlayerPawn(Owner).GameReplicationInfo;

	Canvas.Font = MyFonts.GetHugeFont(Canvas.ClipX);

	Canvas.bCenter = True;
	Canvas.StrLen("Test", XL, YL);
	ScoreStart = 0;
	CanvasFont = Canvas.Font;
	if ( GRI.GameEndedComments != "" )
	{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, ScoreStart);
		Canvas.DrawText(GameOverText, True);

	}
	else
	{
		Canvas.DrawColor = GoldColor;
		Canvas.SetPos(0, ScoreStart);
		Canvas.DrawText(MeatsGameType1, True);
	}
	Canvas.bCenter = False;
	Canvas.Font = CanvasFont;
}

function DrawTrailer( canvas Canvas )
{
	local int Hours, Minutes, Seconds;
	local float XL, YL;
	local PlayerPawn PlayerOwner;

	Canvas.bCenter = true;
        Canvas.Font = MyFonts.GetBigFont(800);
	Canvas.StrLen("Test", XL, YL);
	Canvas.DrawColor = LightGreenColor;
	PlayerOwner = PlayerPawn(Owner);
	Canvas.SetPos(0, Canvas.ClipY - 4 * YL);

	Canvas.SetPos(0, Canvas.ClipY -3 * YL);
	if ( bTimeDown || (PlayerOwner.GameReplicationInfo.RemainingTime > 0) )
	{
		bTimeDown = true;
		if ( PlayerOwner.GameReplicationInfo.RemainingTime <= 0 )
			Canvas.DrawText(RemainingTime@"00:00", true);
		else
		{
			Minutes = PlayerOwner.GameReplicationInfo.RemainingTime/60;
			Seconds = PlayerOwner.GameReplicationInfo.RemainingTime % 60;
			Canvas.DrawText(RemainingTime@TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
		}
	}
	else
	{
		Seconds = PlayerOwner.GameReplicationInfo.ElapsedTime;
		Minutes = Seconds / 60;
		Hours   = Minutes / 60;
		Seconds = Seconds - (Minutes * 60);
		Minutes = Minutes - (Hours * 60);
		Canvas.DrawText(ElapsedTime@TwoDigitString(Hours)$":"$TwoDigitString(Minutes)$":"$TwoDigitString(Seconds), true);
	}

Canvas.SetPos(0, Canvas.ClipY -5 * YL);
	if ( PlayerOwner.GameReplicationInfo.GameEndedComments != "" )
	{
		Canvas.bCenter = true;
		Canvas.DrawColor = GoldColor;
		if ( Level.NetMode == NM_Standalone )
			Canvas.DrawText(Ended@Continue, true);
		else
			Canvas.DrawText(Ended, true);
	}
	else if ( (PlayerOwner != None) && (PlayerOwner.Health <= 0) )
	{
		Canvas.bCenter = true;
		Canvas.DrawColor = GoldColor;
		Canvas.DrawText(Restart, true);
	}
	Canvas.bCenter = false;
}

function DrawCategoryHeaders(Canvas Canvas)
{
	local float Offset, XL, YL;

	Offset = Canvas.CurY;
	Canvas.DrawColor = LightGreenColor;
	Canvas.StrLen(PlayerString, XL, YL);
	Canvas.SetPos((Canvas.ClipX / 8)*2 - XL/2, Offset);
	Canvas.DrawText(PlayerString);
	Canvas.StrLen(FragsString, XL, YL);
	Canvas.SetPos((Canvas.ClipX / 8)*5.3 - XL/2, Offset);
	Canvas.DrawText(FragsString);
}

function DrawNameAndPing(Canvas Canvas, PlayerReplicationInfo PRI, float XOffset, float YOffset, bool bCompressed)
{
   local float XL, YL, XL2, YL2, XL3, YL3, Eff;
   local Font CanvasFont;
   local bool bLocalPlayer;
   local PlayerPawn PlayerOwner;
   local int Time;
   local int i;

   PlayerOwner = PlayerPawn(Owner);
   i=0;
   bLocalPlayer = (PRI.PlayerName == PlayerOwner.PlayerReplicationInfo.PlayerName);

   Canvas.Style = ERenderStyle.STY_Normal;
   Canvas.DrawColor = BlackColor;
   Canvas.SetPos(Canvas.ClipX * 0.5 - 384, YOffset );
   Canvas.DrawTile(Texture'Blackness', 768, 1, 0, 0, 1, 1);
   Canvas.SetPos(Canvas.ClipX * 0.5 - 384, YOffset + 27);
   Canvas.DrawTile(Texture'Blackness', 768, 1, 0, 0, 1, 1);
   Canvas.SetPos(Canvas.ClipX * 0.5 - 384, YOffset + 1);
   Canvas.DrawTile(Texture'Blackness', 1, 26, 0, 0, 1, 1);
   Canvas.SetPos(Canvas.ClipX * 0.5 + 384, YOffset + 1);
   Canvas.DrawTile(Texture'Blackness', 1, 26, 0, 0, 1, 1);

   Canvas.DrawColor.R = 20;
   Canvas.DrawColor.G = 20;
   Canvas.DrawColor.B = 20;
   Canvas.Style = ERenderStyle.STY_Translucent;
   Canvas.SetPos(Canvas.ClipX * 0.5 - 382, YOffset + 1);
   Canvas.DrawTile(Texture'Whiteness', 766, 26, 0, 0, 1, 1);

   if (!PlayerOwner.PlayerReplicationInfo.bIsSpectator)
   {
      Canvas.DrawColor = WhiteColor;
      Canvas.Style = ERenderStyle.STY_Normal;
      Canvas.SetPos(Canvas.ClipX * 0.5 - 383, YOffset + 1);
      Canvas.DrawTile(PRI.TalkTexture, 26, 26, 0, 0, 64, 64);
   }

   Canvas.Font = MyFonts.GetSmallestFont(800);//Canvas.ClipX
   Canvas.SetPos(Canvas.ClipX * 0.5 + 358, YOffset + 1);
   Canvas.Style = ERenderStyle.STY_Translucent;
   Canvas.DrawColor = WhiteColor;
   if (!PRI.bIsABot)
   {
      if (PRI.Ping > 250)
    	 Canvas.DrawTile(Texture'Icon_Con1', 26, 26, 0, 0, 128, 128);
      else if ( PRI.Ping > 150 )
         Canvas.DrawTile(Texture'Icon_Con2', 26, 26, 0, 0, 128, 128);
      else if ( PRI.Ping > 80 )
         Canvas.DrawTile(Texture'Icon_Con3', 26, 26, 0, 0, 128, 128);
      else
 	 Canvas.DrawTile(Texture'Icon_Con4', 26, 26, 0, 0, 128, 128);

      Canvas.Style = ERenderStyle.STY_Normal;
      Canvas.DrawColor = BColor;
      Canvas.StrLen(PRI.Ping, XL, YL );
      Canvas.SetPos(Canvas.ClipX * 0.5 + 370 - 0.5 * XL, YOffset + YL);
      Canvas.DrawText(PRI.Ping, false );
      Canvas.DrawColor = WhiteColor;
      Canvas.StrLen(PRI.Ping, XL, YL );
      Canvas.SetPos(Canvas.ClipX * 0.5 + 371 - 0.5 * XL, YOffset - 1 + YL);
      Canvas.DrawText(PRI.Ping, false );
   }
   else	Canvas.DrawTile(Texture'Icon_cpu', 26, 26, 0, 0, 64, 64);

   Canvas.Style = ERenderStyle.STY_Normal;
   if (PRI.bAdmin)
      Canvas.DrawColor = WhiteColor;
   else if (bLocalPlayer)
      Canvas.DrawColor = GoldColor;
   else Canvas.DrawColor = GreenColor;

   Canvas.Font = MyFonts.GetBigFont(800);
   Canvas.SetPos(Canvas.ClipX * 0.5 - 350, YOffset );
   Canvas.DrawText(PRI.PlayerName, False);
   Canvas.Font = MyFonts.GetSmallFont(800);
   Canvas.StrLen( "0000", XL, YL );

   if (!PRI.bIsABot)
   {
      // Draw Time
      Canvas.DrawColor = LightCyanColor;
      Time = Max(1, (Level.TimeSeconds + PlayerOwner.PlayerReplicationInfo.StartTime - PRI.StartTime)/60);
      Canvas.SetPos( Canvas.ClipX * 0.5 + 100, YOffset - 4 + YL);
      Canvas.DrawText("Time in map:"@Time, false );
      
      // Draw Adj Score
      Eff = PRI.Score - PRI.Deaths;
      Canvas.SetPos(Canvas.ClipX * 0.5 + 100, YOffset );
      Canvas.DrawText( "Adj. Score:"@int(Eff), false );

      Canvas.SetPos(Canvas.ClipX * 0.5 -130, YOffset );
      Canvas.DrawText("Score:"@int(PRI.Score)@"  with "$IPRI(PRI).Telefrags@"telefrags", false );
      Canvas.DrawColor = RedColor;
      Time = Max(1, (Level.TimeSeconds + PlayerOwner.PlayerReplicationInfo.StartTime - PRI.StartTime)/60);
      //Canvas.SetPos( Canvas.ClipX * 0.5 + 204, YOffset - 4 + YL);
      Canvas.SetPos( Canvas.ClipX * 0.5 + 264, YOffset - 4 + YL);
      Canvas.DrawText("Suicides: "$IPRI(PRI).Suicides, false );

      Canvas.DrawColor = LightCyanColor;
      //Canvas.SetPos( Canvas.ClipX * 0.5 +200, YOffset );
      Canvas.SetPos( Canvas.ClipX * 0.5 +260, YOffset );
      Canvas.DrawText(" Deaths: "$int(PRI.Deaths), false);
      Canvas.DrawColor = SilverColor;
      Canvas.Font = MyFonts.GetSmallestFont(800);//Canvas.ClipX
      Canvas.SetPos( Canvas.ClipX * 0.5 - 130, YOffset - 4 + YL);
      if (IPRI(PRI).NewVar != "")
         Canvas.DrawText("Country:"$IPRI(PRI).NewVar, false );
      else Canvas.DrawText("Getting Country", false );
   }
   else
   {
      Canvas.SetPos(Canvas.ClipX * 0.5 -130, YOffset );
      Canvas.DrawText("Score:"@int(PRI.Score), false );
   }
}
function SortScores(int N)
{
	local int I, J, Max;
	local PlayerReplicationInfo TempPRI;

	for ( I=0; I<N-1; I++ )
	{
		Max = I;
		for ( J=I+1; J<N; J++ )
		{
			if ( Ordered[J].Score > Ordered[Max].Score )
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths < Ordered[Max].Deaths))
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths == Ordered[Max].Deaths) &&
					 (Ordered[J].PlayerID < Ordered[Max].Score))
				Max = J;
		}

		TempPRI = Ordered[Max];
		Ordered[Max] = Ordered[I];
		Ordered[I] = TempPRI;
	}
}

function ShowScores( canvas Canvas )
{
local PlayerReplicationInfo PRI;
local int PlayerCount, i, ii;
local float XL, YL, Scale;
local float YOffset, YStart;
local font CanvasFont;

	Canvas.Style = ERenderStyle.STY_Normal;

	Canvas.SetPos(0, 0);
	DrawHeader(Canvas);

	for ( i=0; i<ArrayCount(Ordered); i++ )
		Ordered[i] = None;
	for ( i=0; i<32; i++ )
	{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
		{
			PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			if ( !PRI.bIsSpectator || PRI.bWaitingPlayer )
			{
				Ordered[PlayerCount] = PRI;
				PlayerCount++;
				if ( PlayerCount == ArrayCount(Ordered) )
					break;
			}
		}
	}
	SortScores(PlayerCount);
	CanvasFont = Canvas.Font;
	Canvas.Font = MyFonts.GetBigFont(Canvas.ClipX);
	Canvas.StrLen( "TEST", XL, YL );
	YOffset = YL * 3;
	if ( PlayerCount > 15 )
		PlayerCount = FMin(PlayerCount, (Canvas.ClipY - YStart)/YL - 1);
	Canvas.SetPos(0, 0);
	for ( I=0; I<PlayerCount; I++ )
	{
		if ( YOffset < Canvas.ClipY - 27 )
			{
			DrawNameAndPing( Canvas, Ordered[I], 0, YOffset, false );
			YOffset += 29;
			}
		else
			{
			ii++;
			}
		
	}
	Canvas.DrawColor = WhiteColor;

	if ( ii > 0 )
		{
		Canvas.bCenter = True;
		Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
		Canvas.StrLen( ii, XL, YL );
		Canvas.SetPos(0, Canvas.ClipY - YL);
		if ( ii == 1 )
			Canvas.DrawText("(1 player not showing.)", false );
		else
			Canvas.DrawText("("$ii$" players not showing.)", false );
		Canvas.bCenter = False;
		}
        DrawTrailer(Canvas );
	DrawTextAtBottomCenter(Canvas);
}

simulated function DrawTextAtBottomCenter(Canvas Canvas)
{
        local float XL, YL;
        local int TipText;
        local PlayerPawn PlayerOwner;

        PlayerOwner = PlayerPawn(Owner);
	TipText = PlayerOwner.PlayerReplicationInfo.Score;

	Canvas.Style = ERenderStyle.STY_Normal;
	Canvas.DrawColor = WhiteColor;
	Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
	Canvas.StrLen("GOPOSTALSUCKS", XL, YL);
	Canvas.bCenter = True;
	Canvas.SetPos(0, Canvas.ClipY - YL);
	Canvas.DrawText(ScoreBoardText);
Canvas.DrawColor = SilverColor;
        Canvas.SetPos(0, Canvas.ClipY - YL - YL);

        if (TipText < 1)
        Canvas.DrawText(ScoreBoardText1);
        if (TipText == 1)
        Canvas.DrawText(ScoreBoardText1);
        if (TipText == 2)
        Canvas.DrawText(ScoreBoardText2);
        if (TipText == 3)
        Canvas.DrawText(ScoreBoardText3);
        if (TipText == 4)
        Canvas.DrawText(ScoreBoardText4);
        if (TipText == 5)
        Canvas.DrawText(ScoreBoardText5);
        if (TipText == 6)
        Canvas.DrawText(ScoreBoardText6);
        if (TipText == 7)
        Canvas.DrawText(ScoreBoardText7);
        if (TipText == 8)
        Canvas.DrawText(ScoreBoardText8);
        if (TipText > 8)
        Canvas.DrawText(ScoreBoardText1);
}

defaultproperties
{
   GreenColor=(R=0,G=255,B=0,A=0),
   WhiteColor=(R=255,G=255,B=255,A=0),
   GoldColor=(R=255,G=255,B=0,A=0),
   BlueColor=(R=0,G=0,B=255,A=0),
   LightCyanColor=(R=128,G=255,B=255,A=0),
   SilverColor=(R=138,G=164,B=166,A=0),
   BronzeColor=(R=203,G=147,B=52,A=0),
   CyanColor=(R=0,G=128,B=255,A=0),
   RedColor=(R=255,G=0,B=0,A=0),
   LightGreenColor=(R=0,G=136,B=0,A=0),
   DarkGreenColor=(R=0,G=255,B=128,A=0),
   ParchmentColor=(R=227,G=210,B=176,A=0),
   FrigginDarkColor=(R=4,G=4,B=4,A=0),
   DeathsString="Deaths"
   ScoreBoardText="Adjusted Score is Score minus Deaths"
   ScoreBoardText1="Tip: Don't lead your enemy by much, this missile is FAST"
   ScoreBoardText2="Tip: Keep a translocator disk hidden to escape"
   ScoreBoardText3="Tip: Stay hidden as much as possible"
   ScoreBoardText4="Tip: Use multiple missiles to blanket your opponent"
   ScoreBoardText5="Tip: Keep cover close by to escape incoming fire"
   ScoreBoardText6="Tip: Careful on respawn, find a place to hide quickly"
   ScoreBoardText7="Tip: If you die, just try again. You'll get it"
   ScoreBoardText8="Tip: There is *no* distance limit on missiles"
   GameOverText="Game Over Warriors"
   MeatsGameType1="MEAT'S SNIPER DEEMER"
}
