
class MutResurrection extends Mutator config(theSeeker3);

var string sName;
var bool Initialized;
var int CurrentID;
struct PlayerInfo
{
	var pawn Player;
	var string PlayerName;
	var string NetWorkAddress;
	var int PlayerID;
	var int DieCount;
	var int KillCount;
	var int Score;
	var int Deaths;
	var int Health;
	var int Ammo[10];
	var vector Location;
	var vector Velocity;
};
var PlayerInfo PInfo[64];

var config bool RecoverHealth, RecoverAmmo, RecoverLocation;
var config float RecoverTimer;
var config int Mode;
var bool WeaponValid;				//Are we using CheckWeapon
var config string CheckWeapon[10];		//Weapon classes to check the ammo
var class<Weapon> WeaponClass[10];		//The dynamically loaded class for our weapons

function PreBeginPlay()
{
	CurrentID = 1;
}

function PostBeginPlay()
{
	local int i;
	//Keep our mutator from being registered multiple times.
	if ( Initialized )
		return;
	Initialized = True;

	//Register as a damage mutator, as we'll be using damage checks to
	//update the stored information (new in v3.2).
	Level.Game.RegisterDamageMutator(self);
	//Registers as a Message mutator to allow MutatorTeamMessages or ! commands.
	Level.Game.RegisterMessageMutator(self);

	//Load the weapon class whos ammo we want to check.
	if ( ( CheckWeapon[0] != "none" && CheckWeapon[0] != "" ) && RecoverAmmo )
	{
		for(i=0;i<ArrayCount(WeaponClass) && ( CheckWeapon[i] != "" && CheckWeapon[i] != "none" );i++)
			WeaponClass[i] = class<Weapon>(DynamicLoadObject(CheckWeapon[i],class'class'));

		WeaponValid=True;
	}

	//Record that our mutator is in use, shows up in the log file
	Log("	############################################################",'Resurrector');
	Log("	## "$sName$" Loading",'Resurrector');
	Log("	############################################################",'Resurrector');
	switch(Mode)
	{
		case 0:
			Log("	## Mode: Check Player Name",'Resurrector');
			break;
		case 1:
			Log("	## Mode: IP Address",'Resurrector');
			break;
		case 2:
			Log("	## Mode: Check Player Name OR IP Address",'Resurrector');
			break;
		case 3:
			Log("	## Mode: Check Player Name AND IP Address",'Resurrector');
			break;
	}
	Log("	## Recover Health:"$RecoverHealth$" Recover Ammo:"$RecoverAmmo$" Recover Location:"$RecoverLocation,'Resurrector');
	Log("	## Recovery Timer:"$RecoverTimer,'Resurrector');

	if ( RecoverAmmo )
	{
		for(i=0;i<ArrayCount(WeaponClass) && WeaponClass[i] != none;i++)
			Log("	## Weapons Checked:"$WeaponClass[i],'Resurrector');
	}

	Log("	############################################################",'Resurrector');
}

function ModifyPlayer(Pawn Other)
{
	if ( Level.Game.CurrentID > CurrentID )
		AddPlayers();

	super.ModifyPlayer(Other);
}

function tick(float DeltaTime)
{
	Super.tick(DeltaTime);

	if ( Level.Game.CurrentID > CurrentID )
		AddPlayers();
}

simulated function AddPlayers()
{
	local int i;
	local Pawn Other;
	local bool bFound;
	local string TempAddress;

	bFound = false;

	//	CHECK PLAYERID FOR EXISTANCE (DONE BY THE LEVEL.GAME.CURRENTID)
	if ( Level.Game.CurrentID > CurrentID )
	{
		for( Other=Level.PawnList; Other!=None; Other=Other.NextPawn )
			if( Other.PlayerReplicationInfo.PlayerID == CurrentID)
				break;

		CurrentID++;

		if ( Other.IsA('Bot') || Other.IsA('Spectator') )
			return;

		TempAddress = FilterAddress(Other);

		//	NEW PLAYER INITIALIZATION
		switch ( Mode )
		{
			case 0:
				for(i=0; i<ArrayCount(PInfo) && PInfo[i].PlayerName != ""; i++)
				{
					//	CHECK FOR PLAYER NAME
					if ( PInfo[i].PlayerName ~= Other.PlayerReplicationInfo.PlayerName )
					{
						ResurrectPInfo(Other, i);
						bFound = true;
					}
				}
				break;
			case 1:
				for(i=0; i<ArrayCount(PInfo) && PInfo[i].PlayerName != ""; i++)
				{
					//	CHECK FOR IP ADDRESS
					if ( TempAddress ~= PInfo[i].NetworkAddress )
					{
						ResurrectPInfo(Other, i);
						bFound = true;
					}
				}
				break;
			case 2:
				for(i=0; i<ArrayCount(PInfo) && PInfo[i].PlayerName != ""; i++)
				{
					//	CHECK FOR PLAYER NAME OR IP ADDRESS
					if ( TempAddress ~= PInfo[i].NetworkAddress || PInfo[i].PlayerName ~= Other.PlayerReplicationInfo.PlayerName )
					{
						ResurrectPInfo(Other, i);
						bFound = true;
					}
				}
				break;
			case 3:
				for(i=0; i<ArrayCount(PInfo) && PInfo[i].PlayerName != ""; i++)
				{
					//	CHECK FOR PLAYER NAME AND IP ADDRESS
					if ( TempAddress ~= PInfo[i].NetworkAddress && PInfo[i].PlayerName ~= Other.PlayerReplicationInfo.PlayerName )
					{
						ResurrectPInfo(Other, i);
						bFound = true;
					}
				}
				break;
		}

		//	IP DOES NOT EXIST; INITIALIZE NEW PLAYER
		if ( !bFound )
		{
			PInfo[i].Player = Other;
			PInfo[i].PlayerName = Other.PlayerReplicationInfo.PlayerName;

			PInfo[i].NetworkAddress = TempAddress;

			PInfo[i].PlayerID = Other.PlayerReplicationInfo.PlayerID;
			PInfo[i].DieCount = Other.DieCount;
			PInfo[i].KillCount = Other.KillCount;
			PInfo[i].Deaths = Other.PlayerReplicationInfo.Deaths;
			PInfo[i].Score = Other.PlayerReplicationInfo.Score;
			PInfo[i].Health = Other.Health;
			PInfo[i].Location = Other.Location;
			PInfo[i].Velocity = Other.PlayerReplicationInfo.Velocity;
		}
	}//	IF ID DOES EXIST UPDATE ALL VAULES.
	else if ( !Other.IsA('Bot') || !Other.IsA('Spectator') )
		UpdateAInfo();
}

function UpdatePInfo(Pawn Other)
{
	local int i,j;

	for(i=0; i<ArrayCount(PInfo); i++)
	{
		if ( Other.PlayerReplicationInfo.PlayerID == PInfo[i].PlayerID )
		{
			PInfo[i].Player = Other;
			PInfo[i].PlayerName = Other.PlayerReplicationInfo.PlayerName;
			PInfo[i].NetworkAddress = FilterAddress(Other);
			PInfo[i].PlayerID = Other.PlayerReplicationInfo.PlayerID;
			PInfo[i].DieCount = Other.DieCount;
			PInfo[i].KillCount = Other.KillCount;
			PInfo[i].Deaths = Other.PlayerReplicationInfo.Deaths;
			PInfo[i].Score = Other.PlayerReplicationInfo.Score;
			PInfo[i].Location = Other.Location;
			PInfo[i].Velocity = Other.PlayerReplicationInfo.Velocity;

			if ( Other.Health > 0 )
				PInfo[i].Health = Other.Health;

			for(j=0;j<ArrayCount(WeaponClass) && WeaponClass[j] != None;j++)
			{
				if ( Other.FindInventoryType(WeaponClass[j]) != none && WeaponValid )
					if ( Weapon(Other.FindInventoryType(WeaponClass[j]) ).AmmoType.AmmoAmount != 0 )
						PInfo[i].Ammo[j] = Weapon(Other.FindInventoryType(WeaponClass[j])).AmmoType.AmmoAmount;
			}
			break;
		}
	}
}

function ResurrectPInfo(Pawn Other, int ResurrectMe)
{
	local int i, j, view;
	local string TempAddress;

	//Just in case
	if ( Other.IsA('Bot') )
		return;

	TempAddress = FilterAddress(Other);

	Log("  #########################################################################################",'Resurrector');
	switch ( Mode )
	{
		case 0:
			Log("  ## "$sName$" - Recovered by Name: "$Other.PlayerReplicationInfo.PlayerName$" -- IP: "$TempAddress$"   new ID: "$Other.PlayerReplicationInfo.PlayerID );
			break;
		case 1:
			Log("  ## "$sName$" - Recovered by IP: "$TempAddress$" -- Name: "$Other.PlayerReplicationInfo.PlayerName$"   new ID: "$Other.PlayerReplicationInfo.PlayerID );
			break;
		case 2:
			Log("  ## "$sName$" - Recovered by Name: "$Other.PlayerReplicationInfo.PlayerName$" OR IP: "$TempAddress$" -- new ID: "$Other.PlayerReplicationInfo.PlayerID );
			break;
		case 3:
			Log("  ## "$sName$" - Recovered by Name: "$Other.PlayerReplicationInfo.PlayerName$" AND IP: "$TempAddress$" -- new ID: "$Other.PlayerReplicationInfo.PlayerID );
			break;
	}

	if ( RecoverAmmo && WeaponValid )
	{
		for(j=0;j<ArrayCount(WeaponClass) && WeaponClass[j] != None; j++)
		{
			if ( Other.FindInventoryType(WeaponClass[j]) == None )
				Log("  ## "$sName$" - Weapon: "$string(WeaponClass[j])$"   Does Not Exist In Inventory");
			else if ( PInfo[ResurrectMe].Ammo[j] == 0 )
			{
				Weapon(Other.FindInventoryType(WeaponClass[j])).AmmoType.AmmoAmount = 1;
				Log("  ## "$sName$" - Weapon: "$string(WeaponClass[j])$"   Recovered Ammo: "$Weapon(Other.FindInventoryType(WeaponClass[j])).AmmoType.AmmoAmount);
			}
			else
			{
				Weapon(Other.FindInventoryType(WeaponClass[j])).AmmoType.AmmoAmount = PInfo[ResurrectMe].Ammo[j];
				Log("  ## "$sName$" - Weapon: "$string(WeaponClass[j])$"   Recovered Ammo: "$Weapon(Other.FindInventoryType(WeaponClass[j])).AmmoType.AmmoAmount);
			}
		}
	}

	if ( RecoverLocation )
	{
		Other.SetLocation(PInfo[ResurrectMe].Location);
		Log("  ## ReSpawned here: "$PInfo[ResurrectMe].Location);
		Level.Game.PlayTeleportEffect(Other, true, True);
	}

	PInfo[ResurrectMe].Player = Other;
	PInfo[ResurrectMe].PlayerName = Other.PlayerReplicationInfo.PlayerName;
	PInfo[ResurrectMe].PlayerID = Other.PlayerReplicationInfo.PlayerID;
	Other.DieCount = PInfo[ResurrectMe].DieCount;
	Other.KillCount = PInfo[ResurrectMe].KillCount;
	Other.PlayerReplicationInfo.Deaths = PInfo[ResurrectMe].Deaths;
	Other.PlayerReplicationInfo.Score = PInfo[ResurrectMe].Score;
	Other.PlayerReplicationInfo.Velocity = PInfo[ResurrectMe].Velocity;

	Log("  ## "$sName$" - Recovered DieCount: "$Other.DieCount$"   KillCount: "$Other.KillCount$"   Deaths: "$int(Other.PlayerReplicationInfo.Deaths)$"   Score: "$int(Other.PlayerReplicationInfo.Score));

	if( PInfo[ResurrectMe].Health < 100 && PInfo[ResurrectMe].Health > 0 && RecoverHealth )
	{
		Other.Health = PInfo[ResurrectMe].Health;
		Log("  ## "$sName$" - Recovered Health: "$Other.Health,'Resurrector');
	}

	Log("  #########################################################################################",'Resurrector');
}
//Updates All Players
function UpdateAInfo()
{
	local Pawn Other;

	for( Other=Level.PawnList; Other!=None; Other=Other.NextPawn )
	{
		if ( Other.IsA('PlayerPawn') && !Other.PlayerReplicationInfo.bIsSpectator && !Other.IsA('Bot') && !Other.IsA('Spectator') )
			UpdatePInfo(Other);
	}
}
//Gets Players IP and returns it as a string
function string FilterAddress(Pawn Other)
{
	local int i, j;
	local string TempAddress;

	TempAddress = PlayerPawn(Other).GetPlayerNetworkAddress();

	j = InStr(TempAddress,":");
	if( j != -1 )
		TempAddress = Left(TempAddress,j);

	return TempAddress;
}
//Monitors for shots/deaths to update score, deaths, diecount, killcount
function scorekill(pawn killer, pawn other)
{
	super.ScoreKill(killer, other);

	SetTimer(0.5,false);  //Set to .5 to give the server time to update values in the GameInfo
}
//Monitors for Ammo and Health
function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
	super.MutatorTakeDamage(ActualDamage,Victim,InstigatedBy,HitLocation,Momentum,DamageType);

	SetTimer(0.5,false);
}

function Timer()
{
	UpdateAInfo();
	if ( Level.Game.NumPlayers <= 0 )
		SetTimer(0.0,False);
	else
		SetTimer(RecoverTimer,true);
}

function Mutate(string MutateString, PlayerPawn Sender)
{
	local bool bAdmin;
	local int i, tempMode;
	local string CommandString, CheckPackage;

	bAdmin = Sender.PlayerReplicationInfo.bAdmin;

	if ( NextMutator != None )
		NextMutator.Mutate(MutateString, Sender);

	if ( Caps( Mid(MutateString,0, 12) ) == Caps("RESURRECTION") && bAdmin )
	{
		CommandString = Caps( Mid(MutateString,13));

		if ( Left( Caps(CommandString),4 ) == "MODE" )
		{
			if ( Mid(CommandString,5) == "?" )
			{
				switch(Mode)
				{
					case 0:
						Sender.ClientMessage("Mode:0 Check Player Name");
						break;
					case 1:
						Sender.ClientMessage("Mode:1 IP Address");
						break;
					case 2:
						Sender.ClientMessage("Mode:2 Check Player Name OR IP Address");
						break;
					case 3:
						Sender.ClientMessage("Mode:3 Check Player Name AND IP Address");
						break;
				}
			}
			else
			{
				tempMode = int(Mid(CommandString,5));

				if ( tempMode < 4 && tempMode >= 0 )
				{
					Mode = tempMode;
					SaveConfig();
				}

				Sender.ConsoleCommand("MUTATE RESURRECTION MODE ?");
			}
		}
		else if ( ( Left( Caps (CommandString),5) == "TIMER" ) )
		{
			if ( Mid(CommandString,6) == "?" )
				Sender.ClientMessage("RECOVER TIMER SET AT: "$RecoverTimer);
			else
			{
				RecoverTimer = float(Mid(CommandString,6));
				SaveConfig();
				Sender.ConsoleCommand("MUTATE RESURRECTION TIMER ?");
			}
		}
		else if ( ( Left( Caps (CommandString),15) == "RECOVERLOCATION" ) )
		{
			if ( Mid(CommandString,16) == "?" )
			{
				if ( RecoverLocation )
					Sender.ClientMessage("RECOVER LOCATION IS ON!");
				else
					Sender.ClientMessage("RECOVER LOCATION IS OFF!");
			}
			else
			{
				RecoverLocation = !RecoverLocation;
				SaveConfig();
				Sender.ConsoleCommand("MUTATE RESURRECTION RECOVERLOCATION ?");
			}

		}
		else if ( ( Left( Caps (CommandString),13) == "RECOVERHEALTH" ) )
		{
			if ( Mid(CommandString,14) == "?" )
			{
				if ( RecoverHealth )
					Sender.ClientMessage("RECOVER HEALTH IS ON!");
				else
					Sender.ClientMessage("RECOVER HEALTH IS OFF!");
			}
			else
			{
				RecoverHealth = !RecoverHealth;
				SaveConfig();
				Sender.ConsoleCommand("MUTATE RESURRECTION RECOVERHEALTH ?");
			}

		}
		else if ( ( Left( Caps (CommandString),11) == "RECOVERAMMO" ) )
		{
			if ( Mid(CommandString,12) == "?" )
			{
				if ( RecoverAmmo )
					Sender.ClientMessage("RECOVER AMMO IS ON!");
				else
					Sender.ClientMessage("RECOVER AMMO IS OFF!");
			}
			else
			{
				RecoverAmmo = !RecoverAmmo;
				SaveConfig();
				Sender.ConsoleCommand("MUTATE RESURRECTION RECOVERAMMO ?");
			}
		}
		else if ( ( Left( Caps (CommandString),11) == "CHECKWEAPON" ) )
		{
			if ( Mid(CommandString,12) == "?" )
			{
				for(i=0;i<ArrayCount(CheckWeapon) && CheckWeapon[i] != "" || CheckWeapon[i] != "none";i++)
					Sender.ClientMessage("CHECKED WEAPON: "$CheckWeapon[i]);
			}
			else
			{
				i = InStr( Caps ( Mid(CommandString,12)),".");
				CheckPackage = Mid(CommandString,12,i);

				if ( InStr( Caps( ConsoleCommand("get ini:Engine.Engine.GameEngine ServerPackages")), Caps(CheckPackage)) == -1)
					Sender.ClientMessage("You need to add that weapon into the ServerPackages!");
			}
		}
	}
}

function bool MutatorTeamMessage(Actor Sender, Pawn Receiver, PlayerReplicationInfo PRI, coerce string S, name Type, optional bool bBeep)
{
	local int i;

	if ( PRI != None && Receiver != None && Sender.IsA('PlayerPawn') )
	{
		if ( Left( caps(S), 8) ~= "!RESMODE" )
		{
			if ( Sender == Receiver )
			{
				S = Mid(S,9);
				if ( S != "" )
					PlayerPawn(Sender).ConsoleCommand("MUTATE RESURRECTION MODE "$S);
			}
		}
		else	if ( Left( caps(S), 9) ~= "!RESTIMER" )
		{
			if ( Sender == Receiver )
			{
				S = Mid(S,10);
				if ( S != "" )
					PlayerPawn(Sender).ConsoleCommand("MUTATE RESURRECTION TIMER "$S);
			}
		}
		else	if ( Left( caps(S), 12) ~= "!RESLOCATION" )
		{
			if ( Sender == Receiver )
			{
				S = Mid(S,13);
				if ( S == "?" )
					PlayerPawn(Sender).ConsoleCommand("MUTATE RESURRECTION RECOVERLOCATION "$S);
				else
					PlayerPawn(Sender).ConsoleCommand("MUTATE RESURRECTION RECOVERLOCATION");
			}
		}
		else	if ( Left( caps(S), 10) ~= "!RESHEALTH" )
		{
			if ( Sender == Receiver )
			{
				S = Mid(S,11);
				if ( S == "?" )
					PlayerPawn(Sender).ConsoleCommand("MUTATE RESURRECTION RECOVERHEALTH "$S);
				else
					PlayerPawn(Sender).ConsoleCommand("MUTATE RESURRECTION RECOVERHEALTH");
			}
		}
		else	if ( Left( caps(S), 8) ~= "!RESAMMO" )
		{
			if ( Sender == Receiver )
			{
				S = Mid(S,9);
				if ( S == "?" )
					PlayerPawn(Sender).ConsoleCommand("MUTATE RESURRECTION RECOVERAMMO "$S);
				else
					PlayerPawn(Sender).ConsoleCommand("MUTATE RESURRECTION RECOVERAMMO");
			}
		}
		else	if ( Left( caps(S), 10) ~= "!RESWEAPON" )
		{
			if ( Sender == Receiver )
			{
				S = Mid(S,11);
				if ( S != "" )
					PlayerPawn(Sender).ConsoleCommand("MUTATE RESURRECTION CHECKWEAPON "$S);
			}
		}
	}

	if ( NextMessageMutator != None )
		return NextMessageMutator.MutatorTeamMessage( Sender, Receiver, PRI, S, Type, bBeep );

	return true;
}

defaultproperties
{
    sName="Resurrector;"
    RecoverHealth=True
    RecoverAmmo=True
    RecoverLocation=True
    RecoverTimer=2.00
    Mode=3
    CheckWeapon(0)="none"
    CheckWeapon(1)="none"
    CheckWeapon(2)="none"
    CheckWeapon(3)="none"
    CheckWeapon(4)="none"
    CheckWeapon(5)="none"
    CheckWeapon(6)="none"
    CheckWeapon(7)="none"
    CheckWeapon(8)="none"
    CheckWeapon(9)="none"
}
