
class Pickup_Soul extends Pickup;

#exec obj load file=..\Textures\SGTech1.utx package=SGTech1
#exec mesh import mesh=Cross anivfile=Models\Cross_a.3d datafile=Models\Cross_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=Cross x=0 y=0 z=0
#exec mesh sequence mesh=Cross seq=All startframe=0 numframes=1
#exec meshmap new meshmap=Cross mesh=Cross
#exec meshmap scale meshmap=Cross x=0.12500 y=0.12500 z=0.25000

#exec AUDIO IMPORT FILE="Sounds\Darkbell.wav" NAME="Darkbell"

var int LifeTime;
var() int HealingAmount;
var string Claimer;
var string Claimed;

function FireEffect();

event float BotDesireability(Pawn Bot)
{
   return (0);
}

event TakeDamage( int Damage, Pawn EventInstigator, vector HitLocation, vector Momentum, name DamageType)
{
   if(EventInstigator != None)
   {
      Momentum = Vect(0,0,0);
      if (string(DamageType)=="RedeemerDeath")
      {
         Velocity = Vect(0,0,0);
      }
   }
}

auto state Pickup
{
   function Touch( actor Other )
   {
      local int HealMax;
      local Pawn P;
      local int randm;

      if ( ValidTouch(Other) && Other.IsA('PlayerPawn') && Claimer != PlayerPawn(Other).PlayerReplicationInfo.PlayerName )
         PlayerPawn(Other).ClientMessage("This is not your soul to take...");

      if ( ValidTouch(Other) && Other.IsA('PlayerPawn') && Claimer == PlayerPawn(Other).PlayerReplicationInfo.PlayerName )
      {
         P = Pawn(Other);
         HealMax = 199;

         if (Level.Game.LocalLog != None)
            Level.Game.LocalLog.LogPickup(Self, P);
         if (Level.Game.WorldLog != None)
            Level.Game.WorldLog.LogPickup(Self, P);
         P.Health += HealingAmount;
         if (P.Health > HealMax) P.Health = HealMax;
            PlayPickupMessage(P);
         PlaySound (PickupSound,,2.5);
         if ( Level.Game.Difficulty > 1 )
            Other.MakeNoise(0.1 * Level.Game.Difficulty);
         SetRespawn();

         randm = Rand(4);
	 switch(randm)
         {
	    case 0:
	       BroadcastMessage( P.PlayerReplicationInfo.PlayerName$" claimed another soul for the collection.", false );
	    break;
	    case 1:
	       BroadcastMessage( P.PlayerReplicationInfo.PlayerName$" harvested a soul.", false );
	    break;
	    case 2:
	       BroadcastMessage( P.PlayerReplicationInfo.PlayerName$" claimed someone's life essence.", false );
	    break;
	    case 3:
	       BroadcastMessage( P.PlayerReplicationInfo.PlayerName$" was refreshed by someone's death.", false );
	    break;
         }
      }
   }
}

function PlayPickupMessage(Pawn Other)
{
   Other.ClientMessage(PickupMessage$HealingAmount, 'Pickup');
}

defaultproperties
{
   LifeTime=200
   DrawType=DT_Mesh
   Mesh=Mesh'Cross'
   CollisionRadius=26.00000
   CollisionHeight=32.00000
   MultiSkins(0)=Texture'SGTech1.Trim.SGcontrim_nbolt'
   PickupMessage="You got a health bonus +"
   ItemName="Soul"
   RespawnTime=0.000000
   PickupViewMesh=Mesh'Cross'
   PickupSound=Sound'Darkbell'
   ScaleGlow=2.000000
   bCollideWhenPlacing=True
   bRotatingPickup=False
   M_Activated=""
   M_Selected=""
   M_Deactivated=""
   PickupMessageClass=Class'Botpack.PickupMessagePlus'
   ItemMessageClass=Class'Botpack.ItemMessagePlus'
   bClientAnim=True
   HealingAmount=50
   AmbientGlow=32
   LightBrightness=255
   LightSaturation=102
   LightEffect=LE_SlowWave
   LightRadius=15
   LightType=LT_Steady
}
