//Done
class SpawnProt expands Mutator;

var bool Initialized;

function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
   local Inventory VictimsRP;

   if ((Victim != None) || (Instigatedby != None))
   {
      VictimsRP = Victim.FindInventoryType(class'SpawnProtEffect');
      if (VictimsRP != None)
      {
         if (SpawnProtEffect(VictimsRP).bSpawnProtActive )
         {
            ActualDamage = 0.0;
            Momentum = Vect(0,0,0);
            Velocity = Vect(0,0,0);
            Victim.Velocity = (Victim.Velocity * 0);
         }
         else
         {
            if ( NextDamageMutator != None )
               NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType );
         }
      }
      else
      {
         if ( NextDamageMutator != None )
            NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType );
      }
   }
}

function bool AlwaysKeep(Actor Other)
{
   if ( Other.IsA('SpawnProtEffect') )
      return true;
   if ( NextMutator != None )
      return ( NextMutator.AlwaysKeep(Other) );
   return false;
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
   local inventory inv;

   if ( Other.bIsPawn && Pawn(Other).bIsPlayer   )
   {
      inv = Spawn(class'SpawnProtEffect');
      if( inv != None )
      {
         inv.bHeldItem = true;
         SpawnProtEffect(inv).Duration = 5;
         inv.RespawnTime = 0.0;
         inv.GiveTo(Pawn(Other));
         inv.M_Activated = "";
         inv.M_DeActivated = "";

         inv.Activate();
      }
   }
   if ( Other.IsA('SpawnProtEffect'))
      return false;

   bSuperRelevant = 0;
   return true;
}

function ModifyPlayer(Pawn Other)
{
   local Inventory Inv;

   Inv = Other.FindInventoryType(class'SpawnProtEffect');
   if ( Inv != None )
      SpawnProtEffect(Inv).Duration = 5;
   else
   {
      inv = Spawn(class'SpawnProtEffect');
      if( inv != None )
      {

         SpawnProtEffect(Inv).Duration = 5;
         inv.GiveTo(Other);
         inv.Activate();
      }
   }
   if ( NextMutator != None )
      NextMutator.ModifyPlayer(Other);
}

defaultproperties
{
}