
class theSeekerMod expands Mutator config(theSeeker3);

#exec AUDIO IMPORT FILE="Sounds\HitsoundEnemy.wav" NAME="HitsoundEnemy"
#exec TEXTURE IMPORT NAME=goldplayer FILE=textures\gold.PCX GROUP=Skins
#exec obj load file=..\Music\null48.umx

//Q Announcer
#exec AUDIO IMPORT FILE="Sounds\QAOneFrag.wav" NAME="QAOneFrag" GROUP="QAnnouncer"
#exec AUDIO IMPORT FILE="Sounds\QATwoFrags.wav" NAME="QATwoFrags" GROUP="QAnnouncer"
#exec AUDIO IMPORT FILE="Sounds\QAThreeFrags.wav" NAME="QAThreeFrags" GROUP="QAnnouncer"
#exec AUDIO IMPORT FILE="Sounds\QATakenLead.wav" NAME="QATakenLead" GROUP="QAnnouncer"
#exec AUDIO IMPORT FILE="Sounds\QATiedLead.wav" NAME="QATiedLead" GROUP="QAnnouncer"
#exec AUDIO IMPORT FILE="Sounds\QALostLead.wav" NAME="QALostLead" GROUP="QAnnouncer"

var name WeaponName, AmmoName;
var string WeaponString, AmmoString;

var config bool Removehealth;
var config bool NoInvisibility;

var config bool Hitsounds;
var config float HitVolume;

var bool bInitialized;

//Spawn protection
var() globalconfig bool bUseSpawnProt;
var() globalconfig int SpawnProtDuration;

//Q announce
var Pawn Leaders[32], LastLeaders[32], Player[32];
var int  numLeaders, numLastLeaders, numPawns;
var int	fragsLeft;
var int numLastPlayers, numLastSpectators;

//Multi  Pickups
var config bool bPreventArmorPickupWhenFull, bAlwaysPreventMultiBeltPickup, bPreventMultiDamAmp, bPreventMultiBootsWhenFull;
var config bool bPreventArmorPickupWhenHasFullBelt, bPreventArmorPickupWhenHasDamagedBelt, bPreventMultiInvis, bPreventMultiBootsAtAll;

function AddMutator(Mutator M)
{
    if ( M.IsA('Arena') )
    {
        log(M$" not allowed (already have an Arena mutator)");
        return; //only allow one arena mutator
    }
    Super.AddMutator(M);
}

event PreBeginPlay()
{
   DefaultWeapon = class'theSeekerDeemer3g.MEATWarHeadLauncher';
   WeaponString = "theSeekerDeemer3g.MEATWarheadLauncher";
   WeaponName = 'MEATWarHeadLauncher';
   AmmoString = "theSeekerDeemer3g.MEATWarHeadAmmo";
   AmmoName = 'MEATWarHeadAmmo';

   if ( NextMutator != None )
      NextMutator.PreBeginPlay();
}

function PostBeginPlay()
{
       if (bInitialized)
		return;
	bInitialized = True;
	
       numLastPlayers = Level.Game.NumPlayers;
       numLastSpectators = Level.Game.NumSpectators;
       SetTimer(0.1, True);

       if(Level.Game.ScoreBoardType !=none)
          Level.Game.ScoreBoardType=Class'MH2ScoreBoard';

       Level.Game.RegisterDamageMutator(Spawn(class'SpawnProt'));

       Level.Game.RegisterDamageMutator(Self);

       if ( NextMutator != None )
		NextMutator.PostBeginPlay();
}

function Timer()
{
   local Pawn P;

   Super.Timer();
   CyclePickups();	//countdown LifeTime of pickups
   if ((Level.Game.NumPlayers != numLastPlayers) || (Level.Game.NumSpectators > numLastSpectators))
   {
      announce();
   }
   numLastPlayers = Level.Game.NumPlayers;
   numLastSpectators = Level.Game.NumSpectators;
}

function CyclePickups()
{
   local Pickup_Soul U;

   ForEach AllActors(class'Pickup_Soul', U)
   {
          U.LifeTime--;
          if ( U.LifeTime < 0 )
          {
              spawn(class'UT_SpriteSmokePuff',,,U.Location);
              U.Destroy();
          }
    }
}

function bool AlwaysKeep(Actor Other)
{
    local bool bTemp;

    if ( Other.IsA(WeaponName) )
    {
        Weapon(Other).PickupAmmoCount = Weapon(Other).AmmoName.Default.MaxAmmo;
        return true;
    }
    if ( Other.IsA(AmmoName) )
    {
        Ammo(Other).AmmoAmount = Ammo(Other).MaxAmmo;
        return true;
    }
    if ( ((PlayerPawn(Other) != None) || (Bot(Other) != None)) &&  !Other.IsA('Bot'))
    {
		Pawn(Other).PlayerReplicationInfoClass=Class'IPRI';
		return True;
    }

    if ( NextMutator != None )
        return ( NextMutator.AlwaysKeep(Other) );
    return false;
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
   local Translocator thisweapon;

   if (Removehealth)
   {
      if ( Other.IsA('Health') || (Other.IsA('TournamentHealth')))
         return False;
   }
   if (NoInvisibility)
   {
      if (Other.IsA('Invisibility') || (Other.IsA('UT_Invisibility')))
      {
	 return False;
      }
   }
   if ( Other.IsA('Weapon') )
   {
      if (Other.IsA('MEATWarheadLauncher'))
         return True;
      if (Other.IsA('MRSTranslocator'))
         return True;
      else if (!Other.IsA('MEATWarheadLauncher')&& (!Other.IsA('Translocator')))
      {
         Other.Destroy();
         return False;
      }
   }
   if ( Other.IsA('Ammo') )
   {
      if (AmmoString == "MEATWarHeadAmmo")
         return false;
      else if ((AmmoString != "MEATWarHeadAmmo") && !Other.IsA(AmmoName))
      {
         ReplaceWith(Other, AmmoString);
         return false;
      }
   }
   // Fix for invisibilty crashes
   if(Other.Class==Class'Invisibility')
   {
      ReplaceWith(Other,"Botpack.UT_Invisibility");
      return false;
   }
   if(Other.Class==Class'UT_Stealth')
   {
      ReplaceWith(Other,"Botpack.UT_Invisibility");
      return false;
   }

    bSuperRelevant = 0;
    return true;
}

function ModifyPlayer(Pawn Other)
{
    local Inventory Inv;
    local Pawn P;
    local int i;
    
    if (!(Level.Game.bTeamGame))
    {
       if (addPawnToList(Other))
       {
	  announce();
       }
    }
        Inv = Other.FindInventoryType(class'MEATWarheadLauncher');
          if ( Inv == None )
          {
               inv = Spawn(class'MEATWarheadLauncher');
               if( inv != None )
              {
                    inv.GiveTo(Other);
                    Ammo(Inv).AmmoAmount  = 999;
	            Ammo(Inv).MaxAmmo  = 999;
              }
          }

         Inv = Other.FindInventoryType(class'MRSTranslocator');
          if ( Inv == None )
          {
               inv = Spawn(class'MRSTranslocator');
               if( inv != None )
              {
                    inv.GiveTo(Other);
              }
          }
          if (bUseSpawnProt)
            {
               Inv = Other.FindInventoryType(class'SpawnProtEffect');
               if ( Inv != None )
                  SpawnProtEffect(Inv).Duration = SpawnProtDuration;
               else
                  {
                     inv = Spawn(class'SpawnProtEffect');
                     if( inv != None )
                        {
                           SpawnProtEffect(Inv).Duration = SpawnProtDuration;
                           inv.GiveTo(Other);
                           inv.Activate();
                        }
                 }
            }
	for( Inv=other.Inventory; Inv!=None; Inv=Inv.Inventory )
	{
			if (Ammo(Inv)!=None)
			{
				Ammo(Inv).AmmoAmount  = 999;
				Ammo(Inv).MaxAmmo  = 999;				
			}
	}
}

function MutatorTakeDamage (out int ActualDamage,Pawn Victim,Pawn InstigatedBy,out Vector HitLocation,out Vector Momentum,name DamageType)
{
  if ((Victim != none) && (InstigatedBy != none))
   {
      if(Hitsounds)
	{
               if ( InstigatedBy.IsA('PlayerPawn') && (Victim != InstigatedBy) )
	     {

		if( Victim.IsA('PlayerPawn') || Victim.IsA('Bot') )
		   {    
			PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundEnemy', SLOT_None, HitVolume, false);
			PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundEnemy', SLOT_Interface, HitVolume, false);
			PlayerPawn(InstigatedBy).PlaySound(Sound'HitsoundEnemy', SLOT_Interact, HitVolume, false);
		   }
	     }
	}
   }
   if ( NextDamageMutator != None )
      NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType );
}

function bool HandleEndGame()
{
    local pawn P, Best;
    local PlayerPawn PL;
    local string SkipPlayer;
    local MEATWarShell W;
    
    // find individual winner
    for ( P=Level.PawnList; P!=None; P=P.nextPawn )
        if ( P.bIsPlayer && !P.IsA('Spectator') && ((Best == None) || (P.PlayerReplicationInfo.Score > Best.PlayerReplicationInfo.Score)) )
            {
                Best = P;
                SkipPlayer = P.PlayerReplicationInfo.PlayerName;
            }
    // check for tie
    for ( P=Level.PawnList; P!=None; P=P.nextPawn )
        if ( P.bIsPlayer && (Best != P) && (P.PlayerReplicationInfo.Score == Best.PlayerReplicationInfo.Score) )
        {
            BroadcastLocalizedMessage( class'MyOverTimeMessage', 0 );     //Fix me!
            return false;
        }
    for ( P=Level.PawnList; P!=None; P=P.nextPawn )
    {
        PL = PlayerPawn(P);
        if ( PL != None )
        {
            PlayWinMessage(PL, (PL == Best));
            PL.bBehindView = true;
            
            if ( PL.PlayerReplicationInfo.PlayerName == SkipPlayer )
               {
                   PL.ViewTarget = None;
                   if ( PL.PlayerReplicationInfo.Deaths < 1)
                      {
                          PL.SetDisplayProperties(ERenderStyle.STY_Normal,Texture'goldplayer',true,true);
                          ShutDownLevelMusic();
                          spawn(class'PostalBabesMusic',,,PL.Location);
                          spawn(class'MH2Table1',,,PL.Location  - 72 * Vector(Rotation) + vect(0,0,-7) * 5 );
                          spawn(class'MH2Table2',,,PL.Location  + 72 * Vector(Rotation) + vect(0,0,-7) * 5 );
                          spawn(class'Trophy1',,,PL.Location  - 72 * Vector(Rotation) + vect(0,0,1.4) * 5 );
                          spawn(class'Trophy2',,,PL.Location  + 72 * Vector(Rotation) + vect(0,0,1.4) * 5 );
                          BroadCastMessage(PL.PlayerReplicationInfo.PlayerName@" had a PERFECT Game!");
                          BroadCastMessage(PL.PlayerReplicationInfo.PlayerName@" had a PERFECT Game!");
                          BroadCastMessage(PL.PlayerReplicationInfo.PlayerName@" had a PERFECT Game!");
                      }
               }
            else
               {
                     PL.ViewTarget = Best;
                     PL.GotoState('FeigningDeath');
               }

            PL.ClientGameEnded();
        }
        P.GotoState('GameEnded');
    }

    foreach AllActors(class'MEATWarShell', W)
		W.Destroy();

        if ( NextMutator != None )
        return NextMutator.HandleEndGame();
    return false;
}

function PlayWinMessage(PlayerPawn Player, bool bWinner)
{
    if ( Player.IsA('TournamentPlayer') )
        TournamentPlayer(Player).PlayWinMessage(bWinner);
}

function ShutDownLevelMusic()
{
        local PlayerPawn P;
	local Pawn A;

	A = Level.PawnList;
        While ( A != None )
	   {
	      if ( A.IsA('PlayerPawn') )
	      PlayerPawn(A).ClientSetMusic( Music'null48.null48', 0, 255, MTRAN_Fade);
	      A = A.nextPawn;
	   }
}

function Mutate(string MutateString, PlayerPawn Sender)
{
   if(!Sender.PlayerReplicationInfo.bIsSpectator || !Sender.PlayerReplicationInfo.bWaitingPlayer)
   {
      if(MutateString~="light")
      {
         Sender.ClientMessage("Toggling personal light on");
         Sender.AmbientGlow = 254;
         Sender.LightEffect=LE_NonIncidence;
         Sender.LightBrightness=200;
         Sender.LightHue=210;
         Sender.LightRadius=15;
         Sender.LightSaturation=200;
         Sender.LightType=LT_Steady;
      }
      if(MutateString~="dark")
      {
         Sender.ClientMessage("Toggling personal light off");
         Sender.AmbientGlow = Owner.Default.AmbientGlow;
         Sender.LightType = LT_None;
      }
   }
   if ( NextMutator != None )
		NextMutator.Mutate(MutateString, Sender);
}

function bool PreventDeath(Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
   if (damageType == 'Gibbed' && Killer != NONE && Killer != Killed)
   {
      if (Killed.Health < -999)           //telefrag sets health to -1000
      {
         BroadcastLocalizedMessage(class'TransFragMessage',,, None, None );
         if (Killer.IsA('PlayerPawn'))
         {
            IPRI(PlayerPawn(Killer).PlayerReplicationInfo).Telefrags += 1;
            PlayerPawn(Killer).PlayerReplicationInfo.Score += 1;
         }
      }
   }

   if (Killer !=none && Killed !=none)
   {
      if ( (Killer.IsA('PlayerPawn')) && (Killed.IsA('PlayerPawn')))
      {
         if (Killer != Killed) IPRI(PlayerPawn(Killer).PlayerReplicationInfo).TrueKills += 1;
         else IPRI(PlayerPawn(Killer).PlayerReplicationInfo).Suicides += 1;
      }
   }

   if ( Killed != none)
     DropSoul(Killed, Killer);

   if ( NextMutator != None )
     return NextMutator.PreventDeath(Killed,Killer, damageType,HitLocation);
   return false;
}

function DropSoul(Pawn Other, Pawn Killer)
{
   local Pickup_Soul DropItem;

   if ((Other != none) && (Killer !=none))
   {
      DropItem = Spawn(Class'Pickup_Soul',,,Other.Location);
      DropItem.Claimer = Killer.PlayerReplicationInfo.PlayerName;
      DropItem.Claimed = Other.PlayerReplicationInfo.PlayerName;
      DropItem.DrawScale = 0.75;
      DropItem.RemoteRole = ROLE_DumbProxy;
      DropItem.SetPhysics(PHYS_Falling);
      DropItem.bCollideWorld = true;
      DropItem.RespawnTime = 0.0;
      DropItem.bRotatingPickup = False;
   }
}

//QAnnounce add
function bool isLeader(Pawn P)
{
   local int i;
   for (i = 0; i < numLeaders; i++)
   {
      if (P == Leaders[i])
      {
	 return True;
      }
   }
   return False;
}

function bool wasLeader(Pawn P)
{
   local int i;
   for (i = 0; i < numLastLeaders; i++)
   {
      if (P == LastLeaders[i])
      {
	 return True;
      }
   }
   return False;
}

function bool addPawnToList(Pawn P)
{
   local int i;
   for (i = 0; i < numPawns; i++)
   {
      if (Player[i] == P)
      {
	 return False;
      }
   }
   Player[i] = P;
   numPawns++;
   return True;
}

function announce()
{
   local Pawn P;
   local float maxScore;
   local int i, j;
   local PlayerPawn PP;
   local TournamentGameReplicationInfo TGRI;

   if (Level.Game.bTeamGame)
   {
      return;
   }

   maxScore = -99999;
   numLeaders = 0;
   PP = None;

   for(P = Level.Pawnlist; P != None; P = P.Nextpawn)
   {
      if ((Bot(P) != None || PlayerPawn(P) != None) && P.PlayerReplicationInfo != None)
      {
         if (P.PlayerReplicationInfo.Score > maxScore && !P.IsA('Spectator'))
         {
	    maxScore = P.PlayerReplicationInfo.Score;
	    numLeaders = 1;
	    Leaders[numLeaders - 1] = P;
         }
         else if (P.PlayerReplicationInfo.Score == maxScore && !P.IsA('Spectator'))
         {
	    numLeaders++;
	    Leaders[numLeaders - 1] = P;
         }
         if (PP == None && PlayerPawn(P) != None)
	    PP = PlayerPawn(P);
      }
   }
   if ((numLeaders == 1) && ((numLastLeaders > 1) || ((numLastLeaders == 1) && !wasLeader(leaders[0]))) )
   {
      if (PlayerPawn(Leaders[0]) != None)
      {
         PlayerPawn(Leaders[0]).ClientPlaySound(Sound'QATakenLead', False);
      }
      for (i = 0; i < numLastLeaders; i++)
      {
         if ( (PlayerPawn(LastLeaders[i]) != None) && (LastLeaders[i] != Leaders[0]) )
         {
            PlayerPawn(LastLeaders[i]).ClientPlaySound(Sound'QALostLead', False);
	 }
      }
   }
   else if (numLeaders > 1)
   {
      for (i = 0; i < numLeaders; i++)
      {
         if ((PlayerPawn(Leaders[i]) != None) && (((numLastLeaders == 1) && (wasLeader(Leaders[i]))) || (!wasLeader(Leaders[i]))))
         {
	    PlayerPawn(Leaders[i]).ClientPlaySound(Sound'QATiedLead', False);
	 }
      }
      for (i = 0; i < numLastLeaders; i++)
      {
         if ( !(isLeader(lastLeaders[i])) && (PlayerPawn(lastLeaders[i]) != None) )
	 {
	    PlayerPawn(lastLeaders[i]).ClientPlaySound(Sound'QALostLead', False);
	 }
      }
   }
   for (i = 0; i < numLeaders; i++)
   {
      LastLeaders[i] = Leaders[i];
   }
   numLastLeaders = numLeaders;
   if ( (PP != None) && (Level.Game.GameName != "Last Man Standing") )
   {
      TGRI = TournamentGameReplicationInfo(PP.GameReplicationInfo);
      switch (TGRI.FragLimit - maxScore)
      {
         case 3:
	 if (fragsLeft > 3)
	 {
	    foreach AllActors( class 'PlayerPawn', PP )
            {
	       PP.ClientPlaySound(Sound'QAThreeFrags', False);
	    }
            fragsLeft = 3;
	 }
         break;
         case 2:
	 if (fragsLeft > 2)
         {
            foreach AllActors( class 'PlayerPawn', PP )
            {
	       PP.ClientPlaySound(Sound'QATwoFrags', False);
	    }
            fragsLeft = 2;
         }
         break;
         case 1:
         if (fragsLeft > 1)
         {
            foreach AllActors( class 'PlayerPawn', PP )
            {
               PP.ClientPlaySound(Sound'QAOneFrag', False);
	    }
            fragsLeft = 1;
         }
	 break;
         default:
	 break;
      }
   }
}

function ScoreKill(Pawn Killer, Pawn Other)
{
   local int i;

   i = 0;
   while (TRUE)
   {
      if ( NextMutator != None )
      {
	 NextMutator.ScoreKill(Killer, Other);
      }
      else break;
      if (i > 15)
         break;

      i++;
   }
   announce();

   if ( NextMutator != None )
   {
      NextMutator.ScoreKill(Killer, Other);
   }
}

function bool HandlePickupQuery(Pawn Other, Inventory item, out byte bAllowPickup)
{
   local bool bItemFound;
   local inventory I;

   bItemFound = false;
   if ( Item != None )
   {
      for ( I=Other.Inventory; I!=None; I=I.Inventory )
      {
	 if ( bPreventArmorPickupWhenFull && Item.bIsAnArmor && I.bIsAnArmor && Item.Class == I.Class && I.Charge >= I.Default.Charge )
	 {
	    bItemFound = true;
         }
         else if ( !bAlwaysPreventMultiBeltPickup && Item.IsA('UT_ShieldBelt') && I.IsA('UT_ShieldBelt') && I.Charge < I.Default.Charge )
         {
	    bItemFound = false;
	 }
	 else if ( bPreventMultiBootsWhenFull && Item.IsA('UT_JumpBoots') && I.IsA('UT_JumpBoots') && I.Charge >= I.Default.Charge )
	 {
	    bItemFound = true;
	 }
	 else if ( bPreventMultiBootsAtAll && Item.IsA('UT_JumpBoots') && I.IsA('UT_JumpBoots') && I.Charge >= 0 )
	 {
	    bItemFound = true;
	 }
	 else if ( bPreventMultiDamAmp && (( Item.IsA('UDamage') && I.IsA('UDamage') ) || ( Item.IsA('Amplifier') && I.IsA('Amplifier') )) )
	 {
	    bItemFound = true;
	 }
	 else if ( bPreventMultiInvis && Item.IsA('UT_Invisibility') && I.IsA('UT_Invisibility') )
	 {
	    bItemFound = true;
	 }
	 else if ( I.IsA('UT_ShieldBelt') && Item.bIsAnArmor )
	 {
 	    if ( I.Charge >= I.Default.Charge )
	    {// Belt is fulll
	       if ( bPreventArmorPickupWhenHasFullBelt )
	       {// prevent pickup
	          bItemFound = true;
	       }
	    }
	    else if ( bPreventArmorPickupWhenHasDamagedBelt )
            {// prevent pickup
	       bItemFound = true;
	    }
         }
	 else if ( Item.IsA('Armor') && I.IsA('Armor') )
	 {
            bItemFound = true;
	 }
      }
      if ( bItemFound )
	 return true;
   }
   else	return false;

   if ( NextMutator != None )
      return NextMutator.HandlePickupQuery(Other, item, bAllowPickup);

   return false;
}

defaultproperties
{
   HitSounds=True
   HitVolume=16.00
   bUseSpawnProt=True
   SpawnProtDuration=10
   fragsLeft=4
   bPreventArmorPickupWhenFull=True
   bAlwaysPreventMultiBeltPickup=True
   bPreventMultiDamAmp=True
   bPreventMultiBootsWhenFull=True
   bPreventMultiBootsAtAll=True
   bPreventMultiInvis=True
   bPreventArmorPickupWhenHasFullBelt=True
   bPreventArmorPickupWhenHasDamagedBelt=True
}
