class GxHUD expands UnrealHUD;

// Imports
#EXEC OBJ LOAD FILE=..\Textures\XFX.utx
#EXEC OBJ LOAD FILE=..\Textures\Palettes.utx

#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontSmall"  Height=8  USize=256 VSize=128 CharactersPerPage=256
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontMedium" Height=10 USize=256 VSize=128 CharactersPerPage=256
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontLarge"  Height=12 USize=256 VSize=256 CharactersPerPage=256
#exec Texture Import Name=TeamBeacon2 File="Textures\TeamBeacon2.bmp" Flags=2

#exec TEXTURE IMPORT NAME=myctrans FILE="Textures\myctrans.bmp"

// Constants
const VERSION_NUMBER = "1.01 (gopostal)";

const WhiteTex=Texture'Palettes.Greenwater';

const TIME_NEWMSG_TICK_THRESHOLD = 5.85;	// Treshold to determine if a message is "new"

const MAX_MESSAGES_TO_RETRIEVE_FROM_CONSOLE = 16;		// Max # of messages to dig back in the console for for rendering.

const FACTOR_FACETEXTURE_SLIDEOUT = 8;	// Higher numbers mean faster slideout times

// Structrues
enum EDrawingPosition
{
	EDP_Chat,
	EDP_Center,
	EDP_Pickup
};

Struct MSGSTR
{
	Var String Message;
	var name MessageType;
	Var EDrawingPosition DrawPosition;
	var color DrawColor;
	
	Var Float TickTime;
	Var PlayerReplicationInfo PRI;
	
	var bool bFinished;
	var bool bTriggerAvatars;
};

struct MessageRecord
{
	var string Message;
	var float IssuanceTime;
};


// Internal
	// Metadata
var private GGameReplicationInfo GRI;				// Main game's GRI object
var private GListReplicationInfo LRI;			// List Replication Info object
var private GxHUDController Controller;				// Controlling mutator for this HUD

	// Face texture related
var private GPlayerReplicationInfo DrawFacePRI;			// The PRI associated w/ the drawface
var private VisualPersonalizationBlock FacePersonalization;
var private Float LastDrawFaceTime;							// Last time the face was started to be drawn
var private float LatestMessageStartTime;
var bool bNoSlide;										// If true, the face texture will not slide out.

	// Offsets
var Float BaseOriginX,BaseOriginY,BaseClipX,BaseClipY;

// gopo's addon
var bool UseFloatingTags;
var Texture TeamBeaconIcon;
var color BeaconColor;

simulated event PostBeginPlay()
{
	super.PostBeginPlay();
	LastDrawFaceTime = -500;
	LatestMessageStartTime = -500;
}

simulated function PostRender( canvas Canvas )
{
	local USetIterator MutIter;
	local bool bLoopOverInv;
	local inventory Previous,Current;
	local int i;

	// Set replicationinfo variables
	if( Owner == None || 
		GPlayerReplicationInfo(PlayerPawn(Owner).PlayerReplicationInfo) == None )
		return;
	GRI = GGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if( GRI == None )
		return;
	LRI = GPlayerReplicationInfo(PlayerPawn(Owner).PlayerReplicationInfo).GetListReplicationInfo();
	if( LRI == None )
		return;
	if( Controller == None )
	{
		// Try to find it
		MutIter = LRI.GetMutatorIterator();
		while( MutIter.hasNext() )
		{
			Controller = GxHUDController(MutIter.Next());
			if( Controller != none )
				break;
		}
		LRI.FreeIterator( MutIter );
	}
	if( Controller == None )
		return;
	HUDSetup(canvas);
	if ( PlayerPawn(Owner) != None )
	{
		if ( PlayerPawn(Owner).PlayerReplicationInfo == None )
			return;

		if ( PlayerPawn(Owner).bShowMenu )
		{
			DisplayMenu(Canvas);
			return;
		}
		
		if ( PlayerPawn(Owner).bShowScores )
		{
			if ( ( PlayerPawn(Owner).Weapon != None ) && ( !PlayerPawn(Owner).Weapon.bOwnsCrossHair ) )
				DrawCrossHair(Canvas, 0.5 * Canvas.ClipX - 8, 0.5 * Canvas.ClipY - 8);
			if ( (PlayerPawn(Owner).Scoring == None) && (PlayerPawn(Owner).ScoringType != None) )
				PlayerPawn(Owner).Scoring = Spawn(PlayerPawn(Owner).ScoringType, PlayerPawn(Owner));
			if ( PlayerPawn(Owner).Scoring != None )
			{ 
				PlayerPawn(Owner).Scoring.ShowScores(Canvas);
				return;
			}
		}
		else if ( (PlayerPawn(Owner).Weapon != None) && (Level.LevelAction == LEVACT_None) )
		{
			Canvas.Font = Controller.GetCenterFont();
			PlayerPawn(Owner).Weapon.PostRender(Canvas);
			if ( !PlayerPawn(Owner).Weapon.bOwnsCrossHair )
				DrawCrossHair(Canvas, 0.5 * Canvas.ClipX - 8, 0.5 * Canvas.ClipY - 8);
		}
		DisplayProgressMessage(Canvas);
	}
	if (HudMode==5) 
	{
		DrawInventory(Canvas, Canvas.ClipX-96, 0,False);	
		Return;
	}
	if (Canvas.ClipX<320) HudMode = 4;

	bLoopOverInv =true;
	i=0;
	for(Current=Pawn(Owner).Inventory;Current!=None;Current=Current.Inventory)
	{
		if( i++ >= 10000 )
		{
			bLoopOverInv = false;
			break;
		}
			
		if( Previous != None &&
			Current == Previous )
			{
				bLoopOverInv = false;
				break;
			}
		Previous = Current;
	}
	
	if( bLoopOverInv )
	{
		// Draw Armor
		If( HUDMODE==0 ) DrawArmor( Canvas, 0, Canvas.Clipy-64, False );		// Hack to keep canvas from drawing armor in the top left corner..
		else if (HudMode<2) DrawArmor(Canvas, 32, Canvas.clipy-32,False);
		else if (HudMode==3 || HudMode==2) DrawArmor(Canvas, 0, Canvas.ClipY-32,False);
		else if (HudMode==4) DrawArmor(Canvas, Canvas.ClipX-64, Canvas.ClipY-64,True);
		// Draw Ammo
		if (HudMode!=4) DrawAmmo(Canvas, Canvas.ClipX-48-64, Canvas.ClipY-32);
		else DrawAmmo(Canvas, Canvas.ClipX-48, Canvas.ClipY-32);
		// Display Inventory
		if (HudMode<2) DrawInventory(Canvas, Canvas.ClipX-96, 0,False);
		else if (HudMode==3) DrawInventory(Canvas, Canvas.ClipX-96, Canvas.ClipY-64,False);
		else if (HudMode==4) DrawInventory(Canvas, Canvas.ClipX-64, Canvas.ClipY-64,True);
		else if (HudMode==2) DrawInventory(Canvas, Canvas.ClipX/2-64, Canvas.ClipY-32,False);	
	}

	
	// Draw Health
	if (HudMode<2) DrawHealth(Canvas, 0, Canvas.ClipY-32);
	else if (HudMode==3||HudMode==2) DrawHealth(Canvas, Canvas.ClipX-128, Canvas.ClipY-32);
	else if (HudMode==4) DrawHealth(Canvas, Canvas.ClipX-64, Canvas.ClipY-32);


	// Display Frag count
	if (HudMode<3) DrawFragCount(Canvas, Canvas.ClipX-32,Canvas.ClipY-64);
	else if (HudMode==3) DrawFragCount(Canvas, 0,Canvas.ClipY-64);
	else if (HudMode==4) DrawFragCount(Canvas, 0,Canvas.ClipY-32);

	// Display Identification Info
// added switch for different health hud
//	if (UseFloatingTags)
   	DrawMonsterName(Canvas);
//	else
		DrawIdentifyInfo(Canvas, 0, Canvas.ClipY - 64.0);
	// Message of the Day / Map Info Header
	if (MOTDFadeOutTime != 0.0)
		DrawMOTD(Canvas);
// Translator event 
	DrawActorTip(Canvas);
}

//Add
simulated function DrawActorTip(Canvas Canvas)
{
  local Actor FocusedActor;
//  local vector ScreenPos;

  // Find Target
  FocusedActor = GetFocusedActor();

  // Label Target
  if (FocusedActor != None)
     DrawMyInventory(Canvas);
}

simulated function Actor GetFocusedActor()
{
  local vector Look, EyePos;
  local TranslatorEvent Candidate, Winner;
  local float Score, HiScore;

  EyePos = Owner.Location;
  EyePos.Z += Pawn(Owner).EyeHeight;
  Look = vector(Pawn(Owner).ViewRotation);

  // Iterate through all actors closer than 200 UUs to the player,
  // trying to find the one most directly in front of him:
  HiScore = 0;
  foreach VisibleActors(class'TranslatorEvent', Candidate, 100.0, EyePos)
  {
    // The dot product of two normalised vectors is a nice
    // measure of the angle between them:
    // (1 = perfect match, 0 = right angles, -1 = direct opposites)
    Score = Normal(Candidate.Location - EyePos) dot Look;

    // Ignore actors too far to the sides (too low scores):
    if (Score >= 0.9) // adjust this threshold to taste
    {
      if (Score > HiScore)
      {
        HiScore = Score;
        Winner = Candidate;
      }
    }
  }
  return Winner;
}

//Translator drawing
simulated function DrawMyInventory(Canvas Canvas)
{	
//	local bool bGotNext, bGotPrev, bGotSelected;
	local inventory Inv; //,Prev, Next, SelectedItem;
	local translator Translator;
	local int TempX,TempY;
	local TranslatorEvent TE;

	if ( Owner.Inventory==None) 
		Return;
//	bGotSelected = False;
//	bGotNext = false;
//	bGotPrev = false;
//	Prev = None;
//	Next = None;
//	SelectedItem = Pawn(Owner).SelectedItem;

	for ( Inv=Owner.Inventory; Inv!=None; Inv=Inv.Inventory )
	{
		if ( Translator(Inv) != None )
			Translator = Translator(Inv);
	}

   ForEach VisibleCollidingActors (Class'TranslatorEvent', TE, 60, Owner.Location)
   {
   	if(TE != None)
   	{
  			Canvas.bCenter = false;
			Canvas.Font = Canvas.MedFont;
			TempX = Canvas.ClipX;
			TempY = Canvas.ClipY;
			CurrentMessage = Translator.NewMessage;
			Canvas.Style = 2;	
			Canvas.SetPos(Canvas.ClipX/2-208, Canvas.ClipY/2-212);
         Canvas.Style = ERenderStyle.STY_Modulated;
         Canvas.DrawIcon(texture'myctrans', 1.0);
         Canvas.Style = ERenderStyle.STY_Normal;
			Canvas.SetOrigin(Canvas.ClipX/2-110,Canvas.ClipY/2-52);
			Canvas.SetClip(256,384);
			Canvas.SetPos(0,0);
			Canvas.Style = 1;	
			Canvas.DrawText(CurrentMessage, False);	
			HUDSetup(canvas);
			Canvas.ClipX = TempX;
			Canvas.ClipY = TempY;
		}
	}
}

simulated function DrawArmor(Canvas Canvas, int X, int Y, bool bDrawOne)
{
	Local int ArmorAmount,CurAbs,i;
	Local inventory Inv,BestArmor;
	Local float XL, YL;

	ArmorAmount = 0;
	Canvas.Font = Canvas.LargeFont;
	Canvas.CurX = X;
	Canvas.CurY = Y;
	ArmorOffset=0;
	CurAbs=0;
	BestArmor=None;
	for( Inv=Owner.Inventory; Inv!=None && i++ < 220; Inv=Inv.Inventory ) 
	{
		if (Inv.bIsAnArmor) 
		{
			ArmorAmount += Inv.Charge;				
			if (Inv.Charge>0 && Inv.Icon!=None) 
			{
				if (!bDrawOne) 
				{
					DrawHudIcon(Canvas, Canvas.CurX, Y, Inv);
					DrawIconValue(Canvas, Inv.Charge);						
				}
				else if (Inv.ArmorAbsorption>CurAbs) 
				{
					CurAbs = Inv.ArmorAbsorption;
					BestArmor = Inv;
				}
			}
		}
	}
	if (bDrawOne && BestArmor!=None) 
	{
		DrawHudIcon(Canvas, Canvas.CurX, Y, BestArmor);
		DrawIconValue(Canvas, BestArmor.Charge);		
	}
	Canvas.CurY = Y;
	if (ArmorAmount>0 && HudMode==0) {
		Canvas.StrLen(ArmorAmount,XL,YL);
		Canvas.DrawText(ArmorAmount,False);
	}
}

simulated function DrawTypingPrompt( canvas Canvas, console Console )
{
local string typingprompt;
local float XL, YL;
local color oldcolor;

	if ( Console.bTyping )
	{
		oldcolor = canvas.drawcolor;
		Canvas.DrawColor.r = 0;
		Canvas.DrawColor.g = 255;
		Canvas.DrawColor.b = 0;	
		TypingPrompt = "[GxHUD v"$VERSION_NUMBER$"] (> "$Console.TypedStr$"_";
		Canvas.Font = Controller.GetChatFont();
		Canvas.StrLen( TypingPrompt, XL, YL );
		Canvas.SetPos( 2, Console.FrameY - Console.ConsoleLines - YL - 1 );
		Canvas.DrawRect( Texture'UWindow.BlackTexture', Canvas.ClipX, Canvas.ClipY );
		Canvas.SetPos( 2, Console.FrameY - Console.ConsoleLines - YL - 1 );
		Canvas.DrawText( TypingPrompt, false );
		canvas.drawcolor = oldcolor;
	}
}

simulated function bool DisplayMessages( canvas Canvas )
{
	local int PKM,DM, I, J, k, P,M,C;			// counter vars
	local console Console;
	
	Local int Top,Max;
	Local MSGSTR PickupString[16];
	Local MSGSTR MessageString[16];
	Local MSGSTR CriticalString[16];
	
	Local String TempMessage;
	local color MessageColor;
	local name MsgType;
	local byte bDisplaySender;
	local int EDP;
	local byte bTriggerAvatars;
	
	Local float DeltaY,DeltaX,Margin;
	Local Int XtraLine, ExtraLines;	// For rendering multiple messages.
	
	Local Float by,Temp;
	local float Res;

	local USetIterator Iter;
	local GInfoBlock Block;
	local VisualPersonalizationBlock VPersonalization;

	local bool bLookup;

	if( Owner == None )
		return false;
	
	Console = PlayerPawn(Owner).Player.Console;
	
	// Stop if no console or controller.
	if( Console == None ||
		Controller == None )
		return false;
	
	Canvas.Font = Controller.GetChatFont();	
	if ( !Console.Viewport.Actor.bShowMenu )
		DrawTypingPrompt(Canvas, Console);
			
	// We have text to display that has not timed out.
	If( (Console.TextLines>0) && 
		!Console.Viewport.Actor.bShowmenu )
	{
		P=0;M=0;C=0;J=0;
		Top = Console.Topline;
		Max = Console.Maxlines;
		// Check 16 messages back in the history of the console. Find all 'pickup' type messages and put them in an array. These will be rendered.
		For( I = Top; I > Top - MAX_MESSAGES_TO_RETRIEVE_FROM_CONSOLE; I-- )
		{
			j++;
			If( I < 0 )
			{
				Top = Max - J;
				I = Max;
				Continue;
			}
			
			If( Console.GetMsgTick( I ) <= 0 ) Continue;
			
			bLookup = false;
			for( k = 0; k < Controller.GetNumSpecifications(); k++ )
			{
				// Get spec.
				Controller.GetMessageSpecification( k, GPlayerReplicationInfo(Console.GetMsgPlayer(I)),EDP, MsgType, MessageColor, bDisplaySender, bTriggerAvatars );
				
				if( Console.GetMsgType( I ) == MSGType )
				{
					bLookup = true;
					TempMessage = Console.GetMsgText(I);
					if( (bDisplaySender==1) && Console.GetMsgPlayer(i) != None )
						TempMessage = Console.GetMsgPlayer(i).playername$":"@TempMessage;
					
					switch( EDP )
					{	
						case(EDrawingPosition.EDP_CHAT):
							if( M < Controller.GetMaxChatMessages() )
							{
								MessageString[M].Message = TempMessage;
								MessageString[M].MessageType = Console.GetMsgType( I );
								if( Controller.GetbChatFadesOut() )
								{
									MessageColor.r = byte(float(MessageColor.r)*(Console.GetMsgTick(I)/6.0));
									MessageColor.g = byte(float(MessageColor.g)*(Console.GetMsgTick(I)/6.0));
									MessageColor.b = byte(float(MessageColor.b)*(Console.GetMsgTick(I)/6.0));
								}
								MessageString[M].DrawColor = MessageColor;
								MessageString[M].DrawPosition = EDrawingPosition.EDP_Chat;
								MessageString[M].tickTime = Console.GetMsgTick( I );
								MessageString[M].PRI = Console.GetMsgPlayer( I );
								MessageString[M].bTriggerAvatars = (bTriggerAvatars==1);
								M++;						
							}
							break;
						
						case(EDrawingPosition.EDP_CENTER):
							if( c < Controller.GetMaxCenterMessages() )
							{
								CriticalString[C].Message = TempMessage;
								CriticalString[C].MessageType = Console.GetMsgType( I );
								if( Controller.GetbCenterFadesOut() )
								{
									MessageColor.r = byte(float(MessageColor.r)*(Console.GetMsgTick(I)/6.0));
									MessageColor.g = byte(float(MessageColor.g)*(Console.GetMsgTick(I)/6.0));
									MessageColor.b = byte(float(MessageColor.b)*(Console.GetMsgTick(I)/6.0));
								}
								CriticalString[C].DrawColor = MessageColor;
								CriticalString[C].DrawPosition = EDrawingPosition.EDP_CENTER;
								CriticalString[C].TickTime = Console.GetMsgTick( I );
								CriticalString[C].PRI = Console.GetMsgPlayer( I );
								CriticalString[C].bTriggerAvatars = (bTriggerAvatars==1);
								C++;
							}
							break;
						
						case(edrawingposition.EDP_PICKUP):
						default:
							if( p < Controller.GetMaxPickupMessages() )
							{
								PickupString[P].Message = TempMessage;
								PickupString[P].MessageType = Console.GetMsgType( I );
								if( Controller.GetbPickupFadesOut() )
								{
									MessageColor.r = byte(float(MessageColor.r)*(Console.GetMsgTick(I)/6.0));
									MessageColor.g = byte(float(MessageColor.g)*(Console.GetMsgTick(I)/6.0));
									MessageColor.b = byte(float(MessageColor.b)*(Console.GetMsgTick(I)/6.0));
								}
								PickupString[P].DrawColor = MessageColor;
								PickupString[P].DrawPosition = EDrawingPosition.EDP_pickup;
								PickupString[P].TickTime = Console.GetMsgTick( I );
								PickupString[P].PRI = Console.GetMsgPlayer( I );
								PickupString[P].bTriggerAvatars = (bTriggerAvatars==1);
								P++;
							}
							break;					
					}
					break;
				}
			}
				
			// Default to draw in chat.
			if( !bLookup && M < Controller.GetMaxChatMessages() ) // myumyusoft (c) ^>.<^ o0o
			{
				MessageString[M].Message = Console.GetMsgText(I);
				MessageString[M].MessageType = Console.GetMsgType( I );
				MessageString[M].DrawColor = RGB(255,255,255);
				MessageString[M].DrawPosition = EDP_Chat;
				MessageString[M].tickTime = Console.GetMsgTick( I );
				MessageString[M].PRI = Console.GetMsgPlayer( I );
				MessageString[M].bTriggerAvatars = false;
				M++;								
			}			
		}
				
		// Render pickup messages.
		Canvas.Font = Controller.GetPickupFont();
		if( Controller.GetbPickupFadesOut() )
			Canvas.Style = ERenderStyle.STY_Translucent;
		else Canvas.Style = ERenderStyle.STY_Normal;
		For( PKM = 0; PKM < P; PKM ++ )
		{
			Canvas.DrawColor = PickupString[PKM].DrawColor;
			Canvas.STRLEN( PickupString[PKM].Message, DeltaX, DeltaY );
			Canvas.SetPos( (Canvas.ClipX/2) - (DeltaX/2), Canvas.ClipY - (Canvas.ClipY/6) + ( (DeltaY+1) * PKM ) );
			Canvas.DrawText( PickupString[PKM].Message, False );
		}
		
		// Render Critical Events.	
		Canvas.Font = Controller.GetCenterFont();
		if( Controller.GetbCenterFadesOut() )
			Canvas.Style = ERenderStyle.STY_Translucent;
		else Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.STRLEN("Test",DeltaX,BY);	
		xtraline=0;
		For( PKM = 0; PKM < C; PKM ++ )
		{
			Canvas.STRLEN( CriticalString[PKM].Message, DeltaX, DeltaY );
			Canvas.Setpos( (Canvas.ClipX/2) - (DeltaX/2), (Canvas.ClipY/3) + (XtraLine*(BY+1)) );
			Canvas.DrawColor = CriticalString[PKM].DrawColor;
			Canvas.DrawText( CriticalString[PKM].Message, False );
			XtraLine += (DeltaY/BY);
		}	
		
		// Render TalkTexture (if need be)
		// Dark.:.Night/Mew: Bilinear filter the talk texture, to.
		If( Controller.GetbDisplayAvatars() )
		{
			Canvas.Style = ERenderStyle.STY_Normal;
			Canvas.Drawcolor = Canvas.Default.Drawcolor;
			Canvas.bNoSmooth = False;

			// Search for a new message
			For( DM = M-1; DM > -1; DM-- )
			{
				// New avatar!
				If( MessageString[DM].TickTime > TIME_NEWMSG_TICK_THRESHOLD && 
					MessageString[DM].bTriggerAvatars )
				{
					// Seek new face
					FacePersonalization = None;
					DrawFacePRI = GPlayerReplicationInfo(MessageString[DM].PRI);
				
					// the last message timed out.
					if( Level.TimeSeconds - LatestMessageStartTime > Controller.GetAvatarTimeoutTime() )	
					{
						// New message after all previous messages had timed out.
						LastDrawFaceTime = Level.TimeSeconds;
						bNoSlide = false;
					}
						
					// Register new message -- refresh timeout
					LatestMessageStartTime = Level.TimeSeconds;
					break;
				}
			}

			// If we have a face to draw that has not timed out, then draw it.
			If( Level.TimeSeconds - LatestMessageStartTime < Controller.GetAvatarTimeoutTime() )
			{
				// Render the TalkTex
				Temp = 1;
				if( !bNoSlide )
				{
					Temp = FACTOR_FACETEXTURE_SLIDEOUT*(Level.Timeseconds - LastDrawFaceTime);
					If( Temp > 1 )
					{
						Temp=1;
						bNoSlide = true;
					}
				}
				
				Res = (Canvas.ClipX/8);	
				canvas.setpos( (-res) + (res)*( Temp ) ,0);		

				Canvas.DrawTile( texture'Blacktexture',res,res, 0, 0, texture'consoleback'.UClamp, Texture'consoleback'.VClamp );				
				canvas.setpos( (-res) + (res)*( Temp ) ,0);	

				// Try to get a handle to the FacePersonalization object. We have their PRI.
				if( FacePersonalization == None && 
					DrawFacePRI != None )
				{
					Iter = DrawFacePRI.GetInfoBlockIterator();
					while( Iter.HasNext() )
					{
						Block = GInfoBlock(Iter.Next());
						if( VisualPersonalizationBlock(Block) != None )
						{
							FacePersonalization = VisualPersonalizationBlock(Block);
							break;
						}
					}
					LRI.FreeIterator( Iter );
				}
				
				// Do we have a visual personalization block to render from? If so, draw it. Else use default.
				if( FacePersonalization != None )
					VPersonalization = FacePersonalization;
				else
					VPersonalization = Controller.GetDefaultPersonalization();

				if( VPersonalization != None )
				{
					Canvas.Drawcolor=vPersonalization.GetAvatarTint();	
					if( vPersonalization.GetAvatar() != None )
						Canvas.DrawRect( vPersonalization.GetAvatar(), (res), (res) );
				}
				
				ArmorOffset = (res*Temp);
			}
		}
			
		// Render chat.
		if( Controller.GetbChatFadesOut() )
			Canvas.Style = ERenderStyle.STY_Translucent;
		else Canvas.Style = ERenderStyle.STY_Normal;
		Canvas.Font = Controller.GetChatFont();
		Canvas.STRLEN("TEST",Deltax,Margin);
		ExtraLines = 0;
		canvas.bnosmooth = true;
		
		For( DM = M-1; DM > -1; DM-- )
		{
			TempMessage = MessageString[DM].Message;
			BaseOriginX = Canvas.OrgX;
			BaseOriginY = Canvas.OrgY;
			BaseClipX = Canvas.Clipx;
			BaseClipY = Canvas.Clipy;
			Canvas.SetOrigin( 4+ArmorOffset, 0 );
			Canvas.SetClip( BaseClipX - ( 4+ArmorOffset ), Baseclipy );
			
			Canvas.Setpos(0,4+(ExtraLines*(Margin+1)));	
			Canvas.STRLEN( TempMessage, DeltaX, DeltaY );
			Canvas.DrawColor = MessageString[DM].DrawColor;
			Canvas.DrawText( TempMessage, False );
	
			Canvas.SetOrigin( BaseOriginX, BaseOriginY );
			Canvas.SetClip( BaseClipx, Baseclipy );
			ExtraLines += 1 + Int( DeltaY / 9.0 );
			Canvas.Drawcolor = Canvas.Default.Drawcolor;
		}
	}
	return True;
}

simulated function bool TraceIdentify(canvas Canvas)
{
	local actor Other;
	local vector HitLocation, HitNormal, StartTrace, EndTrace;

	StartTrace = Owner.Location;
	StartTrace.Z += Pawn(Owner).BaseEyeHeight;

	EndTrace = StartTrace + vector(Pawn(Owner).ViewRotation) * 1000.0;

	Other = Trace(HitLocation, HitNormal, EndTrace, StartTrace, true);

	if ( (Pawn(Other) != None) )
	{
		IdentifyTarget = Pawn(Other);
		IdentifyFadeTime = 3.0;
	}

	if ( IdentifyFadeTime == 0.0 )
		return false;

	if ( (IdentifyTarget == None) ||
		 (IdentifyTarget.bHidden) )
		return false;

	return true;
}

simulated function DrawIdentifyInfo(canvas Canvas, float PosX, float PosY)
{
local float XL, YL;
local font oldfont;
local color oldcolor;
local byte oldstyle;

	if (!TraceIdentify(Canvas))
		return;

	oldfont = canvas.font;
	oldstyle = canvas.style;
	Canvas.Font = Controller.GetPickupFont();
	Canvas.Style = ERenderStyle.STY_Translucent;
	if(IdentifyTarget != none)
	{
		If( Identifytarget.playerreplicationinfo != None  )
		{
			Canvas.Drawcolor.G = 255 *(IdentifyFadeTime / 3.0);
			Canvas.Drawcolor.B = 32 *(IdentifyFadeTime / 3.0);
			Canvas.DRawcolor.R = 0;
			Canvas.STRLEN( IdentifyTarget.PlayerReplicationInfo.PlayerName, xL, yL );	
			Canvas.SetPos( (Canvas.ClipX/2) - (xl/2), (Canvas.ClipY/4)*3 - YL );
			Canvas.DrawText(IdentifyTarget.Playerreplicationinfo.PlayerName );
		}

		Oldcolor = Canvas.DrawColor;
		
		if( IdentifyTarget.Health > IdentifyTarget.default.Health*(0.66) )
		{
			// Green
			Canvas.DrawColor = RGB(0,255,0);
		}
		else if( IdentifyTarget.Health > IdentifyTarget.Default.Health*0.33 )
		{
			// Yellow
			Canvas.DrawColor = RGB(255,255,0);
		}
		else
		{
			// FUCK!
			Canvas.DrawColor = RGB(255,0,0);
		}
		
		Canvas.STRLEN( "HP:"@IdentifyTarget.Health, xl, yl );
		Canvas.SetPos( (Canvas.clipx - XL)>>>1, (Canvas.ClipY/4)*3 +4 );
		if (IdentifyTarget.Health < 0)
      	Canvas.DrawText( "DEAD");
      else
			Canvas.DrawText( "HP:"@IdentifyTarget.Health );
		canvas.drawcolor = oldcolor;
	}
	Canvas.font = oldfont;
	Canvas.style = oldstyle;
}

simulated function DrawInventory(Canvas Canvas, int X, int Y, bool bDrawOne)
{	
	local font temp;

	Temp = Canvas.MedFont;
	Canvas.medfont = font'MedFont';
	Canvas.bNoSmooth = True;
	Super.DrawInventory(canvas,x,y,bDrawOne);	// Hack for the translator.
	Canvas.bNoSmooth = False;
	Canvas.Medfont=temp;
}

Simulated static Function Color RGB(Byte R, Byte G, Byte B){local color c;c.R=r;c.g=g;c.b=b;return c;}

//gopo's add-ons
simulated function DrawMonsterName(Canvas Canvas)
{
	local ScriptedPawn thisPawn;
	local vector X, Y, Z, CamLoc, TargetDir, Dir, XY;
	local rotator CamRot;
	local Actor Camera;
	local float BaseBeaconScale, BeaconScale, Dist, DistScale;
	local float TanFOVx, TanFOVy;
//	local float TanX, TanY;
	local float dx, dy, FontY;
	local string BeaconText;

	Canvas.Style = ERenderStyle.STY_Masked;

	if (Canvas.ClipX > 1024)
		Canvas.Font = Font'BeaconNameFontLarge';
	else if (Canvas.ClipX > 640)
		Canvas.Font = Font'BeaconNameFontMedium';
	else
		Canvas.Font = Font'BeaconNameFontSmall';
	
	Canvas.SetPos(0, 0);
	Canvas.TextSize("X", dx, FontY);
	BaseBeaconScale = 1.5 * FontY / Texture'TeamBeacon2'.VSize;
	
   Canvas.ViewPort.Actor.PlayerCalcView(Camera, CamLoc, CamRot);

	TanFOVx = Tan(Canvas.ViewPort.Actor.FOVAngle / 114.591559); // 360/Pi = 114.5915590...
	TanFOVy = (Canvas.ClipY / Canvas.ClipX) * TanFOVx;
	GetAxes(CamRot, X, Y, Z);
	
	Canvas.bNoSmooth = False;
	Canvas.Style = ERenderStyle.STY_Masked;
	foreach AllActors(class'ScriptedPawn', thisPawn)
   {
		if ( thisPawn != none && thisPawn != Camera && thisPawn.Health > 0 && !thisPawn.bHidden && thisPawn.Team < 4)
		{
         TargetDir = thisPawn.Location - CamLoc;
			Dist = VSize(TargetDir) * FMin(TanFOVx, 1.0);
			TargetDir = Normal(TargetDir + vect(0,0,1) * thisPawn.CollisionHeight);
			DistScale = FMin(100.0 * thisPawn.CollisionRadius / Dist, 1.0);

			if (DistScale > 0.5 && TargetDir dot X > 0 && (FastTrace(thisPawn.Location, CamLoc) 
			|| FastTrace(thisPawn.Location + vect(0,0,0.8) * thisPawn.CollisionHeight, CamLoc)))
         {
				BeaconScale = BaseBeaconScale * DistScale;
				Dir = X * (X dot TargetDir);
				XY = TargetDir - Dir;
				
				dx = Canvas.ClipX * 0.5 * (1.0 + (XY dot Y) / (VSize(Dir) * TanFOVx));
				dy = Canvas.ClipY * 0.5 * (1.0 - (XY dot Z) / (VSize(Dir) * TanFOVy));
				
				//C.DrawColor = BeaconColor;
				Canvas.DrawColor = GreenColor;
				Canvas.SetPos(dx - 0.5 * BeaconScale * TeamBeaconIcon.USize, dy - 2 * FontY * DistScale);

				// only draw name if close enough
				if (DistScale == 1.0)
            {
					//BeaconText = thisPawn.PlayerReplicationInfo.PlayerName;
					if (Canvas.ClipX > 600)
						//BeaconText = BeaconText @ "(" $ thisPawn.Health $ ")";
						BeaconText = "" $ thisPawn.Health $ "";
/*
					// shadow
					Canvas.SetPos(dx + 0.6 * BeaconScale * TeamBeaconIcon.USize + 1, dy - 1.75 * FontY + 1);
					//Canvas.DrawColor = GreenColor * 0.125;
					Canvas.DrawColor = GreenColor;
					Canvas.DrawTextClipped(BeaconText, False);
*/
					// color
					Canvas.SetPos(dx + 0.6 * BeaconScale * TeamBeaconIcon.USize, dy - 1.75 * FontY);
					Canvas.DrawColor = GreenColor;
					Canvas.DrawTextClipped(BeaconText, False);
				}
			}
		}
	}
}

defaultproperties
{
	BeaconColor=(R=0,G=150,B=0,A=0),
   TeamBeaconIcon=Texture'TeamBeacon2'
   UseFloatingTags=True
}
