class GxHUDController expands GMutatorPlus
	config(GgoHUD1v);

#exec obj load file="..\System\VisualPersonalizationBlock.u"
	
// Constants
const VERSION = "gopo2";
const CLASS_PERSONALIZATION =  class'VisualPersonalizationBlock';

const DEFAULT_FONT_MESSAGE = Font'WhiteFont';

const TIME_MAX_AVATAR_TIMEOUT_TIME = 6;

// structures
	// EDrawingPosition - Where to draw a message.
enum EDrawingPosition
{
	EDP_Chat,
	EDP_Center,
	EDP_Pickup
};

struct SMessageRenderData
{
	var() config EDrawingPosition DrawingPosition;
	var() config name MessageType;
	var() config color DrawColor;
	var() config byte bDisplaySender;
	var() config byte bTriggerAvatars;
	var() config byte bUsePersonalColor;
};

// variables
	// configuration
var(Messages) const config SMessageRenderData MessageTypeDrawing[16];
var(Messages) private config string ChatFont;
var private string PreviousChatFont;
var private font LoadedChatFont;
var(Messages) private config string CenterFont;
var private string PreviousCenterFont;
var private font LoadedCenterFont;
var(Messages) private config string PickupFont;
var private string PreviousPickupFont;
var private font LoadedPickupFont;
var(Messages) private config bool bDisplayAvatars;
var(Messages) private config float AvatarTimeoutTime;

var(Messages) config private int MaxChatMessages;
var(Messages) config private int MaxCenterMessages;
var(Messages) config private int MaxPickupMessages;

var(Messages) config bool bPickupFadesOut;
var(Messages) config bool bCenterFadesOut;
var(Messages) config bool bChatFadesOut;

var(Messages) config bool bUsePersonalColorMessages;		// if true, personal color will be used for messages


replication
{
	reliable if( role==role_authority )
		MessageTypeDrawing,ChatFont,CenterFont,PickupFont,bDisplayAvatars,
		MaxPickupMessages,MaxCenterMessages,MaxChatMessages,AvatarTimeoutTime,
		bChatfadesout,bCenterfadesout,bPickupfadesout,DefaultPersonalization,bUsePersonalColorMessages;
}

	// runtime
var private VisualPersonalizationBlock DefaultPersonalization;

Simulated Function Initialize()
{
	local int index;
	local int dp;
	local name mtype;
	local color mcolor;
	local byte bds,bta;

	// If on server, load variables.
	if( role==role_authority )
	{
		saveconfig();
		DefaultPersonalization = spawn(CLASS_PERSONALIZATION);
	}
}

simulated final function GetMessageSpecification( int index,
													GPlayerReplicationInfo PRI,
													out int DrawingPosition, 
													out name MessageType, 
													out color MessageColor,
													out byte bDisplaySender,
													out byte bTriggerAvatars )
{
local USetIterator Iter;
local GInfoBlock Block;
local VisualPersonalizationBlock VPersonalization;

	DrawingPosition = MessageTypeDrawing[index].DrawingPosition;
	MessageType = MessageTypeDrawing[index].MessageType;
	
	MessageColor = MessageTypeDrawing[index].DrawColor;
	if( MessageTypeDrawing[index].bUsePersonalColor==1 &&
		PRI != None )
	{
		Iter = PRI.GetInfoBlockIterator();
		while( Iter.HasNext() )
		{
			Block = GInfoBlock(Iter.Next());
			if( VisualPersonalizationBlock(Block) != None )
			{
				// Disallow default color.
				if( MessageColor.R != 0 || 
					MessageColor.G != 0 ||
					MessageColor.B != 0 )
				MessageColor = VisualPersonalizationBlock(Block).PersonalColor;
				break;
			}
		}
		PRI.FreeIterator( Iter );
	}
	
	bDisplaySender = MessageTypeDrawing[index].bDisplaySender;
	bTriggerAvatars = MessageTypeDrawing[index].bTriggerAvatars;
}

simulated final function int GetNumSpecifications()
{
	return arraycount(MessageTypeDrawing);
}

simulated function VisualPersonalizationBlock GetDefaultPersonalization()
{
	return DefaultPersonalization;
}

simulated function font GetChatFont()
{
	if( ChatFont == "" )
		return DEFAULT_FONT_MESSAGE;
	else if( PreviousChatFont != ChatFont )
	{
		LoadedChatFont = Font(DynamicLoadObject(ChatFont,class'Font'));
		PreviousChatFont = ChatFont;
	}
	
	if( LoadedChatFont == None )
		return dEFAULT_FONT_MESSAGE;	
	
	return LoadedChatFont;
}

simulated function font GetCenterFont()
{
	if( CenterFont == "" )
		return DEFAULT_FONT_MESSAGE;
	else if( PreviousCenterFont != CenterFont )
	{
		LoadedCenterFont = Font(DynamicLoadObject(CenterFont,class'Font'));
		PreviousCenterFont = CenterFont;
	}
	
	if( LoadedCenterFont == None )
		return dEFAULT_FONT_MESSAGE;
	
	return LoadedCenterFont;
}

simulated function font GetPickupFont()
{
	if( PickupFont == "" )
		return DEFAULT_FONT_MESSAGE;
	else if( PreviousPickupFont != PickupFont )
	{
		LoadedPickupFont = Font(DynamicLoadObject(PickupFont,class'Font'));
		PreviousPickupFont = PickupFont;
	}

	if( LoadedPickupFont == None )
		return dEFAULT_FONT_MESSAGE;
	
	return LoadedPickupFont;
}

simulated function int GetMaxChatMessages()
{
	return MaxChatMessages;
}

simulated function bool GetbChatfadesout()
{
	return bChatfadesout;
}

simulated function int GetMaxCenterMessages()
{
	return MaxCenterMessages;
}

simulated function bool GetbCenterfadesout()
{
	return bCenterfadesout;
}

simulated function int GetMaxPickupMessages()
{
	return MaxPickupMessages;
}

simulated function bool GetbPickupfadesout()
{
	return bPickupfadesout;
}

simulated function bool GetbDisplayAvatars()
{
	return bDisplayAvatars;
}

simulated function float GetAvatarTimeoutTime()
{
	if( AvatarTimeoutTime < TIME_MAX_AVATAR_TIMEOUT_TIME )
		return AvatarTimeoutTime;
	return 6;
}

defaultproperties
{
    MessageTypeDrawing(0)=(DrawingPosition=0,messagetype=Say,DrawColor=(R=26,G=170,B=0,A=0),,bDisplaySender=1,bTriggerAvatars=1,bUsePersonalColor=1),
    MessageTypeDrawing(1)=(DrawingPosition=0,messagetype=TeamSay,DrawColor=(R=61,G=168,B=173,A=0),,bDisplaySender=1,bTriggerAvatars=0,bUsePersonalColor=0),
    MessageTypeDrawing(2)=(DrawingPosition=2,messagetype=Pickup,DrawColor=(R=255,G=255,B=255,A=0),,bDisplaySender=0,bTriggerAvatars=0,bUsePersonalColor=0),
    MessageTypeDrawing(3)=(DrawingPosition=1,messagetype=CriticalEvent,DrawColor=(R=9,G=95,B=255,A=0),,bDisplaySender=0,bTriggerAvatars=0,bUsePersonalColor=0),
    MessageTypeDrawing(4)=(DrawingPosition=1,messagetype=RedCriticalEvent,DrawColor=(R=255,G=0,B=0,A=0),,bDisplaySender=0,bTriggerAvatars=0,bUsePersonalColor=0),
    MessageTypeDrawing(5)=(DrawingPosition=1,messagetype=LowCriticalEvent,DrawColor=(R=9,G=95,B=255,A=0),,bDisplaySender=0,bTriggerAvatars=0,bUsePersonalColor=0),
    MessageTypeDrawing(6)=(DrawingPosition=0,messagetype=DeathMessage,DrawColor=(R=255,G=0,B=0,A=0),,bDisplaySender=0,bTriggerAvatars=0,bUsePersonalColor=0),
    MessageTypeDrawing(7)=(DrawingPosition=0,messagetype=Log,DrawColor=(R=128,G=128,B=128,A=0),,bDisplaySender=0,bTriggerAvatars=0,bUsePersonalColor=0),
    MessageTypeDrawing(8)=(DrawingPosition=0,messagetype=Event,DrawColor=(R=255,G=255,B=255,A=0),,bDisplaySender=0,bTriggerAvatars=0,bUsePersonalColor=0),
    MessageTypeDrawing(9)=(DrawingPosition=0,messagetype=Console,DrawColor=(R=128,G=128,B=128,A=0),,bDisplaySender=0,bTriggerAvatars=0,bUsePersonalColor=0),
    MessageTypeDrawing(10)=(DrawingPosition=0,messagetype=GSecurityHandler,DrawColor=(R=220,G=115,B=20,A=0),,bDisplaySender=0,bTriggerAvatars=0,bUsePersonalColor=0),
    MessageTypeDrawing(11)=(DrawingPosition=0,messagetype=GGameLogicHandler,DrawColor=(R=150,G=0,B=255,A=0),,bDisplaySender=0,bTriggerAvatars=0,bUsePersonalColor=0),
    MessageTypeDrawing(12)=(DrawingPosition=0,messagetype=GMutatorPlus,DrawColor=(R=255,G=0,B=255,A=0),,bDisplaySender=0,bTriggerAvatars=0,bUsePersonalColor=0),
    MessageTypeDrawing(13)=(DrawingPosition=0,messagetype=None,DrawColor=(R=128,G=128,B=128,A=0),,bDisplaySender=0,bTriggerAvatars=0,bUsePersonalColor=0),
    ChatFont="UnrealShare.WhiteFont"
    CenterFont="UnrealShare.WhiteFont"
    PickupFont="UnrealShare.WhiteFont"
    AvatarTimeoutTime=6.00
    MaxChatMessages=8
    MaxCenterMessages=3
    MaxPickupMessages=3
    bPickupFadesOut=True
    bCenterFadesOut=True
}
