
class CHUD expands ChallengeHUD config(user);

#exec TEXTURE IMPORT NAME=CHUDWeapons2 FILE="Images\CHUDWeapons.bmp" GROUP=All
#exec TEXTURE IMPORT NAME=CHUDWeapons2a FILE="Images\CHUDWeaponsNEW.bmp" GROUP=All
#exec TEXTURE IMPORT NAME=HudElements1c FILE="Images\HudElements1c.bmp" GROUP=All

#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontSmall"  Height=8  USize=256 VSize=128 CharactersPerPage=256
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontMedium" Height=10 USize=256 VSize=128 CharactersPerPage=256
#exec New TrueTypeFontFactory FontName="LucidaSansTypewriter" Name="BeaconNameFontLarge"  Height=12 USize=256 VSize=256 CharactersPerPage=256
#exec Texture Import Name=TeamBeacon2 File="Images\TeamBeacon2.bmp" Flags=2

#exec TEXTURE IMPORT NAME=myctrans FILE="Images\myctrans.bmp"
// MIPS=OFF removed from next line
#exec TEXTURE IMPORT NAME=RaReticle FILE=TEXTURES\RaReticle.BMP FLAGS=2 LODSET=2

//Radar
#exec texture Import File=Textures\radarconsole.pcx Name=radarconsole Mips=Off Flags=2
#exec Texture Import File=Textures\Monsterpoint.pcx Name=monsterpoint Mips=Off
#exec Texture Import File=Textures\Monsterpoint2.pcx Name=monsterpoint2 Mips=Off

var int TranslatorTimer;
var() int TranslatorY, CurTranY, SizeY, Count;
var string CurrentMessage;
var bool bDisplayTran, bFlashTranslator;
var float MOTDFadeOutTime;

var float IdentifyFadeTime;
var Pawn IdentifyTarget;

// Identify Strings
var localized string IdentifyName;
var localized string IdentifyHealth;

var() localized string VersionMessage;

var localized string TeamName[4];
var() color TeamColor[4];
var() color AltTeamColor[4];
var color RedColor, GreenColor;
var int ArmorOffset;

var() config bool bHideSpectatorBeacons;
var Texture TeamBeaconIcon;
var color BeaconColor;

var PlayerReplicationInfo Ordered[32]; //For Sort Score code

//Radar tile placement
var() config enum ES_Position
{
    RADAR_TopLeft, RADAR_TopMiddle, RADAR_TopRight, RADAR_MiddleLeft,
    RADAR_MiddleRight, RADAR_BottomLeft, RADAR_BottomMiddle, RADAR_BottomRight
} Position;
var() config int Zscale;
var texture tex;


//exec function ShowServerInfo()
//{
//}

simulated function PostRender( canvas Canvas )
{
   local float XL, YL, XPos, YPos, FadeValue;
   local string Message;
   local int M, i, j, k, XOverflow;
   local float OldOriginX;

	HUDSetup(canvas);
   if ((PawnOwner == None) || (PlayerOwner.PlayerReplicationInfo == None))
      return;

   if (bShowInfo)
   {
      ServerInfo.RenderInfo( Canvas );
      return;
   }

   Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
   OldOriginX = Canvas.OrgX;
   // Master message short queue control loop.
   Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
   Canvas.StrLen("TEST", XL, YL);
   Canvas.SetClip(768*Scale - 10, Canvas.ClipY);
   bDrawFaceArea = false;
   if (!bHideFaces && !PlayerOwner.bShowScores && !bForceScores && !bHideHUD && !PawnOwner.PlayerReplicationInfo.bIsSpectator && (Scale >= 0.4))
   {
      DrawSpeechArea(Canvas, XL, YL);
      bDrawFaceArea = (FaceTexture != None) && (FaceTime > Level.TimeSeconds);
      if (bDrawFaceArea)
      {
	 		if (!bHideHUD && ((PawnOwner.PlayerReplicationInfo == None) || !PawnOwner.PlayerReplicationInfo.bIsSpectator))
            Canvas.SetOrigin(FMax(YL*4 + 8, 70*Scale) + 7*Scale + 6 + FaceAreaOffset, Canvas.OrgY);
      }
   }

   for (i=0; i<4; i++)
   {
      if (ShortMessageQueue[i].Message != None)
      {
	 		j++;

	 		if (bResChanged || (ShortMessageQueue[i].XL == 0))
	 		{
	    		if (ShortMessageQueue[i].Message.Default.bComplexString)
               Canvas.StrLen(ShortMessageQueue[i].Message.Static.AssembleString(self, ShortMessageQueue[i].Switch,
               	ShortMessageQueue[i].RelatedPRI,	ShortMessageQueue[i].StringMessage), ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);
            else Canvas.StrLen(ShortMessageQueue[i].StringMessage, ShortMessageQueue[i].XL, ShortMessageQueue[i].YL);

	    	Canvas.StrLen("TEST", XL, YL);
         ShortMessageQueue[i].numLines = 1;
	    	if (ShortMessageQueue[i].YL > YL)
            {
	       		ShortMessageQueue[i].numLines++;
	       		for (k=2; k<4-i; k++)
               {
		  				if (ShortMessageQueue[i].YL > YL*k)
		     				ShortMessageQueue[i].numLines++;
               }
	    		}
	 		}

	 		// Keep track of the amount of lines a message overflows, to offset the next message with.
   		Canvas.SetPos(6, 2 + YL * YPos);
	 		YPos += ShortMessageQueue[i].numLines;
	 		if (YPos > 4)
	   		 break;

	 		if (ShortMessageQueue[i].Message.Default.bComplexString)
   		{
	    		// Use this for string messages with multiple colors.
	   		ShortMessageQueue[i].Message.Static.RenderComplexMessage(Canvas, ShortMessageQueue[i].XL,  YL, ShortMessageQueue[i].StringMessage,
      		ShortMessageQueue[i].Switch, ShortMessageQueue[i].RelatedPRI, None, ShortMessageQueue[i].OptionalObject);
   		}
   		else
   		{
	   		Canvas.DrawColor = ShortMessageQueue[i].Message.Default.DrawColor;
	   		Canvas.DrawText(ShortMessageQueue[i].StringMessage, False);
			}
      }
   }

   Canvas.DrawColor = WhiteColor;
   Canvas.SetClip(OldClipX, Canvas.ClipY);
   Canvas.SetOrigin(OldOriginX, Canvas.OrgY);

   if (PlayerOwner.bShowScores || bForceScores)
   {
      if ((PlayerOwner.Scoring == None) && (PlayerOwner.ScoringType != None))
	 		PlayerOwner.Scoring = Spawn(PlayerOwner.ScoringType, PlayerOwner);
      if (PlayerOwner.Scoring != None)
      {
	 		PlayerOwner.Scoring.OwnerHUD = self;
	 		PlayerOwner.Scoring.ShowScores(Canvas);
	 		if (PlayerOwner.Player.Console.bTyping)
            DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);
	 		return;
      }
   }

   YPos = FMax(YL*4 + 8, 70*Scale);
   if (bDrawFaceArea)
      DrawTalkFace( Canvas,0, YPos );
   if (j > 0)
   {
      bDrawMessageArea = True;
      MessageFadeCount = 2;
   }
   else bDrawMessageArea = False;

   if (!bHideCenterMessages)
   {
      for (i=0; i<10; i++)
      {
         if (LocalMessages[i].Message != None)
         {
	    		if (LocalMessages[i].Message.Default.bFadeMessage && Level.bHighDetailMode)
	    		{
	       		Canvas.Style = ERenderStyle.STY_Translucent;
	       		FadeValue = (LocalMessages[i].EndOfLife - Level.TimeSeconds);
	       		if (FadeValue > 0.0)
	       		{
		  				if (bResChanged || (LocalMessages[i].XL == 0))
		  				{
		     				if (LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1)
		        				LocalMessages[i].StringFont = MyFonts.GetBigFont( Canvas.ClipX );
		     				else LocalMessages[i].StringFont = MyFonts.GetHugeFont( Canvas.ClipX );

		     				Canvas.Font = LocalMessages[i].StringFont;
		     				Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
		     				LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
		  				}
		  				Canvas.Font = LocalMessages[i].StringFont;
		  				Canvas.DrawColor = LocalMessages[i].DrawColor * (FadeValue/LocalMessages[i].LifeTime);
		  				Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
		  				Canvas.DrawText( LocalMessages[i].StringMessage, False );
               }
            }
            else
            {
               if (bResChanged || (LocalMessages[i].XL == 0))
               {
		  				if (LocalMessages[i].Message.Static.GetFontSize(LocalMessages[i].Switch) == 1)
		     				LocalMessages[i].StringFont = MyFonts.GetBigFont(Canvas.ClipX);
		  				else LocalMessages[i].StringFont = MyFonts.GetHugeFont(Canvas.ClipX);
		
               	Canvas.Font = LocalMessages[i].StringFont;
		  				Canvas.StrLen(LocalMessages[i].StringMessage, LocalMessages[i].XL, LocalMessages[i].YL);
		  				LocalMessages[i].YPos = LocalMessages[i].Message.Static.GetOffset(LocalMessages[i].Switch, LocalMessages[i].YL, Canvas.ClipY);
	       		}
               Canvas.Font = LocalMessages[i].StringFont;
	      		Canvas.Style = ERenderStyle.STY_Normal;
	       		Canvas.DrawColor = LocalMessages[i].DrawColor;
	       		Canvas.SetPos( 0.5 * (Canvas.ClipX - LocalMessages[i].XL), LocalMessages[i].YPos );
	       		Canvas.DrawText( LocalMessages[i].StringMessage, False );
            }
         }
      }
   }
   Canvas.Style = ERenderStyle.STY_Normal;
   if (!PlayerOwner.bBehindView && (PawnOwner.Weapon != None) && (Level.LevelAction == LEVACT_None))
   {
      Canvas.DrawColor = WhiteColor;
      PawnOwner.Weapon.PostRender(Canvas);
      if (!PawnOwner.Weapon.bOwnsCrossHair)
	 		DrawCrossHair(Canvas, 0,0 );
   }

   if ((PawnOwner != Owner) && PawnOwner.bIsPlayer)
   {
      Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
      Canvas.bCenter = true;
      Canvas.Style = ERenderStyle.STY_Normal;
      Canvas.DrawColor = CyanColor * TutIconBlink;
      Canvas.SetPos(4, Canvas.ClipY - 96 * Scale);
      Canvas.DrawText( livefeed$PawnOwner.PlayerReplicationInfo.PlayerName, true );
      Canvas.bCenter = false;
      Canvas.DrawColor = WhiteColor;
      Canvas.Style = Style;
   }

   if (bStartUpMessage && (Level.TimeSeconds < 5))
   {
      bStartUpMessage = false;
      PlayerOwner.SetProgressTime(7);
   }

   if ((PlayerOwner.ProgressTimeOut > Level.TimeSeconds) && !bHideCenterMessages)
      DisplayProgressMessage(Canvas);

   if (MOTDFadeOutTime > 0.0)
      DrawMOTD(Canvas);

   if(!bHideHUD)
   {
      if (!PawnOwner.PlayerReplicationInfo.bIsSpectator)
      {
	 		Canvas.Style = Style;

	 		DrawAmmo(Canvas);
	 		DrawStatus(Canvas);
	 		if (!bHideAllWeapons)
	    		DrawWeapons(Canvas);
	 		else if (Level.bHighDetailMode	&& (PawnOwner == PlayerOwner) && (PlayerOwner.Handedness == 2))
         {
	    		// if weapon bar hidden and weapon hidden, draw weapon name when it changes
	    		if (PawnOwner.PendingWeapon != None)
	    		{
	      		WeaponNameFade = 1.0;
	       		Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	       		Canvas.DrawColor = PawnOwner.PendingWeapon.NameColor;
	       		Canvas.SetPos(Canvas.ClipX - 360 * Scale, Canvas.ClipY - 64 * Scale);
	       		Canvas.DrawText(PawnOwner.PendingWeapon.ItemName, False);
	    		}
	    		else if ((Level.NetMode == NM_Client) && PawnOwner.IsA('TournamentPlayer') && (TournamentPlayer(PawnOwner).ClientPending != None))
            {
               WeaponNameFade = 1.0;
               Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	       		Canvas.DrawColor = TournamentPlayer(PawnOwner).ClientPending.NameColor;
	       		Canvas.SetPos(Canvas.ClipX - 360 * Scale, Canvas.ClipY - 64 * Scale);
	       		Canvas.DrawText(TournamentPlayer(PawnOwner).ClientPending.ItemName, False);
	    		}
	    		else if ((WeaponNameFade > 0) && (PawnOwner.Weapon != None))
            {
	       		Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
	       		Canvas.DrawColor = PawnOwner.Weapon.NameColor;
	       		if (WeaponNameFade < 1)
		  				Canvas.DrawColor = Canvas.DrawColor * WeaponNameFade;
               Canvas.SetPos(Canvas.ClipX - 360 * Scale, Canvas.ClipY - 64 * Scale);
	       		Canvas.DrawText(PawnOwner.Weapon.ItemName, False);
            }
         }
         // Display Frag count
         if (!bAlwaysHideFrags && !bHideFrags)
	    		DrawFragCount(Canvas);
      }

      if (!bHideTeamInfo)
         DrawGameSynopsis(Canvas);

      if (PawnOwner == PlayerOwner)
         DrawIdentifyInfo(Canvas);

      DrawPlayerHealth(Canvas);
      DrawMonsterName(Canvas);

      if (HUDMutator != None)
         HUDMutator.PostRender(Canvas);

      if ((PlayerOwner.GameReplicationInfo != None) && (PlayerPawn(Owner).GameReplicationInfo.RemainingTime > 0))
      {
         if (TimeMessageClass == None)
	    		TimeMessageClass = class<CriticalEventPlus>(DynamicLoadObject("Botpack.TimeMessage", class'Class'));

         if ((PlayerOwner.GameReplicationInfo.RemainingTime <= 300) && (PlayerOwner.GameReplicationInfo.RemainingTime != LastReportedTime))
         {
   	    	LastReportedTime = PlayerOwner.GameReplicationInfo.RemainingTime;
	    		if (PlayerOwner.GameReplicationInfo.RemainingTime <= 30)
	    		{
	       		bTimeValid = (bTimeValid || (PlayerOwner.GameReplicationInfo.RemainingTime > 0));
               if (PlayerOwner.GameReplicationInfo.RemainingTime == 30)
	          		TellTime(5);
               else if (bTimeValid && PlayerOwner.GameReplicationInfo.RemainingTime <= 10)
	          		TellTime(16 - PlayerOwner.GameReplicationInfo.RemainingTime);
            }
	    		else if (PlayerOwner.GameReplicationInfo.RemainingTime % 60 == 0)
            {
               M = PlayerOwner.GameReplicationInfo.RemainingTime/60;
	       		TellTime(5 - M);
            }
         }
      }
   }
   if (PlayerOwner.Player.Console.bTyping)
      DrawTypingPrompt(Canvas, PlayerOwner.Player.Console);

   if (PlayerOwner.bBadConnectionAlert && (PlayerOwner.Level.TimeSeconds > 5))
   {
      Canvas.Style = ERenderStyle.STY_Normal;
      Canvas.DrawColor = WhiteColor;
      Canvas.SetPos(Canvas.ClipX - (64*Scale), Canvas.ClipY / 2);
      Canvas.DrawIcon(texture'DisconnectWarn', Scale);
   }
   DrawActorTip(Canvas);
// DrawInventory(Canvas);
}

simulated function DrawActorTip(Canvas Canvas)
{
  local Actor FocusedActor;
  local vector ScreenPos;

  // Find Target
  FocusedActor = GetFocusedActor();

  // Label Target
  if (FocusedActor != None)
     DrawInventory(Canvas);
}

simulated function Actor GetFocusedActor()
{
  local vector Look, EyePos;
  local TranslatorEvent Candidate, Winner;
  local float Score, HiScore;

  EyePos = Owner.Location;
  EyePos.Z += Pawn(Owner).EyeHeight;
  Look = vector(Pawn(Owner).ViewRotation);

  // Iterate through all actors closer than 200 UUs to the player,
  // trying to find the one most directly in front of him:
  HiScore = 0;
  foreach VisibleActors(class'TranslatorEvent', Candidate, 100.0, EyePos)
  {
    // The dot product of two normalised vectors is a nice
    // measure of the angle between them:
    // (1 = perfect match, 0 = right angles, -1 = direct opposites)
    Score = Normal(Candidate.Location - EyePos) dot Look;

    // Ignore actors too far to the sides (too low scores):
    if (Score >= 0.9) // adjust this threshold to taste
    {
      if (Score > HiScore)
      {
        HiScore = Score;
        Winner = Candidate;
      }
    }
  }
  return Winner;
}

//Translator drawing
simulated function DrawInventory(Canvas Canvas)
{	
	local bool bGotNext, bGotPrev, bGotSelected;
	local inventory Inv,Prev, Next, SelectedItem;
	local translator Translator;
	local int TempX,TempY, HalfHUDX, HalfHUDY, AmmoIconSize, i;
	local TranslatorEvent TE;

	if ( Owner.Inventory==None) Return;
	bGotSelected = False;
	bGotNext = false;
	bGotPrev = false;
	Prev = None;
	Next = None;
	SelectedItem = Pawn(Owner).SelectedItem;

	for ( Inv=Owner.Inventory; Inv!=None; Inv=Inv.Inventory )
	{
		if ( Translator(Inv) != None )
			Translator = Translator(Inv);
	}

   ForEach VisibleCollidingActors (Class'TranslatorEvent', TE, 60, Owner.Location)
   {
   	if(TE != None)
   	{
  			Canvas.bCenter = false;
			Canvas.Font = Canvas.MedFont;
			TempX = Canvas.ClipX;
			TempY = Canvas.ClipY;
			CurrentMessage = Translator.NewMessage;
			Canvas.Style = 2;	
			Canvas.SetPos(Canvas.ClipX/2-208, Canvas.ClipY/2-212);
         Canvas.Style = ERenderStyle.STY_Modulated;
         Canvas.DrawIcon(texture'myctrans', 1.0);
         Canvas.Style = ERenderStyle.STY_Normal;
			Canvas.SetOrigin(Canvas.ClipX/2-110,Canvas.ClipY/2-52);
			Canvas.SetClip(256,384);
			Canvas.SetPos(0,0);
			Canvas.Style = 1;	
			Canvas.DrawText(CurrentMessage, False);	
			HUDSetup(canvas);
			Canvas.ClipX = TempX;
			Canvas.ClipY = TempY;
		}
	}
}

simulated function DrawAmmo(Canvas Canvas)
{
	local int X,Y;

	Canvas.Style = Style;
	Canvas.DrawColor = HUDColor;
	if ( bHideAllWeapons || (HudScale * WeaponScale * Canvas.ClipX <= Canvas.ClipX - 256 * Scale) )
		Y = Canvas.ClipY - 63.5 * Scale;
	else
		Y = Canvas.ClipY - 127.5 * Scale;
	if ( bHideAllWeapons )
		X = 0.5 * Canvas.ClipX + 128 * Scale;
	else
		X = Canvas.ClipX - 128 * Scale;
	Canvas.SetPos(X, Y);
	Canvas.DrawTile(Texture'HudElements1c', 128*Scale, 64*Scale, 128, 192, 128.0, 64.0);

	if ( (PawnOwner.Weapon == None) || (PawnOwner.Weapon.AmmoType == None) )
		return;

	Canvas.DrawColor = WhiteColor;
	DrawBigNum(Canvas, PawnOwner.Weapon.AmmoType.AmmoAmount, X + 26 * Scale, Y + 16 * Scale);
}

//This is the old version. Kept for reference until I get this shit worked completely out
/*
simulated function DrawStatus(Canvas Canvas)
{
	local float StatScale, ChestAmount, ThighAmount, H1, H2, X, Y, DamageTime;
	Local int ArmorAmount,CurAbs,i;
	Local inventory Inv,BestArmor;
	local bool bChestArmor, bShieldbelt, bThighArmor, bJumpBoots, bHasDoll, bTrans, bScuba, bFlare, bSeeds, bInvisibility, bAmp, bFlashy, bForceF, bTnt, bRebel;
	local Bot BotOwner;
	local TournamentPlayer TPOwner;
	local texture Doll, DollBelt;

	ArmorAmount = 0;
	CurAbs = 0;
	i = 0;
	BestArmor=None;
	for( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
	{ 
		if (Inv.bIsAnArmor)
		{
			if ( Inv.IsA('Shieldbelt') )
				bShieldbelt = true;
			else if ( Inv.IsA('Thighpads') )
			{
				ThighAmount += Inv.Charge;
				bThighArmor = true;
			}
			else
			{ 
				bChestArmor = true;
				ChestAmount += Inv.Charge;
			}
			ArmorAmount += Inv.Charge;
		}
		else if ( Inv.IsA('JumpBoots') )
			bJumpBoots = true;
		else if ( Inv.IsA('ScubaGear') )
		{
			bScuba = true;
		}
		else if ( Inv.IsA('Flare') )
		{
			bFlare = true;
		}
		else if ( Inv.IsA('PlasmaFlare') )
		{
			bFlare = true;
		}
		else if ( Inv.IsA('Seeds') )
		{
			bSeeds = true;
		}
		else if ( Inv.IsA('Invisibility') )
		{
			bInvisibility = true;
		}
		else if ( Inv.IsA('Amplifier') )
		{
			bAmp = true;
		}
		else if ( Inv.IsA('Translator') )
		{
			bTrans = true;
		}
		else if ( Inv.IsA('ForceField') )
		{
			bForceF = true;
		}
		else if ( Inv.IsA('FlashLight') )
		{
			bFlashy = true;
		}
		else if ( Inv.IsA('tnt') )
		{
			bTnt = true;
		}
		else if ( Inv.IsA('Rebel') )
		{
			bRebel = true;
		}
		else
		{
			i++;
			if ( i > 100 )
				break; // can occasionally get temporary loops in netplay
		}
	}

	if ( !bHideStatus )
	{	
		TPOwner = TournamentPlayer(PawnOwner);
		if ( Canvas.ClipX < 400 )
			bHasDoll = false;
		else if ( TPOwner != None)
		{
			Doll = TPOwner.StatusDoll;
			DollBelt = TPOwner.StatusBelt;
			bHasDoll = true;
		}
		else
		{
			BotOwner = Bot(PawnOwner);
			if ( BotOwner != None )
			{
				Doll = BotOwner.StatusDoll;
				DollBelt = BotOwner.StatusBelt;
				bHasDoll = true;
			}
		}
		if ( bHasDoll )
		{ 							
			Canvas.Style = ERenderStyle.STY_Translucent;
			StatScale = Scale * StatusScale;
			X = Canvas.ClipX - 128 * StatScale;
			Canvas.SetPos(X, 0);
			if (PawnOwner.DamageScaling > 2.0)
				Canvas.DrawColor = PurpleColor;
			else
				Canvas.DrawColor = HUDColor;
			Canvas.DrawTile(Doll, 128*StatScale, 256*StatScale, 0, 0, 128.0, 256.0);
			Canvas.DrawColor = HUDColor;
			if ( bShieldBelt )
			{
				Canvas.DrawColor = BaseColor;
				Canvas.DrawColor.B = 0;
				Canvas.SetPos(X, 0);
				Canvas.DrawIcon(DollBelt, StatScale);
			}
			if ( bChestArmor )
			{
				ChestAmount = FMin(0.01 * ChestAmount,1);
				Canvas.DrawColor = HUDColor * ChestAmount;
				Canvas.SetPos(X, 0);
				Canvas.DrawTile(Doll, 128*StatScale, 64*StatScale, 128, 0, 128, 64);
			}
			if ( bThighArmor )
			{
				ThighAmount = FMin(0.02 * ThighAmount,1);
				Canvas.DrawColor = HUDColor * ThighAmount;
				Canvas.SetPos(X, 64*StatScale);
				Canvas.DrawTile(Doll, 128*StatScale, 64*StatScale, 128, 64, 128, 64);
			}
			if ( bJumpBoots )
			{
				Canvas.DrawColor = HUDColor;
				Canvas.SetPos(X, 128*StatScale);
				Canvas.DrawTile(Doll, 128*StatScale, 64*StatScale, 128, 128, 128, 64);
			}
			if ( bScuba )
			{
				Canvas.DrawColor = HUDColor;
				Canvas.SetPos(X+64*StatScale, 200*StatScale);
				Canvas.DrawTile(Texture'I_Scuba', 64*StatScale, 64*StatScale, 128, 128, 32, 32);
			}
			if ( bTrans )
			{
				Canvas.DrawColor = HUDColor;
				Canvas.SetPos(X+64*StatScale, 264*StatScale);
				Canvas.DrawTile(Texture'I_Tran', 64*StatScale, 64*StatScale, 128, 128, 32, 32);
			}
			if ( bFlare )
			{
				Canvas.DrawColor = HUDColor;
				Canvas.SetPos(X+64*StatScale, 328*StatScale);
				Canvas.DrawTile(Texture'I_Flare', 64*StatScale, 64*StatScale, 128, 128, 32, 32);
			}
			if ( bAmp )
			{
				Canvas.DrawColor = HUDColor;
				Canvas.SetPos(X+64*StatScale, 392*StatScale);
				Canvas.DrawTile(Texture'I_Amp', 64*StatScale, 64*StatScale, 128, 128, 32, 32);
			}
			if ( bFlashy )
			{
				Canvas.DrawColor = HUDColor;
				Canvas.SetPos(X+64*StatScale, 456*StatScale);
				Canvas.DrawTile(Texture'I_BigFlash', 64*StatScale, 64*StatScale, 128, 128, 32, 32);
			}
			if ( bSeeds )
			{
				Canvas.DrawColor = HUDColor;
				Canvas.SetPos(X+64*StatScale, 520*StatScale);
				Canvas.DrawTile(Texture'I_Seed', 64*StatScale, 64*StatScale, 128, 128, 32, 32);
			}
			if ( bInvisibility )
			{
				Canvas.DrawColor = HUDColor;
				Canvas.SetPos(X+64*StatScale, 584*StatScale);
				Canvas.DrawTile(Texture'I_Invisibility', 64*StatScale, 64*StatScale, 128, 128, 32, 32);
			}
			if ( bForceF )
			{
				Canvas.DrawColor = HUDColor;
				Canvas.SetPos(X+64*StatScale, 648*StatScale);
				Canvas.DrawTile(Texture'I_ForceField', 64*StatScale, 64*StatScale, 128, 128, 32, 32);
			}
			if ( bTnt )
			{
				Canvas.DrawColor = HUDColor;
				Canvas.SetPos(X+64*StatScale, 712*StatScale);
				Canvas.DrawTile(Texture'I_Flarexxxx', 64*StatScale, 64*StatScale, 128, 128, 32, 32);
			}

			if ( bRebel )
			{
				Canvas.DrawColor = HUDColor;
				Canvas.SetPos(X+64*StatScale, 776*StatScale);
				Canvas.DrawTile(Texture'reb', 64*StatScale, 64*StatScale, 128, 128, 32, 32);
			}

			Canvas.Style = Style;
			if ( (PawnOwner == PlayerOwner) && Level.bHighDetailMode && !Level.bDropDetail )
			{
				for ( i=0; i<4; i++ )
				{
					DamageTime = Level.TimeSeconds - HitTime[i];
					if ( DamageTime < 1 )
					{
						Canvas.SetPos(X + HitPos[i].X * StatScale, HitPos[i].Y * StatScale);
						if ( (HUDColor.G > 100) || (HUDColor.B > 100) )
							Canvas.DrawColor = RedColor;
						else
							Canvas.DrawColor = (WhiteColor - HudColor) * FMin(1, 2 * DamageTime);
						Canvas.DrawColor.R = 255 * FMin(1, 2 * DamageTime);
						Canvas.DrawTile(Texture'HudElements1c', StatScale * HitDamage[i] * 25, StatScale * HitDamage[i] * 64, 0, 64, 25.0, 64.0);
					}
				}
			}
		}
	}
	Canvas.DrawColor = HUDColor;
	if ( bHideStatus && bHideAllWeapons )
	{
		X = 0.5 * Canvas.ClipX;
		Y = Canvas.ClipY - 64 * Scale;
	}
	else
	{
		X = Canvas.ClipX - 128 * StatScale - 140 * Scale;
		Y = 64 * Scale;
	}
	Canvas.SetPos(X,Y);
	if ( PawnOwner.Health < 50 )
	{
		H1 = 1.5 * TutIconBlink;
		H2 = 1 - H1;
		Canvas.DrawColor = WhiteColor * H2 + (HUDColor - WhiteColor) * H1;
	}
	else
		Canvas.DrawColor = HUDColor;
	Canvas.DrawTile(Texture'HudElements1c', 128*Scale, 64*Scale, 128, 128, 128.0, 64.0);

	if ( PawnOwner.Health < 50 )
	{
		H1 = 1.5 * TutIconBlink;
		H2 = 1 - H1;
		Canvas.DrawColor = Canvas.DrawColor * H2 + (WhiteColor - Canvas.DrawColor) * H1;
	}
	else
		Canvas.DrawColor = WhiteColor;

	DrawBigNum(Canvas, Max(0, PawnOwner.Health), X + 26 * Scale, Y + 16 * Scale, 1);

	Canvas.DrawColor = HUDColor;
	if ( bHideStatus && bHideAllWeapons )
	{
		X = 0.5 * Canvas.ClipX - 128 * Scale;
		Y = Canvas.ClipY - 64 * Scale;
	}
	else
	{
		X = Canvas.ClipX - 128 * StatScale - 140 * Scale;
		Y = 0;
	}
	Canvas.SetPos(X, Y);
	Canvas.DrawTile(Texture'HudElements1c', 128*Scale, 64*Scale, 0, 192, 128.0, 64.0);
	if ( bHideStatus && bShieldBelt )
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = WhiteColor;
	DrawBigNum(Canvas, Max(0,ArmorAmount), X + 26 * Scale, Y + 16 * Scale, 1);
}
*/

simulated function DrawStatus(Canvas Canvas)
{
	local float StatScale, ChestAmount, ThighAmount, H1, H2, X, Y, DamageTime;
	Local int ArmorAmount,CurAbs,i;
	Local inventory Inv,BestArmor;
	local bool bChestArmor, bShieldbelt, bThighArmor, bJumpBoots, bHasDoll, bTrans, bScuba, bFlare, bSeeds, bInvisibility, bAmp, bFlashy, bForceF, bTnt, bRebel;
	local Bot BotOwner;
	local TournamentPlayer TPOwner;
	local texture Doll, DollBelt;

	ArmorAmount = 0;
	CurAbs = 0;
	i = 0;
	BestArmor=None;
	for( Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory )
	{ 
		if (Inv.bIsAnArmor)
		{
			if ( Inv.IsA('Shieldbelt') )
				bShieldbelt = true;
			else if ( Inv.IsA('Thighpads') )
			{
				ThighAmount += Inv.Charge;
				bThighArmor = true;
			}
			else
			{ 
				bChestArmor = true;
				ChestAmount += Inv.Charge;
			}
			ArmorAmount += Inv.Charge;
		}
		else
		{
			i++;
			if ( i > 100 )
				break; // can occasionally get temporary loops in netplay
		}
	}

	if ( !bHideStatus )
	{	
		TPOwner = TournamentPlayer(PawnOwner);
		if ( Canvas.ClipX < 400 )
			bHasDoll = false;
		else if ( TPOwner != None)
		{
			Doll = TPOwner.StatusDoll;
			DollBelt = TPOwner.StatusBelt;
			bHasDoll = true;
		}
		else
		{
			BotOwner = Bot(PawnOwner);
			if ( BotOwner != None )
			{
				Doll = BotOwner.StatusDoll;
				DollBelt = BotOwner.StatusBelt;
				bHasDoll = true;
			}
		}
		if ( bHasDoll )
		{
			Canvas.Style = ERenderStyle.STY_Translucent;
			StatScale = Scale * StatusScale;
			X = Canvas.ClipX - 128 * StatScale;
			Canvas.SetPos(X, 0);
			if (PawnOwner.DamageScaling > 2.0)
				Canvas.DrawColor = PurpleColor;
			else
				Canvas.DrawColor = HUDColor;
			Canvas.DrawTile(Doll, 128*StatScale, 256*StatScale, 0, 0, 128.0, 256.0);
			Canvas.DrawColor = HUDColor;
			if ( bShieldBelt )
			{
				Canvas.DrawColor = BaseColor;
				Canvas.DrawColor.B = 0;
				Canvas.SetPos(X, 0);
				Canvas.DrawIcon(DollBelt, StatScale);
			}
			if ( bChestArmor )
			{
				ChestAmount = FMin(0.01 * ChestAmount,1);
				Canvas.DrawColor = HUDColor * ChestAmount;
				Canvas.SetPos(X, 0);
				Canvas.DrawTile(Doll, 128*StatScale, 64*StatScale, 128, 0, 128, 64);
			}
			if ( bThighArmor )
			{
				ThighAmount = FMin(0.02 * ThighAmount,1);
				Canvas.DrawColor = HUDColor * ThighAmount;
				Canvas.SetPos(X, 64*StatScale);
				Canvas.DrawTile(Doll, 128*StatScale, 64*StatScale, 128, 64, 128, 64);
			}

			Canvas.Style = Style;
			if ( (PawnOwner == PlayerOwner) && Level.bHighDetailMode && !Level.bDropDetail )
			{
				for ( i=0; i<4; i++ )
				{
					DamageTime = Level.TimeSeconds - HitTime[i];
					if ( DamageTime < 1 )
					{
						Canvas.SetPos(X + HitPos[i].X * StatScale, HitPos[i].Y * StatScale);
						if ( (HUDColor.G > 100) || (HUDColor.B > 100) )
							Canvas.DrawColor = RedColor;
						else
							Canvas.DrawColor = (WhiteColor - HudColor) * FMin(1, 2 * DamageTime);
						Canvas.DrawColor.R = 255 * FMin(1, 2 * DamageTime);
						Canvas.DrawTile(Texture'HudElements1c', StatScale * HitDamage[i] * 25, StatScale * HitDamage[i] * 64, 0, 64, 25.0, 64.0);
					}
				}
			}
		}
	}
	Canvas.DrawColor = HUDColor;
	if ( bHideStatus && bHideAllWeapons )
	{
		X = 0.5 * Canvas.ClipX;
		Y = Canvas.ClipY - 64 * Scale;
	}
	else
	{
		X = Canvas.ClipX - 128 * StatScale - 140 * Scale;
		Y = 64 * Scale;
	}
	Canvas.SetPos(X,Y);
	if ( PawnOwner.Health < 50 )
	{
		H1 = 1.5 * TutIconBlink;
		H2 = 1 - H1;
		Canvas.DrawColor = WhiteColor * H2 + (HUDColor - WhiteColor) * H1;
	}
	else
		Canvas.DrawColor = HUDColor;
	Canvas.DrawTile(Texture'HudElements1c', 128*Scale, 64*Scale, 128, 128, 128.0, 64.0);

	if ( PawnOwner.Health < 50 )
	{
		H1 = 1.5 * TutIconBlink;
		H2 = 1 - H1;
		Canvas.DrawColor = Canvas.DrawColor * H2 + (WhiteColor - Canvas.DrawColor) * H1;
	}
	else
		Canvas.DrawColor = WhiteColor;

	DrawBigNum(Canvas, Max(0, PawnOwner.Health), X + 26 * Scale, Y + 16 * Scale, 1);

	Canvas.DrawColor = HUDColor;
	if ( bHideStatus && bHideAllWeapons )
	{
		X = 0.5 * Canvas.ClipX - 128 * Scale;
		Y = Canvas.ClipY - 64 * Scale;
	}
	else
	{
		X = Canvas.ClipX - 128 * StatScale - 140 * Scale;
		Y = 0;
	}
	Canvas.SetPos(X, Y);
	Canvas.DrawTile(Texture'HudElements1c', 128*Scale, 64*Scale, 0, 192, 128.0, 64.0);
	if ( bHideStatus && bShieldBelt )
		Canvas.DrawColor = GoldColor;
	else
		Canvas.DrawColor = WhiteColor;
	DrawBigNum(Canvas, Max(0,ArmorAmount), X + 26 * Scale, Y + 16 * Scale, 1);
}

simulated function DrawFragCount(Canvas Canvas)
{
	local float Whiten;
	local int X,Y;

	if ( PawnOwner.PlayerReplicationInfo == None )
		return;

	Canvas.Style = Style;
	if ( bHideAllWeapons || (HudScale * WeaponScale * Canvas.ClipX <= Canvas.ClipX - 256 * Scale) )
		Y = Canvas.ClipY - 63.5 * Scale;
	else
		Y = Canvas.ClipY - 127.5 * Scale;
	if ( bHideAllWeapons )
		X = 0.5 * Canvas.ClipX - 256 * Scale;
	Canvas.CurX = X;
	Canvas.CurY = Y;
	Canvas.DrawColor = HUDColor; 
	Whiten = Level.TimeSeconds - ScoreTime;
	if ( Whiten < 3.0 )
	{
		if ( HudColor == GoldColor )
			Canvas.DrawColor = WhiteColor;
		else
			Canvas.DrawColor = GoldColor;
		if ( Level.bHighDetailMode )
		{
			Canvas.CurX = X - 64 * Scale;
			Canvas.CurY = Y - 32 * Scale;
			Canvas.Style = ERenderStyle.STY_Translucent;
			Canvas.DrawTile(Texture'chudweapons2', 256 * Scale, 128 * Scale, 0, 128, 256.0, 128.0);
		}
		Canvas.CurX = X;
		Canvas.CurY = Y;
		Whiten = 4 * Whiten - int(4 * Whiten);
		Canvas.DrawColor = Canvas.DrawColor + (HUDColor - Canvas.DrawColor) * Whiten;
	}

	Canvas.DrawTile(Texture'HudElements1c', 128*Scale, 64*Scale, 0, 128, 128.0, 64.0);
	Canvas.DrawColor = WhiteColor;
	
	if (int(PawnOwner.PlayerReplicationInfo.Score) >= 9999) 
        {
    	   Canvas.SetPos(X + 10 * Scale,Y + 16 * Scale);
    	   Canvas.Font=MyFonts.GetHugeFont(Canvas.ClipX);
    	   Canvas.DrawText(int(PawnOwner.PlayerReplicationInfo.Score));
        }
        else DrawBigNum(Canvas, PawnOwner.PlayerReplicationInfo.Score, X + 32 * Scale, Y + 16 * Scale);
}

simulated function DrawGameSynopsis(Canvas Canvas)
{
   local float XL, YL, XOffset, YOffset;

   if ((PawnOwner.PlayerReplicationInfo == None) || PawnOwner.PlayerReplicationInfo.bIsSpectator)
      return;

   Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
   Canvas.DrawColor = WhiteColor;
   Canvas.StrLen(RankString, XL, YL);

   if (bHideAllWeapons)
      YOffset = Canvas.ClipY - YL*3;
   else if (HudScale * WeaponScale * Canvas.ClipX <= Canvas.ClipX - 256 * Scale)
      YOffset = Canvas.ClipY - 64*Scale - YL*3;
   else YOffset = Canvas.ClipY - 128*Scale - YL*3;

   DrawPlayerLists(Canvas);

   Canvas.SetPos(0, YOffset + YL + YL);
   //Canvas.SetPos(0, YOffset);
   //Canvas.Font=C.MedFont;
   Canvas.Font=MyFonts.GetBigFont(Canvas.ClipX);
   Canvas.DrawText(" Monsters: "$string(MonsterReplicationInfo(PlayerPawn(Owner).GameReplicationInfo).Monsters), False);
   Canvas.DrawColor = HUDColor;
   DrawRadar(Canvas);
}

simulated function DrawWeapons(Canvas Canvas)
{
   local Weapon W, WeaponSlot[11];
   local inventory Inv;
   local int i, j, BaseY, BaseX, Pending, WeapX, WeapY;
   local float AmmoScale, WeaponOffset, WeapScale, WeaponX, TexX, TexY;

   BaseX = 0.5 * (Canvas.ClipX - HudScale * WeaponScale * Canvas.ClipX);
   WeapScale = WeaponScale * Scale;
   Canvas.Style = Style;
   BaseY = Canvas.ClipY - 63.5 * WeapScale;
   WeaponOffset = 0.1 * HUDScale * WeaponScale * Canvas.ClipX;

   if (PawnOwner.Weapon != None)
   {
      W = PawnOwner.Weapon;
      if ((Opacity > 8) || !Level.bHighDetailMode )
         Canvas.Style = ERenderStyle.STY_Normal;
	
      WeaponX = BaseX + (W.InventoryGroup - 1) * WeaponOffset;
      Canvas.CurX = WeaponX;
      Canvas.CurY = BaseY;
      Canvas.DrawColor = SolidHUDColor;
      Canvas.DrawIcon(W.StatusIcon, WeapScale);
      Canvas.DrawColor = GoldColor;
      Canvas.CurX = WeaponX + 4 * WeapScale;
      Canvas.CurY = BaseY + 4 * WeapScale;
      Canvas.Style = Style;
      if (W.InventoryGroup == 10)
	 Canvas.DrawTile(Texture'HudElements1c', 0.75 * WeapScale * 25, 0.75 * WeapScale * 64, 0, 0, 25.0, 64.0);
      else
	 Canvas.DrawTile(Texture'HudElements1c', 0.75 * WeapScale * 25, 0.75 * WeapScale * 64, 25*W.InventoryGroup, 0, 25.0, 64.0);

      WeaponSlot[W.InventoryGroup] = W;
      Canvas.CurX = WeaponX;
      Canvas.CurY = BaseY;
      Canvas.DrawTile(Texture'chudweapons2', 128 * WeapScale, 64 * WeapScale, 128, 64, 128, 64);
   }
   if (Level.bHighDetailMode && (PawnOwner.PendingWeapon != None))
   {
      Pending = PawnOwner.PendingWeapon.InventoryGroup;
      Canvas.CurX = BaseX + (Pending - 1) * WeaponOffset - 64 * WeapScale;
      Canvas.CurY = Canvas.ClipY - 96 * WeapScale;
      Canvas.Style = ERenderStyle.STY_Translucent;
      Canvas.DrawColor = GoldColor;
      Canvas.DrawTile(Texture'chudweapons2', 256 * WeapScale, 128 * WeapScale, 0, 128, 256.0, 128.0);
   }
   else Pending = 100;

   Canvas.Style = Style;
   i = 0;
   for (Inv=PawnOwner.Inventory; Inv!=None; Inv=Inv.Inventory)
   {
      if (Inv.IsA('Weapon') && (Inv != PawnOwner.Weapon))
      {
	 W = Weapon(Inv);
	 if (WeaponSlot[W.InventoryGroup] == None)
	    WeaponSlot[W.InventoryGroup] = W;
         else if ((WeaponSlot[W.InventoryGroup] != PawnOwner.Weapon) && ((W == PawnOwner.PendingWeapon)
         || (WeaponSlot[W.InventoryGroup].AutoSwitchPriority < W.AutoSwitchPriority)))
	    WeaponSlot[W.InventoryGroup] = W;
      }
      i++;
      if (i > 100)
         break; // can occasionally get temporary loops in netplay
   }
   W = PawnOwner.Weapon;

   // draw weapon list
   TexX = 128 * WeapScale;
   TexY = 64 * WeapScale;
   for (i=1; i<11; i++)
   {
      if (WeaponSlot[i] == None)
      {
	 Canvas.Style = Style;
	 Canvas.DrawColor =  0.5 * HUDColor;
	 Canvas.CurX = BaseX + (i - 1) * WeaponOffset;
	 Canvas.CurY = BaseY;

	 WeapX = ((i-1)%4) * 64;
	 WeapY = ((i-1)/4) * 32;
	 Canvas.DrawTile(Texture'chudweapons2',TexX,TexY,WeapX,WeapY,64.0,32.0);
      }
      else if (WeaponSlot[i] != W)
      {
	 if (Pending == i)
         {
	    if ((Opacity > 8) || !Level.bHighDetailMode)
	       Canvas.Style = ERenderStyle.STY_Normal;
	    Canvas.DrawColor = SolidHUDColor;
         }
	 else
	 {
	    Canvas.Style = Style;
	    Canvas.DrawColor = 0.5 * HUDColor;
	 }
	 Canvas.CurX = BaseX + (i - 1) * WeaponOffset;
	 Canvas.CurY = BaseY;

	 if (WeaponSlot[i].bSpecialIcon)
            Canvas.DrawIcon(WeaponSlot[i].StatusIcon, WeapScale);
	 else
	 {
	    WeapX = ((i-1)%4) * 64;
	    WeapY = ((i-1)/4) * 32;
	    Canvas.DrawTile(Texture'chudweapons2',TexX,TexY,WeapX,WeapY,64.0,32.0);
	 }
      }
   }

   //draw weapon numbers and ammo
   TexX = 0.75 * WeapScale * 25;
   TexY = 0.75 * WeapScale * 64;
   for (i=1; i<11; i++)
   {
      if (WeaponSlot[i] != None)
      {
	 WeaponX = BaseX + (i - 1) * WeaponOffset + 4 * WeapScale;
	 if (WeaponSlot[i] != W)
         {
	    Canvas.CurX = WeaponX;
	    Canvas.CurY = BaseY + 4 * WeapScale;
	    Canvas.DrawColor = GoldColor;
	    if ((Opacity > 8) || !Level.bHighDetailMode)
               Canvas.Style = ERenderStyle.STY_Normal;
	    else Canvas.Style = Style;
	    if (i == 10)
               Canvas.DrawTile(Texture'HudElements1c', TexX, TexY, 0, 0, 25.0, 64.0);
	    else
	       Canvas.DrawTile(Texture'HudElements1c', TexX, TexY, 25*i, 0, 25.0, 64.0);
	 }
	 if (WeaponSlot[i].AmmoType != None)
         {
            // Draw Ammo bar
	    Canvas.CurX = WeaponX;
	    Canvas.CurY = BaseY + 52 * WeapScale;
	    Canvas.DrawColor = BaseColor;
	    AmmoScale = FClamp(88.0 * WeapScale * WeaponSlot[i].AmmoType.AmmoAmount/WeaponSlot[i].AmmoType.MaxAmmo, 0, 88);
	    Canvas.DrawTile(Texture'HudElements1c', AmmoScale, 8 * WeapScale,64,64,128.0,8.0);
         }
      }
   }
}

simulated function bool DrawPlayerHealth(canvas C)
{
   local PlayerPawn thisPawn;
   local vector X, Y, Z, CamLoc, TargetDir, Dir, XY;
   local rotator CamRot;
   local Actor Camera;
   local float BaseBeaconScale, BeaconScale, Dist, DistScale;
   local float TanFOVx, TanFOVy;
   local float TanX, TanY;
   local float dx, dy, FontY;
   local string BeaconText;

   C.Style = ERenderStyle.STY_Masked;

   if (C.ClipX > 1024)
      C.Font = Font'BeaconNameFontLarge';
   else if (C.ClipX > 640)
      C.Font = Font'BeaconNameFontMedium';
   else
      C.Font = Font'BeaconNameFontSmall';

   C.SetPos(0, 0);
   C.TextSize("X", dx, FontY);
   BaseBeaconScale = 1.5 * FontY / Texture'TeamBeacon2'.VSize;
   C.ViewPort.Actor.PlayerCalcView(Camera, CamLoc, CamRot);

   TanFOVx = Tan(C.ViewPort.Actor.FOVAngle / 114.591559); // 360/Pi = 114.5915590...
   TanFOVy = (C.ClipY / C.ClipX) * TanFOVx;
   GetAxes(CamRot, X, Y, Z);

   C.bNoSmooth = False;
   C.Style = ERenderStyle.STY_Masked;
   foreach AllActors(class'PlayerPawn', thisPawn)
   {
      if (thisPawn != none && thisPawn != Camera && thisPawn.Health > 0 && !thisPawn.bHidden)
      {
         TargetDir = thisPawn.Location - CamLoc;
         Dist = VSize(TargetDir) * FMin(TanFOVx, 1.0);
         TargetDir = Normal(TargetDir + vect(0,0,1) * thisPawn.CollisionHeight);
	 		DistScale = FMin(100.0 * thisPawn.CollisionRadius / Dist, 1.0);

	 		if (DistScale > 0.5 && TargetDir dot X > 0 && (FastTrace(thisPawn.Location, CamLoc)
         || FastTrace(thisPawn.Location + vect(0,0,0.8) * thisPawn.CollisionHeight, CamLoc)))
         {
	    		BeaconScale = BaseBeaconScale * DistScale;
	    		Dir = X * (X dot TargetDir);
            XY = TargetDir - Dir;

	    		dx = C.ClipX * 0.5 * (1.0 + (XY dot Y) / (VSize(Dir) * TanFOVx));
	    		dy = C.ClipY * 0.5 * (1.0 - (XY dot Z) / (VSize(Dir) * TanFOVy));
	    		C.DrawColor = BlueColor;
	    		C.SetPos(dx - 0.5 * BeaconScale * TeamBeaconIcon.USize, dy - 2 * FontY * DistScale);

	    		// only draw name if close enough
	    		if (DistScale == 1.0)
            {
	       		if (C.ClipX > 600)
	          	BeaconText = "" $ thisPawn.Health $ "";

	    			// shadow
	    			C.SetPos(dx + 0.6 * BeaconScale * TeamBeaconIcon.USize + 1, dy - 1.75 * FontY + 1);
	    			C.DrawColor = BeaconColor * 0.125;
	    			C.DrawTextClipped(BeaconText, False);

	    			// color
	    			C.SetPos(dx + 0.6 * BeaconScale * TeamBeaconIcon.USize, dy - 1.75 * FontY);
	    			C.DrawColor = BeaconColor;
	    			C.DrawTextClipped(BeaconText, False);
            }
         }
      }
   }
}

simulated function DrawPlayerLists (Canvas C)
{
   local float XL, YL, YOffSetP, YOffSetS;
	local PlayerReplicationInfo PRI;
	local int PlayerCount, i;
   local string playerString;
   local PlayerPawn P;
   local float Scale;

   if (PlayerOwner.PlayerReplicationInfo == none || C == none) return;
   
   //Added Scuba mask here. Why? Because it's my fucking mod :)
   P = PlayerPawn(Owner);
   if ( Owner.IsA('PlayerPawn') && PlayerPawn(Owner).HeadRegion.Zone.bWaterZone)
   {
   	if (P != None)
   	{
      	Scale = C.ClipX/512;
      	C.SetPos(0.5 * C.ClipX - 256 * Scale, 0.5 * C.ClipY - 256 * Scale );
      	C.Style = ERenderStyle.STY_Modulated;
      	C.DrawIcon(Texture'RaReticle', Scale);
      }
   }

	C.Font=C.SmallFont;
//	C.Font=C.MedFont;
	C.DrawColor=HUDColor;

	C.StrLen("[Player(LOCATION)] ", XL, YL);
	C.SetPos(C.ClipX - XL, C.ClipY / 4);
	C.DrawText("[Player(LOCATION)]",False);

	C.StrLen("[Spectators] ",XL,YL);
	C.SetPos(C.ClipX - XL,C.ClipY / 1.5);
	C.DrawText("[Spectators] ",False);

	// Wipe everything.
	for ( i=0; i<ArrayCount(Ordered); i++ )
		Ordered[i] = None;
	for ( i=0; i<32; i++ )
	{
		if (PlayerPawn(Owner).GameReplicationInfo.PRIArray[i] != None)
		{
			PRI = PlayerPawn(Owner).GameReplicationInfo.PRIArray[i];
			if ( !PRI.bWaitingPlayer )
			{
				Ordered[PlayerCount] = PRI;
				PlayerCount++;
				if ( PlayerCount == ArrayCount(Ordered) )
					break;
			}
		}
	}

	SortScores(PlayerCount);
   YOffSetP = C.ClipY/4 + YL;
   YOffSetS = C.ClipY/1.5 + YL;

   for (i = 0; i < playerCount; ++i)
   {
      if (Ordered[i].PlayerName ~= "player")
      {
      }
      else
      {
         playerString = Ordered[i].PlayerName;
         if (!Ordered[i].bIsSpectator)
         {
            if (Ordered[i].PlayerLocation != none && Ordered[i].PlayerLocation.LocationName != "")
               playerString = playerString@"("$Ordered[i].PlayerLocation.LocationName$")";
            else if (Ordered[i].PlayerZone != none && Ordered[i].PlayerZone.ZoneName != "")
               playerString = playerString@"("$Ordered[i].PlayerZone.ZoneName$")";
         }

         if (len(playerstring) > 30)
            playerString = left(playerString, 30)$")"; // truncate if longer than 30 chars

         C.StrLen (playerString$" ", XL, YL);
         if (Ordered[i].bIsSpectator) 
			{
            C.SetPos(C.ClipX - XL, YOffSetS);
            YOffSetS += YL;
         }
         else 
			{
            C.SetPos(C.ClipX - XL, YOffSetP);
            YOffSetP += YL;
         }

         if (!Ordered[i].bIsSpectator && PlayerOwner.PlayerReplicationInfo.PlayerName == Ordered[i].PlayerName)
            C.DrawColor=GoldColor;
         else
            C.DrawColor=WhiteColor;

         C.DrawText (playerString, False);
      }
   }
}

function SortScores(int N)
{
	local int I, J, Max;
	local PlayerReplicationInfo TempPRI;

	for ( I=0; I<N-1; I++ )
	{
		Max = I;
		for ( J=I+1; J<N; J++ )
		{
			if ( Ordered[J].Score > Ordered[Max].Score )
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths < Ordered[Max].Deaths))
				Max = J;
			else if ((Ordered[J].Score == Ordered[Max].Score) && (Ordered[J].Deaths == Ordered[Max].Deaths) &&
					 (Ordered[J].PlayerID < Ordered[Max].Score))
				Max = J;
		}

		TempPRI = Ordered[Max];
		Ordered[Max] = Ordered[I];
		Ordered[I] = TempPRI;
	}
}

simulated function DrawMonsterName(Canvas C)
{
	local ScriptedPawn thisPawn;
	local vector X, Y, Z, CamLoc, TargetDir, Dir, XY;
	local rotator CamRot;
	local Actor Camera;
	local float BaseBeaconScale, BeaconScale, Dist, DistScale;
	local float TanFOVx, TanFOVy;
	local float TanX, TanY;
	local float dx, dy, FontY;
	local string BeaconText;

	C.Style = ERenderStyle.STY_Masked;

	if (C.ClipX > 1024)
		C.Font = Font'BeaconNameFontLarge';
	else if (C.ClipX > 640)
		C.Font = Font'BeaconNameFontMedium';
	else
		C.Font = Font'BeaconNameFontSmall';
	
	C.SetPos(0, 0);
	C.TextSize("X", dx, FontY);
	BaseBeaconScale = 1.5 * FontY / Texture'TeamBeacon2'.VSize;
	
   C.ViewPort.Actor.PlayerCalcView(Camera, CamLoc, CamRot);

	TanFOVx = Tan(C.ViewPort.Actor.FOVAngle / 114.591559); // 360/Pi = 114.5915590...
	TanFOVy = (C.ClipY / C.ClipX) * TanFOVx;
	GetAxes(CamRot, X, Y, Z);
	
	C.bNoSmooth = False;
	C.Style = ERenderStyle.STY_Masked;
	foreach AllActors(class'ScriptedPawn', thisPawn)
   {
		if ( thisPawn != none && thisPawn != Camera && thisPawn.Health > 0 && !thisPawn.bHidden && thisPawn.Team < 4)
		{
         TargetDir = thisPawn.Location - CamLoc;
			Dist = VSize(TargetDir) * FMin(TanFOVx, 1.0);
			TargetDir = Normal(TargetDir + vect(0,0,1) * thisPawn.CollisionHeight);
			DistScale = FMin(100.0 * thisPawn.CollisionRadius / Dist, 1.0);

			if (DistScale > 0.5 && TargetDir dot X > 0 && (FastTrace(thisPawn.Location, CamLoc) 
			|| FastTrace(thisPawn.Location + vect(0,0,0.8) * thisPawn.CollisionHeight, CamLoc)))
         {
				BeaconScale = BaseBeaconScale * DistScale;
				Dir = X * (X dot TargetDir);
				XY = TargetDir - Dir;
				
				dx = C.ClipX * 0.5 * (1.0 + (XY dot Y) / (VSize(Dir) * TanFOVx));
				dy = C.ClipY * 0.5 * (1.0 - (XY dot Z) / (VSize(Dir) * TanFOVy));
				
				//C.DrawColor = BeaconColor;
				C.DrawColor = GreenColor;
				C.SetPos(dx - 0.5 * BeaconScale * TeamBeaconIcon.USize, dy - 2 * FontY * DistScale);

				// only draw name if close enough
				if (DistScale == 1.0)
            {
					//BeaconText = thisPawn.PlayerReplicationInfo.PlayerName;
					if (C.ClipX > 600)
						//BeaconText = BeaconText @ "(" $ thisPawn.Health $ ")";
						BeaconText = "" $ thisPawn.Health $ "";

					// shadow
					C.SetPos(dx + 0.6 * BeaconScale * TeamBeaconIcon.USize + 1, dy - 1.75 * FontY + 1);
					C.DrawColor = BeaconColor * 0.125;
					C.DrawTextClipped(BeaconText, False);

					// color
					C.SetPos(dx + 0.6 * BeaconScale * TeamBeaconIcon.USize, dy - 1.75 * FontY);
					C.DrawColor = BeaconColor;
					C.DrawTextClipped(BeaconText, False);
				}
			}
		}
	}
}

//Radar Code
simulated function drawRadar(canvas Canvas)
{
   local ScriptedPawn Monster;
   local PlayerPawn PP;
   local int index, radius;
   local int originX, originY;
   local Pawn P;

   if(!Owner.IsA('PlayerPawn'))
   {
      Log("Owner: ("$Owner$") does not want me loaded", Class.Name);
      return;
   }

   Canvas.Reset();
   radius = Canvas.sizeY/13;

   switch(Position)
   {
    case RADAR_TopLeft:
        originX = 30;
        originY = 30;
        break;
    case RADAR_TopMiddle:
        originX = Canvas.SizeX/2 - radius;
        originY = 30;
        break;
    case RADAR_TopRight:
        originX = Canvas.SizeX - radius*2 - 30;
        originY = 30;
        break;
    case RADAR_MiddleLeft:
        originX = 10;
//        originY = Canvas.SizeY/2 - radius;
        originY = Canvas.SizeY/1.75 - radius;
        break;
    case RADAR_MiddleRight:
//        originX = Canvas.SizeX - radius - 80;
        originX = Canvas.SizeX - radius - 100;
//        originY = Canvas.SizeY/2 - radius;
        originY = Canvas.SizeY/1.7 - radius;
        break;
    case RADAR_BottomLeft:
        originX = 30;
        originY = Canvas.SizeY - radius*2 - 30;
        break;
    case RADAR_BottomMiddle:
        originX = Canvas.SizeX/2 - radius;
        originY = Canvas.SizeY - radius*2 - 30;
        break;
    case RADAR_BottomRight:
        originX = Canvas.SizeX - radius*2 - 30;
        originY = Canvas.SizeY - radius*2 - 30;
        break;
   }
   Canvas.Style = ERenderStyle.STY_Translucent;
   Canvas.SetPos(originX, originY);
   Canvas.DrawColor=HUDColor;
   Canvas.DrawTile(tex, radius*2, radius*2, 0, 0, 128, 128);

   foreach AllActors(class'ScriptedPawn', Monster)
   {
      if(Monster.Health <= 0) continue;
      drawBlip(Monster, Canvas, originX, originY, radius);
   }
   foreach AllActors(class'PlayerPawn', PP)
   {
      if(PP.Health <= 0) continue;
      if (PP != PawnOwner)   // Null your own blip
        	drawPlayerBlip(PP, Canvas, originX, originY, radius);
   }
}

simulated function drawBlip(Pawn other, canvas Canvas, int originX, int originY, int radius)
{
   local rotator myRotation, monsterRotation, blipRotation;
   local int x, y, monsterDistance;
   local Vector point, myLocation, monsterLocation;
   local Weapon weapon;
   local PlayerPawn pOwner;

   if(other.Health <= 0)
   {
      Canvas.DrawColor.R = 255;
      Canvas.DrawColor.G = 0;
      Canvas.DrawColor.B = 0;
   }
   else
   {
      Canvas.DrawColor.R = 255;
      Canvas.DrawColor.G = 255;
      Canvas.DrawColor.B = 255;
   }

   pOwner = PlayerPawn(Owner);
   weapon = pOwner.Weapon;
   if(Weapon != none && Weapon.IsA('WarheadLauncher') &&
      WarheadLauncher(Weapon).bGuiding && WarheadLauncher(Weapon).GuidedShell != none)
   {
      myLocation = WarheadLauncher(Weapon).GuidedShell.Location;
   }
   else
   {
      myLocation = Owner.Location;
   }
   myLocation.z = 0;

   myRotation = pOwner.ViewRotation;
   myRotation.Yaw  += 16384;
   myRotation.Pitch = 0;
   myRotation.Roll  = 0;

   monsterLocation   = other.Location;
   monsterLocation.z = 0;
   point = myLocation - monsterLocation;
   monsterDistance = VSize(point);
   monsterRotation = rotator(point);
   monsterRotation.Pitch = 0;
   monsterRotation.Roll  = 0;

   blipRotation = myRotation - monsterRotation;
   point = monsterDistance * vector(blipRotation);
   if(VSize(point) < radius*50)
   {
      point.x = -point.x / 50 + radius + originX;
      point.y = point.y / 50 + radius + originY;
      Canvas.SetPos(point.x, point.y);
      Canvas.DrawTile(Texture'monsterpoint', 3, 3, 0, 0, 2, 2);
   }
}

simulated function drawPlayerBlip(Pawn other, canvas Canvas, int originX, int originY, int radius)
{
   local rotator myRotation, playerRotation, blipRotation;
   local int x, y, playerDistance;
   local Vector point, myLocation, playerLocation;
   local Weapon weapon;
   local PlayerPawn pOwner;

   Canvas.DrawColor.R = 255;
   Canvas.DrawColor.G = 1;
   Canvas.DrawColor.B = 1;

   pOwner = PlayerPawn(Owner);

   weapon = pOwner.Weapon;
   if(Weapon != none && Weapon.IsA('WarheadLauncher') &&
      WarheadLauncher(Weapon).bGuiding && WarheadLauncher(Weapon).GuidedShell != none)
   {
      myLocation = WarheadLauncher(Weapon).GuidedShell.Location;
   } 
	else
   {
      myLocation = Owner.Location;
   }
   myLocation.z = 0;

   myRotation = pOwner.ViewRotation;
   myRotation.Yaw  += 16384;
   myRotation.Pitch = 0;
   myRotation.Roll  = 0;

   playerLocation   = other.Location;
   playerLocation.z = 0;
   point = myLocation - playerLocation;
   playerDistance = VSize(point);
   playerRotation = rotator(point);
   playerRotation.Pitch = 0;
   playerRotation.Roll  = 0;

   blipRotation = myRotation - playerRotation;

   point = playerDistance * vector(blipRotation);

   if(VSize(point) < radius*50)
   {
      point.x = -point.x / 50 + radius + originX;
      point.y = point.y / 50 + radius + originY;
      Canvas.SetPos(point.x, point.y);
      Canvas.DrawTile(Texture'monsterpoint2', 3, 3, 0, 0, 2, 2);
   }
}

function setZscale(int value)
{
   if(value < 1) value = 1;
   scale = value;
}

defaultproperties
{
   BeaconColor=(R=0,G=150,B=0,A=0),
   TeamBeaconIcon=Texture'TeamBeacon2'
   GreenColor=(R=0,G=255,B=0,A=0),
   BlueColor=(R=0,G=0,B=255,A=0),
   Tex=Texture'GoCoopDev9.radarconsole'
   Position=RADAR_MiddleRight
   Zscale=50
   ServerInfoClass=class'GoCoopServerInfo'
}
