
class FixedNaliRabbit extends NaliRabbit;

State Evade
{
    ignores SeePlayer;
    
    function EnemyNotVisible()
    {
        GotoState('Grazing');
    }
    
    function Bump(actor Other)
    {
        if ( (Normal(Destination - Location) Dot Normal(Other.Location - Location)) > 0.75 )
            MoveTimer = -1.0;
        if ( (Pawn(Other) != None) && (Pawn(Other).bIsPlayer || Other.IsA('ScriptedPawn')) )
            Enemy = Pawn(Other);

        Disable('Bump');
    }
    
    function bool TestDirection(vector dir, out vector pick)
    {   
        local vector HitLocation, HitNormal;
        local actor HitActor;

        HitActor = Trace(HitLocation, HitNormal, Location + dir * 150, Location, false);
        if ( (HitActor != None) && (HitNormal.Z < 0.7) )
        {
            pick = HitLocation - dir + (HitNormal Cross vect(0,0,1)) * 5 * CollisionRadius;
            HitActor = Trace(HitLocation, HitNormal, pick , Location, false);
            if (HitActor != None)
                return false;
        }
        else pick = Location + dir * (150 + FRand() * 450);

        return true; 
    }
    
    function PickDestination()
    {
        local vector pick, pickdir, enemyDir;
        local bool success;
        local float XY;
        
		  if(Enemy!=None)
        	enemyDir = Enemy.Location - Location;
        pickDir = VRand();
        pickDir.Z = 0;
        if ( (pickDir Dot enemyDir) > 0 )
            pickDir *= -1;  
        success = TestDirection(pickdir, pick);
        if (!success)
        {
            pickDir = VRand();
            pickDir.Z = 0;
            if ( (pickDir Dot enemyDir) > 0 )
                pickDir *= -1;  
            success = TestDirection( pickDir, pick);
        }       
        if (success)
            Destination = pick;
        else
        {
            Destination = Location;
            GotoState('Evade', 'Turn');
        }
    }
Begin:
Wander:
    WaitForLanding();
    PickDestination();
    TurnTo(Destination);
    Falling();
    SetPhysics(PHYS_Falling);
    Velocity = GroundSpeed * Normal(Destination - Location);
    Velocity.Z = 360;
    WaitForLanding();
    FinishAnim();
    LoopAnim('Jump', 1.5);
Moving:
    Enable('Bump');
    MoveTo(Destination);
    Acceleration = vect(0,0,0);
Graze:
    if ( FRand() < 0.3 )
    {
        PlaySound(sound'CallBN');
        PlayAnim('Call', 0.4 + 0.2 * FRand(), 0.2);
    }
    else
        PlayAnim('Looking', 0.2 + 0.3 * FRand(), 0.2);
    FinishAnim();
    Goto('Wander');
Turn:
    PlayTurning();
    TurnTo(Location + 20 * VRand());
    Goto('Graze');
}

defaultproperties
{
}

