// todo: check for all new configs

class GoCoopGame expands UnrealGameInfo Config(GoCoopDev9);

var() config float friendlyfirescale;
var bool bSpecialFallDamage;
var float LastTauntTime;
var int LastTaunt[4];
var config bool baddiespectate;

var int MonstersTotal;
var config bool bNoRebelDamage;
var GoCoop GoCoopMutator;

function PostBeginPlay()
{
   Local Mover M;
   local ScriptedPawn S;

   foreach AllActors(Class'Mover', M)
   {
      if (M.MoverEncroachType==ME_ReturnWhenEncroach)
         M.MoverEncroachType= ME_IgnoreWhenEncroach;
   }

   foreach AllActors(class'ScriptedPawn', S)
   {
      MonstersTotal ++;
   }

   MonsterReplicationInfo(GameReplicationInfo).Monsters = MonstersTotal;

   Super.PostBeginPlay();
   bClassicDeathMessages = True;
}

function Destroyed()
{
	Song = None;
	GoCoopMutator = None;
	Super.Destroyed();
}

function GoCoop GetGoCoopMutator()
{
	local Mutator M;

	//Get From Linked list
	for (M=BaseMutator; M!=None; M=M.NextMutator)
		if (M.Class == class'GoCoopDev9.GoCoop')
			return GoCoop(M);
	//if linked list screwed - should never happen
	Foreach AllActors (class'Mutator', M)
		if (M.Class == class'GoCoopDev9.GoCoop')
			return GoCoop(M);
}

// Optional handling of ServerTravel for network games.
function ProcessServerTravel( string URL, bool bItems )
{
	local playerpawn P, LocalPlayer;

	if (LocalLog != None)
	{
		LocalLog.LogGameEnd("mapchange");
		LocalLog.StopLog();
		LocalLog.Destroy();
		LocalLog = None;
	}

	if (WorldLog != None)
	{
		WorldLog.LogGameEnd("mapchange");
		WorldLog.StopLog();
		WorldLog.Destroy();
		WorldLog = None;
	}

	// Notify clients we're switching level and give them time to receive.
	// We call PreClientTravel directly on any local PlayerPawns (ie listen server)
	bLevelTravel = True;
	bItems = AllowInvTravel(URL, bItems);
	Level.bNextItems = bItems;
	foreach AllActors( class'PlayerPawn', P )
	{
		if( NetConnection(P.Player)!=None )
			P.ClientTravel( URL, TRAVEL_Relative, bItems );
		else
		{	
			LocalPlayer = P;
			P.PreClientTravel();
		}
	}

	if ((Level.NetMode == NM_ListenServer) && (LocalPlayer != None))
		Level.NextURL = Level.NextURL$"?Skin="$LocalPlayer.GetDefaultURL("Skin")
					 $"?Face="$LocalPlayer.GetDefaultURL("Face")
					 $"?Team="$LocalPlayer.GetDefaultURL("Team")
					 $"?Name="$LocalPlayer.GetDefaultURL("Name")
					 $"?Class="$LocalPlayer.GetDefaultURL("Class");

	// Switch immediately if not networking.
	if( Level.NetMode!=NM_DedicatedServer && Level.NetMode!=NM_ListenServer )
		Level.NextSwitchCountdown = 0.0;
}

function StartPlayer(PlayerPawn Other)
{
	if(!Other.Region.Zone.bWaterZone && ( Level.NetMode==NM_DedicatedServer || Level.NetMode==NM_ListenServer || !bRestartLevel ))
		Other.GotoState(Other.PlayerRestartState);
	else if (!Other.Region.Zone.bWaterZone)
		Other.ClientTravel( "?restart", TRAVEL_Relative, false );
}

//Don't allow mutators to replace/modify non-stock monsters
function bool AllowModifying(Pawn P)
{
	//Allow only stock ut Monsters/bots and other non-mappack specific pawns to be mutated/replaced
	if (Left(P.class, 8) ~= "UnrealI." || Left(P.class, 12) ~= "UnrealShare." || Left(P.class, 8) ~= "Botpack." || P.IsA('AKsp')
		|| P.IsA('Napalisp') || P.IsA('Spinsp') || Left(P.class, 8) ~= "AKcoop2." || Left(P.class, 9) ~= "jurassic.")// || Left(P.class,7) ~="RYSMNST")
		 	return True;

	return False;
}

function bool CanSpectate(pawn Viewer, actor ViewTarget )
{
   if ( ViewTarget.bIsPawn && (Pawn(ViewTarget).PlayerReplicationInfo != None) && Pawn(ViewTarget).PlayerReplicationInfo.bIsSpectator )
      return false;

   if (viewtarget.bIsPawn && !Pawn(Viewtarget).bisplayer )      //only spectate baddies if server allows this...
      return baddiespectate;

   if (Viewtarget.bispawn)
      return true;

   return false;
}

function bool IsRelevant(actor Other)
{
   // hide all playerpawns     (these are incoming ones...)
   if ( Other.IsA('PlayerPawn') && !Other.IsA('Spectator') )
   {
      Other.SetCollision(false,false,false);
      Other.bHidden = true;
   }

   if ( BaseMutator.AlwaysKeep(Other) )
		return true;
		
	//Send through mutator chain if not a custom monster
	if (Pawn(Other) == None || AllowModifying(Pawn(Other)))
	{
		if ( BaseMutator.IsRelevant(Other, bSuperRelevant) )
		{
			if ( bSuperRelevant == 1 ) // mutator wants to override any logic in here
				return true;
		}
		else return false;
	}
	else  //Hands off the custom monsters!
	{
		if (GoCoopMutator == None)
			GoCoopMutator = GetGoCoopMutator();
		if (GoCoopMutator != None)
		{
			if (GoCoopMutator.IsRelevant(Other, bSuperRelevant))
			{
				if ( bSuperRelevant == 1 ) // Coop wants to override any logic in here
					return true;
			}
			else return false;
		}
	}
	
	if
	((Difficulty==0 && !Other.bDifficulty0) ||	(Difficulty==1 && !Other.bDifficulty1)
	||	(Difficulty==2 && !Other.bDifficulty2) ||	(Difficulty==3 && !Other.bDifficulty3)
	||	(!Other.bSinglePlayer && (Level.NetMode==NM_Standalone))
	||	(!Other.bNet && ((Level.NetMode == NM_DedicatedServer) || (Level.NetMode == NM_ListenServer)))
	||	(!Other.bNetSpecial  && (Level.NetMode==NM_Client)))
		return False;

	if( bNoMonsters && (Pawn(Other) != None) && !Pawn(Other).bIsPlayer )
		return False;

	if( FRand() > Other.OddsOfAppearing )
		return False;

   return True;
   //return Super.IsRelevant(Other);
}

event PostLogin(playerpawn NewPlayer )
{
   //local PlayerPawn NewPlayer;
   local Pawn P;

   // Start player's music.
   If (Level.Song!=None)
      NewPlayer.ClientSetMusic( Level.Song, Level.SongSection, Level.CdTrack, MTRAN_Fade );
   else NewPlayer.ClientSetMusic( Music'olroot.null', 0, 0, MTRAN_Fade );

   
   if (NewPlayer.HUDType != HUDType)
		NewPlayer.HUDType = HUDType;
}

function string GetCurrentPortal(String Portal)
{
	local Teleporter T;

	foreach AllActors(class'Teleporter', T)
	{
		if (string(T.Tag) ~= Portal)
			return Portal;
	}
	return "";
}


function float PlaySpawnEffect(inventory Inv)
{
   Playsound(sound'RespawnSound');

   if ( !bCoopWeaponMode || !Inv.IsA('Weapon') )
   {
      spawn( class 'ReSpawn',,, Inv.Location );
      return 0.3;
   }
   return 0.0;
}

function PreCacheReferences()
{
   spawn(class'olweps.uautomag');
   spawn(class'olweps.udpistol');
   spawn(class'olweps.ueightball');
   spawn(class'olweps.uflakcannon');
   spawn(class'olweps.urazorjack');
   spawn(class'olweps.uasmd');
   spawn(class'olweps.ugesbiorifle');
   spawn(class'olweps.urifle');
   spawn(class'olweps.uminigun');
}

function PlayTeleportEffect( actor Incoming, bool bOut, bool bSound)
{
   local UTTeleportEffect PTE;

   if (Incoming.bIsPawn && (Incoming.Mesh != None))
   {
      if (bSound)
      {
         PTE = Spawn(class'UTTeleportEffect',,, Incoming.Location, Incoming.Rotation);
         PTE.Initialize(Pawn(Incoming), bOut);
         Incoming.PlaySound(sound'Resp2A',, 10.0);
      }
   }
}

event playerpawn Login(string Portal, string Options, out string Error, class<playerpawn> SpawnClass)
{
   local PlayerPawn NewPlayer;
   local string InVoice;
   local string InName, InPassword;
   local pawn aPawn;

   if (ClassIsChildOf(SpawnClass, class'Spectator'))
   {
      if (!ClassIsChildOf( SpawnClass, class'unrealSpectator'))    //force unreal spectator....
         SpawnClass = class'unrealSpectator';
   }
   else if (!ClassIsChildOf(SpawnClass, class'TournamentPlayer') || Left(string(spawnclass),6) ~= "u4etc." 
   || SpawnClass.default.Mesh==LodMesh'UnrealI.SkTrooper' || !SpawnClass.default.bSinglePlayer)
      //taken from tournamentgameinfo
      SpawnClass = DefaultPlayerClass;
      NewPlayer =  Super.Login(Portal, Options, Error, SpawnClass);
      if (NewPlayer != None)
      {
         if (!NewPlayer.IsA('Spectator'))
         {
            NewPlayer.bHidden = false;
            NewPlayer.SetCollision(true,true,true);
            InVoice = ParseOption ( Options, "Voice" );
            if (InVoice != "")
               NewPlayer.PlayerReplicationInfo.VoiceType = class<VoicePack>(DynamicLoadObject(InVoice, class'Class'));
            if (NewPlayer.PlayerReplicationInfo.VoiceType == None)
               NewPlayer.PlayerReplicationInfo.VoiceType = class<VoicePack>(DynamicLoadObject(NewPlayer.VoiceType, class'Class'));
            if (NewPlayer.PlayerReplicationInfo.VoiceType == None)
               NewPlayer.PlayerReplicationInfo.VoiceType = class<VoicePack>(DynamicLoadObject("Botpack.VoiceMaleOne", class'Class'));
      }
      else
      {
         //we have to swap the spectator's HUD
         newplayer.hudtype=class'oldskool.oldskoolspectatorhud';
         If (newplayer.myhud!=None) //if it is none then the hudtype swap will fix it anyway :D
            newplayer.myhud.destroy();
         newplayer.myhud=none; 
      }
      
      log("Logging in to "$Level.Title);
      if (Level.Title ~= "The Source Antechamber")  //level h4ck...
         bSpecialFallDamage = true;
   }
   return NewPlayer;
}

function NavigationPoint FindPlayerStart( Pawn Player, optional byte InTeam, optional string incomingName )
{
   local PlayerStart Dest, Candidate[8], Best;
   local float Score[8], BestScore, NextDist;
   local pawn OtherPlayer;
   local int i, num;
   local Teleporter Tel;

   num = 0;
   //choose candidates
   foreach AllActors(class 'PlayerStart', Dest)
   {
      if (Dest.bEnabled && Dest.bCoopStart)
      {
         if (num<4)
            Candidate[num] = Dest;
         else if (Rand(num) < 4)
            Candidate[Rand(4)] = Dest;
         num++;
      }
   }
   if (num == 0)
	{
		foreach AllActors( class 'PlayerStart', Dest )
		{
			if (Dest.bSinglePlayerStart || Dest.bCoopStart)
			{
				if (num<4)
					Candidate[num] = Dest;
				else if (Rand(num) < 4)
					Candidate[Rand(4)] = Dest;
				num++;
			}
		}
	}

   if (num>4) num = 4;
   else if (num == 0)
   return None;

   //assess candidates
   for (i=0;i<num;i++)
      Score[i] = 4000 * FRand(); //randomize

   foreach AllActors( class 'Pawn', OtherPlayer )
   {
      if (OtherPlayer.bIsPlayer)
      {
         for (i=0;i<num;i++)
         {
            NextDist = VSize(OtherPlayer.Location - Candidate[i].Location);
            Score[i] += NextDist;
            if (NextDist < OtherPlayer.CollisionRadius + OtherPlayer.CollisionHeight)
               Score[i] -= 1000000.0;
         }
      }
   }

   BestScore = Score[0];
   Best = Candidate[0];
   for (i=1;i<num;i++)
   {
      if (Score[i] > BestScore)
      {
         BestScore = Score[i];
         Best = Candidate[i];
      }
   }
   return Best;
}

function int ReduceDamage(int Damage, name DamageType, pawn injured, pawn instigatedBy)
{
   if(injured.Region.Zone.bNeutralZone)
      return 0;

	if (PlayerPawn(Injured) != None)
	{
		if (bLevelTravel)
			return 0;

		//No Damage when viewing scene  or interpolating
		if (GoViewSpot(PlayerPawn(Injured).ViewTarget) != None || Injured.bInterPolating)
			return 0;
	}

	if(Damage >= Injured.Health)
	{
		if(Injured.isA('SpaceMarine'))
		{
			if(Injured.bIsPlayer)
				Injured.bIsPlayer = False;

			Killed(InstigatedBy, Injured, DamageType);  //only Called for marinematch gametype
			Injured.Health = -1;
			if (Injured.GetPropertyText("bBeamingIn") ~= "True")
				return 1;
			return Damage;
		}
		else if (ScriptedPawn(Injured) != None && (InstigatedBy == None || PlayerPawn(InstigatedBy) == None))
		{
			S = String(Injured.class);
			//all AKsp and nalisp ScriptedPawns (they shouldn't test killer or PRI when calling level.game.killed
			//that way excluding environmental damage, while level.game.killed supports killer==None)
			if(Injured.IsA('MHuman') || Left(S, 7) ~= "AKcoop2" || Left(S, 9) ~= "napali103")
			{
				//Allow Vict and PRI to be destroyed instead of just hiding the vict like players
				if(Injured.bIsPlayer)
					Injured.bIsPlayer = False;
	
				//Call this one which was reserved for Players only in akcoop2, breaking deaths count
				Killed(InstigatedBy, Injured, DamageType);
				Injured.Health = -1;
				return Damage;
			}
		}
	}

   if (instigatedBy == None)
      return Damage;

	if (instigatedBy.bIsPlayer && injured.bIsPlayer && (instigatedBy != injured))
   	return Damage * friendlyfirescale;

   if (PlayerPawn(Injured) != None && (InstigatedBy.IsA('Follower') || InstigatedBy.IsA('MHuman')) && bNoRebelDamage
		 && InstigatedBy.AttitudeToPlayer != ATTITUDE_Hate && InstigatedBy.AttitudeToPlayer != ATTITUDE_Frenzy)
		return 0;
	
	if ((Injured.IsA('Follower') || Injured.IsA('MHuman')) && PlayerPawn(InstigatedBy) != None
		 && Injured.AttitudeToPlayer != ATTITUDE_Hate && Injured.AttitudeToPlayer != ATTITUDE_Frenzy)
	{
		PlayerPawn(InstigatedBy).ClientMessage(Injured.MenuName$": Don't shoot me!");
		return Damage/5;
	}
	
	if ( instigatedBy.bIsPlayer && injured.bIsPlayer && (instigatedBy != injured) )
		return Damage*friendlyfirescale;
	
   if ((DamageType == 'Fell') && bSpecialFallDamage)
      return Min(Damage, 5);

	return Damage;
}

function bool ShouldRespawn(Actor Other)
{
   if (Other.IsA('Weapon') && !Weapon(Other).bHeldItem && (Weapon(Other).ReSpawnTime != 0))
   {
      if (Inventory(Other).RespawnTime != 0.50)
			Inventory(Other).ReSpawnTime = 0.50;
      return true;
   }
   //Allow respawning important pickups that are required or need to be carried to an interact trigger
	//respawntime configured in CheckReplacement()
	else if (Other.IsA('SFKeyCard') || Other.IsA('SFHardDrive') || Other.IsA('SFEVSuit') || Other.IsA('SFFuse')
			 || Other.IsA('SFLogicChute') || Other.IsA('AsbestosSuit') || Other.IsA('ToxinSuit'))
		return True;

	else if (Other.IsA('Kdungeon') || Other.IsA('LeTeleporter'))
		return True;

	return false;
}

function SendPlayer(PlayerPawn aPlayer, string URL)
{
   // hack to skip end game in coop play
   if ( left(URL,7) ~= "endgame")
   {
      Level.ServerTravel( "Vortex2", false);
      return;
   }
   Level.ServerTravel( URL, true );
}

//Fixing No-Names
function string GetHumanReadableName(pawn Other)
{
	local string S, HumanReadableName;
	local int I;

	if (Other.PlayerReplicationInfo != None)
		return Other.PlayerReplicationInfo.PlayerName;

	else if (Other.IsA('KamikazePupae'))
		return "a kamikaze Pupae";

	else if (Other.IsA('cannoncl'))
		return "an automatic Cannon";

	HumanReadableName = Other.MenuName;
	if (HumanReadableName ~= "")
		HumanReadableName = GetItemName(String(Other.Class));

	S = Left(HumanReadableName, 1);
	if (S ~= "a" || S ~= "e" || S ~= "i" || S ~= "o" || S ~= "u")
		HumanReadableName = "an "$HumanReadableName;
	else HumanReadableName = "a "$HumanReadableName;

	S = Right(HumanReadableName, 1);
	While (S == "0" || S == "1" || S == "2" || S == "3" || S == "4" || S == "5" || S == "6" || S == "7" || S == "8" || S == "9")
	{
		HumanReadableName = Left(HumanReadableName,Len(HumanReadableName) - 1);
		S = Right(HumanReadableName, 1);
	}
	return HumanReadableName;
}

function ScoreKill(pawn Killer, pawn Other)
{
   local ScriptedPawn S;

   MonstersTotal = 0;

   foreach AllActors(class'ScriptedPawn', S)
   {
      if (S.Health >= 1)
         MonstersTotal ++;
   }

   MonsterReplicationInfo(GameReplicationInfo).Monsters = MonstersTotal;

   if (Other.isA('ScriptedPawn') && (Killer.isA('PlayerPawn') || Killer.isA('Bot')))
   {
      Killer.playerreplicationinfo.score += 1;
      BroadcastMessage(Killer.GetHumanName()@"killed"$Other.GetHumanName());
   }

   if (Other.isA('ScriptedPawn') && (Killer.isA('ScriptedPawn')))
      BroadcastMessage(Killer.GetHumanName()@"killed"$Other.GetHumanName());

   if (Other.isA('TournamentPlayer') && (Killer.isA('PlayerPawn') || Killer.isA('Bot')))
   {
      Killer.playerreplicationinfo.score -= 6;
      BroadcastMessage( Killer.PlayerReplicationInfo.PlayerName@" killed  " $ Other.GetHumanName() );
   }
  
   if (Other.isA('Cow') || (Other.isA('BabyCow')) && (Killer.isA('PlayerPawn') || Killer.isA('Bot')) )
   {
      //Killer.playerreplicationinfo.score -= 11; //More BS, I'm killing everything
      BroadcastMessage( Killer.PlayerReplicationInfo.PlayerName@" showed that cow who is the BOSS!" );
   }

   BaseMutator.ScoreKill(Killer, Other);
}

function Killed(pawn killer, pawn Other, name damageType)  //taunts....
{
   local int NextTaunt, i;
   local bool bAutoTaunt;

   if ((damageType == 'Decapitated') && (Killer != Other) && (Killer != None) 
   &&(TournamentPlayer(Killer) != None) && TournamentPlayer(Killer).bAutoTaunt)       //play headshot thingy :D
      Killer.ReceiveLocalizedMessage(class'DecapitationMessage');

   super.Killed(killer, Other, damageType);
   bAutoTaunt = ((TournamentPlayer(Killer) != None) && TournamentPlayer(Killer).bAutoTaunt);     //stupid auto taunting

   if (bAutoTaunt && (Killer != Other) && (DamageType != 'gibbed') && (Killer.Health > 0)
   && (Level.TimeSeconds - LastTauntTime > 3))
   {
      LastTauntTime = Level.TimeSeconds;
      NextTaunt = Rand(class<ChallengeVoicePack>(Killer.PlayerReplicationInfo.VoiceType).Default.NumTaunts);
      for ( i=0; i<4; i++ )                                   //keeps taunts unique.....
      {
         if (NextTaunt == LastTaunt[i])
            NextTaunt = Rand(class<ChallengeVoicePack>(Killer.PlayerReplicationInfo.VoiceType).Default.NumTaunts);
         if ( i > 0 )
            LastTaunt[i-1] = LastTaunt[i];
      }
      LastTaunt[3] = NextTaunt;
      killer.SendGlobalMessage(None, 'AUTOTAUNT', NextTaunt, 5);
   }
}

function AddDefaultInventory(pawn PlayerPawn)
{
   local Translator newTranslator;

   GiveWeapon(PlayerPawn, "olweps.uASMD");

   Super.AddDefaultInventory(PlayerPawn);

   if ( Level.DefaultGameType != class'VRikersGame' )
      Super.AddDefaultInventory(PlayerPawn);

   // Spawn translator.
   if( PlayerPawn.IsA('Spectator') || PlayerPawn.FindInventoryType(class'Translator') != None )
      return;

   newTranslator = Spawn(class'Translator',,, Location);
   if( newTranslator != None )
   {
      newTranslator.bHeldItem = true;
      newTranslator.GiveTo( PlayerPawn );
      PlayerPawn.SelectedItem = newTranslator;
      newTranslator.PickupFunction(PlayerPawn);
   }
}

function GiveWeapon(Pawn PlayerPawn, string aClassName )
{
   local class<Weapon> WeaponClass;
   local Weapon NewWeapon;

   WeaponClass = class<Weapon>(DynamicLoadObject(aClassName, class'Class'));

   if(PlayerPawn.FindInventoryType(WeaponClass) != None)
      return;

   newWeapon = Spawn(WeaponClass);
   if(newWeapon != None)
   {
      newWeapon.RespawnTime = 0.0;
      newWeapon.GiveTo(PlayerPawn);
      newWeapon.bHeldItem = true;
      newWeapon.GiveAmmo(PlayerPawn);
      newWeapon.SetSwitchPriority(PlayerPawn);
      newWeapon.WeaponSet(PlayerPawn);
      newWeapon.AmbientGlow = 0;

      if (PlayerPawn.IsA('PlayerPawn'))
         newWeapon.SetHand(PlayerPawn(PlayerPawn).Handedness);
      else
	 		newWeapon.GotoState('Idle');

      PlayerPawn.Weapon.GotoState('DownWeapon');
      PlayerPawn.PendingWeapon = None;
      PlayerPawn.Weapon = newWeapon;
   }
}

defaultproperties
{
   bRestartLevel=False
   bPauseable=False
   bClassicDeathMessages=True
   DefaultPlayerClass=Class'Botpack.TMale2'
   DefaultWeapon=Class'olweps.uDpistol'
   ScoreBoardType=Class'ccoopscoreboard'
   GameMenuType=Class'UnrealShare.UnrealCoopGameOptions'
   RulesMenuType="UMenu.UMenuCoopGameRulesSClient"
   SettingsMenuType="UMenu.UMenuCoopGameRulesSClient"
   MultiplayerUMenuType="UTMenu.UTMultiplayerMenu"
   HUDType=Class'CHUD'
   BeaconName="Coop"
   GameName="Coop Game"
   MutatorClass=Class'GoCoop'
   GameReplicationInfoClass=Class'GoCoopDev9.MonsterReplicationInfo'
}
