
class GoCoopServerInfo extends ServerInfo;

var color WhiteColor, RedColor;

var localized string ServerInfoText, MOTD, TXT1, TXT2,  TXT3, TXT4, TXT5,  TXT6, TXT7, TXT8,
TXT9, TXT10, TXT11, TXT12, TXT13, TXT14,  TXT15, TXT16, TXT17, TXT18, TXT19, TXT20, TXT21;

var FontInfo MyFonts;

function Destroyed()
{
   Super.Destroyed();
   if ( MyFonts != None )
      MyFonts.Destroy();
}

function PostBeginPlay()
{
   Super.PostBeginPlay();
   MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(class'ChallengeHUD'.default.FontInfoClass, class'Class'))));
}

function RenderInfo( canvas C )
{
   local GameReplicationInfo GRI;
   GRI = PlayerPawn(Owner).GameReplicationInfo;
   DrawMyMOTD(C, GRI);
}

function DrawMyMOTD( canvas C, GameReplicationInfo GRI )
{
   local float XL, YL, XL2, YL2;

   C.DrawColor.R = 9;
   C.DrawColor.G = 151;
   C.DrawColor.B = 247;

   C.Font = MyFonts.GetBigFont( C.ClipX );
   C.StrLen( "TEMP", XL, YL );

   C.bCenter = true;
   C.SetPos( 0, C.ClipY / 8 );
   C.DrawText( MOTD, True);

   C.DrawColor = RedColor;
   C.Font = MyFonts.GetSmallFont( C.ClipX );
   C.StrLen( "TEMP", XL2, YL2 );
   C.StrLen(TXT1, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) );
   C.DrawText(TXT1, True );

   C.DrawColor = WhiteColor;

   C.StrLen(TXT2, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1) );
   C.DrawText(TXT2, True );

   C.StrLen(TXT3, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1)*2 );
   C.DrawText(TXT3, True );

   C.StrLen(TXT4, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1)*3 );
   C.DrawText(TXT4, True );

   C.StrLen(TXT5, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1)*4 );
   C.DrawText(TXT5, True );

   C.StrLen(TXT6, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1)*5 );
   C.DrawText(TXT6, True );

   C.StrLen(TXT7, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1)*6 );
   C.DrawText(TXT7, True );

   C.StrLen(TXT8, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1)*7 );
   C.DrawText(TXT8, True );

   C.DrawColor = RedColor;

   C.StrLen(TXT9, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1)*8 );
   C.DrawText(TXT9, True );

   C.DrawColor = WhiteColor;

   C.StrLen(TXT10, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1)*9 );
   C.DrawText(TXT10, True );

   C.StrLen(TXT11, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1)*10 );
   C.DrawText(TXT11, True );

   C.StrLen(TXT12, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1)*11 );
   C.DrawText(TXT12, True );

   C.StrLen(TXT13, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1)*12 );
   C.DrawText(TXT13, True );

   C.StrLen(TXT14, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1)*13 );
   C.DrawText(TXT14, True );

   C.StrLen(TXT15, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1)*14 );
   C.DrawText(TXT15, True );

   C.DrawColor = RedColor;

   C.StrLen(TXT16, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1)*15 );
   C.DrawText(TXT16, True );

   C.DrawColor = WhiteColor;

   C.StrLen(TXT17, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1)*16 );
   C.DrawText(TXT17, True );

   C.StrLen(TXT18, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1)*17 );
   C.DrawText(TXT18, True );

   C.StrLen(TXT19, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1)*18 );
   C.DrawText(TXT19, True );

   C.StrLen(TXT20, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1)*19 );
   C.DrawText(TXT20, True );

   C.DrawColor = RedColor;

   C.DrawColor.R = 9;
   C.DrawColor.G = 151;
   C.DrawColor.B = 247;

   C.Font = MyFonts.GetBigFont( C.ClipX );
   C.StrLen(TXT21, XL2, YL2 );
   C.SetPos( 0, (C.ClipY / 8) + (YL+1) + (YL2+1)*20 );
   C.DrawText(TXT21, True );
}

defaultproperties
{
   ServerInfoText="Server Info"
   MOTD="SOME USEFUL INFORMATION"
   RedColor=(R=255,G=0,B=0,A=0),
   WhiteColor=(R=255,G=255,B=255,A=0),
   TXT1="MUTATE COMMANDS...How to use them:"
   TXT2="To enter a mutate command open your console with the ~ key."
   TXT3="Now type in: mutate <pick one below> and hit enter to activate the command."
   TXT4="These can be used by any player: mutate light turns on your personal light."
   TXT5="Mutate dark turns it off (it never runs out), mutate open or mutate close will"
   TXT6="cause nearby movers to cycle even if you haven't found the trigger (open those"
   TXT7="stuck doors now :). Mutate guns will drop several weapons for your use and mutate"
   TXT8="trans will drop you a translocator."
   TXT9="SERVER EXTRAS"
   TXT10="To heal 3X faster, find a safe spot and lie down (feign death). This is really"
   TXT11="helpful if you are close to dying. The radar will help you find your enemies"
   TXT12="as well as your teammates. The small boxes scattered about with the faint ? on"
   TXT13="them contain goodies to help your quest. I'm still working out the inventory"
   TXT14="so some things are buggy. I'm on it though."
   TXT15=""
   TXT16="SOME THANKS..."
   TXT17="I appreciate you taking the time to play coop with my controller. You are helping"
   TXT18="to keep Unreal coop alive and that's pretty cool. There is more to come so stay"
   TXT19="tuned. And as always send me your requests to add to the mod."
   TXT20=""
   TXT21="Now go explore these wonderful maps and enjoy yourself!"
}