
class ccoopscoreboard expands UnrealScoreBoard;

#exec TEXTURE IMPORT NAME=F2logo FILE=Textures\F2Logo.bmp Group=HUD MIPS=ON

var float ID[16];
var color ParchmentColor, WhiteColor;
var string ScoreBoardText;
var FontInfo MyFonts;

function PostBeginPlay()
{
   Super.PostBeginPlay();
   MyFonts = FontInfo(spawn(Class<Actor>(DynamicLoadObject(class'ChallengeHUD'.default.FontInfoClass, class'Class'))));
}

function Destroyed()
{
   Super.Destroyed();
   if ( MyFonts != None )
      MyFonts.Destroy();
}

function DrawHeader( canvas Canvas )
{
}

function DrawTrailer( canvas Canvas )
{
   local int Hours, Minutes, Seconds;
   local string HourString, MinuteString, SecondString;
   local float XL, YL;
   local int randm;

   if (Canvas.ClipX > 500)
   {
      Seconds = int(Level.TimeSeconds);
      Minutes = Seconds / 60;
      Hours   = Minutes / 60;
      Seconds = Seconds - (Minutes * 60);
      Minutes = Minutes - (Hours * 60);

      if (Seconds < 10)
         SecondString = "0"$Seconds;
      else
	 SecondString = string(Seconds);

      if (Minutes < 10)
	 MinuteString = "0"$Minutes;
      else
	 MinuteString = string(Minutes);

      if (Hours < 10)
	 HourString = "0"$Hours;
      else
	 HourString = string(Hours);

      Canvas.bCenter = true;
      Canvas.StrLen("Test", XL, YL);
      Canvas.SetPos(0, Canvas.ClipY - 2*YL);
      Canvas.DrawText("Time spent on map: "$HourString$":"$MinuteString$":"$SecondString, true);

      Canvas.SetPos(0, Canvas.ClipY - 4*YL);
      Canvas.DrawText("Map Title: "$Level.Title, true);
      Canvas.SetPos(0, Canvas.ClipY - 5*YL);
      Canvas.DrawText("Author: "$Level.Author, true);
      Canvas.bCenter = false;
   }

   if ((Pawn(Owner) != None) && (Pawn(Owner).Health <= 0))
   {
      Canvas.bCenter = true;
      Canvas.StrLen("Test", XL, YL);
      Canvas.SetPos(0, Canvas.ClipY - YL*6);
      Canvas.DrawColor.R = 0;
      Canvas.DrawColor.G = 255;
      Canvas.DrawColor.B = 0;
      randm = Rand(3);
		Canvas.DrawText("You died?! Wow, that sucks.", true);
      Canvas.bCenter = false;
   }
}

function DrawIDInfo( canvas Canvas )
{
   Canvas.SetPos(Canvas.ClipX/4 * 1.9, Canvas.ClipY/4.5);
   Canvas.DrawColor.R = 0;
   Canvas.DrawColor.G = 255;
   Canvas.DrawColor.B = 0;
   Canvas.DrawText("PlayerID", true);
}

function DrawPlayerNames( canvas Canvas )
{
   Canvas.SetPos(Canvas.ClipX/4 * 1, Canvas.ClipY/4.5);
   Canvas.DrawColor.R = 0;
   Canvas.DrawColor.G = 255;
   Canvas.DrawColor.B = 0;
   Canvas.DrawText("Name", true);
}

function DrawFragInfo( canvas Canvas )
{
   Canvas.SetPos(Canvas.ClipX/4 * 2.9, Canvas.ClipY/4.5);
   Canvas.DrawColor.R = 0;
   Canvas.DrawColor.G = 255;
   Canvas.DrawColor.B = 0;
   Canvas.DrawText("Score", true);
}

function DrawID( canvas Canvas, int I, float XOffset, int LoopCount )
{
   local int Step;

   if (Canvas.ClipX >= 640)
      Step = 16;
   else
      Step = 8;

   Canvas.SetPos(Canvas.ClipX/4 * 2, Canvas.ClipY/4 + (LoopCount * Step));

   if(ID[I] >= 100.0)
      Canvas.CurX -= 6.0;
   if(ID[I] >= 10.0)
      Canvas.CurX -= 6.0;
   if(ID[I] < 0.0)
      Canvas.CurX -= 6.0;
   Canvas.DrawText(int(ID[I]), false);
}

function Swap( int L, int R )
{
   local string TempPlayerName, TempTeamName;
   local float TempScore;
   local byte TempTeam;
   local int TempPing;
   local float TempID;

   TempPlayerName = PlayerNames[L];
   TempTeamName = TeamNames[L];
   TempScore = Scores[L];
   TempTeam = Teams[L];
   TempPing = Pings[L];
   TempID = ID[L];

   PlayerNames[L] = PlayerNames[R];
   TeamNames[L] = TeamNames[R];
   Scores[L] = Scores[R];
   Teams[L] = Teams[R];
   Pings[L] = Pings[R];
   ID[L] = ID[R];

   PlayerNames[R] = TempPlayerName;
   TeamNames[R] = TempTeamName;
   Scores[R] = TempScore;
   Teams[R] = TempTeam;
   Pings[R] = TempPing;
   ID[R] = TempID;
}

function ShowScores( canvas Canvas )
{
   local PlayerReplicationInfo PRI;
   local Pawn P;
   local int PlayerCount, LoopCount, I;
   local float XL, YL;

   //Canvas.Font = RegFont;
   Canvas.Font = MyFonts.GetBigFont( Canvas.ClipX );
   DrawHeader(Canvas);
   DrawTrailer(Canvas);

   // Wipe everything.
   for (I=0; I<16; I++)
   {
      Scores[I] = -500;
   }

   Canvas.DrawColor.R = 0;
   Canvas.DrawColor.G = 255;
   Canvas.DrawColor.B = 0;

   foreach AllActors (class'PlayerReplicationInfo', PRI)
   if (!PRI.bIsSpectator)
   {
      PlayerNames[PlayerCount] = PRI.PlayerName;
      TeamNames[PlayerCount] = PRI.TeamName;
      Scores[PlayerCount] = PRI.Score;
      Teams[PlayerCount] = PRI.Team;
      Pings[PlayerCount] = PRI.Ping;
      ID[PlayerCount] = PRI.PlayerID;

      PlayerCount++;
   }
   SortScores(PlayerCount);
   LoopCount = 0;

   for (I=0; I<PlayerCount; I++)
   {
      DrawName(Canvas, I, 0, LoopCount);
      DrawPing(Canvas, I, 0, LoopCount);
      DrawScore(Canvas, I, 0, LoopCount);
      DrawID(Canvas, I, 0, LoopCount);
      DrawIDInfo(Canvas);
      DrawPlayerNames(Canvas);
      DrawFragInfo(Canvas);

      LoopCount++;
   }
   Canvas.DrawColor.R = 255;
   Canvas.DrawColor.G = 255;
   Canvas.DrawColor.B = 255;
   //Header tile
   DrawF2background(Canvas);
	DrawTextAtBottomCenter(Canvas);
}

simulated function DrawF2background(Canvas Canvas)
{
   local float XL, YL, DrawScale;

   //Canvas.DrawColor = RedColor;
	Canvas.Style = ERenderStyle.STY_Translucent;

	XL = Canvas.ClipX * 0.5;
	YL = Canvas.ClipY * 0.07;
	if ( Canvas.ClipX < 1024 )
		DrawScale = Canvas.ClipX / 1024;
	else
		DrawScale = 1;

	Canvas.SetPos( XL - (DrawScale * 512) , YL - ( DrawScale * 256 ) );
	Canvas.DrawTile(Texture'F2logo', DrawScale * 1024, DrawScale * 512, 0, 0,1024,512);

	Canvas.DrawColor = ParchmentColor;
   XL = Canvas.ClipX * 0.5;
	YL = Canvas.ClipY * 0.8;
	if ( Canvas.ClipX < 1024 )
		DrawScale = Canvas.ClipX / 1024;
	else
		DrawScale = 0.6;

	Canvas.SetPos( XL - (DrawScale * 512) , YL - ( DrawScale * 256 ) );
}

simulated function DrawTextAtBottomCenter(Canvas Canvas)
{
   local float XL, YL;

   Canvas.Style = ERenderStyle.STY_Normal;
   Canvas.DrawColor = WhiteColor;
   //Canvas.Font = MyFonts.GetSmallFont( Canvas.ClipX );
   Canvas.StrLen("GOPOSTALSUCKS", XL, YL);
   Canvas.bCenter = True;
   Canvas.SetPos(0, Canvas.ClipY - YL);
   Canvas.DrawText(ScoreBoardText);
   Canvas.bCenter = False;
}

defaultproperties
{
	ParchmentColor=(R=227,G=210,B=176,A=0),
	WhiteColor=(R=255,G=255,B=255,A=0),
	ScoreBoardText="Thank you for playing, press F2 for mod information"
}
