
class invspawnbox expands Decoration;

#exec TEXTURE IMPORT NAME=GopoWoodenBox FILE=Textures\GopoWoodenBox.bmp GROUP=Skins

var() int Health;
var() int FragChunks;
var() Float Fragsize;

function PreBeginPlay()
{
	// some boxes will float (randomly)
	if ( Buoyancy == Default.Buoyancy)
		Buoyancy = Mass * (0.9 + 0.6 * FRand());

	Super.PreBeginPlay();
}

Auto State Animate
{
	function TakeDamage( int NDamage, Pawn instigatedBy, Vector hitlocation, Vector momentum, name damageType)
	{
		Instigator = InstigatedBy;
		if (Health<0) Return;
		if ( Instigator != None )
			MakeNoise(1.0);
		bBobbing = false;
		Health -= NDamage;
		if (Health <0) 	
			Frag(Class'WoodFragments',Momentum,FragSize,FragChunks);
		else 
		{
			SetPhysics(PHYS_Falling);
			Momentum.Z = 1000;
			Velocity=Momentum*0.016;
		}
	}
}

defaultproperties
{
	Health=5
   FragChunks=6
   Fragsize=0.30
   bStatic=False
   DrawType=DT_Mesh
   Mesh=LodMesh'UnrealShare.WoodenBoxM'
   Texture=GopoWoodenBox
   MultiSkins(1)=GopoWoodenBox
   DrawScale=0.33
   CollisionRadius=12.00
   CollisionHeight=10.00
   bCollideActors=True
   bCollideWorld=True
   bBlockActors=True
   bBlockPlayers=True
}
