
class GoJGrass2v expands mutator config(GoJGrass2v);

#exec TEXTURE IMPORT NAME=exclamation FILE=Textures\exclamation.bmp FLAGS=2
#exec TEXTURE IMPORT NAME=Blak FILE=Textures\Blak.pcx

#exec mesh import mesh=SV_Invincible anivfile=Models\SV_Invincible_a.3d datafile=Models\SV_Invincible_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=SV_Invincible x=0 y=0 z=0
#exec mesh sequence mesh=SV_Invincible seq=All startframe=0 numframes=1
#exec meshmap new meshmap=SV_Invincible mesh=SV_Invincible
#exec meshmap scale meshmap=SV_Invincible x=0.062500 y=0.062500 z=0.125000

#exec MESHMAP SETTEXTURE MESHMAP=SV_Invincible NUM=0 TEXTURE=Blak
#exec MESHMAP SETTEXTURE MESHMAP=SV_Invincible NUM=1 TEXTURE=exclamation

var config int HealthRegenPerSec;
var config int MaxRegenHealth;
var config int MaxMonsterHealth;

function postbeginplay()
{
   local TranslatorEvent TE;
   local Pawn P, NewMommy;
   local BabyCow BC;
   local Mercenary FixMerc;
   local ScriptedPawn SP;

   SetTimer(3, True);

   foreach AllActors(class'ScriptedPawn', SP)
   {
      if(SP !=none)
		   if(SP.Health > MaxMonsterHealth)
			   SP.Health = MaxMonsterHealth;
   }

   foreach AllActors(class'TranslatorEvent', TE)
   {
      if(TE !=none)
      {
         TE.bHidden=False;
         TE.DrawType=DT_Mesh;
         TE.Mesh=Mesh'GoJGrass2v.SV_Invincible';
         TE.bFixedRotationDir=True;
         TE.SetPhysics(PHYS_Rotating);
         TE.RotationRate.Yaw=6000;
         TE.Velocity.Z=6000;
		}
   }

   for ( P=Level.PawnList; P!=None; P=P.nextPawn )
   {
		if (P.IsA('Cow'))
		{
			NewMommy = P;
			foreach AllActors(class'BabyCow', BC)
   		{
      		if(BC !=none)
      		{
      			if(BC.Mom == None)
      				NewMommy = BC.Mom;
      		}
      	}
      }
   }
   ForEach AllActors(class'Mercenary', FixMerc)
	{
      if (FixMerc != None)
			if (FixMerc.bHasInvulnerableShield == True)
      		FixMerc.bHasInvulnerableShield = False;
   }
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
   local Teleporter T;

   local Trigger TR;
   local Mover M;
   local SpecialEvent SE;
   local MusicEvent ME;
   local ZoneInfo ZI;
   local LevelInfo LI;
   local CreatureFactory CF;
   local PlayerStart PS;
   local WoodenBox WB;
   local LavaZone LZ;
   local ThingFactory TF;
   local RazorBlade RB;
   local cpanel Pa;
   local FixedNaliRabbit FR;
   local Dispatcher Di;

   T = Teleporter(Other);
   TR = Trigger(Other);
   M = Mover(Other);
   SE = SpecialEvent(Other);
   ME = MusicEvent(Other);
   ZI = ZoneInfo(Other);
   LI = LevelInfo(Other);
   CF = CreatureFactory(Other);
   PS = PlayerStart(Other);
   WB = WoodenBox(Other);
   LZ = LavaZone(Other);
   TF = ThingFactory(Other);
   RB = RazorBlade(Other);
   Di = Dispatcher(Other);

   if ( Other.IsA('Trigger') )
   {
      if ( Level.Title == "Map 6: Gore Mine Crossing " && (Trigger(Other).Name == 'Trigger60') )
      {
	 		Trigger(Other).InitialState = 'NormalTrigger';
	 		Trigger(Other).bInitiallyActive = True;
      }
   }
   if (Other.Class==Class'NaliRabbit')
   {
    	Other.Destroy();
    	FR = Spawn(class'FixedNaliRabbit',,,other.location);
   }
   else if ( Other.IsA('Mover'))
   {
      if ( Level.Title == "Map 6: Gore Mine Crossing " && (Mover(Other).Name == 'Mover76') )
      {
	 		Mover(Other).MoveTime = 99999999;
      }
      else if ( Level.Title == "Map 6: Gore Mine Crossing " && (Mover(Other).Name == 'Mover77') )
      {
         Mover(Other).MoveTime = 99999999;
      }
   }
   if ( Other.IsA('KrallCarcass'))
   {
      KrallCarcass(Other).SetCollision(false, false, false);
   }
// Fixes the door on Strange5 that gets stuck in coop
   if ( TR != None)
   {
      if ( string(TR) ~= "Strange5.Trigger4" )
      {
         TR.Event='qwert4';
      }
      if ( string(TR) ~= "Strange5.Trigger5" )
      {
	 		TR.RetriggerDelay= 4;
	 		TR.bTriggerOnceOnly= False;
      }
   }
//Fix DKSkybases extremely annoying triggers
   if ( string(TR) ~= "DKSkybase.Trigger9" )
   {
      TR.RetriggerDelay= 2;
   }
   if ( string(TR) ~= "DKSkybase.Trigger20" )
   {
      TR.RetriggerDelay= 2;
   }
   if ( string(TR) ~= "DKSkybase.Trigger23" )
   {
      TR.RetriggerDelay= 2;
   }
   if ( string(TR) ~= "DKSkybase.Trigger25" )
   {
      TR.RetriggerDelay= 2;
   }
   if ( string(TR) ~= "DKSkybase.Trigger26" )
   {
      TR.RetriggerDelay= 2;
   }
   if ( string(TR) ~= "DKSkybase.Trigger77" )
   {
      TR.RetriggerDelay= 2;
   }
//No more blocked ends on dk maps
   if ( string(TR) ~= "DKNaliBoat.Trigger0" )
   {
      TR.Event= 'None';
   }
   if ( string(TR) ~= "DKnalic.Trigger12" )
   {
      TR.Event= 'None';
   }
   if ( string(TR) ~= "DKnoork.Trigger1" )
   {
      TR.Event= 'None';
   }
   if ( string(TR) ~= "DKnoork.Trigger2" )
   {
      TR.Event= 'None';
   }
   if ( string(TR) ~= "zmu97fhub2b.Trigger1" )
   {
      TR.Event= 'None';
   }
   if ( string(TR) ~= "zmu97fhub2b.Trigger2" )
   {
      TR.Event= 'None';
   }
   if ( string(TR) ~= "DKPassage.Trigger0" )
   {
      TR.Event= 'None';
   }
   if ( string(TR) ~= "DKruins.Trigger1" )
   {
      TR.Event= 'None';
   }
   if ( string(TR) ~= "zmu97ruins.Trigger1" )
   {
      TR.Event= 'None';
   }
   if ( string(TR) ~= "DKVeloraEnd.Trigger5" )
   {
      TR.InitialState= 'NormalTrigger';
   }
//Skylvl4 fix
   if ( string(TR) ~= "Skylvl4.Trigger1" )
   {
      TR.TriggerType= TT_PlayerProximity;
   }
// Removes the chance of getting stuck on Hexephet's starting position
   if ( string(M) ~= "Hexephet.Mover14" )
   {
      M.InitialState= 'StandOpenTimed';
   }
//Mover fix for DKRuins
   if ( string(M) ~= "DKRuins.Mover35" )
   {
      M.Tag= 'spelldis';
      M.StayOpenTime= 99999;
   }
//Fix the first door on Bluff
   if ( string(M) ~= "DKBluff.Mover17" )
   {
      M.MoverEncroachType= ME_IgnoreWhenEncroach;
   }
   if ( string(M) ~= "DKBluff.Mover24" )
   {
      M.MoverEncroachType= ME_IgnoreWhenEncroach;
   }
//Keep dasapass big doors opened
   if ( string(M) ~= "DKDasapass.Mover18" )
   {
      M.StayOpenTime= 9999999;
   }
   if ( string(M) ~= "zmu97Dasa.Mover113" )
   {
      M.StayOpenTime= 9999999;
   }
   if ( string(M) ~= "zmu97Dasa.Mover115" )
   {
      M.StayOpenTime= 9999999;
   }
   if ( string(M) ~= "zmu97Dasa.Mover149" )
   {
      M.StayOpenTime= 9999999;
   }
   if ( string(M) ~= "zmu97Dasa.Mover157" )
   {
      M.StayOpenTime= 9999999;
   }
   if ( string(M) ~= "DKDasacellars.Mover149" )
   {
      M.StayOpenTime= 9999999;
   }
   if ( string(M) ~= "DKDasacellars.Mover157" )
   {
      M.StayOpenTime= 9999999;
   }
   if ( string(M) ~= "DKDasapass.Mover115" )
   {
      M.StayOpenTime= 9999999;
   }
// Fixes the ray of light that should kill the final big Skaarj
   if ( string(SE) ~= "Shrak3.SpecialEvent10" )
   {
      SE.Tag= 'lightray';
      SE.InitialState= 'KillInstigator';
      SE.Damage= 10000;
   }
//Hack fix for poorly placed ending teleporter on NewAlc1
   if (string(ZI) ~= "NewAlc1.ZoneInfo1" )
   {
      ZI.ZoneTerminalVelocity= 500;
   }
//same for dawn...
   if (string(LI) ~= "Dusk2.LevelInfo0" )
   {
      LI.ZoneTerminalVelocity= 500;
   }
   if (string(LI) ~= "ST-Nrgatothbase.LevelInfo0" )
   {
      LI.ZoneTerminalVelocity= 750;
   }
//Makes Shrak2 DecoMut&Akcoop compatible
   if (string(TR) ~= "Shrak2.Trigger2" )
   {
      TR.InitialState= 'NormalTrigger';
      TR.bInitiallyActive= True;
   }
// Fixes the sucking lift on Shrak3
   if ( string(M) ~= "Shrak3.Mover48" )
   {
      M.InitialState= 'StandOpenTimed';
   }
   if ( string(M) ~= "Shrak3.Mover99" )
   {
      M.InitialState= 'TriggerToggle';
   }
   if (string(RB) ~= "Shrak3.RazorBlade1" )
      RB.Destroy();
   if (string(RB) ~= "Shrak3.RazorBlade3" )
      RB.Destroy();
   if (string(RB) ~= "Shrak3.RazorBlade5" )
      RB.Destroy();
   if (string(RB) ~= "Shrak3.RazorBlade7" )
      RB.Destroy();
   if (string(RB) ~= "Shrak3.RazorBlade10" )
      RB.Destroy();
   if (string(RB) ~= "Shrak3.RazorBlade11" )
      RB.Destroy();
   if (string(RB) ~= "Shrak3.RazorBlade16" )
      RB.Destroy();
   if (string(RB) ~= "Shrak3.RazorBlade17" )
      RB.Destroy();
   if (string(RB) ~= "Shrak3.RazorBlade18" )
      RB.Destroy();
   if (string(RB) ~= "Shrak3.RazorBlade20" )
      RB.Destroy();
// Fixes the extremedarks last door which often gets stuck in coop
   if ( string(M) ~= "dk3extremedark.Mover63" )
   {
      M.InitialState= 'TriggerOpenTimed';
      M.StayOpenTime= 99999;
   }
   if ( string(M) ~= "dk3extremedark.Mover64" )
   {
      M.InitialState= 'TriggerOpenTimed';
      M.StayOpenTime= 99999;
   }
   if ( string(M) ~= "dk3extremedark.Mover65" )
   {
      M.InitialState= 'TriggerOpenTimed';
      M.StayOpenTime= 99999;
   }
//Mover fix for Xerania
   if ( string(M) ~= "Xerania.Mover123" )
   {
      M.InitialState= 'TriggerOpenTimed';
      M.StayOpenTime= 999999;
   }
//Lift fix for PML1
   if ( string(TR) ~= "pml1.Trigger22" )
   {
      TR.Event= 'None';
   }
//Mover fix for PML4
   if ( string(M) ~= "pml4.Mover12" )
   {
      M.InitialState= 'TriggerOpenTimed';
      M.StayOpenTime= 99999;
   }
//Mover fix for Attacked3
   if ( string(M) ~= "Attacked3[1].Mover20" )
   {
      M.InitialState= 'TriggerOpenTimed';
   }
   if ( string(LZ) ~= "Attacked3[1].LavaZone0" )
   {
      LZ.DamagePerSec= 5;
   }
//Mover fix for Attacked4
   if ( string(M) ~= "Attacked4[wtf].Mover21" )
   {
      M.StayOpenTime= 10;
   }
   if ( string(M) ~= "Attacked4[wtf].Mover84" )
   {
      M.InitialState= 'BumpOpenTimed';
   }
//Mover fix for Tashara3
   if ( string(M) ~= "Tashara3.Mover12" )
   {
      M.InitialState= 'BumpOpenTimed';
   }
   if ( string(M) ~= "Tashara3.Mover13" )
   {
      M.InitialState= 'BumpOpenTimed';
   }

//Prevent the door with skaarj behind from getting stuck in coop on Strange1
   if ( string(TR) ~= "Strange1.Trigger16" )
   {
      TR.InitialState= 'NormalTrigger';
      TR.bInitiallyActive= True;
   }
// Remove falling damage on ExtremeEnd
   if ( string(ZI) ~= "dk3extremeend.ZoneInfo0" )
   {
      ZI.ZoneGravity.z= -50;
   }
   if ( string(ZI) ~= "dk3extremeend.ZoneInfo1" )
   {
      ZI.ZoneGravity.z= -50;
   }
   if ( string(LI) ~= "dk3extremeend.LevelInfo5" )
   {
      LI.ZoneGravity.z= -50;
   }
//DKNaliC Guillotine must do damage :P
   if ( string(M) ~= "DKNaliC.Mover29" )
   {
      M.MoverEncroachType= ME_CrushWhenEncroach;
      M.EncroachDamage= 9999;
   }
// Fix the last doors on DKDCrater that stay stuck when running akcoop
   if ( string(M) ~= "DKDCrater.Mover4" )
   {
      M.InitialState= 'BumpOpenTimed';
   }
   if ( string(M) ~= "DKDCrater.Mover5" )
   {
      M.InitialState= 'BumpOpenTimed';
   }
   if ( string(M) ~= "DKDCrater.Mover6" )
   {
      M.InitialState= 'BumpOpenTimed';
   }
//Gets rid of the million spawning pupaes at the start of UTLNP06
   if ( string(CF) ~= "UTLNP06.CreatureFactory0" )
   {
      CF.Capacity= 100;
   }
//Fixes a couple fast movers on SkaarjTower to make them coop friendly
   if ( string(M) ~= "SkaarjTowerF.Mover163" )
   {
      M.DelayTime= 5;
   }
   if ( string(M) ~= "SkaarjTowerF.Mover194" )
   {
      M.DelayTime= 5;
   }
//Makes the last fast lift on UTLNP15 coop friendly
   if ( string(M) ~= "UTLNP15.Mover113" )
   {
      M.DelayTime= 5;
   }
//Darkside fixes
   if ( string(M) ~= "dark_3.Mover32" )
   {
      M.StayOpenTime= 5;
   }
   if ( string(M) ~= "dark_3.Mover31" )
   {
      M.StayOpenTime= 5;
   }
   if ( string(TR) ~= "dark_3.Trigger13" )
   {
      TR.bTriggerOnceOnly= False;
   }
   if ( string(T) ~= "dark_3.Teleporter1" )
   {
      T.URL= "dnspu4#entry?peer";
   }
   if ( string(M) ~= "dnspu4-2.Mover11" )
   {
      M.StayOpenTime= 5;
   }
   if ( string(TR) ~= "dnspu4-2.Trigger5" )
   {
      TR.bTriggerOnceOnly= False;
   }
   if (string(PS) ~= "Strange6.PlayerStart6")
   {
      PS.bEnabled= False;
      PS.bCoopStart= False;
   }


//Fix the buggy gate on USP-14 which often gets stuck on coop
   if (string(M) ~= "USP-14-Maekh.Mover44")
   {
      M.InitialState= 'BumpOpenTimed';
   }
//Fixes for Chico's maps...to be continued...
   if (string(TF) ~= "sbegin2.ThingFactory0")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "sbegin2.ThingFactory1")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "sbegin2.ThingFactory2")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "sbegin2.ThingFactory3")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "sbegin2.ThingFactory4")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "sbegin2.ThingFactory5")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "sbegin2.ThingFactory6")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "stemple.ThingFactory0")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "stemple.ThingFactory1")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "stemple.ThingFactory2")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "stemple.ThingFactory3")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "stemple.ThingFactory4")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "stemple.ThingFactory5")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "stemple.ThingFactory6")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "stemple.ThingFactory7")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "stemple.ThingFactory8")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "stemple.ThingFactory9")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "stemple.ThingFactory10")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "stemple.ThingFactory11")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "stemple.ThingFactory12")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "stemple.ThingFactory13")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(M) ~= "svalley2.Mover54")
   {
      M.InitialState= 'TriggerOpenTimed';
      M.StayOpenTime= 999999;
   }
   if (string(TF) ~= "sbegin.ThingFactory0")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "sbegin.ThingFactory1")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "sbegin.ThingFactory2")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "sbegin.ThingFactory3")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "sbegin.ThingFactory4")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "sbegin.ThingFactory5")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "sbegin.ThingFactory6")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TF) ~= "sbegin.ThingFactory7")
   {
      TF.Capacity= 1;
      TF.Prototype= None;
      return false;
   }
   if (string(TR) ~= "sancient1.trigger43")
   {
      TR.bTriggerOnceOnly= False;
      TR.InitialState= 'NormalTrigger';
   }
   if (string(M) ~= "sancient1.Mover61")
   {
      M.InitialState= 'TriggerOpenTimed';
      M.StayOpenTime= 9999999;
   }
   if (string(M) ~= "sancient1.Mover62")
   {
      M.InitialState= 'TriggerOpenTimed';
      M.StayOpenTime= 9999999;
   }
   if (string(M) ~= "sancient1.Mover63")
   {
      M.InitialState= 'TriggerOpenTimed';
      M.StayOpenTime= 9999999;
   }
   if (string(M) ~= "sancient1.Mover64")
   {
      M.InitialState= 'TriggerOpenTimed';
      M.StayOpenTime= 9999999;
   }
   if (string(TR) ~= "sancient1.Trigger313")
   {
      TR.Event= 'None';
   }
   if (string(TR) ~= "sancient1.Trigger314")
   {
      TR.Event= 'None';
   }
   if (string(M) ~= "sancient1.Mover64")
   {
      M.InitialState= 'BumpOpenTimed';
   }
// Mover fix
   if (string(M) ~= "Dnspu4-2.Mover4")
   {
      M.StayOpenTime=5;
   }
//DeCyberInvasion fixes
   if (string(M) ~= "Invasion_1.Mover9")
   {
      M.InitialState= 'TriggerOpenTimed';
      M.StayOpenTime= 9999999;
   }
   if (string(M) ~= "Invasion_1.Mover12")
   {
      M.InitialState= 'TriggerOpenTimed';
      M.StayOpenTime= 9999999;
   }
   if (string(M) ~= "Invasion_1.Mover19")
   {
      M.InitialState= 'TriggerOpenTimed';
      M.StayOpenTime= 9999999;
   }
   if (string(M) ~= "Invasion_1.Mover3")
   {
      M.Tag= 'None';
   }
   if (string(M) ~= "Invasion_5.Mover9")
   {
      M.InitialState= 'TriggerOpenTimed';
      M.StayOpenTime= 9999999;
   }
   if (string(M) ~= "Invasion_5.Mover12")
   {
      M.InitialState= 'TriggerOpenTimed';
      M.StayOpenTime= 9999999;
   }
   if (string(M) ~= "Invasion_5.Mover19")
   {
      M.InitialState= 'TriggerOpenTimed';
      M.StayOpenTime= 9999999;
   }
//NP02DavidM
   if ( string(M) ~= "NP02DavidM.Mover70" )
   {
      M.InitialState= 'BumpOpenTimed';
   }
   if ( string(M) ~= "NP02DavidM.Mover71" )	
   {
      M.InitialState= 'BumpOpenTimed';
   }
   if ( string(TR) ~= "NP02DavidM.Trigger21" )	
   {
      TR.Event= 'None';
   }
		//NP09Silver
   if ( string(TR) ~= "NP09Silver.Trigger5" )
   {
      TR.bTriggerOnceOnly= False;
   }
		//NP13DrPest
   if ( string(TR) ~= "NP13DrPest.Trigger19" )
   {
      TR.bInitiallyActive = True;
   }
   if ( string(TR) ~= "NP13DrPest.Trigger39" )
   {
      TR.bInitiallyActive = True;
   }
		//NP19Part1Chico
   if ( string(Di) ~= "NP19Part1Chico.Dispatcher16" )
   {
      Di.Tag = 'gateoff';
   }
		//NP22DavidM
   if ( string(M) ~= "NP22DavidM.Mover9" )
   {
      M.Tag= 'trigsound1';
      M.StayOpenTime= 99999;
   }
   if ( string(M) ~= "NP22DavidM.Mover6" )	
   {
      M.InitialState= 'BumpOpenTimed';
   }
//NP31 no esr...no worky...
   if ( string(TR) ~= "NP31DavidM.Trigger19" )
   {
      TR.Event= 'nextone';
   }

//XidiaFixes
   if ( string(TR) ~= "XidiaES-Map2-Rail.Trigger1" )
   {
      TR.bInitiallyActive= True;
   }
   if ( string(TR) ~= "XidiaES-Map3-ReOP.Trigger93" )
   {
      TR.bInitiallyActive= True;
   }
   if ( string(TR) ~= "XidiaES-Map3-ReOP.Trigger42" )
   {
      TR.bTriggerOnceOnly= False;
   }
   if ( string(TR) ~= "XidiaES-Map4-DeadMines.Trigger46" )
   {
      TR.bInitiallyActive= True;
   }
   if ( string(M) ~= "XidiaES-Map4-DeadMines.Mover0" )	
   {
      M.InitialState= 'BumpOpenTimed';
   }
   if ( string(M) ~= "XidiaGold-Map7-Darklord.Mover13" )	
   {
      M.InitialState= 'TriggerOpenTimed';
      M.StayOpenTime= 10;
   }
   if ( string(TR) ~= "XidiaGold-Map7-Darklord.Trigger16" )	
   {
      TR.bTriggerOnceOnly= False;
   }
   if ( string(M) ~= "XidiaGold-Map7-Darklord.Mover17" )	
   {
      M.InitialState= 'TriggerOpenTimed';
   }
   if ( string(M) ~= "XidiaGold-Map7-Darklord.Mover27" )	
   {
      M.Tag= 'TheQuickening';
   }
//7B fixes
   if ( string(TR) ~= "Jones-01-Deployment.Trigger11" )	
   {
      TR.Event= 'LockedVent';
   }
   if ( string(TR) ~= "Jones-02-Darkness.Trigger74" )	
   {
      TR.Event= 'PowerSwitchesEnabled';
   }
   if ( string(M) ~= "Jones-03-Rogue.Mover9" )	
   {
      M.Tag= 'WeaponsLabDoors2';
      M.InitialState= 'TriggerOpenTimed';
   }
   if ( string(M) ~= "Jones-03-Rogue.Mover10" )
   {
      M.Tag= 'WeaponsLabDoors2';
      M.InitialState= 'TriggerOpenTimed';
   }
   if ( string(M) ~= "Jones-03-Rogue.Mover11" )
   {
      M.Tag= 'WeaponsLabDoors2';
      M.InitialState= 'TriggerOpenTimed';
   }
   if ( string(M) ~= "Jones-03-Rogue.Mover12" )
   {
      M.Tag= 'WeaponsLabDoors2';
      M.InitialState= 'TriggerOpenTimed';
   }
   if ( string(M) ~= "Jones-05-TemplePart3.Mover46" )
   {
      M.Tag= 'ProphSancBars';
      M.StayOpenTime= 99999;
   }
   if ( string(M) ~= "Jones-05-TemplePart3.Mover62" )	
   {
      M.StayOpenTime= 99999;
      M.InitialState= 'TriggerOpenTimed';
   }
   if ( string(M) ~= "Jones-05-TemplePart3.Mover64" )	
   {
      M.InitialState= 'BumpOpenTimed';
   }
   if ( string(TR) ~= "Jones-06-Vandora.Trigger21" )	
   {
      TR.Event= 'ConsoleDisser';
   }	
   if ( string(TR) ~= "Jones-08-Pirate.Trigger49" )	
   {
      TR.bInitiallyActive= True;
   }
   if ( string(TR) ~= "Jones-08-Pirate2.Trigger20" )
   {
      TR.Event= 'LoginDispatcher';
   }
   if ( string(TR) ~= "Jones-08-Pirate2.Trigger6" )
   {
      TR.bTriggerOnceOnly= False;
   }

   if ( string(M) ~= "Jones-08-Pirate3.Mover13" )	
   {
		M.MoveTime= 10;
   }
	//Unreal 97 Beta map fixes
   if ( string(TR) ~= "zmu97fhub1.Trigger14" )
   {
      TR.InitialState='NormalTrigger';
      TR.bInitiallyActive=True;
   }
   if ( string(TR) ~= "zmu97ruins.trigger1" )
   {
      TR.Event='None';
   }
   if ( string(TR) ~= "zmu97fhub5.Trigger47" )
   {
      TR.bInitiallyActive= True;
   }
   if ( string(ZI) ~= "zmu97foundry.zoneinfo0" )
   {
      ZI.bPainZone= False;
      ZI.DamagePErSec=0;
   }
   if ( string(ZI) ~= "zmu97foundry.zoneinfo14" )
   {
      ZI.bPainZone= False;
      ZI.DamagePErSec=0;
   }
   if ( string(ZI) ~= "zmu97foundry.zoneinfo15" )
   {
      ZI.bPainZone= False;
      ZI.DamagePErSec=0;
   }
   if ( string(ZI) ~= "zmu97toxic.zoneinfo7" )
   {
      ZI.bPainZone= False;
      ZI.DamagePErSec=0;
   }
   if ( string(ZI) ~= "zmu97toxic.zoneinfo5" )
   {
      ZI.bPainZone= False;
      ZI.DamagePErSec=0;
   }
   if ( string(ZI) ~= "zmu97toxic.zoneinfo9" )
   {
      ZI.bPainZone= False;
      ZI.DamagePErSec=0;
   }
   if ( string(M) ~= "zmu97toxic.Mover30" )
   {
      M.InitialState='TriggerOpenTimed';
   }
   if ( string(M) ~= "zmu97toxic.Mover113" )
   {
      M.bTriggerOnceOnly=False;
   }
   if ( string(M) ~= "zmu97velora.Mover10" )
   {
      M.bTriggerOnceOnly=False;
   }
   if ( string(M) ~= "zmu97nexus.Mover24" )
   {
      M.Tag='reo1';
   }

   if ( Other.IsA('Teleporter') )
   {
      if (InStr(Teleporter(Other).URL, "#") !=-1)
      {
	 		Pa=Spawn(class'cpanel',,,other.location+vect(-1,-1,-1));
      }
   }
   if ( Other.IsA('Teleporter') )
   {
      if (InStr(Teleporter(Other).URL, "/") !=-1)
      {
         Pa=Spawn(class'cpanel',,,other.location+vect(-1,-1,-1));
      }
   }
   if (other.isa('tree'))
   {
      tree(other).style= STY_Masked;
   }
   return true;
   return Super.CheckReplacement(Other, bSuperRelevant);
}

function Timer()
{
   local Pawn P;
   local Inventory Inv;

   for (P=Level.PawnList; P!=None; P=P.NextPawn)
   //if (P.IsA('UnrealIPlayer'))
   if (P.IsA('GHuman'))
   {
      if (P.Health > 1)
      {
         for(Inv=P.Inventory; Inv!=None; Inv=Inv.Inventory)
         if ((Ammo(Inv)!=None) && (P.bFire==0) && (P.bAltFire==0))
            if (Ammo(Inv).AmmoAmount < Ammo(Inv).MaxAmmo)
	       		Ammo(Inv).AmmoAmount += 0.1*Ammo(Inv).MaxAmmo;
         	if (P.Health < MaxRegenHealth && P.Region.Zone != None && !P.Region.Zone.bWaterZone) // waterzone stoppage of health regen
         	{
            	if (P.IsInState('FeigningDeath'))
               	P.Health = FMin(MaxRegenHealth, P.Health + (3 * HealthRegenPerSec));
            	else
                  P.Health = FMin(MaxRegenHealth, P.Health + HealthRegenPerSec);
         	}
      }
   }
}

defaultproperties
{
   HealthRegenPerSec=1
   MaxRegenHealth=100
}
