class MoverWallHitEffect extends WallHitEffect;

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	if ( Instigator != None )
		MakeNoise(0.3);

	SpawnEffects();
}

simulated function SpawnEffects()
{
	local Actor A;
	local float decision;

	decision = FRand();
	if (decision<0.1)
		PlaySound(sound'ricochet',, 1,,1200, 0.5+FRand());
	if ( decision < 0.35 )
		PlaySound(sound'Impact1',, 2.0,,1200);
	else if ( decision < 0.6 )
		PlaySound(sound'Impact2',, 2.0,,1200);

	A = spawn(class'MoverHitEffect',,,,Rotation + RotRand());
	if ( A != None )
		A.RemoteRole = ROLE_None;
}

defaultproperties
{
}