//------------------------------------------------------//
// EffectSpawner                                        //
//                                                      //
// this class handles the spawning of effects on actors //
//   with variable frequency and number of spawns       //
//                                                      //
// Written by Martin "Pfhoenix" Actor                   //
// Copyright (C) 2000 Martin Actor                      //
// This class is freely available to anyone who wants   //
//   to use it. All I ask is that you give due credit.  //
//------------------------------------------------------//

class EffectSpawner extends Actor;

var float SpawnDelay;			// time between effect spawns
var float DelayLeft;			// time left until next spawn, unused for now
var int NumSpawns;			// number of total effects to spawn. 0 means infinite
var int SpawnsLeft;			// number of effects left to spawn before the spawner is destroyed
var bool bIsSpawning;			// flag to check whether spawner is active
var vector RelLocation;			// the location of the spawner relative to the location of the owner
var EffectSpawner FirstSpawner;	// first spawner in the list
var EffectSpawner NextSpawner;	// next spawner in the list
var class<Effects> EffectToSpawn;	// the effect we want to spawn

function bool IsSpawning()
{
	return bIsSpawning;
}

function StopSpawner()
{
	SetTimer(0.0, false);
	bIsSpawning = false;
}

function StartSpawner()
{
	// check if we're already spawning
	if (bIsSpawning)
	{
		// stop spawning and reset vars where pertinent
		StopSpawner();
		SpawnsLeft = NumSpawns;
	}
	bIsSpawning = true;
	SetTimer(SpawnDelay, true);
}

function SetRelativeLocation()
{
	RelLocation = Location - Owner.Location;
}

function InitSpawner()
{
	SetRelativeLocation();
	FirstSpawner = Self;
	NextSpawner = None;
}

function SetSpawnProperties(optional float SD, optional int NS, optional int SL, optional class<Effects> E, optional bool RestartTimer)
{
	SpawnDelay = SD;
	NumSpawns = NS;
	SpawnsLeft = SL;
	EffectToSpawn = E;
	if (RestartTimer) StartSpawner();

	return;
}

function Timer()
{
	// only process if we're spawning
	if (bIsSpawning)
	{
		// check if we're spawning a finite number
		if (NumSpawns > 0)
		{
			// decrement the spawns left
			SpawnsLeft--;
			// spawn the effect
			Spawn(EffectToSpawn, Self, , RelLocation + Owner.Location, Owner.Rotation);
			// we've run out of spawns
			if (SpawnsLeft <= 0)
			{
				DeleteFromCurrentList();
				Destroy();
			}
		}
		else Spawn(EffectToSpawn, Owner, , RelLocation + Owner.Location, Owner.Rotation);
	}
}

function EffectSpawner AddToList(EffectSpawner FS)
{
	local EffectSpawner ES;

	// make sure this is valid
	if (FS == None) return None;

	// we are an unlimited spawner
	if (NumSpawns == 0)
	{
		// the list already has unlimited spawners
		if (FS.NumSpawns == 0)
		{
			FirstSpawner = FS;
			NextSpawner = FS.NextSpawner;
			FS.NextSpawner = Self;
		}
		// need make us the first spawner
		else
		{
			NextSpawner = FS;
			ES = Self;
			while (ES != None)
			{
				ES.FirstSpawner = Self;
				ES = ES.NextSpawner;
			}
		}
	}
	// we are a limited spawner
	else
	{
		// we go at the end of the list
		if (FS.NumSpawns == 0)
		{
			FirstSpawner = FS;
			ES = FS;
			while (ES.NextSpawner != None) ES = ES.NextSpawner;
			NextSpawner = ES.NextSpawner;
			ES.NextSpawner = NextSpawner;
		}
		// throw us right next to the first spawner
		else
		{
			FirstSpawner = FS;
			NextSpawner = FS.NextSpawner;
			FS.NextSpawner = Self;
		}
	}

	return FirstSpawner;
}

function EffectSpawner DeleteFromCurrentList()
{
	local EffectSpawner ES, tES;

	// check for first entry condition
	if (FirstSpawner == Self)
	{
		// set the other entries first node to NextSpawner
		ES = NextSpawner;
		tES = NextSpawner;
		while (ES != None)
		{
			ES.FirstSpawner = tBES;
			ES = ES.NextSpawner;
		}
		NextSpawner = None;
	}
	// find the list node before this and connect it to the one after this, eliminating this entry from the list
	else
	{
		ES = FirstSpawner;
		tES = FirstSpawner;
		while (ES.NextSpawner != None)
		{
			if (ES.NextSpawner == Self) break;
			ES = ES.NextSpawner;
		}
		if (ES.NextSpawner != None)
		{
			ES.NextSpawner = NextSpawner;
		}
		ES = None;
		NextSpawner = None;
		FirstSpawner = Self;
	}

	return tES;
}

defaultproperties
{
	bHidden=true
}