// --------------------------------------------------------------------
// CMySqlData.hxx
// Whatis:  Common data manipulation for all tables
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 24-NOV-2001     Created this source
// --------------------------------------------------------------------
#ifndef CMySqlData_hxx
#define CMySqlData_hxx
#include    "CMySqlConnect.hxx"
#include    "CMySqlWhere.hxx"

// --------------------------------------------------------------------
// Number of colors in the default color scheme
// --------------------------------------------------------------------
#define	COLOR_SCHEME_COLORS	22

// --------------------------------------------------------------------
// The commmon flags used in many tables
// --------------------------------------------------------------------
#define	FLAG_DENY_READ	0x00000001		// (    1) Deny read
#define	FLAG_DENY_WRITE	0x00000002		// (    2) Deny write
#define	FLAG_DENY_VIEW	0x00000004		// (    4) Deny view (hidden)
#define	FLAG_DENY_MOD	0x00000008		// (    8) Deny update
#define	FLAG_DENY_REN	0x00000010		// (   16) Deny rename
#define	FLAG_DENY_DEL	0x00000020		// (   32) Deny deletion
#define	FLAG_FIX_FLAG	0x00000040		// (   64) Flags are fixed
#define	FLAG_ACCEPTED	0x00000080		// (  128) Record is accepted
#define	FLAG_BANNED		0x00000100		// (  256) Record is banned
#define	FLAG_NOSUGGEST	0x00000200		// (  512) Do not suggest on download
#define	FLAG_NODOWNLOAD	0x00000400		// ( 1024) Do not allow downloads
#define	FLAG_SUPERUSER	0x00000800		// ( 2048) This user has lot of privileges
#define	FLAG_NEWSADMIN	0x00001000		// ( 4096) Can administrate news
#define	FLAG_REVIADMIN	0x00002000		// ( 8192) Can administrate reviews
#define	FLAG_COMMADMIN	0x00004000		// (16384) Can administrate comments
#define	FLAG_USECOOKIES	0x00008000		// (32768) Uses cookies

// --------------------------------------------------------------------
// Macro for pointing data inside 'structure'
// --------------------------------------------------------------------
#define DATA_LOCATION(b,d,t)    ((t *)((b)+d.offset))
#define DATA_OFFSET( s, r, o )  (word_t)((long)(&(s.o)) - (long)(&(s.r)))

// --------------------------------------------------------------------
// Supported data types
// --------------------------------------------------------------------
typedef enum {
    data_struct_type_time,   // time
    data_struct_type_bool,   // boolean
    data_struct_type_dword,  // 4 byte unsigned integer
    data_struct_type_ascz    // ASCZ string
}   data_struct_type_t;

// --------------------------------------------------------------------
// Data descriptor structure
// --------------------------------------------------------------------
typedef struct {
    word_t              offset;     // Data offset in the given structure
    data_struct_type_t  type;       // Type of the field
    word_t              size;       // Size of the field
    const char *        name;       // Name of the field
    bool                crypt;      // Contents crypted
}   data_struct_descriptor_t,
*   data_struct_descriptor_tp,
**  data_struct_descriptor_th;

// --------------------------------------------------------------------
// Declaration of the CMySqlData class
// --------------------------------------------------------------------
class   CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CMySqlData ( data_struct_descriptor_tp, word_t );

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CMySqlData              ( const CMySqlData & );
    CMySqlData & operator = ( const CMySqlData & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    virtual ~CMySqlData();

    // ----------------------------------------------------------------
    public:     // Queries
    // ----------------------------------------------------------------
    void **             MakeSelect( CMySqlConnect_t &   aDataBase,
                                    const char *        aTableName,
                                    bool				aDistinct,
                                    const char *        aWhereClause = NULL,
                                    const char *        aOrderClause = NULL );

    dword_t             MakeSelectCount (   CMySqlConnect_t &   aDataBase,
                                            const char *        aTableName,
		                                    bool				aDistinct,
                                            const char *        aWhereClause = NULL );

    void                MakeInsert( CMySqlConnect_t &   aDataBase,
                                    const char *        aTableName,
                                    const void **       aData );

    void                MakeUpdate( CMySqlConnect_t &   aDataBase,
                                    const char *        aTableName,
                                    const char *        aWhereClause,
                                    const void **       aData );

    void                MakeUpdate( CMySqlConnect_t &   aDataBase,
                                    const char *        aTableName,
                                    const CMySqlWhere & aWhereClause,
                                    const void **       aData );

    void                MakeDelete( CMySqlConnect_t &   aDataBase,
                                    const char *        aTableName,
                                    const char *        aWhereClause = NULL );

    dword_t             Maximum( 	CMySqlConnect_t &   aDataBase,
                                    const char *        aTableName,
                                    const char *        aColumnName );

    // ----------------------------------------------------------------
    public:     // Utility
    // ----------------------------------------------------------------
    void                Destroy   ( void ** aData );

    // ----------------------------------------------------------------
    private:    // Helpers
    // ----------------------------------------------------------------
    void                ImportTime  ( char *, data_struct_descriptor_t &, const char * );
    void                ImportBool  ( char *, data_struct_descriptor_t &, const char * );
    void                ImportDword ( char *, data_struct_descriptor_t &, const char * );
    void                ImportAscz  ( char *, data_struct_descriptor_t &, const char * );

    void                ExportTime  ( char *, data_struct_descriptor_t &, const char * );
    void                ExportBool  ( char *, data_struct_descriptor_t &, const char * );
    void                ExportDword ( char *, data_struct_descriptor_t &, const char * );
    void                ExportAscz  ( char *, data_struct_descriptor_t &, const char * );

    // ----------------------------------------------------------------
    private:    // Instance data
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   itsDataStructDescriptor;
    word_t                      itsStructSize;
};

// --------------------------------------------------------------------
// Derived data types
// --------------------------------------------------------------------
typedef class CMySqlData               CMySqlData_t;
typedef class CMySqlData *             CMySqlData_tp;

// --------------------------------------------------------------------
// Utility function for parsing table contents
// --------------------------------------------------------------------
extern "C" {

extern	bool	MySqlTableParser	(	const data_struct_descriptor_tp	aLayout,
										const char *					aTb,
										const char *					aData,
										const char *					aQ );

};

#endif  // #ifdef  CMySqlData_hxx
// --------------------------------------------------------------------
// EOF: CMySqlData.hxx
// --------------------------------------------------------------------
