// --------------------------------------------------------------------
// CTableAuth.hxx
// Whatis:  auth table access class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableAuth_hxx
#define CTableAuth_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	dword_t	auth_idnt;			// Record identifier, used to reference a auth
	dword_t	auth_user;			// Owner of this author
	char	auth_name[101];		// Real name of the author
	dword_t	auth_flag;			// Flags for the auth
	dword_t	auth_rate;			// Rating of the file 0 .. 10000
	dword_t	auth_rat0;			// Number of bad klicks for this author
	dword_t	auth_rat1;			// Number of average klicks for this author  
	dword_t	auth_rat2;			// Number of good klicks for this author
	dword_t	auth_dlct;			// Download count
	dword_t	auth_plct;			// Players count
}   data_auth_t,
*   data_auth_tp,
**  data_auth_th;
typedef list <data_auth_t>               data_auth_tl;
typedef data_auth_tl::iterator           data_auth_tli;
typedef data_auth_tl::const_iterator     data_auth_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableAuth class
// --------------------------------------------------------------------
class   CTableAuth : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableAuth ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableAuth              ( const CTableAuth & );
    CTableAuth & operator = ( const CTableAuth & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableAuth();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_auth_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_auth_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                	bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_auth_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_auth_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_auth_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

	dword_t				NextIdnt(	CMySqlConnect_t & aDb );

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableAuth_hxx
// --------------------------------------------------------------------
// EOF: CTableAuth.hxx
// --------------------------------------------------------------------
