// --------------------------------------------------------------------
// CTableCach.hxx
// Whatis:  cach table access class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableCach_hxx
#define CTableCach_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	char	cach_file[251];	// Cached file name
	dword_t	cach_size;		// Size of this cache entry
	time_t	cach_ltim;		// Last access time
}   data_cach_t,
*   data_cach_tp,
**  data_cach_th;
typedef list <data_cach_t>               data_cach_tl;
typedef data_cach_tl::iterator           data_cach_tli;
typedef data_cach_tl::const_iterator     data_cach_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableCach class
// --------------------------------------------------------------------
class   CTableCach : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableCach ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableCach              ( const CTableCach & );
    CTableCach & operator = ( const CTableCach & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableCach();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_cach_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_cach_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                	bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_cach_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_cach_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_cach_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableCach_hxx
// --------------------------------------------------------------------
// EOF: CTableCach.hxx
// --------------------------------------------------------------------
