// --------------------------------------------------------------------
// CTableDcac.hxx
// Whatis:  dcac table access class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableDcac_hxx
#define CTableDcac_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	dword_t	dcac_idnt;
	char	dcac_file[201];
	char	dcac_link[201];
	char	dcac_csum[201];
	char	dcac_addr[101];
	time_t	dcac_ltim;
	dword_t	dcac_prog;
	dword_t	dcac_size;
}   data_dcac_t,
*   data_dcac_tp,
**  data_dcac_th;
typedef list <data_dcac_t>               data_dcac_tl;
typedef data_dcac_tl::iterator           data_dcac_tli;
typedef data_dcac_tl::const_iterator     data_dcac_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableDcac class
// --------------------------------------------------------------------
class   CTableDcac : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableDcac ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableDcac              ( const CTableDcac & );
    CTableDcac & operator = ( const CTableDcac & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableDcac();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_dcac_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_dcac_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                	bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_dcac_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_dcac_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_dcac_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

	dword_t				NextIdnt(	CMySqlConnect_t & aDb );

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableDcac_hxx
// --------------------------------------------------------------------
// EOF: CTableDcac.hxx
// --------------------------------------------------------------------
