// --------------------------------------------------------------------
// CTableDeny.hxx
// Whatis:  deny table access class
// Denyors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableDeny_hxx
#define CTableDeny_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	char	deny_name[101];		// Real name of the denyor
}   data_deny_t,
*   data_deny_tp,
**  data_deny_th;
typedef list <data_deny_t>               data_deny_tl;
typedef data_deny_tl::iterator           data_deny_tli;
typedef data_deny_tl::const_iterator     data_deny_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableDeny class
// --------------------------------------------------------------------
class   CTableDeny : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableDeny ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableDeny              ( const CTableDeny & );
    CTableDeny & operator = ( const CTableDeny & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableDeny();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_deny_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_deny_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                	bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_deny_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_deny_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_deny_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableDeny_hxx
// --------------------------------------------------------------------
// EOF: CTableDeny.hxx
// --------------------------------------------------------------------
