// --------------------------------------------------------------------
// CTableFsrv.hxx
// Whatis:  fsrv table access class
// Fsrvors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableFsrv_hxx
#define CTableFsrv_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	dword_t	fsrv_file	;
	char	fsrv_addr	[65];
	dword_t	fsrv_quep	;
	dword_t	fsrv_pcur	;
	dword_t	fsrv_pmax	;
	time_t	fsrv_time	;
}   data_fsrv_t,
*   data_fsrv_tp,
**  data_fsrv_th;
typedef list <data_fsrv_t>               data_fsrv_tl;
typedef data_fsrv_tl::iterator           data_fsrv_tli;
typedef data_fsrv_tl::const_iterator     data_fsrv_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableFsrv class
// --------------------------------------------------------------------
class   CTableFsrv : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableFsrv ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableFsrv              ( const CTableFsrv & );
    CTableFsrv & operator = ( const CTableFsrv & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableFsrv();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_fsrv_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_fsrv_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                    bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_fsrv_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_fsrv_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_fsrv_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableFsrv_hxx
// --------------------------------------------------------------------
// EOF: CTableFsrv.hxx
// --------------------------------------------------------------------
