// --------------------------------------------------------------------
// CTableNews.hxx
// Whatis:  news table access class
// Newsors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableNews_hxx
#define CTableNews_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	dword_t	news_idnt;			// Surrogate key
	dword_t	news_user;			// Author of this news entry
	time_t	news_time;			// Creation time
	char	news_titl[251];		// Title
	dword_t	news_file;			// File identifier of the news text
}   data_news_t,
*   data_news_tp,
**  data_news_th;
typedef list <data_news_t>               data_news_tl;
typedef data_news_tl::iterator           data_news_tli;
typedef data_news_tl::const_iterator     data_news_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableNews class
// --------------------------------------------------------------------
class   CTableNews : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableNews ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableNews              ( const CTableNews & );
    CTableNews & operator = ( const CTableNews & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableNews();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_news_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_news_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                    bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_news_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_news_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_news_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

	dword_t				NextIdnt(	CMySqlConnect_t & aDb );

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableNews_hxx
// --------------------------------------------------------------------
// EOF: CTableNews.hxx
// --------------------------------------------------------------------
