// --------------------------------------------------------------------
// CTablePack.hxx
// Whatis:  pack table access class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTablePack_hxx
#define CTablePack_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	dword_t	pack_idnt;			// Record identifier, used to reference a pack
	char	pack_name[101];		// Real name of the pack
	char	pack_file[101];		// Suggested filename for retrieving
	dword_t	pack_user;			// Author of this package
	dword_t	pack_text;			// Attached text
	dword_t	pack_pict;			// Attached picture
	time_t	pack_atim;			// Arrival time
	time_t	pack_mtim;			// Modification time
	time_t	pack_ltim;			// Last access time
	dword_t	pack_flag;			// Flags for the pack
}   data_pack_t,
*   data_pack_tp,
**  data_pack_th;
typedef list <data_pack_t>               data_pack_tl;
typedef data_pack_tl::iterator           data_pack_tli;
typedef data_pack_tl::const_iterator     data_pack_tlci;

// --------------------------------------------------------------------
// Declaration of the CTablePack class
// --------------------------------------------------------------------
class   CTablePack : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTablePack ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTablePack              ( const CTablePack & );
    CTablePack & operator = ( const CTablePack & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTablePack();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_pack_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_pack_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                	bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_pack_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_pack_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_pack_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

	dword_t				NextIdnt(	CMySqlConnect_t & aDb );

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTablePack_hxx
// --------------------------------------------------------------------
// EOF: CTablePack.hxx
// --------------------------------------------------------------------
