// --------------------------------------------------------------------
// CTableQuot.hxx
// Whatis:  quot table access class
// Quotors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableQuot_hxx
#define CTableQuot_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	dword_t	quot_idnt;
	char	quot_text[251];
}   data_quot_t,
*   data_quot_tp,
**  data_quot_th;
typedef list <data_quot_t>               data_quot_tl;
typedef data_quot_tl::iterator           data_quot_tli;
typedef data_quot_tl::const_iterator     data_quot_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableQuot class
// --------------------------------------------------------------------
class   CTableQuot : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableQuot ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableQuot              ( const CTableQuot & );
    CTableQuot & operator = ( const CTableQuot & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableQuot();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_quot_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_quot_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                	bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_quot_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_quot_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_quot_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

	dword_t				NextIdnt(	CMySqlConnect_t & aDb );

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableQuot_hxx
// --------------------------------------------------------------------
// EOF: CTableQuot.hxx
// --------------------------------------------------------------------
