// --------------------------------------------------------------------
// CTableSess.hxx
// Whatis:  sess table access class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableSess_hxx
#define CTableSess_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	dword_t	sess_idnt;			// Record identifier, used to reference a sess
	dword_t	sess_user;			// User reference
	dword_t	sess_time;			// Time after which is invalid
	char	sess_pass[101];		// Crypted password that was used
	char	sess_addr[101];		// IP address that was used for this session
}   data_sess_t,
*   data_sess_tp,
**  data_sess_th;
typedef list <data_sess_t>               data_sess_tl;
typedef data_sess_tl::iterator           data_sess_tli;
typedef data_sess_tl::const_iterator     data_sess_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableSess class
// --------------------------------------------------------------------
class   CTableSess : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableSess ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableSess              ( const CTableSess & );
    CTableSess & operator = ( const CTableSess & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableSess();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_sess_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_sess_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                	bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_sess_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_sess_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_sess_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

	dword_t				NextIdnt(	CMySqlConnect_t & aDb );

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableSess_hxx
// --------------------------------------------------------------------
// EOF: CTableSess.hxx
// --------------------------------------------------------------------
