// --------------------------------------------------------------------
// CTableUrll.hxx
// Whatis:  auth table access class
// Urllors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableUrll_hxx
#define CTableUrll_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	char	urll_name[201];		// Name of this link
	char	urll_type[33];		// Type of the link 
	char	urll_addr[201];		// Address          
	char	urll_ftyp[9];		// Fetch type
	dword_t	urll_user;			// Owner of the link
	char	urll_text[251];		// Explanation      
}   data_urll_t,
*   data_urll_tp,
**  data_urll_th;
typedef list <data_urll_t>               data_urll_tl;
typedef data_urll_tl::iterator           data_urll_tli;
typedef data_urll_tl::const_iterator     data_urll_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableUrll class
// --------------------------------------------------------------------
class   CTableUrll : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableUrll ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableUrll              ( const CTableUrll & );
    CTableUrll & operator = ( const CTableUrll & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableUrll();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_urll_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_urll_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                	bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_urll_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_urll_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_urll_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableUrll_hxx
// --------------------------------------------------------------------
// EOF: CTableUrll.hxx
// --------------------------------------------------------------------
