// --------------------------------------------------------------------
// CTableUser.hxx
// Whatis:  user table access class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableUser_hxx
#define CTableUser_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	dword_t	user_idnt;			// Record identifier, used to reference a user
	char	user_name[101];		// Real name of this user
	char	user_logn[101];		// Login name of this user
	char	user_pass[101];		// Password for the user
	dword_t	user_text;			// Text of this user
	dword_t	user_pict;			// Picture of this user
	time_t	user_atim;			// Arrival time
	time_t	user_ltim;			// Last access time
	dword_t	user_flag;			// Flags for the user
	char	user_cook[101];		// Cookie string
	time_t	user_whtm;			// What's new time
	char	user_colo[251];		// Color scheme
}   data_user_t,
*   data_user_tp,
**  data_user_th;
typedef list <data_user_t>               data_user_tl;
typedef data_user_tl::iterator           data_user_tli;
typedef data_user_tl::const_iterator     data_user_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableUser class
// --------------------------------------------------------------------
class   CTableUser : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableUser ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableUser              ( const CTableUser & );
    CTableUser & operator = ( const CTableUser & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableUser();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_user_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_user_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                	bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_user_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_user_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_user_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

	dword_t				NextIdnt(	CMySqlConnect_t & aDb );

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableUser_hxx
// --------------------------------------------------------------------
// EOF: CTableUser.hxx
// --------------------------------------------------------------------
