// --------------------------------------------------------------------
// CTableVote.hxx
// Whatis:  vote table access class
// Voteors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableVote_hxx
#define CTableVote_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	char	vote_idnt[41];		// Generated key for votes
	time_t	vote_time;			// Vote time
}   data_vote_t,
*   data_vote_tp,
**  data_vote_th;
typedef list <data_vote_t>               data_vote_tl;
typedef data_vote_tl::iterator           data_vote_tli;
typedef data_vote_tl::const_iterator     data_vote_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableVote class
// --------------------------------------------------------------------
class   CTableVote : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableVote ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableVote              ( const CTableVote & );
    CTableVote & operator = ( const CTableVote & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableVote();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_vote_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_vote_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                    bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_vote_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_vote_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_vote_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableVote_hxx
// --------------------------------------------------------------------
// EOF: CTableVote.hxx
// --------------------------------------------------------------------
