// --------------------------------------------------------------------
// CTableWurl.hxx
// Whatis:  wurl table access class
// Authors: Esko 'Varpu' Ilola  EIL
// History: EIL 03-JUL-2002     Created this source
// --------------------------------------------------------------------
#ifndef CTableWurl_hxx
#define CTableWurl_hxx
#include    "CMySqlData.hxx"

// --------------------------------------------------------------------
// Data structure carrying the select data
// --------------------------------------------------------------------
typedef struct {
	dword_t	wurl_idnt;			// Record identifier, used to reference a wurl
	char	wurl_type[33];		// Type of this URL
	char	wurl_titl[101];		// Title
	char	wurl_desc[251];		// Short description
	char	wurl_link[201];		// The actual link
	dword_t	wurl_rate;			// Access rating, 0=inaccessible, 10 = OK
	time_t	wurl_ltim;			// Last access time
}   data_wurl_t,
*   data_wurl_tp,
**  data_wurl_th;
typedef list <data_wurl_t>               data_wurl_tl;
typedef data_wurl_tl::iterator           data_wurl_tli;
typedef data_wurl_tl::const_iterator     data_wurl_tlci;

// --------------------------------------------------------------------
// Declaration of the CTableWurl class
// --------------------------------------------------------------------
class   CTableWurl : public CMySqlData {

    // ----------------------------------------------------------------
    public:     // Constructors
    // ----------------------------------------------------------------
    CTableWurl ();

    // ----------------------------------------------------------------
    private:    // Copy constructor and assignment operator are lethal
                // Therefore they are made private
    // ----------------------------------------------------------------
    CTableWurl              ( const CTableWurl & );
    CTableWurl & operator = ( const CTableWurl & );

    // ----------------------------------------------------------------
    public:     // Destructor
    // ----------------------------------------------------------------
    ~CTableWurl();

    // ----------------------------------------------------------------
    public:     // Interface
    // ----------------------------------------------------------------
    data_wurl_tl   		Select  (  	CMySqlConnect_t &,
                                	const char *,
                                	bool = false );

    data_wurl_tl		Select  (  	CMySqlConnect_t & aDb,
                            		const CMySqlWhere & aW ) { return Select( aDb, aW.Where() ); }

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const char *,
                                	bool = false );

    dword_t             Count   (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { return Count( aDb, aW.Where() ); }

    void                Insert  (   CMySqlConnect_t &,
                                    data_wurl_tp );

    void                Update  (   CMySqlConnect_t &,
                                    data_wurl_tp );

    void                Delete  (   CMySqlConnect_t &,
                                    data_wurl_tp = NULL );

    void                Delete  (   CMySqlConnect_t &,
                                    const char * );

    void                Delete  (   CMySqlConnect_t & aDb,
                                    const CMySqlWhere & aW ) { Delete( aDb, aW.Where() ); }

	dword_t				NextIdnt(	CMySqlConnect_t & aDb );

    // ----------------------------------------------------------------
    public:     // Retrieve layout descriptor
    // ----------------------------------------------------------------
    data_struct_descriptor_tp   Layout  ( void ) const;
};

#endif  // #ifdef  CTableWurl_hxx
// --------------------------------------------------------------------
// EOF: CTableWurl.hxx
// --------------------------------------------------------------------
