# ################################################################
# UTCMS_cach.sql
# Creates cach table
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ref from:
# refers  :
#
# ################################################################
# Field descriptions
# ################################################################
# cach_file		Name of the cached preview image
# cach_ltim		Last access time

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS cach;

# ################################################################
# Create the cach table and it's indexes
# ################################################################
CREATE TABLE cach (
	cach_file	CHAR(250)		NOT NULL,
	cach_size	INTEGER			NOT NULL	DEFAULT 0,
	cach_ltim	DATETIME		NOT NULL,

	PRIMARY KEY ( cach_file )
);

CREATE INDEX			cach_ltim_ix		ON cach ( cach_ltim );

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON cach TO quest@localhost;

FLUSH PRIVILEGES;


# ################################################################
# EOF: UTCMS_cach.sql
# ################################################################
