# ################################################################
# UTCMS_dcac.sql
# Creates dcac table
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ref from:
# refers  :
#
# ################################################################
# Field descriptions
# ################################################################
# dcac_idnt		Unique identifier
# dcac_file		Related file - unique
# dcac_link		Related URL - unique
# dcac_csum		Checksum - unique
# dcac_addr		IP Address of creator - spam detection
# dcac_ltim		Creation time
# dcac_prog		Progress indicator 0..100


# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS dcac;

# ################################################################
# Create the dcac table and it's indexes
# ################################################################
CREATE TABLE dcac (
	dcac_idnt	INTEGER			NOT NULL DEFAULT 0,
	dcac_file	CHAR(200)		NOT NULL,
	dcac_link	CHAR(200)		NOT NULL,
	dcac_csum	CHAR(200)		NOT NULL,
	dcac_addr	CHAR(100)		NOT NULL,
	dcac_ltim	DATETIME		NOT NULL,
	dcac_prog	INTEGER			NOT NULL DEFAULT 0,
	dcac_size	INTEGER			NOT NULL DEFAULT 0,

	PRIMARY KEY ( dcac_idnt )
);

CREATE INDEX		dcac_file_ix		ON dcac ( dcac_file );
CREATE INDEX		dcac_link_ix		ON dcac ( dcac_link );
CREATE UNIQUE INDEX	dcac_csum_ix		ON dcac ( dcac_csum );
CREATE INDEX		dcac_ltim_ix		ON dcac ( dcac_ltim );
CREATE INDEX		dcac_addr_ix		ON dcac ( dcac_addr );

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON dcac TO quest@localhost;

FLUSH PRIVILEGES;


# ################################################################
# EOF: UTCMS_dcac.sql
# ################################################################
