# ################################################################
# UTCMS_deny.sql
# Creates auth table
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
#
# ################################################################
# Field descriptions
# ################################################################
# deny_name		Name of the denied file

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS deny;

# ################################################################
# Create the auth table and it's indexes
# ################################################################
CREATE TABLE deny (
	deny_name	CHAR(100)		NOT NULL,
	PRIMARY KEY ( deny_name )
);

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON deny TO quest@localhost;

FLUSH PRIVILEGES;

# ################################################################
# Some default authors
# ################################################################
INSERT INTO deny ( deny_name ) VALUES
( "1-1.gif" ),
( "1-2.gif" ),
( "1.gif" ),
( "2-1.gif" ),
( "2-2.gif" ),
( "3-1.gif" ),
( "3-2.gif" ),
( "4-1.gif" ),
( "4-2.gif" ),
( "5-1.gif" ),
( "5-2.gif" ),
( "6-1.gif" ),
( "6-2.gif" ),
( "7-1.gif" ),
( "7-2.gif" ),
( "7-3.gif" ),
( "abaddonarchitecture-epic.utx" ),
( "abaddonarchitecture.utx" ),
( "abaddonhardware.usx" ),
( "abaddonhardwarebrush.utx" ),
( "abaddonterrain.utx" ),
( "about_epic_games.html" ),
( "about_netgames_usa.html" ),
( "about_ngtcs.html" ),
( "about_ngworldstats.html" ),
( "activates.uax" ),
( "addantiportal.bmp" ),
( "addmover.bmp" ),
( "addon1.uax" ),
( "addspecial.bmp" ),
( "admins_account.htm" ),
( "admins_home.htm" ),
( "admins_menu.htm" ),
( "admins_priv_table.inc" ),
( "adminsframe.htm" ),
( "alaudio.dll" ),
( "alaudio.int" ),
( "alfafx.utx" ),
( "alien.ka" ),
( "alienmaletaunts.uax" ),
( "aliens.ukx" ),
( "alientech.usx" ),
( "all_totals.htm" ),
( "alleriaarchitecture.utx" ),
( "alleriahardware.usx" ),
( "alleriahardwarebrush.utx" ),
( "alleriaterrain.utx" ),
( "ambancient.uax" ),
( "ambcity.uax" ),
( "ambmodern.uax" ),
( "amboutside.uax" ),
( "ancient.utx" ),
( "animated.utx" ),
( "announcer.uax" ),
( "announcerevil.uax" ),
( "announcerfemale.uax" ),
( "announcerlong.uax" ),
( "announcermain.uax" ),
( "announcernames.uax" ),
( "announcersexy.uax" ),
( "antalusstatic.usx" ),
( "antalustextures.utx" ),
( "anubissky.utx" ),
( "anubisstatic.usx" ),
( "anubistextures.utx" ),
( "arboreaarchitecture.utx" ),
( "arboreahardware.usx" ),
( "arboreahardwarebrush.utx" ),
( "arborealanscape.usx" ),
( "arboreaterrain.utx" ),
( "arenatex.utx" ),
( "as-frigate.unr" ),
( "as-guardia.unr" ),
( "as-hispeed.unr" ),
( "as-mazon.unr" ),
( "as-oceanfloor.unr" ),
( "as-overlord.unr" ),
( "as-rook.unr" ),
( "as-tutorial.unr" ),
( "ati.utx" ),
( "aurorae.utx" ),
( "aw-alleria.utx" ),
( "aw-convert.utx" ),
( "aw-cubes.utx" ),
( "aw-junk.usx" ),
( "aw-junk2.usx" ),
( "aw-mechmeshes.usx" ),
( "aw-metals.utx" ),
( "aw-metals2.utx" ),
( "aw-natural.usx" ),
( "aw-neutral.usx" ),
( "aw-rustmeshes.usx" ),
( "aw-rusttex.utx" ),
( "aw-shaders.utx" ),
( "aw-steel.usx" ),
( "aw-stone.utx" ),
( "aw_alleriahw.usx" ),
( "awcity.utx" ),
( "awglobal.utx" ),
( "awhardware.usx" ),
( "awmagic.utx" ),
( "awmagichardware.usx" ),
( "awpipes.usx" ),
( "awstellar.utx" ),
( "awstellarmeshes.usx" ),
( "awtroff.utx" ),
( "background.gif" ),
( "banetextures.utx" ),
( "barrenhardware-epic.usx" ),
( "barrenhardware.usx" ),
( "barrenhardwaredeux.utx" ),
( "barrensarchitecture-epic.utx" ),
( "barrensarchitecture-scion.utx" ),
( "barrensarchitecture.utx" ),
( "barrenshardwarebrush.utx" ),
( "barrensterrain.utx" ),
( "bastien.utx" ),
( "bastienhardware.usx" ),
( "bbcone.bmp" ),
( "bbcube.bmp" ),
( "bbcurvedstair.bmp" ),
( "bbcylinder.bmp" ),
( "bbgeneric.bmp" ),
( "bblinearstair.bmp" ),
( "bbsheet.bmp" ),
( "bbsphere.bmp" ),
( "bbspiralstair.bmp" ),
( "bbterrain.bmp" ),
( "bbvolumetric.bmp" ),
( "belt_fx.utx" ),
( "benchmark.exe" ),
( "bloodfx.utx" ),
( "blue_white.gif" ),
( "blufffx.utx" ),
( "bonuspack.det" ),
( "bonuspack.est" ),
( "bonuspack.frt" ),
( "bonuspack.int" ),
( "bonuspack.itt" ),
( "bonuspack.kot" ),
( "bonuspack.tmt" ),
( "bonuspack.u" ),
( "bonuspackreadme.txt" ),
( "bossskins.int" ),
( "bossskins.utx" ),
( "bossvoice.uax" ),
( "bot.ka" ),
( "bot.ukx" ),
( "bot_totals.htm" ),
( "botmatch-all.bat" ),
( "botmatch-antalus.bat" ),
( "botmatch-anubis.bat" ),
( "botmatch-asbestos.bat" ),
( "botmatch-citadel.bat" ),
( "botmatch-endagra.bat" ),
( "botmatch-inferno.bat" ),
( "botmatch-suntemple.bat" ),
( "botmatchexec.txt" ),
( "botmca9.umx" ),
( "botpack.int" ),
( "botpack.u" ),
( "botpck10.umx" ),
( "bp4readme.txt" ),
( "bp_arch1.utx" ),
( "bp_egyptnew.usx" ),
( "br-anubis.ut2" ),
( "br-bifrost.ut2" ),
( "br-canyon.ut2" ),
( "br-de-elecfields.ut2" ),
( "br-disclosure.ut2" ),
( "br-icefields.ut2" ),
( "br-skyline.ut2" ),
( "br-slaughterhouse.ut2" ),
( "br-twintombs.ut2" ),
( "brightplayerskins.utx" ),
( "brushclip.bmp" ),
( "brushclipdelete.bmp" ),
( "brushclipflip.bmp" ),
( "brushclipsplit.bmp" ),
( "bugreport.exe" ),
( "build.ini" ),
( "bulldogmeshes.usx" ),
( "cameraalign.bmp" ),
( "cannon.umx" ),
( "cannons.ukx" ),
( "casstextures2.utx" ),
( "castle1.utx" ),
( "cavernstatic.usx" ),
( "caverntextures.utx" ),
( "cb-staticmesh.usx" ),
( "cell_center.inc" ),
( "cell_center_nowrap.inc" ),
( "cell_colspan.inc" ),
( "cell_left.inc" ),
( "cell_left_nowrap.inc" ),
( "cell_right.inc" ),
( "cell_right_nowrap.inc" ),
( "cf_de.usx" ),
( "cf_sm01.usx" ),
( "cf_sm02.usx" ),
( "cf_tex01.utx" ),
( "cf_tex02.utx" ),
( "change_ngworldstats_password.gif" ),
( "checkbox.inc" ),
( "checkerfx.utx" ),
( "checkerfxb.utx" ),
( "chizraefx.utx" ),
( "chrome_cp.utx" ),
( "citadel_static.usx" ),
( "citadeltextures.utx" ),
( "city.utx" ),
( "cityintro.unr" ),
( "classicut.css" ),
( "clifftest.utx" ),
( "clipz.bmp" ),
( "colossus.umx" ),
( "commandoskins.int" ),
( "commandoskins.utx" ),
( "comp.usx" ),
( "compress.utx" ),
( "confirm_password.gif" ),
( "content_footer_tables.inc" ),
( "content_header_tables.inc" ),
( "core.det" ),
( "core.dll" ),
( "core.est" ),
( "core.frt" ),
( "core.int" ),
( "core.itt" ),
( "core.kot" ),
( "core.smt" ),
( "core.tmt" ),
( "core.u" ),
( "coret_fx.utx" ),
( "course.umx" ),
( "cp_cubemaps.utx" ),
( "cp_effects1.utx" ),
( "cp_enviromesh1.usx" ),
( "cp_envirotex1.utx" ),
( "cp_evil.usx" ),
( "cp_evil2.utx" ),
( "cp_evil3.utx" ),
( "cp_evillandscape.utx" ),
( "cp_evilmetal.utx" ),
( "cp_evilstatic2.usx" ),
( "cp_fx.utx" ),
( "cp_junkyard.utx" ),
( "cp_liquid1.utx" ),
( "cp_mech1.utx" ),
( "cp_mechstaticpack1.usx" ),
( "cp_newskins1.utx" ),
( "cp_nightmare1_epic.usx" ),
( "cp_particles.utx" ),
( "cp_simplewall_meshs.usx" ),
( "cp_staticmeshskin1.utx" ),
( "cp_stevetest1.usx" ),
( "cp_stevetest1.utx" ),
( "cp_terrain1.utx" ),
( "cp_texturetest1.utx" ),
( "cp_ut2k3_techset1.utx" ),
( "cp_ut2k3_techsetmesh1.usx" ),
( "cp_wasteland.utx" ),
( "cp_wasteland_mesh.usx" ),
( "creative.utx" ),
( "credits.umx" ),
( "credits.utx" ),
( "crosshairs.utx" ),
( "crypt.utx" ),
( "crypt2.utx" ),
( "crypt_fx.utx" ),
( "ctf-avaris.ut2" ),
( "ctf-beatitude.unr" ),
( "ctf-chrome.ut2" ),
( "ctf-citadel.ut2" ),
( "ctf-command.unr" ),
( "ctf-coret.unr" ),
( "ctf-cybrosis][.unr" ),
( "ctf-darji16.unr" ),
( "ctf-de-elecfields.ut2" ),
( "ctf-de-lavagiant2.ut2" ),
( "ctf-december.ut2" ),
( "ctf-doubledammage.ut2" ),
( "ctf-dreary.unr" ),
( "ctf-epicboy.unr" ),
( "ctf-eternalcave.unr" ),
( "ctf-face-se.unr" ),
( "ctf-face.unr" ),
( "ctf-face3.ut2" ),
( "ctf-face][.unr" ),
( "ctf-gauntlet.unr" ),
( "ctf-geothermal.ut2" ),
( "ctf-high.unr" ),
( "ctf-hydro16.unr" ),
( "ctf-kosov.unr" ),
( "ctf-lavagiant.unr" ),
( "ctf-lostfaith.ut2" ),
( "ctf-magma.ut2" ),
( "ctf-maul.ut2" ),
( "ctf-niven.unr" ),
( "ctf-november.unr" ),
( "ctf-noxion16.unr" ),
( "ctf-nucleus.unr" ),
( "ctf-orbital2.ut2" ),
( "ctf-ratchet.unr" ),
( "ctf-tutorial.unr" ),
( "ctf.utx" ),
( "cubemaps.utx" ),
( "current.uhtm" ),
( "current_bots.htm" ),
( "current_bots_row.inc" ),
( "current_bots_row_sel.inc" ),
( "current_bots_species.inc" ),
( "current_console.htm" ),
( "current_console.uhtm" ),
( "current_console_log.htm" ),
( "current_console_log.uhtm" ),
( "current_console_send.htm" ),
( "current_console_send.uhtm" ),
( "current_game.htm" ),
( "current_game.uhtm" ),
( "current_game_stat_table.inc" ),
( "current_game_stat_table_row.inc" ),
( "current_menu.htm" ),
( "current_menu.uhtm" ),
( "current_mutators.htm" ),
( "current_mutators.uhtm" ),
( "current_mutators_group.inc" ),
( "current_mutators_group_row.inc" ),
( "current_mutators_row.inc" ),
( "current_mutators_selected.inc" ),
( "current_mutators_table.inc" ),
( "current_players.htm" ),
( "current_players.uhtm" ),
( "current_players_ban_col.inc" ),
( "current_players_empty_col.inc" ),
( "current_players_kick_col.inc" ),
( "current_players_list_head.inc" ),
( "current_players_list_head_link.inc" ),
( "current_players_minp.inc" ),
( "currentframe.htm" ),
( "d3ddrv.dll" ),
( "d3ddrv.int" ),
( "dacomafem.utx" ),
( "dacomaskins.utx" ),
( "danfx.utx" ),
( "davestextures.utx" ),
( "dday.uax" ),
( "ddayfx.utx" ),
( "de-logo.bmp" ),
( "de.int" ),
( "de.u" ),
( "debonusmeshes.usx" ),
( "debonustextures.utx" ),
( "debpchecker.usx" ),
( "debuggerlogo.bmp" ),
( "decayeds.utx" ),
( "december_cp.utx" ),
( "decorationprojectors.utx" ),
( "default.ini" ),
( "defaultfluid.utx" ),
( "defaults.uhtm" ),
( "defaults_bots.uhtm" ),
( "defaults_header.inc" ),
( "defaults_ippolicy-d.uhtm" ),
( "defaults_ippolicy-f.uhtm" ),
( "defaults_ippolicy-h.uhtm" ),
( "defaults_ippolicy.htm" ),
( "defaults_ippolicy_row.inc" ),
( "defaults_maps.htm" ),
( "defaults_maps.uhtm" ),
( "defaults_mark.inc" ),
( "defaults_menu.htm" ),
( "defaults_menu.uhtm" ),
( "defaults_menu_row.inc" ),
( "defaults_row.inc" ),
( "defaults_row_check.inc" ),
( "defaults_row_select.inc" ),
( "defaults_row_text.inc" ),
( "defaults_rules.htm" ),
( "defaults_rules.uhtm" ),
( "defaults_server.uhtm" ),
( "defaults_settings.uhtm" ),
( "defaultsframe.htm" ),
( "defopenal32.dll" ),
( "defunrealed.ini" ),
( "defuser.ini" ),
( "delete_me.txt" ),
( "demoplayerpictures.utx" ),
( "demoplayerskins.utx" ),
( "demutators-readme.txt" ),
( "deployabletex.utx" ),
( "derez.utx" ),
( "detail.utx" ),
( "detected.ini" ),
( "dinterface.dll" ),
( "dm-1on1-crash.ut2" ),
( "dm-1on1-mixer.ut2" ),
( "dm-agony.unr" ),
( "dm-antalus.ut2" ),
( "dm-arcanetemple.unr" ),
( "dm-asbestos.ut2" ),
( "dm-barricade.unr" ),
( "dm-bishop.unr" ),
( "dm-closer.unr" ),
( "dm-codex.unr" ),
( "dm-compressed.ut2" ),
( "dm-conveyor.unr" ),
( "dm-crane.unr" ),
( "dm-curse3.ut2" ),
( "dm-curse][.unr" ),
( "dm-cybrosis][.unr" ),
( "dm-de-grendelkeep.ut2" ),
( "dm-de-ironic.ut2" ),
( "dm-de-osiris2.ut2" ),
( "dm-deck16][.unr" ),
( "dm-fetid.unr" ),
( "dm-flux2.ut2" ),
( "dm-fractal.unr" ),
( "dm-gael.ut2" ),
( "dm-gothic.unr" ),
( "dm-grinder.unr" ),
( "dm-grit-tourney.unr" ),
( "dm-healpod][.unr" ),
( "dm-hyperblast.unr" ),
( "dm-icetomb.ut2" ),
( "dm-inferno.ut2" ),
( "dm-injector.ut2" ),
( "dm-insidious.ut2" ),
( "dm-irondeity.ut2" ),
( "dm-kgalleon.unr" ),
( "dm-leviathan.ut2" ),
( "dm-liandri.unr" ),
( "dm-malevolence.unr" ),
( "dm-mojo][.unr" ),
( "dm-morbias][.unr" ),
( "dm-morpheus.unr" ),
( "dm-oblivion.unr" ),
( "dm-oceanic.ut2" ),
( "dm-peak.unr" ),
( "dm-phobos.unr" ),
( "dm-phobos2.ut2" ),
( "dm-plunge.ut2" ),
( "dm-pressure.unr" ),
( "dm-pyramid.unr" ),
( "dm-rustatorium.ut2" ),
( "dm-serpentine.ut2" ),
( "dm-shrapnel][.unr" ),
( "dm-spacenoxx.unr" ),
( "dm-stalwart.unr" ),
( "dm-stalwartxl.unr" ),
( "dm-tempest.unr" ),
( "dm-tokaraforest.ut2" ),
( "dm-trainingday.ut2" ),
( "dm-turbine.unr" ),
( "dm-tutorial.unr" ),
( "dm-viridian-tourney.unr" ),
( "dm-zeto.unr" ),
( "dmatch.uax" ),
( "dmeffects.utx" ),
( "dom-bullet.unr" ),
( "dom-cidom.unr" ),
( "dom-cinder.unr" ),
( "dom-condemned.unr" ),
( "dom-core.ut2" ),
( "dom-cryptic.unr" ),
( "dom-gearbolt.unr" ),
( "dom-ghardhen.unr" ),
( "dom-goose.utx" ),
( "dom-junkyard.ut2" ),
( "dom-lament.unr" ),
( "dom-lament][.unr" ),
( "dom-leadworks.unr" ),
( "dom-metaldream.unr" ),
( "dom-olden.unr" ),
( "dom-outrigger.ut2" ),
( "dom-ruination.ut2" ),
( "dom-scorchedearth.ut2" ),
( "dom-sepukkugorge.ut2" ),
( "dom-sesmar.unr" ),
( "dom-suntemple.ut2" ),
( "dom-tutorial.unr" ),
( "dom-wolfsbay.unr" ),
( "doorsanc.uax" ),
( "doorsmod.uax" ),
( "e_pickups.usx" ),
( "editor.dll" ),
( "editor.int" ),
( "editor.u" ),
( "edsplash.bmp" ),
( "effectmeshes.usx" ),
( "egypt.utx" ),
( "egypt_tech_epic.utx" ),
( "egypt_techmeshes_epic.usx" ),
( "egyptpan.utx" ),
( "elecfeildsshine.utx" ),
( "emittertextures.utx" ),
( "emittertextures2.utx" ),
( "endgame-new.usx" ),
( "endgame.ut2" ),
( "endgameaudio.uax" ),
( "ending.umx" ),
( "endstatic.usx" ),
( "endtextures.utx" ),
( "engine.det" ),
( "engine.dll" ),
( "engine.est" ),
( "engine.frt" ),
( "engine.int" ),
( "engine.itt" ),
( "engine.u" ),
( "enigma.umx" ),
( "entry.unr" ),
( "entry.ut2" ),
( "eol.utx" ),
( "eol_assault.unr" ),
( "eol_challenge.unr" ),
( "eol_ctf.unr" ),
( "eol_deathmatch.unr" ),
( "eol_domination.unr" ),
( "eol_statues.unr" ),
( "epic_november2.usx" ),
( "epic_phobos.usx" ),
( "epic_phoboswing.utx" ),
( "epiccustommodels.u" ),
( "epicparticles.utx" ),
( "exitscreen.utx" ),
( "extro.uax" ),
( "face3_deco.utx" ),
( "face3_decomeshes.usx" ),
( "faces.utx" ),
( "factory.utx" ),
( "fcommandoskins.int" ),
( "fcommandoskins.utx" ),
( "female1skins.utx" ),
( "female1voice.uax" ),
( "female2skins.utx" ),
( "female2voice.uax" ),
( "femalesounds.uax" ),
( "fire.dll" ),
( "fire.u" ),
( "firebr.umx" ),
( "fireeng.utx" ),
( "fireengine.utx" ),
( "flags_279.gif" ),
( "flarefx.utx" ),
( "flyby-antalus.bat" ),
( "flyby-asbestos.bat" ),
( "flyby-citadel.bat" ),
( "flyby-endagra.bat" ),
( "flyby-face3.bat" ),
( "flyby-inferno.bat" ),
( "flyby-phobos2.bat" ),
( "flyby-suntemple.bat" ),
( "flybyexec.txt" ),
( "foliage.utx" ),
( "footer.inc" ),
( "foregone.umx" ),
( "fractalfx.utx" ),
( "frame_header.inc" ),
( "frame_message.htm" ),
( "futuretech1.utx" ),
( "g1.gif" ),
( "g10.gif" ),
( "g11.gif" ),
( "g12.gif" ),
( "g13.gif" ),
( "g14.gif" ),
( "g15.gif" ),
( "g16.gif" ),
( "g17.gif" ),
( "g18.gif" ),
( "g19.gif" ),
( "g2.gif" ),
( "g20.gif" ),
( "g21.gif" ),
( "g22.gif" ),
( "g23.gif" ),
( "g24.gif" ),
( "g25.gif" ),
( "g26.gif" ),
( "g27.gif" ),
( "g28.gif" ),
( "g29.gif" ),
( "g3.gif" ),
( "g30.gif" ),
( "g31.gif" ),
( "g32.gif" ),
( "g4.gif" ),
( "g5.gif" ),
( "g6.gif" ),
( "g7.gif" ),
( "g8.gif" ),
( "g9.gif" ),
( "g_finalset1_m_cp.usx" ),
( "g_legend.gif" ),
( "g_no.gif" ),
( "galaxy.dll" ),
( "galaxy.int" ),
( "gameplay.det" ),
( "gameplay.int" ),
( "gameplay.itt" ),
( "gameplay.u" ),
( "gamesounds.uax" ),
( "genearth.utx" ),
( "generalambience.uax" ),
( "generalimpacts.uax" ),
( "generalstatic.usx" ),
( "generalstatictextures.utx" ),
( "genfluid.utx" ),
( "genfx.utx" ),
( "genin.utx" ),
( "genterra.utx" ),
( "genwarp.utx" ),
( "geothermalstatic.usx" ),
( "geothermaltextures.utx" ),
( "glidedrv.dll" ),
( "glidedrv.int" ),
( "glsetup.106.exe" ),
( "godown.umx" ),
( "goldcubes.utx" ),
( "goose.usx" ),
( "goosefx.utx" ),
( "gothfem.utx" ),
( "gothskins.utx" ),
( "gotoheat.exe" ),
( "graph_back_ngstats.gif" ),
( "graph_back_ngstats_big.gif" ),
( "greatfire.utx" ),
( "greatfire2.utx" ),
( "groups_add.htm" ),
( "groups_browse.htm" ),
( "groups_edit.htm" ),
( "groups_row.inc" ),
( "gwotseffects.utx" ),
( "gwotstuff.utx" ),
( "h_e_l_ltx.utx" ),
( "h_fill.gif" ),
( "h_logo.jpg" ),
( "h_navseach.gif" ),
( "h_rgfx.jpg" ),
( "h_space.gif" ),
( "header.inc" ),
( "heat.ico" ),
( "help_using_ngstats.htm" ),
( "hidden.inc" ),
( "hideselected.bmp" ),
( "history.txt" ),
( "hubeffects.utx" ),
( "human.ka" ),
( "human_totals.htm" ),
( "humanfemalea.ukx" ),
( "humanmalea.ukx" ),
( "humanoidarchitecture.utx" ),
( "humanoidarchitecture2.utx" ),
( "humanoidhardware.usx" ),
( "humanoidhardwarebrush.utx" ),
( "icecliffs.usx" ),
( "ifc23.dll" ),
( "illumshaders.utx" ),
( "image.gif" ),
( "index.htm" ),
( "indoorambience.uax" ),
( "indus1.utx" ),
( "indus2.utx" ),
( "indus3.utx" ),
( "indus4.utx" ),
( "indus5.utx" ),
( "indus6.utx" ),
( "indus7.utx" ),
( "industrial.utx" ),
( "industrial_static.usx" ),
( "inoxxpack.txt" ),
( "instagibeffects.utx" ),
( "installerlogo.bmp" ),
( "interfacecontent.utx" ),
( "intro.ka" ),
( "intro_brock.ukx" ),
( "intro_brockfan.ukx" ),
( "intro_characters.utx" ),
( "intro_crowd.ukx" ),
( "intro_gorge.ukx" ),
( "intro_gorgefan.ukx" ),
( "intro_jugchick.ukx" ),
( "intro_lauren.ukx" ),
( "intro_malcom.ukx" ),
( "intro_music.ogg" ),
( "intro_nikoli.ukx" ),
( "introannouncers.uax" ),
( "introsounds.uax" ),
( "invertselections.bmp" ),
( "ipdrv.dll" ),
( "ipdrv.int" ),
( "ipdrv.u" ),
( "ipserver.int" ),
( "ipserver.u" ),
( "isvfx.utx" ),
( "jameseffects.utx" ),
( "jm-particl2.utx" ),
( "jm-prefabs.utx" ),
( "jugg.ka" ),
( "jugg.ukx" ),
( "jugs-entrance.ogg" ),
( "jwdecember.usx" ),
( "jwdecemberarchitecture.utx" ),
( "jwdecembersnd.uax" ),
( "jwsky.utx" ),
( "kr-assault.ogg" ),
( "kr-chemical-burn.ogg" ),
( "kr-collision-course.ogg" ),
( "kr-dm1.ogg" ),
( "kr-endingsequence.ogg" ),
( "kr-from-below-v2.ogg" ),
( "kr-ghosts-of-anubis.ogg" ),
( "kr-hell.ogg" ),
( "kr-infernal-realm.ogg" ),
( "kr-infiltrate.ogg" ),
( "kr-menumusic-v2.ogg" ),
( "kr-menumusic.ogg" ),
( "kr-pharaohs-revenge.ogg" ),
( "kr-skyscraper.ogg" ),
( "kr-slaughter.ogg" ),
( "kr-sniper-time.ogg" ),
( "kr-tomb-of-horus.ogg" ),
( "kr-ut2003-menu.ogg" ),
( "kr-wasteland.ogg" ),
( "ladderfonts.utx" ),
( "laddershots.utx" ),
( "laddersounds.uax" ),
( "ladrarrow.utx" ),
( "ladrstatic.utx" ),
( "lastmanstanding.utx" ),
( "lavafx.utx" ),
( "lavamlfx.utx" ),
( "lavaskyx.utx" ),
( "leathamfx.utx" ),
( "legal_terms.htm" ),
( "level11.ogg" ),
( "level13.ogg" ),
( "level15.ogg" ),
( "level16.ogg" ),
( "level2.ogg" ),
( "level3.ogg" ),
( "level5.ogg" ),
( "level6.ogg" ),
( "level7.ogg" ),
( "level8.ogg" ),
( "level9.ogg" ),
( "lian-x.utx" ),
( "lightningcoretex.utx" ),
( "liquids.utx" ),
( "lock.umx" ),
( "logo.bmp" ),
( "logo.gif" ),
( "logo.utx" ),
( "lp_evil1.usx" ),
( "lp_junk.usx" ),
( "lp_scene2_m.usx" ),
( "lp_scene3_m.usx" ),
( "lp_scene_1_t.utx" ),
( "m1-1.gif" ),
( "m1-2.gif" ),
( "m3-1.gif" ),
( "m3-2.gif" ),
( "mainmenu.htm" ),
( "mainmenu_item.inc" ),
( "mainmenu_itemd.inc" ),
( "mainmenu_items.inc" ),
( "male1skins.utx" ),
( "male1voice.uax" ),
( "male2skins.utx" ),
( "male2voice.uax" ),
( "male3skins.utx" ),
( "malesounds.uax" ),
( "mapthumbnails.utx" ),
( "maxdetail.ini" ),
( "maxdetailuser.ini" ),
( "mech8.umx" ),
( "mech_decay_new.utx" ),
( "mech_decayed.utx" ),
( "mechcity1_cp.utx" ),
( "mechstandard.utx" ),
( "menu.uhtm" ),
( "menu1.ogg" ),
( "menu_footer.inc" ),
( "menu_header.inc" ),
( "menueffects.utx" ),
( "menufooter.inc" ),
( "menugr.utx" ),
( "menuheader.inc" ),
( "menusounds.uax" ),
( "mercfemaletaunts.uax" ),
( "mercmaletaunts.uax" ),
( "mercs-entrance.ogg" ),
( "message.htm" ),
( "message.uhtm" ),
( "metaldrv.dll" ),
( "metaldrv.int" ),
( "metalmys.utx" ),
( "mikedemolevel.utx" ),
( "mindetail.ini" ),
( "mindetailuser.ini" ),
( "mine.utx" ),
( "mirrorx.bmp" ),
( "mirrory.bmp" ),
( "mirrorz.bmp" ),
( "miscepictex01.utx" ),
( "miscphysicsmeshes.usx" ),
( "miscphysicsmeshestex.utx" ),
( "mission.umx" ),
( "modeadd.bmp" ),
( "modeaddstaticmesh.bmp" ),
( "modeaddvolume.bmp" ),
( "modebrushclip.bmp" ),
( "modecamera.bmp" ),
( "modedeintersect.bmp" ),
( "modefacedrag.bmp" ),
( "modegeometry.bmp" ),
( "modeintersect.bmp" ),
( "modematinee.bmp" ),
( "modepolygon.bmp" ),
( "moderotate.bmp" ),
( "modescale.bmp" ),
( "modesubtract.bmp" ),
( "modeterrainedit.bmp" ),
( "modevertex.bmp" ),
( "mplayer.ico" ),
( "mplaynow.exe" ),
( "mplaynow.ini" ),
( "msvcr70.dll" ),
( "msvcrt.dll" ),
( "multimesh.int" ),
( "multimesh.u" ),
( "mutantskins.utx" ),
( "mutatorart.utx" ),
( "mylevel.u" ),
( "mylevel.uax" ),
( "mylevel.ukx" ),
( "mylevel.umx" ),
( "mylevel.usx" ),
( "mylevel.utx" ),
( "nalicast.utx" ),
( "nalifx.utx" ),
( "nether.umx" ),
( "newdeath.uax" ),
( "newtutorialsounds.uax" ),
( "ngstats.gif" ),
( "ngstats.ico" ),
( "ngstats_106_wide.gif" ),
( "ngstats_main.htm" ),
( "ngstats_processing.gif" ),
( "ngstatsut.cfg" ),
( "ngstatsut.exe" ),
( "ngtcs_129x114.gif" ),
( "ngtcs_lite_129x114.gif" ),
( "ngtcs_pro_129x114.gif" ),
( "ngusa_logo.gif" ),
( "ngusa_logo_106_wide.gif" ),
( "ngworldstats.exe" ),
( "ngworldstats.gif" ),
( "ngworldstats.ico" ),
( "ngworldstats_500x83.gif" ),
( "ngworldstats_enabled_234x46.gif" ),
( "ngworldstats_enabled_240x70.gif" ),
( "ngworldstats_enabled_88x31.gif" ),
( "ngworldstats_password.gif" ),
( "nivenfx.utx" ),
( "normalmaps.utx" ),
( "november2ship.utx" ),
( "noxxpack.utx" ),
( "noxxsnd.uax" ),
( "nvidiagorge.ukx" ),
( "nvidialogo.ut2" ),
( "nvidialogo_m.usx" ),
( "nvidialogo_t.utx" ),
( "nvidialogosounds.uax" ),
( "of1.utx" ),
( "ogg.dll" ),
( "oggplayer.int" ),
( "oggplayer.u" ),
( "old_fx.utx" ),
( "opengldrv.dll" ),
( "opengldrv.ini" ),
( "openingwave.uax" ),
( "organic.umx" ),
( "outdoorambience.uax" ),
( "packages.md5" ),
( "palettes.utx" ),
( "pan1.uax" ),
( "particlemeshes.usx" ),
( "phantom.umx" ),
( "phobos2_cp.utx" ),
( "phraelfx.utx" ),
( "pickupskins.utx" ),
( "pickupsounds.uax" ),
( "pipe_set.utx" ),
( "pipe_static.usx" ),
( "pipe_staticmeshes.usx" ),
( "pipetextures.utx" ),
( "player_index.htm" ),
( "playerfootsteps.uax" ),
( "playerpictures.utx" ),
( "playerskins.utx" ),
( "playersounds.uax" ),
( "playrshp.utx" ),
( "plungemeshes.usx" ),
( "privs_element.inc" ),
( "privs_element_ro.inc" ),
( "privs_header.inc" ),
( "privs_header_chk.inc" ),
( "processing.htm" ),
( "procmeshes.usx" ),
( "q_botleft.gif" ),
( "q_botmid.gif" ),
( "q_botright.gif" ),
( "q_left.gif" ),
( "q_mid.gif" ),
( "q_right.gif" ),
( "q_topleft.gif" ),
( "q_topmid.gif" ),
( "q_topright.gif" ),
( "queen.utx" ),
( "radio_button.inc" ),
( "rain.uax" ),
( "rainfx.utx" ),
( "rankings.htm" ),
( "razor-ub.umx" ),
( "readme-help_using_ngstats.htm" ),
( "readmedebonus.txt" ),
( "recent_index.htm" ),
( "releasenotes.htm" ),
( "relics.int" ),
( "relics.u" ),
( "relicsbindings.int" ),
( "relicsbindings.u" ),
( "render.dll" ),
( "render.utx" ),
( "reset_button.inc" ),
( "right.gif" ),
( "root.uhtm" ),
( "rootframe.htm" ),
( "rotatingu.utx" ),
( "row_center.inc" ),
( "row_left.inc" ),
( "run.umx" ),
( "running.ini" ),
( "runserver.bat" ),
( "sampleskin.int" ),
( "sampleskin.u" ),
( "saveme.umx" ),
( "savemeg.umx" ),
( "sc-city.utx" ),
( "sc-intro_meshes.usx" ),
( "sc_intro.utx" ),
( "sc_volcano_m.usx" ),
( "sc_volcano_t.utx" ),
( "scripted.utx" ),
( "seeker.umx" ),
( "seeker2.umx" ),
( "select.inc" ),
( "selectinside.bmp" ),
( "server_restart.htm" ),
( "server_restart_row.inc" ),
( "servericons.utx" ),
( "setup.det" ),
( "setup.est" ),
( "setup.exe" ),
( "setup.frt" ),
( "setup.int" ),
( "setup.itt" ),
( "setup.kot" ),
( "setup.smt" ),
( "setup.tmt" ),
( "sg-mech.utx" ),
( "sg_floorsandgrates_alpha.utx" ),
( "sg_lo_meshes.usx" ),
( "sg_lost_outpost.utx" ),
( "sg_special.usx" ),
( "sg_special_decos.utx" ),
( "sg_ut2003_jumpboots.utx" ),
( "sg_ut2003_pickups.usx" ),
( "sgirlskins.int" ),
( "sgirlskins.utx" ),
( "sgldrv.dll" ),
( "sgldrv.int" ),
( "sgtech1.utx" ),
( "shanechurch.utx" ),
( "shaneday.utx" ),
( "shanedemohead.utx" ),
( "shanejungle.utx" ),
( "shanesky.utx" ),
( "shiptech.utx" ),
( "shiptech2.utx" ),
( "shiptechhardware.usx" ),
( "shiptechhardwarebrush.utx" ),
( "showall.bmp" ),
( "showselected.bmp" ),
( "sidebar_120x90.gif" ),
( "singleplayerthumbs.utx" ),
( "skaarj.utx" ),
( "skaarjpack.det" ),
( "skaarjpack.est" ),
( "skaarjpack.frt" ),
( "skaarjpack.int" ),
( "skaarjpack.itt" ),
( "skaarjpack.kot" ),
( "skaarjpack.tmt" ),
( "skaarjpack.u" ),
( "skaarjpack_rc.u" ),
( "skaarjpackskins.utx" ),
( "skeletalchars.int" ),
( "skeletalchars.u" ),
( "skies.utx" ),
( "skin.css" ),
( "skin_credit_88x31.gif" ),
( "sktrooperskins.utx" ),
( "skybox.utx" ),
( "skycity.utx" ),
( "skyline-epic.utx" ),
( "skyline-meshes-epic.usx" ),
( "skyrenders.utx" ),
( "skyward.umx" ),
( "slaughtersounds.uax" ),
( "slums.utx" ),
( "snjawt11.dll" ),
( "snjrt11.dll" ),
( "softdrv.dll" ),
( "soldierskins.int" ),
( "soldierskins.utx" ),
( "spacefx.utx" ),
( "spawnbrowser.exe" ),
( "stagemusic.ogg" ),
( "starship.utx" ),
( "startup.int" ),
( "strider.umx" ),
( "submit_button.inc" ),
( "suprfist.umx" ),
( "survivalguidemeshes.usx" ),
( "survivalguidesmskins.utx" ),
( "t.gif" ),
( "tauntpack.uax" ),
( "tcowmeshskins.int" ),
( "tcowmeshskins.utx" ),
( "tcrystal.utx" ),
( "teamsymbols.utx" ),
( "teamsymbols_ut2003.int" ),
( "teamsymbols_ut2003.utx" ),
( "terrain2.utx" ),
( "terranius.utx" ),
( "textbox.inc" ),
( "texturepan.bmp" ),
( "texturerotate.bmp" ),
( "tnalimeshskins.int" ),
( "tnalimeshskins.utx" ),
( "top_begin.inc" ),
( "top_end.inc" ),
( "total_index.htm" ),
( "towerstatic.usx" ),
( "towerterrain.utx" ),
( "trenchesfx.utx" ),
( "troffhardware.usx" ),
( "trophy_endroom.usx" ),
( "trophyroom_end.utx" ),
( "tskmskins.int" ),
( "tskmskins.utx" ),
( "tut-br.ut2" ),
( "tut-ctf.ut2" ),
( "tut-dm.ut2" ),
( "tut-dom.ut2" ),
( "tutorialsounds.uax" ),
( "tutvoiceas.uax" ),
( "tutvoicectf.uax" ),
( "tutvoicedm.uax" ),
( "tutvoicedom.uax" ),
( "ubrowser.int" ),
( "ubrowser.u" ),
( "ucc.exe" ),
( "ucgamespecific.utx" ),
( "ucgeneric.utx" ),
( "udebugger.exe" ),
( "udnhelptopics.ini" ),
( "umenu.int" ),
( "umenu.u" ),
( "unreal.ico" ),
( "unrealed.exe" ),
( "unrealed.ico" ),
( "unrealed.ini" ),
( "unrealed.int" ),
( "unrealed.u" ),
( "unrealeddll.dll" ),
( "unrealedinstaller.exe" ),
( "unrealedtips.ini" ),
( "unrealgame.det" ),
( "unrealgame.est" ),
( "unrealgame.frt" ),
( "unrealgame.int" ),
( "unrealgame.itt" ),
( "unrealgame.kot" ),
( "unrealgame.smt" ),
( "unrealgame.tmt" ),
( "unrealgame.u" ),
( "unreali.int" ),
( "unreali.u" ),
( "unreallogo.gif" ),
( "unrealshare.int" ),
( "unrealshare.u" ),
( "unrealtournament.exe" ),
( "unrealtournament.ini" ),
( "unrealtournament.int" ),
( "unrealtournamentlogo.bmp" ),
( "unrealtournamentsetuplogo.bmp" ),
( "unworld2.umx" ),
( "user.ini" ),
( "users.htm" ),
( "users_add.htm" ),
( "users_browse.htm" ),
( "users_edit.htm" ),
( "users_groups.htm" ),
( "users_groups_row.inc" ),
( "users_row.inc" ),
( "ut-logo-map.unr" ),
( "ut.utx" ),
( "ut2-intro.ut2" ),
( "ut2003.css" ),
( "ut2003.exe" ),
( "ut2003.ini" ),
( "ut2003.int" ),
( "ut2003fonts.utx" ),
( "ut2003logo.bmp" ),
( "ut2003stats.css" ),
( "ut_artfx.utx" ),
( "ut_logo_large_button.gif" ),
( "ut_logo_small_button.gif" ),
( "utbase1.utx" ),
( "utbrowser.u" ),
( "utclassic.int" ),
( "utclassic.u" ),
( "utcredits.unr" ),
( "utcrypt.utx" ),
( "utmenu.int" ),
( "utmenu.u" ),
( "utmenu23.umx" ),
( "utserveradmin.int" ),
( "utserveradmin.u" ),
( "uttech1.utx" ),
( "uttech2.utx" ),
( "uttech3.utx" ),
( "uttitle.umx" ),
( "uweb.dll" ),
( "uweb.int" ),
( "uweb.kot" ),
( "uweb.smt" ),
( "uweb.tmt" ),
( "uweb.u" ),
( "uwindow.u" ),
( "uwindowfonts.utx" ),
( "vehicledemo.ut2" ),
( "vehiclefx.utx" ),
( "vehiclemeshes.usx" ),
( "vehicles.u" ),
( "vehicleskins.utx" ),
( "view_ngstats.gif" ),
( "view_ngworldstats.gif" ),
( "vorbis.dll" ),
( "vorbisfile.dll" ),
( "vrikers.uax" ),
( "wareffectstextures.utx" ),
( "warfx.utx" ),
( "warroomtech.utx" ),
( "wastelandhardware.usx" ),
( "weapons.ukx" ),
( "weaponskins.utx" ),
( "weaponsounds.uax" ),
( "weaponstaticmesh.usx" ),
( "wheels.umx" ),
( "white.gif" ),
( "whiteheader.inc" ),
( "window.det" ),
( "window.dll" ),
( "window.est" ),
( "window.frt" ),
( "window.int" ),
( "window.itt" ),
( "window.kot" ),
( "window.smt" ),
( "window.tmt" ),
( "windrv.dll" ),
( "windrv.int" ),
( "wm-staticmesh.usx" ),
( "wm_meshes.usx" ),
( "wm_misc.utx" ),
( "wm_sounds.uax" ),
( "wm_textures.utx" ),
( "xadmin.int" ),
( "xadmin.u" ),
( "xbpfx.utx" ),
( "xceptone.utx" ),
( "xceptoneobja.usx" ),
( "xceptthree.utx" ),
( "xcepttwo.utx" ),
( "xeffectmat.utx" ),
( "xeffects.u" ),
( "xfx.utx" ),
( "xgame.det" ),
( "xgame.dll" ),
( "xgame.est" ),
( "xgame.frt" ),
( "xgame.int" ),
( "xgame.itt" ),
( "xgame.kot" ),
( "xgame.smt" ),
( "xgame.tmt" ),
( "xgame.u" ),
( "xgame_rc.u" ),
( "xgame_staticmeshes.usx" ),
( "xgameshaders.utx" ),
( "xgameshadersb.utx" ),
( "xgametextures.utx" ),
( "xinterface.det" ),
( "xinterface.dll" ),
( "xinterface.est" ),
( "xinterface.frt" ),
( "xinterface.int" ),
( "xinterface.itt" ),
( "xinterface.kot" ),
( "xinterface.smt" ),
( "xinterface.tmt" ),
( "xinterface.u" ),
( "xmaps.det" ),
( "xmaps.est" ),
( "xmaps.int" ),
( "xmisceffects.utx" ),
( "xpickups.int" ),
( "xpickups.u" ),
( "xpickups_rc.u" ),
( "xplanttextures.utx" ),
( "xplayers.int" ),
( "xplayersl1.upl" ),
( "xtortion.utx" ),
( "xutfx.utx" ),
( "xweapons.det" ),
( "xweapons.est" ),
( "xweapons.frt" ),
( "xweapons.int" ),
( "xweapons.itt" ),
( "xweapons.u" ),
( "xweapons_rc.u" ),
( "xwebadmin.int" ),
( "xwebadmin.u" );

# ################################################################
# EOF: UTCMS_deny.sql
# ################################################################
