# ################################################################
# UTCMS_faqq.sql
# Creates faqq table - contains FAQ Questions
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ref from: faqa
# refers  :	faqt
#
# ################################################################
# Field descriptions
# ################################################################
# faqq_idnt		Record identifier, used to reference a faqq
# faqq_auth		Author name of this FAQ
# faqq_time		Time when written
# faqq_head		Header text (title if you like)
# faqq_ques		The question text reference

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS faqq;

# ################################################################
# Create the faqq table and it's indexes
# ################################################################
CREATE TABLE faqq (
	faqq_idnt	INTEGER			NOT NULL	DEFAULT 0,
	faqq_auth	CHAR(100)		NOT NULL,
	faqq_time	DATETIME		NOT NULL,
	faqq_head	CHAR(200)		NOT NULL,
	faqq_ques	INTEGER			NOT NULL	DEFAULT 0,
	PRIMARY KEY ( faqq_idnt )
);

CREATE INDEX		faqq_auth_ix		ON faqq ( faqq_auth );
CREATE INDEX		faqq_time_ix		ON faqq ( faqq_time );
CREATE INDEX		faqq_head_ix		ON faqq ( faqq_head );
CREATE UNIQUE INDEX	faqq_ques_ix		ON faqq ( faqq_ques );

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON faqq TO quest@localhost;

FLUSH PRIVILEGES;

# ################################################################
# EOF: UTCMS_faqq.sql
# ################################################################
