# ################################################################
# UTCMS_file.sql
# Creates file table
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ref from: packfile(packfile_file), xref(xref_file)
# refers  : auth(file_auth), type(file_type), user(file_user)
#
# ################################################################
# Field descriptions
# ################################################################
# file_idnt		Record identifier, used to reference a file
# file_auth		Owner of this file
# file_type		Type of the file
# file_typ1		Primary type, string form
# file_ctgr		Category
# file_typ2		Secondary type, string form
# file_name		Real name of the file
# file_suff		Suffix of the file (no dot included)
# file_vers		Version number
# file_csum		Checksum of the file, used to find identical files
# file_ctim		Creation time
# file_mtim		Modification time
# file_atim		Arrival time
# file_ltim		Last access time
# file_size		Size of the file
# file_psiz		Packed size of the file
# file_lcnt		Load count
# file_flag		Common flags - see CMySqlData.hxx
# file_data		Absolute path to the gzipped file image
# file_user		Indentifier of the owner of this file
# file_rate		Readily calculated rate for the file - range 0 ... 10000
# file_rat0		Number of bad klicks for this file
# file_rat1		Number of average klicks for this file
# file_rat2		Number of good klicks for this file
# file_dlct		Download count
# file_plct		Played count


# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS file;

# ################################################################
# Create the file table and it's indexes
# ################################################################
CREATE TABLE file (
	file_idnt	INTEGER			NOT NULL	DEFAULT 0,
	file_auth	INTEGER			NOT NULL	DEFAULT 0,
	file_type	INTEGER			NOT NULL	DEFAULT 0,
	file_typ1	CHAR(8)			NOT NULL,
	file_ctgr	CHAR(64)		NOT NULL,
	file_typ2	CHAR(16)		NOT NULL,
	file_name	CHAR(100)		NOT NULL,
	file_suff	CHAR(32)		NOT NULL,
	file_vers	INTEGER			NOT NULL	DEFAULT 0,
	file_csum	CHAR(100)		NOT NULL,
	file_ctim	DATETIME		NOT NULL,
	file_mtim	DATETIME		NOT NULL,
	file_atim	DATETIME		NOT NULL,
	file_ltim	DATETIME		NOT NULL,
	file_size	INTEGER			NOT NULL	DEFAULT 0,
	file_psiz	INTEGER			NOT NULL	DEFAULT 0,
	file_lcnt	INTEGER			NOT NULL	DEFAULT 0,
	file_flag	INTEGER			NOT NULL	DEFAULT 0,
	file_data	CHAR(64)		NOT NULL,
	file_user	INTEGER			NOT NULL	DEFAULT 0,
	file_rate	INTEGER			NOT NULL	DEFAULT 0,
	file_rat0	INTEGER			NOT NULL	DEFAULT 0,
	file_rat1	INTEGER			NOT NULL	DEFAULT 0,
	file_rat2	INTEGER			NOT NULL	DEFAULT 0,
	file_dlct	INTEGER			NOT NULL	DEFAULT 0,
	file_plct	INTEGER			NOT NULL	DEFAULT 0,
	PRIMARY KEY ( file_idnt )
);

CREATE UNIQUE INDEX		file_name_csum_ix	ON file ( file_name, file_suff, file_csum );
CREATE INDEX			file_auth_ix		ON file ( file_auth );
CREATE INDEX			file_type_ix		ON file ( file_type );
CREATE INDEX			file_typ1_ix		ON file ( file_typ1 );
CREATE INDEX			file_typ2_ix		ON file ( file_typ2 );
CREATE INDEX			file_csum_ix		ON file ( file_csum );
CREATE INDEX			file_data_ix		ON file ( file_data );
CREATE INDEX			file_ctim_ix		ON file ( file_ctim );
CREATE INDEX			file_mtim_ix		ON file ( file_mtim );
CREATE INDEX			file_atim_ix		ON file ( file_atim );
CREATE INDEX			file_ltim_ix		ON file ( file_ltim );
CREATE INDEX			file_size_ix		ON file ( file_size );
CREATE INDEX			file_lcnt_ix		ON file ( file_lcnt );
CREATE INDEX			file_name_ix		ON file ( file_name );
CREATE INDEX			file_user_ix		ON file ( file_user );
CREATE INDEX			file_ctgr_ix		ON file ( file_ctgr );
CREATE INDEX			file_rate_ix		ON file ( file_rate );
CREATE INDEX			file_dlct_ix		ON file ( file_dlct );

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON file TO quest@localhost;

FLUSH PRIVILEGES;


# ################################################################
# EOF: UTCMS_file.sql
# ################################################################
