# ################################################################
# UTCMS_menu.sql
# Creates menu table
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ref from: 
# refers  : file(menu_file)
#
# ################################################################
# Field descriptions
# ################################################################
# menu_name Name of this entry
# menu_ordr Used to order the menu's inside one selection
# menu_pnam Parent entry name of this entry
# menu_pord	Parent entry order of this entry
# menu_text Text appearing as the link (use absolute url for images)
# menu_onst CSS class for on style of the menu text
# menu_ofst CSS class for off style of the menu text
# menu_link URL
# menu_titl Title
# menu_ttst CSS class for title line
# menu_brfn	Briefing for this menu
# menu_brst CSS class for briefing portion

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS menu;

# ################################################################
# Create the menu table and it's indexes
# ################################################################
CREATE TABLE menu (
	menu_name	CHAR(32)		NOT NULL,
	menu_ordr	INTEGER			NOT NULL	DEFAULT 0,
	menu_pnam	CHAR(32)		NOT NULL,
	menu_pord	INTEGER			NOT NULL	DEFAULT 0,
	menu_text	CHAR(100)		NOT NULL,
	menu_onst	CHAR(32)		NOT NULL,
	menu_ofst	CHAR(32)		NOT NULL,
	menu_link	CHAR(250)		NOT NULL,
	menu_titl	CHAR(250)		NOT NULL,
	menu_ttst	CHAR(32)		NOT NULL,
	menu_brfn	CHAR(250)		NOT NULL,
	menu_brst	CHAR(32)		NOT NULL,

	PRIMARY KEY ( menu_name, menu_ordr )
);

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON menu TO quest@localhost;

FLUSH PRIVILEGES;

# ################################################################
# Special cases: Log in and Log out buttons
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"menulogin",	0,	"none",	0,	"Login",	"buttonup",	"buttonup",
	"/UTCMS/login/?task=1&forw=/UTCMS/",
	"Log into UTCMS", 	"menubanner",
	"",	"" ),

(	"menulogout",	0,	"none",	0,	"Logout",	"buttonup",	"buttonup",
	"/UTCMS/login/?task=0&forw=/UTCMS/",
	"Log out of UTCMS",	"",
	"",	"" );

# ################################################################
# Root menu
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"root",		1,	"",	0,	"Links",		"buttondn",	"buttonup",
	"/UTCMS/home/links/",
	"UTCMS Link Database", 					"menubanner",
	"",	"" ),

(	"root",		2,	"",	0,	"News",			"buttondn",	"buttonup",
	"/UTCMS/news/",
	"News", 								"",
	"",	"" ),

(	"root",		3,	"",	0,	"Files",		"buttondn",	"buttonup",
	"/UTCMS/files/",
	"Files", 								"menubanner",
	"",	"" ),

(	"root",		4,	"",	0,	"Documents",	"buttondn",	"buttonup",
	"/UTCMS/documents/",
	"Documentation",  						"menubanner",
	"",	"" ),

(	"root",		5,	"",	0,	"TOP-100",		"buttondn",	"buttonup",
	"/UTCMS/top10/",
	"TOP 100",								"menubanner",
	"",	"" ),

(	"root",		6,	"",	0,	"Servers",		"buttondn",	"buttonup",
	"/UTCMS/servers/",
	"Game servers known to UTCMS",			"menubanner",
	"",	"" ),

(	"root",		7,	"",	0,	"Mail",			"buttondn",	"buttonup",
	"/webmail/",
	"Webmail system @ furpile.com",			"",
	"",	"" );

# ################################################################
# Document menu
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"document",		1,	"root",	4,	"Cheat",	"buttondn",	"buttonup",
	"/UTCMS/documents/cheating/",
	"Cheating",	"menubanner",
	"",	"" ),

(	"document",		2,	"root",	4,	"Edit",		"buttondn",	"buttonup",
	"/UTCMS/documents/editing/",
	"Editing Tutorials", "menubanner",
	"",	"" ),

(	"document",		3,	"root",	4,	"Modl",		"buttondn",	"buttonup",
	"/UTCMS/documents/modeling/",
	"Modeling Tutorials",	"menubanner",
	"",	"" ),

(	"document",		4,	"root",	4,	"Play",		"buttondn",	"buttonup",
	"/UTCMS/documents/playing/",
	"Playing Tips",	"menubanner",
	"", "" ),

(	"document",		5,	"root",	4,	"Prog",		"buttondn",	"buttonup",
	"/UTCMS/documents/programming/",
	"Programming Documents", "",
	"",	"" ),

(	"document",		6,	"root",	4,	"Srcp",		"buttondn",	"buttonup",
	"/UTCMS/documents/scripting/",
	"Scripting Tutorials",	"",
	"",	"" ),

(	"document",		7,	"root",	4,	"Serv",		"buttondn",	"buttonup",
	"/UTCMS/documents/server/",
	"Server Admin Tutorials", "menubanner",
	"",	"" ),

(	"document",		8,	"root",	4,	"Skin",		"buttondn",	"buttonup",
	"/UTCMS/documents/skinning/",
	"Skinnig Tutorials", "menubanner",
	"", "" ),

(	"document",		9,	"root",	4,	"UTCMS",	"buttondn",	"buttonup",
	"/UTCMS/documents/UTCMS/",
	"UTCMS Site documentation", "menubanner",
	"",	"" ),

(	"document",		10,	"root",	4,	"Misc",		"buttondn",	"buttonup",
	"/UTCMS/documents/other/",
	"Miscallaneous Documents", "",
	"",	"" );

# ################################################################
# EditDoc menu
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"editdoc",		1,	"document",	2,	"UED1",	"buttondn",	"buttonup",
	"/UTCMS/documents/editing/UED1/",
	"Editing with UED1", "",
	"",	"" ),

(	"editdoc",		2,	"document",	2,	"UED2",	"buttondn",	"buttonup",
	"/UTCMS/documents/editing/UED2/",
	"Editing with UED2", "",
	"",	"" ),

(	"editdoc",		3,	"document",	2,	"UED3",	"buttondn",	"buttonup",
	"/UTCMS/documents/editing/UED3/",
	"Editing with UED3", "",
	"",	"" ),

(	"editdoc",		4,	"document",	2,	"Misc",	"buttondn",	"buttonup",
	"/UTCMS/documents/editing/other/",
	"Miscallaneous editing documents", "",
	"",	"" );

# ################################################################
# ModelDoc menu
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"modeldoc",		1,	"document",	3,	"UED1",	"buttondn",	"buttonup",
	"/UTCMS/documents/modeling/UED1/",
	"Modeling with UED1", "",
	"",	"" ),

(	"modeldoc",		2,	"document",	3,	"UED2",	"buttondn",	"buttonup",
	"/UTCMS/documents/modeling/UED2/",
	"Modeling with UED2", "",
	"",	"" ),

(	"modeldoc",		3,	"document",	3,	"UED3",	"buttondn",	"buttonup",
	"/UTCMS/documents/modeling/UED3/",
	"Modeling with UED3", "",
	"",	"" ),

(	"modeldoc",		4,	"document",	3,	"Misc",	"buttondn",	"buttonup",
	"/UTCMS/documents/modeling/other/",
	"Miscallaneous modeling documents", "",
	"",	"" );

# ################################################################
# PlayDoc menu
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"playdoc",		1,	"document",	4,	"Unreal",	"buttondn",	"buttonup",
	"/UTCMS/documents/playing/U1/",
	"Playing Unreal", "",
	"",	"" ),

(	"playdoc",		2,	"document",	4,	"UT",	"buttondn",	"buttonup",
	"/UTCMS/documents/playing/UT/",
	"Playing UT", "",
	"",	"" ),

(	"playdoc",		3,	"document",	4,	"UT 2003",	"buttondn",	"buttonup",
	"/UTCMS/documents/playing/UT2k3/",
	"Playing UT 2003", "",
	"",	"" ),

(	"playdoc",		4,	"document",	4,	"Misc",	"buttondn",	"buttonup",
	"/UTCMS/documents/playing/other/",
	"Other Playing Tutorials", "",
	"",	"" );

# ################################################################
# ServerDoc menu
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"serverdoc",	1,	"document",	7,	"Unreal",	"buttondn",	"buttonup",
	"/UTCMS/documents/server/U1/",
	"Administering Unreal Server", "",
	"",	"" ),

(	"serverdoc",	2,	"document",	7,	"UT",	"buttondn",	"buttonup",
	"/UTCMS/documents/server/UT/",
	"Administering UT Server", "",
	"",	"" ),

(	"serverdoc",	3,	"document",	7,	"UT 2003",	"buttondn",	"buttonup",
	"/UTCMS/documents/server/UT2k3/",
	"Administering UT 2003 Server", "",
	"",	"" ),

(	"serverdoc",	4,	"document",	7,	"Misc",	"buttondn",	"buttonup",
	"/UTCMS/documents/server/other/",
	"Other Server Tutorials", "",
	"",	"" );

# ################################################################
# SkinDoc menu
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"skindoc",		1,	"document",	8,	"UED1",	"buttondn",	"buttonup",
	"/UTCMS/documents/skinning/UED1/",
	"Skinning with UED1", "",
	"",	"" ),

(	"skindoc",		2,	"document",	8,	"UED2",	"buttondn",	"buttonup",
	"/UTCMS/documents/skinning/UED2/",
	"Skinning with UED2", "",
	"",	"" ),

(	"skindoc",		3,	"document",	8,	"UED3",	"buttondn",	"buttonup",
	"/UTCMS/documents/skinning/UED3/",
	"Skinning with UED3", "",
	"",	"" ),

(	"skindoc",		4,	"document",	8,	"Misc",	"buttondn",	"buttonup",
	"/UTCMS/documents/skinning/other/",
	"Other Skinning Tutorials", "",
	"",	"" );

# ################################################################
# UTCMS Doc menu
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES

(	"utcmsdoc",		1,	"document",	9,	"Packing",	"buttondn",	"buttonup",
	"/UTCMS/documents/UTCMS/Packing/",
	"How to pack Your map for UTCMS", "menubanner",
	"",	"" ),

(	"utcmsdoc",		2,	"document",	9,	"Uploading",	"buttondn",	"buttonup",
	"/UTCMS/documents/UTCMS/Uploading/",
	"How to upload Your map to UTCMS", "menubanner",
	"",	"" ),

(	"utcmsdoc",		3,	"document",	9,	"Previews",	"buttondn",	"buttonup",
	"/UTCMS/documents/UTCMS/Previews/",
	"Using UTCMS preview services", "menubanner",
	"",	"" ),

(	"utcmsdoc",		4,	"document",	9,	"Downloads",	"buttondn",	"buttonup",
	"/UTCMS/documents/UTCMS/Downloads/",
	"Using UTCMS download services", "menubanner",
	"",	"" ),

(	"utcmsdoc",		5,	"document",	9,	"Advertising",	"buttondn",	"buttonup",
	"/UTCMS/documents/UTCMS/Advertising/",
	"Using UTCMS news system for advertising", "menubanner",
	"",	"" );


# ################################################################
# Filemenu
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"file",		1,	"root",	3,	"Essential",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/",
	"Essential Files",	"menubanner",
	"",	"" ),

(	"file",		2,	"root",	3,	"Search",	"buttondn",	"buttonup",
	"/UTCMS/files/search/",
	"Search for files",	"",
	"",	"" ),

(	"file",		3,	"root",	3,	"Submit",	"buttondn",	"buttonup",
	"/UTCMS/files/upload/",
	"Upload File",	"menubanner",
	"",	"" ),

(	"file",		4,	"root",	3,	"MOD",		"buttondn",	"buttonup",
	"/UTCMS/files/mod/",
	"Game modifications",	"menubanner",
	"",	"" );

# ################################################################
# Essential menu
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"essential",	1,	"file",	1,	"Bonus",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/bonus/",
	"Bonus Packs",	"menubanner",
	"",	"" ),

(	"essential",	2,	"file",	1,	"Patch",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/patches/",
	"Software Updates",	"menubanner",
	"",	"" ),

(	"essential",	3,	"file",	1,	"Demo",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/demo/",
	"Working Demo Games",	"",
	"",	"" ),

(	"essential",	4,	"file",	1,	"Server",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/server/",
	"Free Server Software",	"menubanner",
	"",	"" ),

(	"essential",	5,	"file",	1,	"Tools",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/tools/",
	"Tool Chest",	"menubanner",
	"",	"" ),

(	"essential",	6,	"file",	1,	"Deco",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/deco/",
	"Desktop Decorations",	"",
	"",	"" ),

(	"essential",	7,	"file",	1,	"Trail",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/trailers/",
	"Trailers and Teasers",	"menubanner",
	"",	"" ),

(	"essential",	8,	"file",	1,	"Gallery",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/gallery/",
	"Pictures at an Exhibition",	"menubanner",
	"",	"" );

# ################################################################
# Bonus pack menu
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"bonus",	1,	"essential",	1,	"Unreal",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/bonus/U1/",
	"Bonus Packs for Unreal",	"",
	"",	"" ),

(	"bonus",	2,	"essential",	1,	"UT",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/bonus/UT/",
	"Bonus Packs for Unreal Tournament",	"",
	"",	"" ),

(	"bonus",	3,	"essential",	1,	"UT 2003",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/bonus/UT2k3/",
	"Bonus Packs for Unreal Tournament 2003",	"",
	"",	"" );


# ################################################################
# Patches menu
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"patch",	1,	"essential",	2,	"Unreal",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/patches/U1/",
	"Game Patches for Unreal Retail",	"",
	"",	"" ),

(	"patch",	2,	"essential",	2,	"UT Demo",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/patches/UTD/",
	"Game Patches for Unreal Tournament Demo",	"",
	"",	"" ),

(	"patch",	3,	"essential",	2,	"UT",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/patches/UT/",
	"Game Patches for Unreal Tournament Retail",	"",
	"",	"" ),

(	"patch",	4,	"essential",	2,	"UT 2003 Demo",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/patches/UT2k3D/",
	"Game Patches for Unreal Tournament 2003 Demo",	"",
	"",	"" ),

(	"patch",	5,	"essential",	2,	"UT 2003",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/patches/UT2k3",
	"Game Patches for Unreal Tournament 2003 Retail",	"",
	"",	"" );

# ################################################################
# Servers
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"servers",	1,	"essential",	4,	"Unreal",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/server/U1/",
	"Free Server Software for Unreal",	"",
	"",	"" ),

(	"servers",	2,	"essential",	4,	"UT",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/server/UT/",
	"Free Server Software for Unreal Tournament",	"",
	"",	"" ),

(	"servers",	3,	"essential",	4,	"UT 2003",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/server/UT2k3/",
	"Free Server Software for Unreal Tournament 2003",	"",
	"",	"" );

# ################################################################
# Tools
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES

(	"tools",	1,	"essential",	5,	"Edit",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/tools/editing/",
	"Editing Tools",	"menubanner",
	"",	"" ),

(	"tools",	2,	"essential",	5,	"Conf",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/tools/configuring/",
	"Configuring Tools",	"",
	"",	"" ),

(	"tools",	3,	"essential",	5,	"Cache",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/tools/cache/",
	"Cache Managers",	"",
	"",	"" ),

(	"tools",	4,	"essential",	5,	"Conv",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/tools/converting/",
	"Conversion Tools",	"",
	"",	"" ),

(	"tools",	5,	"essential",	5,	"IDE",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/tools/ide/",
	"Integrated Development Environment",	"",
	"",	"" ),

(	"tools",	6,	"essential",	5,	"Pack",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/tools/packing/",
	"Packing Tools",	"",
	"",	"" ),

(	"tools",	7,	"essential",	5,	"Prog",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/tools/programming/",
	"Programming Tools",	"",
	"",	"" ),

(	"tools",	8,	"essential",	5,	"Leech",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/tools/leeching/",
	"Leeching Tools",	"",
	"",	"" ),

(	"tools",	9,	"essential",	5,	"TOST",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/tools/tost/",
	"Tactical Ops Server Tool",	"",
	"",	"" );

# ################################################################
# Edit tools
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"editools",	1,	"tools",	1,	"UED1",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/tools/editing/UED1/",
	"Editing Tools for UED1",	"",
	"",	"" ),

(	"editools",	2,	"tools",	1,	"UED2",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/tools/editing/UED2/",
	"Editing Tools for UED2",	"",
	"",	"" ),

(	"editools",	3,	"tools",	1,	"UED3",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/tools/editing/UED3/",
	"Editing Tools for UED3",	"",
	"",	"" ),

(	"editools",	4,	"tools",	1,	"Other",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/tools/editing/other/",
	"Other Editing Tools",	"",
	"",	"" );


# ################################################################
# Packing tools
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"packtools",	1,	"tools",	6,	"Unreal Packer",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/tools/packing/UnrealPacker/",
	"Unreal Packer",	"",
	"",	"" ),

(	"packtools",	2,	"tools",	6,	"Unreal Remover",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/tools/packing/UnrealDelete/",
	"Unreal Map Remover",	"",
	"",	"" ),

(	"packtools",	3,	"tools",	6,	"Other",		"buttondn",	"buttonup",
	"/UTCMS/files/essential/tools/packing/other/",
	"Other Packing Tools",	"",
	"",	"" );


# ################################################################
# Trailers
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"trailers",	1,	"essential",	7,	"Unreal",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/trailers/U1/",
	"Trailers and Teasers for Unreal",	"",
	"",	"" ),

(	"trailers",	2,	"essential",	7,	"UT",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/trailers/UT/",
	"Trailers and Teasers for UT",	"",
	"",	"" ),

(	"trailers",	3,	"essential",	7,	"UT 2003",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/trailers/UT2k3/",
	"Trailers and Teasers for UT 2003",	"",
	"",	"" ),

(	"trailers",	4,	"essential",	7,	"Other",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/trailers/other/",
	"Other Trailers and Teasers",	"",
	"",	"" );

# ################################################################
# Gallery
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"gallery",	1,	"essential",	8,	"Unreal",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/gallery/U1/",
	"Pictures at an Unreal Exhibition",	"",
	"",	"" ),

(	"gallery",	2,	"essential",	8,	"UT",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/gallery/UT/",
	"Pictures at an UT Exhibition",	"",
	"",	"" ),

(	"gallery",	3,	"essential",	8,	"UT 2003",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/gallery/UT2k3/",
	"Pictures at an UT 2003 Exhibition",	"",
	"",	"" ),

(	"gallery",	4,	"essential",	8,	"Other",	"buttondn",	"buttonup",
	"/UTCMS/files/essential/gallery/other/",
	"Pictures at an other Exhibition",	"",
	"",	"" );

# ################################################################
# Links menu
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"links",	1,	"root",	1,	"Clans",		"buttondn",	"buttonup",
	"/UTCMS/home/links/clans/",
	"Clan Sites", "",
	"",	"" ),

(	"links",	2,	"root",	1,	"Fan",			"buttondn",	"buttonup",
	"/UTCMS/home/links/fan/",
	"Fan Sites", "",
	"",	"" ),

(	"links",	3,	"root",	1,	"Files",			"buttondn",	"buttonup",
	"/UTCMS/home/links/files/",
	"Sitten with a lot of files", "",
	"",	"" ),

(	"links",	4,	"root",	1,	"General",			"buttondn",	"buttonup",
	"/UTCMS/home/links/general/",
	"General Unreal Sites", "",
	"",	"" ),

(	"links",	5,	"root",	1,	"Mods",			"buttondn",	"buttonup",
	"/UTCMS/home/links/mods/",
	"MOD Home Sites", "",
	"",	"" ),

(	"links",	6,	"root",	1,	"Official",			"buttondn",	"buttonup",
	"/UTCMS/home/links/official/",
	"Official Sites", "",
	"",	"" ),

(	"links",	7,	"root",	1,	"Reviews",			"buttondn",	"buttonup",
	"/UTCMS/home/links/reviews/",
	"Reviewing Sites", "",
	"",	"" ),

(	"links",	8,	"root",	1,	"Other",			"buttondn",	"buttonup",
	"/UTCMS/home/links/other/",
	"Whatever", "",
	"",	"" );

# ################################################################
# Game modification menu
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"mod",	1,	"file",	4,	"Unreal",	"buttondn",	"buttonup",
	"/UTCMS/files/mod/U1/",
	"Game modifications for Unreal",	"",
	"",	"" ),

(	"mod",	2,	"file",	4,	"UT",		"buttondn",	"buttonup",
	"/UTCMS/files/mod/UT/",
	"Game modifications for UT",	"",
	"",	"" ),

(	"mod",	3,	"file",	4,	"UT 2003",	"buttondn",	"buttonup",
	"/UTCMS/files/mod/UT2k3/",
	"Game modifications for UT 2003",	"",
	"",	"" );

# ################################################################
# TOP-10 menu
# ################################################################
INSERT INTO menu ( 	menu_name, menu_ordr, menu_pnam, menu_pord, menu_text, menu_onst, menu_ofst,
					menu_link,
					menu_titl, menu_ttst,
					menu_brfn, menu_brst ) VALUES
(	"top10",	1,	"root",	5,	"Best Files",	"buttondn",	"buttonup",
	"/UTCMS/top10/bestmap/",
	"Best files",	"",
	"",	"" ),

(	"top10",	2,	"root",	5,	"Best Authors",	"buttondn",	"buttonup",
	"/UTCMS/top10/bestauth/",
	"Best authors",	"",
	"",	"" ),

(	"top10",	3,	"root",	5,	"Worst Files",	"buttondn",	"buttonup",
	"/UTCMS/top10/worstmap/",
	"Worst files",	"",
	"",	"" ),

(	"top10",	4,	"root",	5,	"Worst Authors",	"buttondn",	"buttonup",
	"/UTCMS/top10/worstauth/",
	"Worst authors",	"",
	"",	"" );


# ################################################################
# EOF: UTCMS_menu.sql
# ################################################################
