# ################################################################
# UTCMS_packfile.sql
# Creates packfile table
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
#
# ref from:
# refers  : file(packfile_file), pack(packfile_pack)
#
# ################################################################
# Field descriptions
# ################################################################
# packfile_file		File relation
# packfile_pack		Pack relation

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS packfile;

# ################################################################
# Create the packfile table and it's indexes
# ################################################################
CREATE TABLE packfile (
	packfile_file	INTEGER			NOT NULL	DEFAULT 0,
	packfile_pack	INTEGER			NOT NULL	DEFAULT 0,

	PRIMARY KEY ( packfile_file, packfile_pack )
);

CREATE INDEX			packfile_pack_ix		ON packfile ( packfile_pack );

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON packfile TO quest@localhost;

FLUSH PRIVILEGES;


# ################################################################
# EOF: UTCMS_packfile.sql
# ################################################################
