# ################################################################
# UTCMS_pref.sql
# Creates preferences table
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
# Field descriptions
# ################################################################
# pref_name		Name of this preference
# pref_valu		Value of the preference

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS pref;

# ################################################################
# Create the pref table and it's indexes
# ################################################################
CREATE TABLE pref (
	pref_name		CHAR(32)	NOT NULL,
	pref_valu		CHAR(200)	NOT NULL,

    PRIMARY KEY ( pref_name )
);

# ################################################################
# Grants
# ################################################################
GRANT ALL ON pref TO quest@localhost;

FLUSH PRIVILEGES;

# ################################################################
# Color scheme
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "default-colors",			"334FFF333FFF633AA9334008000777000FFE000DDDFFFBFB000FFF000FFF000FFF13" ),
( "default-css",			"/mnt/disk8/wwwroot/template/UTCMS/css.tmpl" );

# ################################################################
# Cookie system
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "cookie-name",			"FURPILE_COM_UTCMS_LOGIN" ),
( "cookie-path",			"/" ),
( "cookie-info",			"This cookie is used to identify a user at UTCMS" );

# ################################################################
# Directories
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "default-screenshot",		"../UTCMS-NoScreenShot.gif" ),
( "default-screenshot-tn",	"../UTCMS-NoScreenShotTn.gif" ),
( "default-assaultshot",	"../UTCMS-NoScreenShot.gif" ),
( "default-assaultshot-tn",	"../UTCMS-NoScreenShotTn.gif" ),
( "default-portrait",		"../UTCMS-NoPortrait.gif" ),
( "max-download-cache",		"200" ),
( "max-download-size",		"1000000000" ),
( "dir-download-file",		"/home/ftp/download" ),
( "url-download-file",		"ftp://furpile.com/download" );

# ################################################################
# Cache declarations
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "preview-cache-maxfiles",	"1000" ),
( "preview-cache-maxsize",	"1000000000" ),
( "preview-cache-dirbase",	"/mnt/disk8/wwwroot/images/UTCMS/preview/cache" ),
( "preview-cache-urlbase",	"/images/UTCMS/preview/cache" );

# ################################################################
# Some warning texts
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-spam-warning",	"/mnt/disk8/wwwroot/template/UTCMS/warnings/spam.tmpl" );

# ################################################################
# Templates for search
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES

( "tmpl-search-formdata",	"/mnt/disk8/wwwroot/template/UTCMS/search/formdata.tmpl" ),

( "tmpl-search-simple",		"/mnt/disk8/wwwroot/template/UTCMS/search/simple.tmpl" ),

( "tmpl-search-headtop",	"/mnt/disk8/wwwroot/template/UTCMS/search/headtop.tmpl" ),

( "tmpl-search-clst-head",	"/mnt/disk8/wwwroot/template/UTCMS/search/category/lst/head.tmpl" ),
( "tmpl-search-clst-body",	"/mnt/disk8/wwwroot/template/UTCMS/search/category/lst/body.tmpl" ),
( "tmpl-search-clst-tail",	"/mnt/disk8/wwwroot/template/UTCMS/search/category/lst/tail.tmpl" ),

( "tmpl-search-cpop-head",	"/mnt/disk8/wwwroot/template/UTCMS/search/category/pop/head.tmpl" ),
( "tmpl-search-cpop-body",	"/mnt/disk8/wwwroot/template/UTCMS/search/category/pop/body.tmpl" ),
( "tmpl-search-cpop-tail",	"/mnt/disk8/wwwroot/template/UTCMS/search/category/pop/tail.tmpl" ),

( "tmpl-search-headend",	"/mnt/disk8/wwwroot/template/UTCMS/search/headend.tmpl" ),

( "tmpl-search-file-head",	"/mnt/disk8/wwwroot/template/UTCMS/search/file/head.tmpl" ),
( "tmpl-search-file-body",	"/mnt/disk8/wwwroot/template/UTCMS/search/file/body.tmpl" ),
( "tmpl-search-file-tail",	"/mnt/disk8/wwwroot/template/UTCMS/search/file/tail.tmpl" ),
( "tmpl-search-file-none",	"/mnt/disk8/wwwroot/template/UTCMS/search/file/none.tmpl" ),

( "tmpl-search-pack-head",	"/mnt/disk8/wwwroot/template/UTCMS/search/pack/head.tmpl" ),
( "tmpl-search-pack-body",	"/mnt/disk8/wwwroot/template/UTCMS/search/pack/body.tmpl" ),
( "tmpl-search-pack-tail",	"/mnt/disk8/wwwroot/template/UTCMS/search/pack/tail.tmpl" ),
( "tmpl-search-pack-none",	"/mnt/disk8/wwwroot/template/UTCMS/search/pack/none.tmpl" ),

( "tmpl-search-tail", 		"/mnt/disk8/wwwroot/template/UTCMS/search/tail.tmpl" );

# ################################################################
# Templates for review
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-review-login",		"/mnt/disk8/wwwroot/template/UTCMS/review/login.tmpl" ),
( "tmpl-review-head",		"/mnt/disk8/wwwroot/template/UTCMS/preview/head.tmpl" ),
( "tmpl-review-tail",		"/mnt/disk8/wwwroot/template/UTCMS/preview/tail.tmpl" ),
( "tmpl-review-form-head",	"/mnt/disk8/wwwroot/template/UTCMS/review/form/head.tmpl" ),
( "tmpl-review-form-body",	"/mnt/disk8/wwwroot/template/UTCMS/review/form/body.tmpl" ),
( "tmpl-review-form-tail",	"/mnt/disk8/wwwroot/template/UTCMS/review/form/tail.tmpl" );

# ################################################################
# Templates for review viewing
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-reviews-hhead",		"/mnt/disk8/wwwroot/template/UTCMS/reviews/head/head.tmpl" ),
( "tmpl-reviews-hbody",		"/mnt/disk8/wwwroot/template/UTCMS/reviews/head/body.tmpl" ),
( "tmpl-reviews-htail",		"/mnt/disk8/wwwroot/template/UTCMS/reviews/head/tail.tmpl" ),

( "tmpl-reviews-shead",		"/mnt/disk8/wwwroot/template/UTCMS/reviews/scores/head.tmpl" ),
( "tmpl-reviews-sbody",		"/mnt/disk8/wwwroot/template/UTCMS/reviews/scores/body.tmpl" ),
( "tmpl-reviews-stail",		"/mnt/disk8/wwwroot/template/UTCMS/reviews/scores/tail.tmpl" ),

( "tmpl-reviews-zhead",		"/mnt/disk8/wwwroot/template/UTCMS/reviews/detscr/head.tmpl" ),
( "tmpl-reviews-zbody",		"/mnt/disk8/wwwroot/template/UTCMS/reviews/detscr/body.tmpl" ),
( "tmpl-reviews-ztail",		"/mnt/disk8/wwwroot/template/UTCMS/reviews/detscr/tail.tmpl" ),

( "tmpl-reviews-dhead",		"/mnt/disk8/wwwroot/template/UTCMS/reviews/detail/head.tmpl" ),
( "tmpl-reviews-dbody",		"/mnt/disk8/wwwroot/template/UTCMS/reviews/detail/body.tmpl" ),
( "tmpl-reviews-dtail",		"/mnt/disk8/wwwroot/template/UTCMS/reviews/detail/tail.tmpl" );


# ################################################################
# Templates for preview
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-prv-head",			"/mnt/disk8/wwwroot/template/UTCMS/preview/head.tmpl" ),
( "tmpl-prv-tail",			"/mnt/disk8/wwwroot/template/UTCMS/preview/tail.tmpl" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-prv-fdeta-head",	"/mnt/disk8/wwwroot/template/UTCMS/preview/fdeta/head.tmpl" ),
( "tmpl-prv-fdeta-body",	"/mnt/disk8/wwwroot/template/UTCMS/preview/fdeta/body.tmpl" ),
( "tmpl-prv-fdeta-tail",	"/mnt/disk8/wwwroot/template/UTCMS/preview/fdeta/tail.tmpl" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-prv-linfo-data",	"/mnt/disk8/wwwroot/template/UTCMS/preview/linfo/data.tmpl" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-prv-upack-data",	"/mnt/disk8/wwwroot/template/UTCMS/preview/upack/data.tmpl" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-prv-skin-none",		"/mnt/disk8/wwwroot/template/UTCMS/preview/skin/noskin.tmpl" ),
( "tmpl-prv-skin-skin",		"/mnt/disk8/wwwroot/template/UTCMS/preview/skin/skin.tmpl" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-prv-sshot-head",	"/mnt/disk8/wwwroot/template/UTCMS/preview/sshot/head.tmpl" ),
( "tmpl-prv-sshot-body",	"/mnt/disk8/wwwroot/template/UTCMS/preview/sshot/body.tmpl" ),
( "tmpl-prv-sshot-tail",	"/mnt/disk8/wwwroot/template/UTCMS/preview/sshot/tail.tmpl" ),
( "tmpl-prv-sshot-nosh",	"/mnt/disk8/wwwroot/template/UTCMS/preview/sshot/nosh.tmpl" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-prv-ilist-head",	"/mnt/disk8/wwwroot/template/UTCMS/preview/ilist/head.tmpl" ),
( "tmpl-prv-ilist-body",	"/mnt/disk8/wwwroot/template/UTCMS/preview/ilist/body.tmpl" ),
( "tmpl-prv-ilist-bodx",	"/mnt/disk8/wwwroot/template/UTCMS/preview/ilist/bodx.tmpl" ),
( "tmpl-prv-ilist-bodh",	"/mnt/disk8/wwwroot/template/UTCMS/preview/ilist/bodh.tmpl" ),
( "tmpl-prv-ilist-bodb",	"/mnt/disk8/wwwroot/template/UTCMS/preview/ilist/bodb.tmpl" ),
( "tmpl-prv-ilist-bodt",	"/mnt/disk8/wwwroot/template/UTCMS/preview/ilist/bodt.tmpl" ),
( "tmpl-prv-ilist-tail",	"/mnt/disk8/wwwroot/template/UTCMS/preview/ilist/tail.tmpl" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-prv-elist-head",	"/mnt/disk8/wwwroot/template/UTCMS/preview/elist/head.tmpl" ),
( "tmpl-prv-elist-body",	"/mnt/disk8/wwwroot/template/UTCMS/preview/elist/body.tmpl" ),
( "tmpl-prv-elist-tail",	"/mnt/disk8/wwwroot/template/UTCMS/preview/elist/tail.tmpl" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-prv-ashot-head",	"/mnt/disk8/wwwroot/template/UTCMS/preview/ashot/head.tmpl" ),
( "tmpl-prv-ashot-body",	"/mnt/disk8/wwwroot/template/UTCMS/preview/ashot/body.tmpl" ),
( "tmpl-prv-ashot-tail",	"/mnt/disk8/wwwroot/template/UTCMS/preview/ashot/tail.tmpl" ),
( "tmpl-prv-ashot-nosh",	"/mnt/disk8/wwwroot/template/UTCMS/preview/ashot/nosh.tmpl" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-prv-render-text",	"/mnt/disk8/wwwroot/template/UTCMS/preview/render/text.tmpl" ),
( "tmpl-prv-render-code",	"/mnt/disk8/wwwroot/template/UTCMS/preview/render/code.tmpl" ),
( "tmpl-prv-render-t3df",	"/mnt/disk8/wwwroot/template/UTCMS/preview/render/t3df.tmpl" ),
( "tmpl-prv-render-imag",	"/mnt/disk8/wwwroot/template/UTCMS/preview/render/imag.tmpl" );


# ################################################################
# Templates for texture previewer
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-previewtexture-head",	"/mnt/disk8/wwwroot/template/UTCMS/preview/texture/head.tmpl" ),
( "tmpl-previewtexture-body",	"/mnt/disk8/wwwroot/template/UTCMS/preview/texture/body.tmpl" ),
( "tmpl-previewtexture-tail",	"/mnt/disk8/wwwroot/template/UTCMS/preview/texture/tail.tmpl" ),
( "tmpl-previewtex-notn",		"../UTCMS-NoTexSummaryTn.gif" ),
( "tmpl-previewtex-notx",		"../UTCMS-NoTexSummary.gif" );

# ################################################################
# Templates for script previewers
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-previewfunction-head",	"/mnt/disk8/wwwroot/template/UTCMS/preview/script/function/head.tmpl" ),
( "tmpl-previewfunction-body",	"/mnt/disk8/wwwroot/template/UTCMS/preview/script/function/body.tmpl" ),
( "tmpl-previewfunction-none",	"/mnt/disk8/wwwroot/template/UTCMS/preview/script/function/none.tmpl" ),
( "tmpl-previewfunction-tail",	"/mnt/disk8/wwwroot/template/UTCMS/preview/script/function/tail.tmpl" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-previewtextbuffer-head",	"/mnt/disk8/wwwroot/template/UTCMS/preview/script/textbuffer/head.tmpl" ),
( "tmpl-previewtextbuffer-body",	"/mnt/disk8/wwwroot/template/UTCMS/preview/script/textbuffer/body.tmpl" ),
( "tmpl-previewtextbuffer-none",	"/mnt/disk8/wwwroot/template/UTCMS/preview/script/textbuffer/none.tmpl" ),
( "tmpl-previewtextbuffer-tail",	"/mnt/disk8/wwwroot/template/UTCMS/preview/script/textbuffer/tail.tmpl" ),
( "tmpl-previewtextbuffer-thead",	"/mnt/disk8/wwwroot/template/UTCMS/preview/script/textbuffer/thead.tmpl" ),
( "tmpl-previewtextbuffer-ttail",	"/mnt/disk8/wwwroot/template/UTCMS/preview/script/textbuffer/ttail.tmpl" );

# ################################################################
# Templates for sound preview
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-previewsound-head",		"/mnt/disk8/wwwroot/template/UTCMS/preview/sound/head.tmpl" ),
( "tmpl-previewsound-body",		"/mnt/disk8/wwwroot/template/UTCMS/preview/sound/body.tmpl" ),
( "tmpl-previewsound-none",		"/mnt/disk8/wwwroot/template/UTCMS/preview/sound/none.tmpl" ),
( "tmpl-previewsound-tail",		"/mnt/disk8/wwwroot/template/UTCMS/preview/sound/tail.tmpl" );

# ################################################################
# Templates for user administration
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-useradmin-list-head",	"/mnt/disk8/wwwroot/template/UTCMS/useradmin/list/head.tmpl" ),
( "tmpl-useradmin-list-body",	"/mnt/disk8/wwwroot/template/UTCMS/useradmin/list/body.tmpl" ),
( "tmpl-useradmin-list-tail",	"/mnt/disk8/wwwroot/template/UTCMS/useradmin/list/tail.tmpl" ),
( "tmpl-useradmin-edit",		"/mnt/disk8/wwwroot/template/UTCMS/useradmin/edit.tmpl" ),
( "tmpl-useradmin-logn",		"/mnt/disk8/wwwroot/template/UTCMS/useradmin/logn.tmpl" );

# ################################################################
# Templates for news administration
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-newsadmin-logn",		"/mnt/disk8/wwwroot/template/UTCMS/newsadmin/logn.tmpl" ),
( "tmpl-newsadmin-head",		"/mnt/disk8/wwwroot/template/UTCMS/newsadmin/head.tmpl" ),
( "tmpl-newsadmin-data",		"/mnt/disk8/wwwroot/template/UTCMS/newsadmin/data.tmpl" ),
( "tmpl-newsadmin-list-head",	"/mnt/disk8/wwwroot/template/UTCMS/newsadmin/list/head.tmpl" ),
( "tmpl-newsadmin-list-body",	"/mnt/disk8/wwwroot/template/UTCMS/newsadmin/list/body.tmpl" ),
( "tmpl-newsadmin-list-tail",	"/mnt/disk8/wwwroot/template/UTCMS/newsadmin/list/tail.tmpl" ),
( "tmpl-newsadmin-tail",		"/mnt/disk8/wwwroot/template/UTCMS/newsadmin/tail.tmpl" );

# ################################################################
# Templates for news view
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-news-head",				"/mnt/disk8/wwwroot/template/UTCMS/news/head.tmpl" ),
( "tmpl-news-body",				"/mnt/disk8/wwwroot/template/UTCMS/news/body.tmpl" ),
( "tmpl-news-tail",				"/mnt/disk8/wwwroot/template/UTCMS/news/tail.tmpl" );

# ################################################################
# Templates for user registration
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-userregister-base",		"/mnt/disk8/wwwroot/template/UTCMS/userregister/base.tmpl" );

# ################################################################
# Templates for author administration
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-authadmin-list-head",	"/mnt/disk8/wwwroot/template/UTCMS/authadmin/list/head.tmpl" ),
( "tmpl-authadmin-list-body",	"/mnt/disk8/wwwroot/template/UTCMS/authadmin/list/body.tmpl" ),
( "tmpl-authadmin-logn",	"/mnt/disk8/wwwroot/template/UTCMS/authadmin/logn.tmpl" ),
( "tmpl-authadmin-list-tail",	"/mnt/disk8/wwwroot/template/UTCMS/authadmin/list/tail.tmpl" );

# ################################################################
# Templates for color administration
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-coloradmin-logn",		"/mnt/disk8/wwwroot/template/UTCMS/coloradmin/logn.tmpl" ),
( "tmpl-coloradmin-data",		"/mnt/disk8/wwwroot/template/UTCMS/coloradmin/data.tmpl" );

# ################################################################
# Templates for file administration
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-fileadmin-list-head",	"/mnt/disk8/wwwroot/template/UTCMS/fileadmin/list/head.tmpl" ),
( "tmpl-fileadmin-list-body",	"/mnt/disk8/wwwroot/template/UTCMS/fileadmin/list/body.tmpl" ),
( "tmpl-fileadmin-logn",		"/mnt/disk8/wwwroot/template/UTCMS/fileadmin/logn.tmpl" ),
( "tmpl-fileadmin-list-tail",	"/mnt/disk8/wwwroot/template/UTCMS/fileadmin/list/tail.tmpl" );

# ################################################################
# Templates for pack administration
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-packadmin-list-head",	"/mnt/disk8/wwwroot/template/UTCMS/packadmin/list/head.tmpl" ),
( "tmpl-packadmin-list-body",	"/mnt/disk8/wwwroot/template/UTCMS/packadmin/list/body.tmpl" ),
( "tmpl-packadmin-logn",		"/mnt/disk8/wwwroot/template/UTCMS/packadmin/logn.tmpl" ),
( "tmpl-packadmin-list-tail",	"/mnt/disk8/wwwroot/template/UTCMS/packadmin/list/tail.tmpl" );

# ################################################################
# Templates for download
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-download-login",		"/mnt/disk8/wwwroot/template/UTCMS/download/login.tmpl" ),
( "tmpl-download-choos",		"/mnt/disk8/wwwroot/template/UTCMS/download/choose.tmpl" ),
( "tmpl-download-poll",			"/mnt/disk8/wwwroot/template/UTCMS/download/poll.tmpl" ),
( "tmpl-download-phead",		"/mnt/disk8/wwwroot/template/UTCMS/download/phead.tmpl" ),
( "tmpl-download-pbody",		"/mnt/disk8/wwwroot/template/UTCMS/download/pbody.tmpl" ),
( "tmpl-download-ptail",		"/mnt/disk8/wwwroot/template/UTCMS/download/ptail.tmpl" );

# ################################################################
# Templates for login
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-no-rights",				"/mnt/disk8/wwwroot/template/UTCMS/norights.tmpl" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-login",					"/mnt/disk8/wwwroot/template/UTCMS/login/logn.tmpl" );

# ################################################################
# Templates for linki viewer (deprecated)
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-linkview-head",			"/mnt/disk8/wwwroot/template/UTCMS/linkview/head.tmpl" ),
( "tmpl-linkview-body",			"/mnt/disk8/wwwroot/template/UTCMS/linkview/body.tmpl" ),
( "tmpl-linkview-tail",			"/mnt/disk8/wwwroot/template/UTCMS/linkview/tail.tmpl" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-linkadd-base",			"/mnt/disk8/wwwroot/template/UTCMS/linkaddition/base.tmpl" );

# ################################################################
# Templates for link viewer
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-displink-list-head",	"/mnt/disk8/wwwroot/template/UTCMS/displink/list/head.tmpl" ),
( "tmpl-displink-list-bhead",	"/mnt/disk8/wwwroot/template/UTCMS/displink/list/bhead.tmpl" ),
( "tmpl-displink-list-bbody",	"/mnt/disk8/wwwroot/template/UTCMS/displink/list/bbody.tmpl" ),
( "tmpl-displink-list-btail",	"/mnt/disk8/wwwroot/template/UTCMS/displink/list/btail.tmpl" ),
( "tmpl-displink-list-tail",	"/mnt/disk8/wwwroot/template/UTCMS/displink/list/tail.tmpl" ),
( "tmpl-displink-list-none",	"/mnt/disk8/wwwroot/template/UTCMS/displink/list/none.tmpl" );

# ################################################################
# Templates for server viewer
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-dispserv-list-rota",	"/mnt/disk8/wwwroot/template/UTCMS/serverlist/list/rota.tmpl" ),
( "tmpl-dispserv-list-head",	"/mnt/disk8/wwwroot/template/UTCMS/serverlist/list/head.tmpl" ),
( "tmpl-dispserv-list-body",	"/mnt/disk8/wwwroot/template/UTCMS/serverlist/list/body.tmpl" ),
( "tmpl-dispserv-list-tail",	"/mnt/disk8/wwwroot/template/UTCMS/serverlist/list/tail.tmpl" ),
( "tmpl-dispserv-erro-nadd",	"/mnt/disk8/wwwroot/template/UTCMS/serverlist/nadd.tmpl" ),
( "tmpl-dispserv-erro-nsrv",	"/mnt/disk8/wwwroot/template/UTCMS/serverlist/nsrv.tmpl" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-dispserv-info-head",	"/mnt/disk8/wwwroot/template/UTCMS/serverlist/info/head.tmpl" ),
( "tmpl-dispserv-info-tail",	"/mnt/disk8/wwwroot/template/UTCMS/serverlist/info/tail.tmpl" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-dispserv-ginf-head",	"/mnt/disk8/wwwroot/template/UTCMS/serverlist/info/game/head.tmpl" ),
( "tmpl-dispserv-ginf-body",	"/mnt/disk8/wwwroot/template/UTCMS/serverlist/info/game/body.tmpl" ),
( "tmpl-dispserv-ginf-tail",	"/mnt/disk8/wwwroot/template/UTCMS/serverlist/info/game/tail.tmpl" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-dispserv-pinf-head",	"/mnt/disk8/wwwroot/template/UTCMS/serverlist/info/play/head.tmpl" ),
( "tmpl-dispserv-pinf-body",	"/mnt/disk8/wwwroot/template/UTCMS/serverlist/info/play/body.tmpl" ),
( "tmpl-dispserv-pinf-tail",	"/mnt/disk8/wwwroot/template/UTCMS/serverlist/info/play/tail.tmpl" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-dispserv-rota-head",	"/mnt/disk8/wwwroot/template/UTCMS/serverlist/info/rota/head.tmpl" ),
( "tmpl-dispserv-rota-body",	"/mnt/disk8/wwwroot/template/UTCMS/serverlist/info/rota/body.tmpl" ),
( "tmpl-dispserv-rota-tail",	"/mnt/disk8/wwwroot/template/UTCMS/serverlist/info/rota/tail.tmpl" );

# ################################################################
# Templates for link admin
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-linkadmin-list-hhead",	"/mnt/disk8/wwwroot/template/UTCMS/linkadmin/list/hhead.tmpl" ),
( "tmpl-linkadmin-list-hbody",	"/mnt/disk8/wwwroot/template/UTCMS/linkadmin/list/hbody.tmpl" ),
( "tmpl-linkadmin-list-htail",	"/mnt/disk8/wwwroot/template/UTCMS/linkadmin/list/htail.tmpl" ),
( "tmpl-linkadmin-list-body",	"/mnt/disk8/wwwroot/template/UTCMS/linkadmin/list/body.tmpl" ),
( "tmpl-linkadmin-list-tail",	"/mnt/disk8/wwwroot/template/UTCMS/linkadmin/list/tail.tmpl" ),
( "tmpl-linkadmin-edit-head",	"/mnt/disk8/wwwroot/template/UTCMS/linkadmin/edit/head.tmpl" ),
( "tmpl-linkadmin-edit-body",	"/mnt/disk8/wwwroot/template/UTCMS/linkadmin/edit/body.tmpl" ),
( "tmpl-linkadmin-edit-tail",	"/mnt/disk8/wwwroot/template/UTCMS/linkadmin/edit/tail.tmpl" ),
( "tmpl-linkadmin-logn",		"/mnt/disk8/wwwroot/template/UTCMS/linkadmin/logn.tmpl" );

# ################################################################
# Templates for TOP-10 rank lists
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "tmpl-rank-bmap-head",	"/mnt/disk8/wwwroot/template/UTCMS/top10/bmap/head.tmpl" ),
( "tmpl-rank-bmap-body",	"/mnt/disk8/wwwroot/template/UTCMS/top10/bmap/body.tmpl" ),
( "tmpl-rank-bmap-tail",	"/mnt/disk8/wwwroot/template/UTCMS/top10/bmap/tail.tmpl" ),

( "tmpl-rank-wmap-head",	"/mnt/disk8/wwwroot/template/UTCMS/top10/wmap/head.tmpl" ),
( "tmpl-rank-wmap-body",	"/mnt/disk8/wwwroot/template/UTCMS/top10/wmap/body.tmpl" ),
( "tmpl-rank-wmap-tail",	"/mnt/disk8/wwwroot/template/UTCMS/top10/wmap/tail.tmpl" ),

( "tmpl-rank-baut-head",	"/mnt/disk8/wwwroot/template/UTCMS/top10/baut/head.tmpl" ),
( "tmpl-rank-baut-body",	"/mnt/disk8/wwwroot/template/UTCMS/top10/baut/body.tmpl" ),
( "tmpl-rank-baut-tail",	"/mnt/disk8/wwwroot/template/UTCMS/top10/baut/tail.tmpl" ),

( "tmpl-rank-waut-head",	"/mnt/disk8/wwwroot/template/UTCMS/top10/waut/head.tmpl" ),
( "tmpl-rank-waut-body",	"/mnt/disk8/wwwroot/template/UTCMS/top10/waut/body.tmpl" ),
( "tmpl-rank-waut-tail",	"/mnt/disk8/wwwroot/template/UTCMS/top10/waut/tail.tmpl" );

# ################################################################
# URL types
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "urltype-tool-file-prog",		"1 tool-file-prog Tools - Programming" ),
( "urltype-tool-file-conv",		"1 tool-file-conv Tools - Converter" ),
( "urltype-tool-file-ued1",		"1 tool-file-ued1 Tools - Addition UED1" ),
( "urltype-tool-file-ued2",		"1 tool-file-ued2 Tools - Addition UED2" ),
( "urltype-tool-file-ued3",		"1 tool-file-ued3 Tools - Addition UED3" ),
( "urltype-tool-file-uedx",		"1 tool-file-uedx Tools - Addition Other" ),
( "urltype-tool-file-conf",		"1 tool-file-conf Tools - Configuring" ),
( "urltype-tool-file-cach",		"1 tool-file-cach Tools - Cache manager" ),
( "urltype-tool-file-uide",		"1 tool-file-uide Tools - IDE for UED" ),
( "urltype-tool-file-pack",		"1 tool-file-pack Tools - Packing" ),
( "urltype-tool-file-ftpc",		"1 tool-file-ftpc Tools - FTP Client" ),
( "urltype-tool-file-tost",		"1 tool-file-tost Tools - TOST" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "urltype-home-link-offi",		"1 home-link-offi Links - Official sites" ),
( "urltype-home-link-gene",		"1 home-link-gene Links - General sites" ),
( "urltype-home-link-file",		"1 home-link-file Links - File sites" ),
( "urltype-home-link-revi",		"1 home-link-revi Links - Review sites" ),
( "urltype-home-link-mods",		"1 home-link-mods Links - MOD sites" ),
( "urltype-home-link-fans",		"0 home-link-fans Links - Fan sites" ),
( "urltype-home-link-clan",		"1 home-link-clan Links - Clan sites" ),
( "urltype-home-link-othe",		"0 home-link-othe Links - Other sites" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "urltype-docs-edit-ued1",		"1 docs-edit-ued1 Documents - Edit UED1" ),
( "urltype-docs-edit-ued2",		"1 docs-edit-ued2 Documents - Edit UED2" ),
( "urltype-docs-edit-ued3",		"1 docs-edit-ued3 Documents - Edit UED3" ),
( "urltype-docs-edit-comm",		"1 docs-edit-comm Documents - Edit Other" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "urltype-docs-modl-ued1",		"1 docs-modl-ued1 Documents - Modeling Unreal" ),
( "urltype-docs-modl-ued2",		"1 docs-modl-ued2 Documents - Modeling UT" ),
( "urltype-docs-modl-ued3",		"1 docs-modl-ued3 Documents - Modeling UT2k3" ),
( "urltype-docs-modl-comm",		"1 docs-modl-comm Documents - Modeling Other" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "urltype-docs-skin-ued1",		"1 docs-skin-ued1 Documents - Skinning Unreal" ),
( "urltype-docs-skin-ued2",		"1 docs-skin-ued2 Documents - Skinning UT" ),
( "urltype-docs-skin-ued3",		"1 docs-skin-ued3 Documents - Skinning UT2k3" ),
( "urltype-docs-skin-comm",		"1 docs-skin-comm Documents - Skinning Other" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "urltype-docs-play-unre",		"1 docs-play-unre Documents - Playing Unreal" ),
( "urltype-docs-play-utou",		"1 docs-play-utou Documents - Playing UT" ),
( "urltype-docs-play-ut2k",		"1 docs-play-ut2k Documents - Playing UT2k3" ),
( "urltype-docs-play-comm",		"1 docs-play-comm Documents - Playing Other" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "urltype-docs-serv-unre",		"1 docs-serv-unre Documents - Server admin Unreal" ),
( "urltype-docs-serv-utou",		"1 docs-serv-utou Documents - Server admin UT" ),
( "urltype-docs-serv-ut2k",		"1 docs-serv-ut2k Documents - Server admin UT2k3" ),
( "urltype-docs-serv-comm",		"1 docs-serv-comm Documents - Server admin Other" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "urltype-docs-site-utcm",		"1 docs-site-utcm Documents - UTCMS Site documentation" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "urltype-docs-scripting",		"1 docs-scripting Documents - Scripting" ),
( "urltype-docs-programming",	"1 docs-programming Documents - Programming" ),
( "urltype-docs-other",			"1 docs-other Documents - Other" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "urltype-file-patc-unre",		"1 file-patc-unre Files - Patch Unreal" ),
( "urltype-file-patc-utde",		"1 file-patc-utde Files - Patch UT Demo" ),
( "urltype-file-patc-utou",		"1 file-patc-utou Files - Patch UT" ),
( "urltype-file-patc-ut2d",		"1 file-patc-ut2d Files - Patch UT2003 Demo" ),
( "urltype-file-patc-ut2k",		"1 file-patc-ut2k Files - Patch UT2003" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "urltype-file-demo",			"1 file-demo Files - Demo" ),
( "urltype-file-deco",			"1 file-deco Files - Decorations" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "urltype-file-serv-unre",		"1 file-serv-unre Files - Server Unreal" ),
( "urltype-file-serv-utou",		"1 file-serv-utou Files - Server UT" ),
( "urltype-file-serv-ut2k",		"1 file-serv-ut2k Files - Server UT2003" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "urltype-file-bonu-unre",		"1 file-bonu-unre Files - Bonus Pack Unreal" ),
( "urltype-file-bonu-utou",		"1 file-bonu-utou Files - Bonus Pack UT" ),
( "urltype-file-bonu-ut2k",		"1 file-bonu-ut2k Files - Bonus Pack UT2003" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "urltype-file-mod-unre",		"1 file-mod-unre Files - MOD for Unreal" ),
( "urltype-file-mod-utou",		"1 file-mod-utou Files - MOD for UT" ),
( "urltype-file-mod-ut2k",		"1 file-mod-ut2k Files - MOD for UT2003" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "urltype-file-trai-unre",		"1 file-trai-unre Files - Trailer Unreal" ),
( "urltype-file-trai-utou",		"1 file-trai-utou Files - Trailer UT" ),
( "urltype-file-trai-ut2k",		"1 file-trai-ut2k Files - Trailer UT2003" ),
( "urltype-file-trai-comm",		"1 file-trai-comm Files - Trailer Other" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "urltype-file-gall-unre",		"1 file-gall-unre Files - Gallery Unreal" ),
( "urltype-file-gall-utou",		"1 file-gall-utou Files - Gallery UT" ),
( "urltype-file-gall-ut2k",		"1 file-gall-ut2k Files - Gallery UT2003" ),
( "urltype-file-gall-comm",		"0 file-gall-comm Files - Gallery Other" );

# ################################################################
# Rating images
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "rate-bad-images", 	"/mnt/disk8/wwwroot/images/UTCMS/scoring/bad" ),
( "rate-avg-images", 	"/mnt/disk8/wwwroot/images/UTCMS/scoring/avg" ),
( "rate-god-images", 	"/mnt/disk8/wwwroot/images/UTCMS/scoring/good" );

# ################################################################
# Export previewers
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES
( "xp-texture", 	"/UTCMS/files/preview/texture/" ),
( "xp-function",	"/UTCMS/files/preview/script/" ),
( "xp-textbuffer",	"/UTCMS/files/preview/script/" ),
( "xp-sound",		"/UTCMS/files/preview/sound/" );

# ################################################################
# Disk storage places. The system will try to use
# each of these evenly. If You have bigger and smaller disks
# give more places to the bigger ones to balance the load.
# The names should be between storage000 ...storage999, other names
# are not recognized.
# This system has 5 x 4G and 2 x 8G disks
# ################################################################
INSERT INTO pref ( pref_name, pref_valu ) VALUES

( "storage200", "/mnt/disk2/00" ),
( "storage201", "/mnt/disk2/01" ),
( "storage202", "/mnt/disk2/02" ),
( "storage203", "/mnt/disk2/03" ),
( "storage204", "/mnt/disk2/04" ),
( "storage205", "/mnt/disk2/05" ),
( "storage206", "/mnt/disk2/06" ),
( "storage207", "/mnt/disk2/07" ),
( "storage208", "/mnt/disk2/08" ),
( "storage209", "/mnt/disk2/09" ),
( "storage210", "/mnt/disk2/10" ),
( "storage211", "/mnt/disk2/11" ),
( "storage212", "/mnt/disk2/12" ),
( "storage213", "/mnt/disk2/13" ),
( "storage214", "/mnt/disk2/14" ),
( "storage215", "/mnt/disk2/15" ),
( "storage216", "/mnt/disk2/16" ),
( "storage217", "/mnt/disk2/17" ),
( "storage218", "/mnt/disk2/18" ),
( "storage219", "/mnt/disk2/19" ),
( "storage220", "/mnt/disk2/20" ),
( "storage221", "/mnt/disk2/21" ),
( "storage222", "/mnt/disk2/22" ),
( "storage223", "/mnt/disk2/23" ),
( "storage224", "/mnt/disk2/24" ),
( "storage225", "/mnt/disk2/25" );

# ( "storage226", "/mnt/disk2/26" ),
# ( "storage227", "/mnt/disk2/27" ),
# ( "storage228", "/mnt/disk2/28" ),
# ( "storage229", "/mnt/disk2/29" ),
# ( "storage230", "/mnt/disk2/30" ),
# ( "storage231", "/mnt/disk2/31" ),
# ( "storage232", "/mnt/disk2/32" ),
# ( "storage233", "/mnt/disk2/33" ),
# ( "storage234", "/mnt/disk2/34" ),
# ( "storage235", "/mnt/disk2/35" ),
# ( "storage236", "/mnt/disk2/36" ),
# ( "storage237", "/mnt/disk2/37" ),
# ( "storage238", "/mnt/disk2/38" ),
# ( "storage239", "/mnt/disk2/39" ),
# ( "storage240", "/mnt/disk2/40" ),
# ( "storage241", "/mnt/disk2/41" ),
# ( "storage242", "/mnt/disk2/42" ),
# ( "storage243", "/mnt/disk2/43" ),
# ( "storage244", "/mnt/disk2/44" ),
# ( "storage245", "/mnt/disk2/45" ),
# ( "storage246", "/mnt/disk2/46" ),
# ( "storage247", "/mnt/disk2/47" ),
# ( "storage248", "/mnt/disk2/48" ),
# ( "storage249", "/mnt/disk2/49" );


INSERT INTO pref ( pref_name, pref_valu ) VALUES

( "storage300", "/mnt/disk3/00" ),
( "storage301", "/mnt/disk3/01" ),
( "storage302", "/mnt/disk3/02" ),
( "storage303", "/mnt/disk3/03" ),
( "storage304", "/mnt/disk3/04" ),
( "storage305", "/mnt/disk3/05" ),
( "storage306", "/mnt/disk3/06" ),
( "storage307", "/mnt/disk3/07" ),
( "storage308", "/mnt/disk3/08" ),
( "storage309", "/mnt/disk3/09" ),
( "storage310", "/mnt/disk3/10" ),
( "storage311", "/mnt/disk3/11" ),
( "storage312", "/mnt/disk3/12" ),
( "storage313", "/mnt/disk3/13" ),
( "storage314", "/mnt/disk3/14" ),
( "storage315", "/mnt/disk3/15" ),
( "storage316", "/mnt/disk3/16" ),
( "storage317", "/mnt/disk3/17" ),
( "storage318", "/mnt/disk3/18" ),
( "storage319", "/mnt/disk3/19" ),
( "storage320", "/mnt/disk3/20" ),
( "storage321", "/mnt/disk3/21" ),
( "storage322", "/mnt/disk3/22" ),
( "storage323", "/mnt/disk3/23" ),
( "storage324", "/mnt/disk3/24" ),
( "storage325", "/mnt/disk3/25" );

# ( "storage326", "/mnt/disk3/26" ),
# ( "storage327", "/mnt/disk3/27" ),
# ( "storage328", "/mnt/disk3/28" ),
# ( "storage329", "/mnt/disk3/29" ),
# ( "storage330", "/mnt/disk3/30" ),
# ( "storage331", "/mnt/disk3/31" ),
# ( "storage332", "/mnt/disk3/32" ),
# ( "storage333", "/mnt/disk3/33" ),
# ( "storage334", "/mnt/disk3/34" ),
# ( "storage335", "/mnt/disk3/35" ),
# ( "storage336", "/mnt/disk3/36" ),
# ( "storage337", "/mnt/disk3/37" ),
# ( "storage338", "/mnt/disk3/38" ),
# ( "storage339", "/mnt/disk3/39" ),
# ( "storage340", "/mnt/disk3/40" ),
# ( "storage341", "/mnt/disk3/41" ),
# ( "storage342", "/mnt/disk3/42" ),
# ( "storage343", "/mnt/disk3/43" ),
# ( "storage344", "/mnt/disk3/44" ),
# ( "storage345", "/mnt/disk3/45" ),
# ( "storage346", "/mnt/disk3/46" ),
# ( "storage347", "/mnt/disk3/47" ),
# ( "storage348", "/mnt/disk3/48" ),
# ( "storage349", "/mnt/disk3/49" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES

( "storage400", "/mnt/disk4/00" ),
( "storage401", "/mnt/disk4/01" ),
( "storage402", "/mnt/disk4/02" ),
( "storage403", "/mnt/disk4/03" ),
( "storage404", "/mnt/disk4/04" ),
( "storage405", "/mnt/disk4/05" ),
( "storage406", "/mnt/disk4/06" ),
( "storage407", "/mnt/disk4/07" ),
( "storage408", "/mnt/disk4/08" ),
( "storage409", "/mnt/disk4/09" ),
( "storage410", "/mnt/disk4/10" ),
( "storage411", "/mnt/disk4/11" ),
( "storage412", "/mnt/disk4/12" ),
( "storage413", "/mnt/disk4/13" ),
( "storage414", "/mnt/disk4/14" ),
( "storage415", "/mnt/disk4/15" ),
( "storage416", "/mnt/disk4/16" ),
( "storage417", "/mnt/disk4/17" ),
( "storage418", "/mnt/disk4/18" ),
( "storage419", "/mnt/disk4/19" ),
( "storage420", "/mnt/disk4/20" ),
( "storage421", "/mnt/disk4/21" ),
( "storage422", "/mnt/disk4/22" ),
( "storage423", "/mnt/disk4/23" ),
( "storage424", "/mnt/disk4/24" ),
( "storage425", "/mnt/disk4/25" );

# ( "storage426", "/mnt/disk4/26" ),
# ( "storage427", "/mnt/disk4/27" ),
# ( "storage428", "/mnt/disk4/28" ),
# ( "storage429", "/mnt/disk4/29" ),
# ( "storage430", "/mnt/disk4/30" ),
# ( "storage431", "/mnt/disk4/31" ),
# ( "storage432", "/mnt/disk4/32" ),
# ( "storage433", "/mnt/disk4/33" ),
# ( "storage434", "/mnt/disk4/34" ),
# ( "storage435", "/mnt/disk4/35" ),
# ( "storage436", "/mnt/disk4/36" ),
# ( "storage437", "/mnt/disk4/37" ),
# ( "storage438", "/mnt/disk4/38" ),
# ( "storage439", "/mnt/disk4/39" ),
# ( "storage440", "/mnt/disk4/40" ),
# ( "storage441", "/mnt/disk4/41" ),
# ( "storage442", "/mnt/disk4/42" ),
# ( "storage443", "/mnt/disk4/43" ),
# ( "storage444", "/mnt/disk4/44" ),
# ( "storage445", "/mnt/disk4/45" ),
# ( "storage446", "/mnt/disk4/46" ),
# ( "storage447", "/mnt/disk4/47" ),
# ( "storage448", "/mnt/disk4/48" ),
# ( "storage449", "/mnt/disk4/49" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES

( "storage500", "/mnt/disk5/00" ),
( "storage501", "/mnt/disk5/01" ),
( "storage502", "/mnt/disk5/02" ),
( "storage503", "/mnt/disk5/03" ),
( "storage504", "/mnt/disk5/04" ),
( "storage505", "/mnt/disk5/05" ),
( "storage506", "/mnt/disk5/06" ),
( "storage507", "/mnt/disk5/07" ),
( "storage508", "/mnt/disk5/08" ),
( "storage509", "/mnt/disk5/09" ),
( "storage510", "/mnt/disk5/10" ),
( "storage511", "/mnt/disk5/11" ),
( "storage512", "/mnt/disk5/12" ),
( "storage513", "/mnt/disk5/13" ),
( "storage514", "/mnt/disk5/14" ),
( "storage515", "/mnt/disk5/15" ),
( "storage516", "/mnt/disk5/16" ),
( "storage517", "/mnt/disk5/17" ),
( "storage518", "/mnt/disk5/18" ),
( "storage519", "/mnt/disk5/19" ),
( "storage520", "/mnt/disk5/20" ),
( "storage521", "/mnt/disk5/21" ),
( "storage522", "/mnt/disk5/22" ),
( "storage523", "/mnt/disk5/23" ),
( "storage524", "/mnt/disk5/24" ),
( "storage525", "/mnt/disk5/25" );

# ( "storage526", "/mnt/disk5/26" ),
# ( "storage527", "/mnt/disk5/27" ),
# ( "storage528", "/mnt/disk5/28" ),
# ( "storage529", "/mnt/disk5/29" ),
# ( "storage530", "/mnt/disk5/30" ),
# ( "storage531", "/mnt/disk5/31" ),
# ( "storage532", "/mnt/disk5/32" ),
# ( "storage533", "/mnt/disk5/33" ),
# ( "storage534", "/mnt/disk5/34" ),
# ( "storage535", "/mnt/disk5/35" ),
# ( "storage536", "/mnt/disk5/36" ),
# ( "storage537", "/mnt/disk5/37" ),
# ( "storage538", "/mnt/disk5/38" ),
# ( "storage539", "/mnt/disk5/39" ),
# ( "storage540", "/mnt/disk5/40" ),
# ( "storage541", "/mnt/disk5/41" ),
# ( "storage542", "/mnt/disk5/42" ),
# ( "storage543", "/mnt/disk5/43" ),
# ( "storage544", "/mnt/disk5/44" ),
# ( "storage545", "/mnt/disk5/45" ),
# ( "storage546", "/mnt/disk5/46" ),
# ( "storage547", "/mnt/disk5/47" ),
# ( "storage548", "/mnt/disk5/48" ),
# ( "storage549", "/mnt/disk5/49" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES

( "storage600", "/mnt/disk6/00" ),
( "storage601", "/mnt/disk6/01" ),
( "storage602", "/mnt/disk6/02" ),
( "storage603", "/mnt/disk6/03" ),
( "storage604", "/mnt/disk6/04" ),
( "storage605", "/mnt/disk6/05" ),
( "storage606", "/mnt/disk6/06" ),
( "storage607", "/mnt/disk6/07" ),
( "storage608", "/mnt/disk6/08" ),
( "storage609", "/mnt/disk6/09" ),
( "storage610", "/mnt/disk6/10" ),
( "storage611", "/mnt/disk6/11" ),
( "storage612", "/mnt/disk6/12" ),
( "storage613", "/mnt/disk6/13" ),
( "storage614", "/mnt/disk6/14" ),
( "storage615", "/mnt/disk6/15" ),
( "storage616", "/mnt/disk6/16" ),
( "storage617", "/mnt/disk6/17" ),
( "storage618", "/mnt/disk6/18" ),
( "storage619", "/mnt/disk6/19" ),
( "storage620", "/mnt/disk6/20" ),
( "storage621", "/mnt/disk6/21" ),
( "storage622", "/mnt/disk6/22" ),
( "storage623", "/mnt/disk6/23" ),
( "storage624", "/mnt/disk6/24" ),
( "storage625", "/mnt/disk6/25" ),
( "storage626", "/mnt/disk6/26" ),
( "storage627", "/mnt/disk6/27" ),
( "storage628", "/mnt/disk6/28" ),
( "storage629", "/mnt/disk6/29" ),
( "storage630", "/mnt/disk6/30" ),
( "storage631", "/mnt/disk6/31" ),
( "storage632", "/mnt/disk6/32" ),
( "storage633", "/mnt/disk6/33" ),
( "storage634", "/mnt/disk6/34" ),
( "storage635", "/mnt/disk6/35" ),
( "storage636", "/mnt/disk6/36" ),
( "storage637", "/mnt/disk6/37" ),
( "storage638", "/mnt/disk6/38" ),
( "storage639", "/mnt/disk6/39" ),
( "storage640", "/mnt/disk6/40" ),
( "storage641", "/mnt/disk6/41" ),
( "storage642", "/mnt/disk6/42" ),
( "storage643", "/mnt/disk6/43" ),
( "storage644", "/mnt/disk6/44" ),
( "storage645", "/mnt/disk6/45" ),
( "storage646", "/mnt/disk6/46" ),
( "storage647", "/mnt/disk6/47" ),
( "storage648", "/mnt/disk6/48" ),
( "storage649", "/mnt/disk6/49" ),
( "storage650", "/mnt/disk6/50" ),
( "storage651", "/mnt/disk6/51" ),
( "storage652", "/mnt/disk6/52" ),
( "storage653", "/mnt/disk6/53" ),
( "storage654", "/mnt/disk6/54" ),
( "storage655", "/mnt/disk6/55" ),
( "storage656", "/mnt/disk6/56" ),
( "storage657", "/mnt/disk6/57" ),
( "storage658", "/mnt/disk6/58" ),
( "storage659", "/mnt/disk6/59" ),
( "storage660", "/mnt/disk6/60" ),
( "storage661", "/mnt/disk6/61" ),
( "storage662", "/mnt/disk6/62" ),
( "storage663", "/mnt/disk6/63" ),
( "storage664", "/mnt/disk6/64" ),
( "storage665", "/mnt/disk6/65" ),
( "storage666", "/mnt/disk6/66" ),
( "storage667", "/mnt/disk6/67" ),
( "storage668", "/mnt/disk6/68" ),
( "storage669", "/mnt/disk6/69" ),
( "storage670", "/mnt/disk6/70" ),
( "storage671", "/mnt/disk6/71" ),
( "storage672", "/mnt/disk6/72" ),
( "storage673", "/mnt/disk6/73" ),
( "storage674", "/mnt/disk6/74" ),
( "storage675", "/mnt/disk6/75" ),
( "storage676", "/mnt/disk6/76" ),
( "storage677", "/mnt/disk6/77" ),
( "storage678", "/mnt/disk6/78" ),
( "storage679", "/mnt/disk6/79" ),
( "storage680", "/mnt/disk6/80" ),
( "storage681", "/mnt/disk6/81" ),
( "storage682", "/mnt/disk6/82" ),
( "storage683", "/mnt/disk6/83" ),
( "storage684", "/mnt/disk6/84" ),
( "storage685", "/mnt/disk6/85" ),
( "storage686", "/mnt/disk6/86" ),
( "storage687", "/mnt/disk6/87" ),
( "storage688", "/mnt/disk6/88" ),
( "storage689", "/mnt/disk6/89" ),
( "storage690", "/mnt/disk6/90" ),
( "storage691", "/mnt/disk6/91" ),
( "storage692", "/mnt/disk6/92" ),
( "storage693", "/mnt/disk6/93" ),
( "storage694", "/mnt/disk6/94" ),
( "storage695", "/mnt/disk6/95" ),
( "storage696", "/mnt/disk6/96" ),
( "storage697", "/mnt/disk6/97" ),
( "storage698", "/mnt/disk6/98" ),
( "storage699", "/mnt/disk6/99" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES

( "storage700", "/mnt/disk7/00" ),
( "storage701", "/mnt/disk7/01" ),
( "storage702", "/mnt/disk7/02" ),
( "storage703", "/mnt/disk7/03" ),
( "storage704", "/mnt/disk7/04" ),
( "storage705", "/mnt/disk7/05" ),
( "storage706", "/mnt/disk7/06" ),
( "storage707", "/mnt/disk7/07" ),
( "storage708", "/mnt/disk7/08" ),
( "storage709", "/mnt/disk7/09" ),
( "storage710", "/mnt/disk7/10" ),
( "storage711", "/mnt/disk7/11" ),
( "storage712", "/mnt/disk7/12" ),
( "storage713", "/mnt/disk7/13" ),
( "storage714", "/mnt/disk7/14" ),
( "storage715", "/mnt/disk7/15" ),
( "storage716", "/mnt/disk7/16" ),
( "storage717", "/mnt/disk7/17" ),
( "storage718", "/mnt/disk7/18" ),
( "storage719", "/mnt/disk7/19" ),
( "storage720", "/mnt/disk7/20" ),
( "storage721", "/mnt/disk7/21" ),
( "storage722", "/mnt/disk7/22" ),
( "storage723", "/mnt/disk7/23" ),
( "storage724", "/mnt/disk7/24" ),
( "storage725", "/mnt/disk7/25" ),
( "storage726", "/mnt/disk7/26" ),
( "storage727", "/mnt/disk7/27" ),
( "storage728", "/mnt/disk7/28" ),
( "storage729", "/mnt/disk7/29" ),
( "storage730", "/mnt/disk7/30" ),
( "storage731", "/mnt/disk7/31" ),
( "storage732", "/mnt/disk7/32" ),
( "storage733", "/mnt/disk7/33" ),
( "storage734", "/mnt/disk7/34" ),
( "storage735", "/mnt/disk7/35" ),
( "storage736", "/mnt/disk7/36" ),
( "storage737", "/mnt/disk7/37" ),
( "storage738", "/mnt/disk7/38" ),
( "storage739", "/mnt/disk7/39" ),
( "storage740", "/mnt/disk7/40" ),
( "storage741", "/mnt/disk7/41" ),
( "storage742", "/mnt/disk7/42" ),
( "storage743", "/mnt/disk7/43" ),
( "storage744", "/mnt/disk7/44" ),
( "storage745", "/mnt/disk7/45" ),
( "storage746", "/mnt/disk7/46" ),
( "storage747", "/mnt/disk7/47" ),
( "storage748", "/mnt/disk7/48" ),
( "storage749", "/mnt/disk7/49" ),
( "storage750", "/mnt/disk7/50" ),
( "storage751", "/mnt/disk7/51" ),
( "storage752", "/mnt/disk7/52" ),
( "storage753", "/mnt/disk7/53" ),
( "storage754", "/mnt/disk7/54" ),
( "storage755", "/mnt/disk7/55" ),
( "storage756", "/mnt/disk7/56" ),
( "storage757", "/mnt/disk7/57" ),
( "storage758", "/mnt/disk7/58" ),
( "storage759", "/mnt/disk7/59" ),
( "storage760", "/mnt/disk7/60" ),
( "storage761", "/mnt/disk7/61" ),
( "storage762", "/mnt/disk7/62" ),
( "storage763", "/mnt/disk7/63" ),
( "storage764", "/mnt/disk7/64" ),
( "storage765", "/mnt/disk7/65" ),
( "storage766", "/mnt/disk7/66" ),
( "storage767", "/mnt/disk7/67" ),
( "storage768", "/mnt/disk7/68" ),
( "storage769", "/mnt/disk7/69" ),
( "storage770", "/mnt/disk7/70" ),
( "storage771", "/mnt/disk7/71" ),
( "storage772", "/mnt/disk7/72" ),
( "storage773", "/mnt/disk7/73" ),
( "storage774", "/mnt/disk7/74" ),
( "storage775", "/mnt/disk7/75" ),
( "storage776", "/mnt/disk7/76" ),
( "storage777", "/mnt/disk7/77" ),
( "storage778", "/mnt/disk7/78" ),
( "storage779", "/mnt/disk7/79" ),
( "storage780", "/mnt/disk7/80" ),
( "storage781", "/mnt/disk7/81" ),
( "storage782", "/mnt/disk7/82" ),
( "storage783", "/mnt/disk7/83" ),
( "storage784", "/mnt/disk7/84" ),
( "storage785", "/mnt/disk7/85" ),
( "storage786", "/mnt/disk7/86" ),
( "storage787", "/mnt/disk7/87" ),
( "storage788", "/mnt/disk7/88" ),
( "storage789", "/mnt/disk7/89" ),
( "storage790", "/mnt/disk7/90" ),
( "storage791", "/mnt/disk7/91" ),
( "storage792", "/mnt/disk7/92" ),
( "storage793", "/mnt/disk7/93" ),
( "storage794", "/mnt/disk7/94" ),
( "storage795", "/mnt/disk7/95" ),
( "storage796", "/mnt/disk7/96" ),
( "storage797", "/mnt/disk7/97" ),
( "storage798", "/mnt/disk7/98" ),
( "storage799", "/mnt/disk7/99" );

INSERT INTO pref ( pref_name, pref_valu ) VALUES

( "storage800", "/mnt/disk8/00" ),
( "storage801", "/mnt/disk8/01" ),
( "storage802", "/mnt/disk8/02" ),
( "storage803", "/mnt/disk8/03" ),
( "storage804", "/mnt/disk8/04" ),
( "storage805", "/mnt/disk8/05" ),
( "storage806", "/mnt/disk8/06" ),
( "storage807", "/mnt/disk8/07" ),
( "storage808", "/mnt/disk8/08" ),
( "storage809", "/mnt/disk8/09" ),
( "storage810", "/mnt/disk8/10" ),
( "storage811", "/mnt/disk8/11" ),
( "storage812", "/mnt/disk8/12" ),
( "storage813", "/mnt/disk8/13" ),
( "storage814", "/mnt/disk8/14" ),
( "storage815", "/mnt/disk8/15" ),
( "storage816", "/mnt/disk8/16" ),
( "storage817", "/mnt/disk8/17" ),
( "storage818", "/mnt/disk8/18" ),
( "storage819", "/mnt/disk8/19" ),
( "storage820", "/mnt/disk8/20" ),
( "storage821", "/mnt/disk8/21" ),
( "storage822", "/mnt/disk8/22" ),
( "storage823", "/mnt/disk8/23" ),
( "storage824", "/mnt/disk8/24" ),
( "storage825", "/mnt/disk8/25" ),
( "storage826", "/mnt/disk8/26" ),
( "storage827", "/mnt/disk8/27" ),
( "storage828", "/mnt/disk8/28" ),
( "storage829", "/mnt/disk8/29" ),
( "storage830", "/mnt/disk8/30" ),
( "storage831", "/mnt/disk8/31" ),
( "storage832", "/mnt/disk8/32" ),
( "storage833", "/mnt/disk8/33" ),
( "storage834", "/mnt/disk8/34" ),
( "storage835", "/mnt/disk8/35" ),
( "storage836", "/mnt/disk8/36" ),
( "storage837", "/mnt/disk8/37" ),
( "storage838", "/mnt/disk8/38" ),
( "storage839", "/mnt/disk8/39" ),
( "storage840", "/mnt/disk8/40" ),
( "storage841", "/mnt/disk8/41" ),
( "storage842", "/mnt/disk8/42" ),
( "storage843", "/mnt/disk8/43" ),
( "storage844", "/mnt/disk8/44" ),
( "storage845", "/mnt/disk8/45" ),
( "storage846", "/mnt/disk8/46" ),
( "storage847", "/mnt/disk8/47" ),
( "storage848", "/mnt/disk8/48" ),
( "storage849", "/mnt/disk8/49" ),
( "storage850", "/mnt/disk8/50" ),
( "storage851", "/mnt/disk8/51" ),
( "storage852", "/mnt/disk8/52" ),
( "storage853", "/mnt/disk8/53" ),
( "storage854", "/mnt/disk8/54" ),
( "storage855", "/mnt/disk8/55" ),
( "storage856", "/mnt/disk8/56" ),
( "storage857", "/mnt/disk8/57" ),
( "storage858", "/mnt/disk8/58" ),
( "storage859", "/mnt/disk8/59" ),
( "storage860", "/mnt/disk8/60" ),
( "storage861", "/mnt/disk8/61" ),
( "storage862", "/mnt/disk8/62" ),
( "storage863", "/mnt/disk8/63" ),
( "storage864", "/mnt/disk8/64" ),
( "storage865", "/mnt/disk8/65" ),
( "storage866", "/mnt/disk8/66" ),
( "storage867", "/mnt/disk8/67" ),
( "storage868", "/mnt/disk8/68" ),
( "storage869", "/mnt/disk8/69" ),
( "storage870", "/mnt/disk8/70" ),
( "storage871", "/mnt/disk8/71" ),
( "storage872", "/mnt/disk8/72" ),
( "storage873", "/mnt/disk8/73" ),
( "storage874", "/mnt/disk8/74" ),
( "storage875", "/mnt/disk8/75" ),
( "storage876", "/mnt/disk8/76" ),
( "storage877", "/mnt/disk8/77" ),
( "storage878", "/mnt/disk8/78" ),
( "storage879", "/mnt/disk8/79" ),
( "storage880", "/mnt/disk8/80" ),
( "storage881", "/mnt/disk8/81" ),
( "storage882", "/mnt/disk8/82" ),
( "storage883", "/mnt/disk8/83" ),
( "storage884", "/mnt/disk8/84" ),
( "storage885", "/mnt/disk8/85" ),
( "storage886", "/mnt/disk8/86" ),
( "storage887", "/mnt/disk8/87" ),
( "storage888", "/mnt/disk8/88" ),
( "storage889", "/mnt/disk8/89" ),
( "storage890", "/mnt/disk8/90" ),
( "storage891", "/mnt/disk8/91" ),
( "storage892", "/mnt/disk8/92" ),
( "storage893", "/mnt/disk8/93" ),
( "storage894", "/mnt/disk8/94" ),
( "storage895", "/mnt/disk8/95" ),
( "storage896", "/mnt/disk8/96" ),
( "storage897", "/mnt/disk8/97" ),
( "storage898", "/mnt/disk8/98" ),
( "storage899", "/mnt/disk8/99" );

# ################################################################
# EOF: UTCMS_pref.sql
# ################################################################
