# ################################################################
# UTCMS_quot.sql
# Creates quot table
# ################################################################
#
#                         C A U T I O N
#
#           This script WILL ERASE all existing data
#
# ################################################################
# Field descriptions
# ################################################################
# quot_idnt		Only a key
# quot_text		Some quote

# ################################################################
# Use UTCMS database
# ################################################################
USE UTCMS;

# ################################################################
# Drop the table if it exists
# ################################################################
DROP TABLE IF EXISTS quot;

# ################################################################
# Create the rule table and it's indexes
# ################################################################
CREATE TABLE quot (
    quot_idnt	INTEGER         NOT NULL    DEFAULT 0,
    quot_text	CHAR(250)       NOT NULL,

    PRIMARY KEY ( quot_idnt )
);

# ################################################################
# Grants
# ################################################################
GRANT  ALL ON rule TO quest@localhost;

FLUSH PRIVILEGES;


# ################################################################
# SOme predeclared quotes
# ################################################################
# Identification rules
INSERT INTO quot ( quot_idnt, quot_text ) VALUES
(       1, "It isn't the mountains ahead that wear you out, it's the grain of sand in your shoe." ),
(       2, "The most wasted day of all is the one without laughter. -E. E. Cummings" ),
(       3, "Other desires perish in their gratification but the desire of knowledge never." ),
(       4, "There are two ways of spreading the light: to be the candle or the mirror that reflects it. -Edith Wharton" ),
(       5, "No one can make you feel inferior without your consent." ),
(       6, "You never miss the water until the well runs dry." ),
(       7, "When ideas fail, words come in very handy." ),
(       8, "Nothing will ever be attempted, if all possible objections must be first overcome. -Jules W. Lederer" ),
(       9, "A great deal of talent is lost to the world for the want of a little courage." ),
(      10, "The people who live in the Golden Age usually go around complaining how yellow everything looks." ),
(      11, "It is easier to fight for one's principles than to live up to them." ),
(      12, "People are not the best because they work hard, they work hard because they are the best." ),
(      13, "Happiness is good health and a bad memory." ),
(      14, "There is a foolish corner in the brain of the wisest man." ),
(      15, "The Ten Most Important Two-Letter Words: If it is to be, it is up to me." ),
(      16, "A bend in the road, is not the end of the road... unless you fail to make the turn." ),
(      17, "A hundred years from now it will not matter what my bank account was, the sort of house I lived in, or the kind of car I drove... but the world may be different because I was important in the life of a child." ),
(      18, "Teamwork is the ability to work together toward a common vision. The ability to direct individual accomplishment toward orgaizational objectives. It is the fuel that allows common people to attain uncommon results." ),
(      19, "Attitude is a little thing that makes a big difference." ),
(      20, "Some people dream of success... while others wake up and work hard at it." ),
(      21, "Some people make things happen, some watch things happen, while others wonder what has happened..." ),
(      22, "Every job is a self-portrait of the person who did it. Autograph your work with excellence." ),
(      23, "Real leaders are ordinary people with extraordinary determination." ),
(      24, "Together, everyone achieves more." ),
(      25, "Keep your head and your heart in the right direction and you'll never have to worry about your feet." ),
(      26, "Nothing in this world is impossibe to a willing heart." ),
(      27, "The distance between success and failure can only be measured by one's desire." ),
(      28, "If you do not believe in yourself...chances are that nobody else will." ),
(      29, "You can't steal second base and keep one foot on first." ),
(      30, "True success is overcoming the fear of being unsuccessful. -Paul Seeney" ),
(      31, "History repeats itself. Historians repeat each other." ),
(      32, "He who tries can fail. But he who doesn't try, already has." ),
(      33, "Good judgment comes from experience, and experience comes from bad judgment." ),
(      34, "Taxes are the way the government has of artificially inducing the rainy day everybody has been saving for." ),
(      35, "Half the misery in the world is caused by ignorance. The other half is caused by knowledge. -Bonar Thompson" ),
(      36, "The only existing things are atoms in space. All else is mere opinion. -Democritus" ),
(      37, "Why can't life be menu-driven or at least have an 'undo' feature? -David M. De Felice" ),
(      38, "Well tended garden is better than a neglected wood lot. -Dixie Lee Ray" ),
(      39, "Pay no attention to what critics say. No statue has ever been put up to a critic. -Jean Sibelius" ),
(      40, "It is no measure of health to be well adjusted to a profoundly sick society. -Krishnamurti" ),
(      41, "A pesimist is an optimist with experience." ),
(      42, "The search for perfection begins with detecting imperfection." ),
(      43, "The gods do not deduct from man's alloted span the hours spent fishing. -Babylonian proverb" ),
(      44, "Nothing ventured, nothing gained." ),
(      45, "You can observe a lot just by watching. -Yogi Berra" ),
(      46, "You should never wear your best trousers when you go out to fight for freedom and truth." ),
(      47, "Whether you think that you can or that you can't, you are usually right." ),
(      48, "Research is what I'm doing when I don't know what I'm doing." ),
(      49, "Opportunities multiply as they are seized." ),
(      50, "Education's purpose is to replace an empty mind with an open one." ),
(      51, "Always do right, this will gratify some and astonish the rest." ),
(      52, "Setting out well is a quarter of the journey." ),
(      53, "Don't look back. Something might be gaining on you." ),
(      54, "The artist is nothing without the gift, but the gift is nothing without the work." ),
(      55, "Time is the longest distance between two places." ),
(      56, "At times I think and at times I am." ),
(      57, "The best way to predict the future is to invent it." ),
(      58, "The water that is past cannot make the mill go." ),
(      59, "It's better to ask some of the questions than to know all the answers." ),
(      60, "Our deeds determine us as much as we determine our deeds." ),
(      61, "If you come to a fork in the road, take it." ),
(      62, "That which the fool does in the end, the wise man does in the beginning." ),
(      63, "Injustice anywhere is a threat to justice everywhere." ),
(      64, "Why do you need two coats when you have only one back? -Gypsy proverb" ),
(      65, "Learning is weightless treasure you always carry easy. -Chinese proverb" ),
(      66, "Chance comes to everybody. Only those who are slow to acknowledge chance complain that life is unfair. -Maurice Chevalier" ),
(      67, "There are too many sad things in this world. Don't walk away from the happy ones." ),
(      68, "No road to happiness or sorrow... find them in yourself. -Chinese proverb" ),
(      69, "I love deadlines. I like the whooshing sound they make as they fly by. -Douglas Adams" ),
(      70, "Each and every one of us has a right to be exactly who we are." ),
(      71, "I like to see a man pround on a place in which he lives. -A. Lincoln" ),
(      72, "Chance favors the prepared mind. -Louis Pasteur (attributed)" ),
(      73, "You never get a second chance to make a first impression." ),
(      74, "Lead me not into temptation, I can find it myself." ),
(      75, "To dream of a person you would like to be is to waste the person you are." ),
(      76, "Don't leave the job to the other guy. How do you know he'll even try?" ),
(      77, "It is not enough to have a good mind. The main thing is to use it well. -Ren Descartes" ),
(      78, "Don't ask me what I want to express with my pictures, ask yourself, what they mean to you! -Michael Quack" ),
(      79, "Life is short, live long. -from Rick Starr" ),
(      80, "The Earth Is But One Country And Mankind Its Citizens -Bah'u'llh" ),
(      81, "Time is a great teacher, but unfortunately it kills all its pupils. -Hector Berlioz" ),
(      82, "Animals do not smoke, drink nor take drugs - except in laboratories." ),
(      83, "Open seven days a week, excluding Sundays! -Sign on a K.F.C. store" ),
(      84, "Either you give me what I demand or I'll take what you're offering! -Joe Torre" ),
(      85, "A bank is a place where you can lend money if you can prove you don't need it. Unknown, 1995" ),
(      86, "Opinions expressed here are mine and not those of my employer. And if you don't agree with them, you are racist, sexist, elitist, imperialist, Baptist, and possibly even right." ),
(      87, "The only thing you need to know about a country is whether people are trying to get in, or get out. -Louis Rukeiser" ),
(      88, "We must not fear daylight just because it almost always illuminates a miserable world. -Ren Magritte" ),
(      89, "There is only one smartest dog in the world, and everybody has it!" ),
(      90, "If you ain't the lead dog, the scenery never changes. -Lewis Grizzard" ),
(      91, "He who sweats more in peace, bleeds less in war." ),
(      92, "Always forgive your enemies. That's what they hate most." ),
(      93, "What comes around goes around." ),
(      94, "What 'exists' is only a small part of what is 'possible'. -Pere Alberch" ),
(      95, "Do not let big ambitions overshadow small successes." ),
(      96, "Since I am convinced That Reality is in no way Real, How am I to admit That dreams are dreams? Tanka by Saigyo Hoshi [1118-1190 AD]" ),
(      97, "In art, the hand can never execute anything higher than the heart can inspire. -Ralph Waldo Emerson" ),
(      98, "A louse I used to know told me that millionaires and bums taste much the same to him. -archie the cockroach - via don marquis" ),
(      99, "Yesterday is History, tomorrow is a Mystery, today is a Gift, that's why it's called 'The Present'  ...  Carpe Diem !" ),
(     100, "A mind stretched by a new idea never goes back to its original dimensions." ),
(     101, "That which is beautiful is not always good. But that which is good is always beautiful." ),
(     102, "To love and win is the best thing in the world. To love and lose is the second best one." ),
(     103, "Only two kinds of people complain about taxes - men and women." ),
(     104, "He who has a thing to sell And goes and wishes in a well Will not as likely get the dollars As he who climbs a tree and hollars." ),
(     105, "Sooner or later, everyone stops smoking." ),
(     106, "I hear and I forget. I see and I remember. I do and I understand. -Confucius" ),
(     107, "We are each of us angels with but one wing, and can only fly by embracing each other. -Luciano Decrescenzo" ),
(     108, "Even when the heart's stopped beating, it is still bleeding." ),
(     109, "It's not an optical illusion, it just looks like one." ),
(     110, "There are no explanations for human evil. Only excuses. -Dean Koontz" ),
(     111, "A proverb is a short sentence based on long experience. -Miguel de Cervantes" ),
(     112, "You become successful the moment you start moving toward a worthwhile goal." ),
(     113, "Unless you try to do something beyond what you have already mastered, you will never grow." ),
(     114, "Many times the difference between failure and success is doing something nearly right... or doing it exactly right." ),
(     115, "You'll always miss 100% of the shots you don't take." ),
(     116, "There is an island of opportunity in the middle of every difficulty." ),
(     117, "There are many things in life that will catch your eye, but only a few will catch your heart... pursue those." ),
(     118, "Countless, unseen details are often the only difference between mediocre and magnificent." ),
(     119, "Never doubt that a small group of thoughtful, committed people can change the world. Indeed, it is the only thing that ever has." ),
(     120, "In raising your children spend half as much money and twice as much time." ),
(     121, "We make a living by what we get; we make a life by what we give." ),
(     122, "At the end of reasons comes persuasion. -Ludwig Wittgenstein" ),
(     123, "Anyone can hold the helm when the sea is calm. -Publilius Syrus" ),
(     124, "Imagination is more important than knowledge. -Albert Einstein" ),
(     125, "Blessed are they who can laugh at themselves, for they shall never cease to be amused." ),
(     126, "It isn't procrastination if you put it off right away." ),
(     127, "I can explain it for you, but I can't understand it for you." ),
(     128, "Dear Sir, thank you so much for lending me the vacuum cleaner. It really sucks." ),
(     129, "Last year I went fishing with Salvador Dali. He was using a dotted line. He caught every other fish. -dto" ),
(     130, "You can't have everything. Where would you put it? -dto" ),
(     131, "On a gas station in the desert: Fill up here! Next gas station is only fata morgana." ),
(     132, "Never go to a doctor whose office plants have died. -Erma Bombeck" ),
(     133, "I respect faith, but doubt is what gets you an education. -Wilson Mizner" ),
(     134, "When money talks, nobody notices what grammar it uses." ),
(     135, "If you don't learn to laugh at troubles, you won't have anything to laugh at when you grow old. -Ed Howe" ),
(     136, "Believe those who are seeking the truth. Doubt those who find it. -Andre Gide" ),
(     137, "Never try to teach a pig to sing; you'll frustrate yourself and annoy the pig." ),
(     138, "When your dreams turn to dust, vacuum." ),
(     139, "My ambition is to live forever - so far so good!" ),
(     140, "If you keep your feet firmly on the ground, you'll have trouble putting on your pants." ),
(     141, "What if this weren't a hypothetical question?" ),
(     142, "He who knows little quickly tells it. -Italian proverb" ),
(     143, "In just two days, tomorrow will be yesterday." ),
(     144, "Why is there an expiration date on a sour cream container?" ),
(     145, "Life is cheap. It's the accessories that kill you." ),
(     146, "Assumption is the mother of all screw-ups. -Wethern's law" ),
(     147, "You're never too old to learn something stupid." ),
(     148, "A Smith&Wesson *always* beats 4 aces." ),
(     149, "If you cannot get what you like, why not try to like what you get?" ),
(     150, "I think animal testing is a terrible idea; they get all nervous and give the wrong answers." ),
(     151, "Give some people an inch and they think they are rulers." ),
(     152, "The greatest lesson in life is to know that even fools are right sometimes. -Winston Churchill" ),
(     153, "It is better to remain silent and be thought a fool than to speak and remove all doubt. -Socrates, Lincoln, Twain" ),
(     154, "Men marry women hoping they won't change; women marry men hoping they will." ),
(     155, "Little boy's prayer: God bless Mother and Daddy, my brother and sister, and God, do take care of yourself because if anything happens to you, we're all sunk." ),
(     156, "Dogs have so many friends because they wag their tails, not their tongues." ),
(     157, "Sitting still and wishing Made no person great; The good Lord sends the fishing, but you must dig the bait." ),
(     158, "Opportunity knocks only once, but temptation bangs on your door for years." ),
(     159, "Some minds are like concrete: thoroughly mixed up and permanently set. - Denny J. Brake" ),
(     160, "Trouble knocked on the door, but, hearing laughter, hurried away. -Benjamin Franklin" ),
(     161, "Imagination was given to man to compensate him for what he is not; a sense of humor to console him for what he is. -Francis Bacon" ),
(     162, "The monuments of wit survive the monuments of power. -Francis Bacon" ),
(     163, "Joy comes not to him who seeks it for himself, but to him whoo seeks it for other people. -H. W. Sylvester" ),
(     164, "Education makes people easy to lead, but difficult to drive; easy to govern but impossible to enslave. -Henry Peter Brougham" ),
(     165, "Don't argue with someone whose neck is bigger than your head." ),
(     166, "At our local restaurant, you can eat dirt cheap - but who wants to eat dirt?" ),
(     167, "I married Miss Right. I just didn't know her first name was Always." ),
(     168, "Don't take the wrong side in an argument just because your opponent has taken the right side. -Baltasar Gracian" ),
(     169, "An honest politician is one who, when he is bought, will stay bought. -Simon Cameron" ),
(     170, "Fiction is obliged to stick to possibilities. Truth isn't. -Mark Twain" ),
(     171, "Don't worry about the world coming to an end today. It's already tomorrow in Australia. -Charles Schultz" ),
(     172, "Random number generation is too important to be left to chance." ),
(     173, "Everybody will accept your ideas much more readily if you tell them Benjamin Franklin said that first." ),
(     174, "What we cannot speak about we must pass over in silence." ),
(     175, "Keep your words sweet! You never know when you will have to eat them!" ),
(     176, "The future belongs to those who believe in the beauty of their dreams. -Eleanor Roosevelt" ),
(     177, "Chicken is an egg's way of producing more eggs." ),
(     178, "Enough research will tend to support your theory." ),
(     179, "Someone who thinks logically is a nice contrast to the real world." ),
(     180, "I've gotta be me - everyone else is already taken." ),
(     181, "If you don't know where you're going, any road will take you there." ),
(     182, "I think therefore I am... I think." ),
(     183, "The future ain't what it used to be. -Yogi Berra" ),
(     184, "In a country of free speech, why are there phone bills?" ),
(     185, "There cannot be a crisis today. My schedule is already full." ),
(     186, "Do not judge your friend until you stand in his place." ),
(     187, "He who sows courtesy reaps friendship, and he who plants kindness gathers love." ),
(     188, "To love is virtually to know; to know is not virtually to love." ),
(     189, "Real friends are those who, when you've made a fool of yourself, don't feel that you've done a permanent job." ),
(     190, "Only those who have to do simple things perfectly will acquire the skill to do difficult things easily. -Johann Schiller" ),
(     191, "The more you use your brain, the more brain you will have to use. -George A. Dorsey" ),
(     192, "A mother is not a person to lean on, but a person to make leaning unnecessary. -Dorothy Fisher" ),
(     193, "In prosperity, prepare for a change. In adversity, hope for one. -James Burgh" ),
(     194, "The hardest work in the world is that which should have been done yesterday." ),
(     195, "Don't be afraid to take a big step if one is indicated. You can't cross a chasm in two small steps. -David Lloyd George" ),
(     196, "There is this paradox in pride - it makes some men ridiculous, but prevents others from becoming so. -C. C. Colton" ),
(     197, "Originality is simply a pair of fresh eyes. -Thomas Wentworth Higginson" ),
(     198, "There is no meaning to life except the meaning man gives his life by unfolding his powers. -Erich Fromm" ),
(     199, "Prayer doesn't change things. It changes people and they change things." ),
(     200, "There are many men whose tongues might govern multitudes if they could govern their tongues. -George D. Prentice" ),
(     201, "Mankind's worst enemy is fear of work." ),
(     202, "He is the richest who is content with the least. -Socrates" ),
(     203, "Beware of the man who knows the answer before he understands the question." ),
(     204, "I quote others only to better express myself. -Michel de Montaigne" ),
(     205, "Enjoy present pleasures in such a way as not to injure future ones. -Seneca" ),
(     206, "You get the best out of others when you get the best out of yourself." ),
(     207, "Man is the only animal for whom his own existence is a problem which he has to solve. -Erich Fromm" ),
(     208, "Today is the tomorrow you worried about yesterday." ),
(     209, "Opinion is that exercise of the human will which helps us to make a decision without information. -John Erskine" ),
(     210, "The honest poor can sometimes forget poverty. The honest rich can never forget it. -Gilbert Keith Chesterton" ),
(     211, "If someone offers to furnish a sure test, ask what the test was which made the sure test sure." ),
(     212, "Criticizing another's garden doesn't keep the weeds out of your own." ),
(     213, "There are two kinds of men who never amount to very much: Those who cannot do what they are told, and those who can do nothing else. -Cyrus H.K. Curtis" ),
(     214, "You don't drown by falling in the water; you drown by staying there. -Edwin Louis Cole" ),
(     215, "A conceited person never gets anywhere because he thinks he is already there." ),
(     216, "Never cut what can be untied." ),
(     217, "Proverbs are like butterflies, some are caught, some fly away." ),
(     218, "Of evil grain, no good seed can come." ),
(     219, "Words hurt more than swords." ),
(     220, "Don't bite off more than you can chew." ),
(     221, "When the itch is inside the boot, scratching outside provides littleconsolation. -Chinese proverb" ),
(     222, "My dog is worried about the economy because Alpo is up to 99 cents a can. That's almost $7.00 in dog money. -Joe Weinstein" ),
(     223, "Keep away from people who try to belittle your ambitions. Small people always do that, but the really great make you feel that you, too, can become great. -Mark Twain" ),
(     224, "No furniture is so charming as books. -Sydney Smith" ),
(     225, "It took me fifteen years to discover that I had no talent for writing, but I couldn't give it up because by that time I was too famous. -Robert Benchley" ),
(     226, "Murder is a crime. Writing about it isn't. Sex is not a crime, but writing about it is. Why? -Larry Flynt" ),
(     227, "An unbreakable toy is useful for breaking other toys!" ),
(     228, "You can only be young once, but you can be immature forever." ),
(     229, "Cleaning the house when your kids are still growing up, is like shoveling the walk before it stops snowing!" ),
(     230, "A song is not a song until it is sung. A bell is not a bell until it is rung. Love was not put here to stay. For it isn't really love, until you give it away." ),
(     231, "Experience is the best teacher, but the school fees are heavy." ),
(     232, "Trouble is only opportunity in work clothes." ),
(     233, "It's a wise husband who will buy his wife such fine china that she won't trust him to wash the dishes." ),
(     234, "Worry is like a rocking chair. It gives you something to do but it doesn't get you anywhere." ),
(     235, "Be careful of the words you say, to keep them soft & sweet. You never know from day to day which ones wou'll have to eat." ),
(     236, "An open mind leaves a chance for someone to drop a worthwhile thought in it." ),
(     237, "The smallest good deed is better than the grandest good intention." ),
(     238, "No one grows old by living; only by losing interest in living." ),
(     239, "The men who try to do something & fail are infinitely better than those who try to do nothing and succeed." ),
(     240, "Americans have more food to eat than any other people and more diets to keep them from eating it." ),
(     241, "The real act of discovery is not in finding new lands, but in seeing with new eyes. -Marcel Proust" ),
(     242, "When you are born you are crying and everyone around you is smiling. Live your life so that when you die you are smiling and everyone around you is crying." ),
(     243, "The tragedy of life doesn't lie in not reaching your goal. The tragedy lies in having no goal to reach. -Benjamin Mays" ),
(     244, "I wear my wife's eyeglasses because she wants me to see things her way. -Jayson Feinburg" ),
(     245, "The most effective way to remember your wife's birthday is to forget it once." ),
(     246, "Women will never be equal to men until they can walk down the street with a bald head and a beer gut, and still think they are beautiful." ),
(     247, "'I do' is the shortest sentence in the English language. Also the longest." ),
(     248, "And the things that we fear are a weapon to be held against us... -Rush" ),
(     249, "Time is like the snowflake that on your finger lit. It disappeared while you were thinking of what to do with it..." ),
(     250, "The best vitamin for making friends: B1." ),
(     251, "If you eat something, but no one else sees you eat it, it has no calories." ),
(     252, "It's so simple to be wise. Just think of something stupid to say and say the opposite.  -Sam Levenson" ),
(     253, "I am different from Washington; I have a higher, grander standard of principle. Washington could not lie. I can lie, but I won't. - Mark Twain" ),
(     254, "Shut up brain or I'll stab you with a q-tip! -Homer Simpson" ),
(     255, "It takes two to lie. One to lie and one to listen. -Homer Simpson" ),
(     256, "The aim of education should be to teach us rather how to think, than what to think - rather to improve our minds, so as to enable us to think for ourselves, than to load the memory with the thoughts of other men. -Bill Beattie" ),
(     257, "Not everything that can be counted counts, and not everything that counts can be counted. -Albert Einstein" ),
(     258, "You can pretend to be serious; you can't pretend to be witty. -Sacha Guitry" ),
(     259, "Reality is that which, when you stop believing in it, doesn't go away. -Philip K. Dick" ),
(     260, "Mind over matter: If you don't mind, it doesn't matter." ),
(     261, "Patriotism is your conviction that this country is superior to all other countries because you were born in it. -George Bernard Shaw" ),
(     262, "Foolproof systems don't take into account the ingenuity of fools.  -Gene Brown" ),
(     263, "Efficiency is intelligent laziness. -David Dunham" ),
(     264, "Good communication is as stimulating as black coffee, and just as hard to sleep after. -Anne Morrow Lindbergh" ),
(     265, "People generally quarrel because they cannot argue. -Gilbert K. Chesterton" ),
(     266, "You don't have to suffer to be a poet; adolescence is enough suffering for anyone. -John Ciardi" ),
(     267, "Due to recent cutbacks, the light at the end of the tunnel is turned off until further notice." ),
(     268, "We really don't have any enemies. It's just that some of our best friends are trying to kill us." ),
(     269, "Good morning is a contradiction of terms. -Garfield (by Jim Davis)" ),
(     270, "We don't stop playing because we get old... we get old because we stop playing." ),
(     271, "The devil you know beats the devil you don't." ),
(     272, "The test of literature is, I suppose, whether we ourselves live more intensely for the reading of it. -Elizabeth Drew" ),
(     273, "Friends are relatives you make for yourself. -Eustache Deschamps" ),
(     274, "He is not poor that hath not much, but he that craves much. -Thomas Fuller" ),
(     275, "The fellow who does things that count, doesn't usually stop to count them." ),
(     276, "The greater the difficulty the more glory in surmounting it. Skillful pilots gain their reputation from storms and tempests. -Epictetus" ),
(     277, "We live in deeds, not years: In thoughts not breaths; In feelings, not in figures on a dial. We should count time by heart throbs. He most lives who thinks most, feels the noblest, acts the best. -David Bailey" ),
(     278, "If Columbus had turned back, no one would have blamed him. Of course, no one would have remembered him either." ),
(     279, "I couldn't repair your brakes, so I made your horn louder." ),
(     280, "In just two days, tomorrow will be yesterday." ),
(     281, "I don't get even, I get odder." ),
(     282, "If a cluttered desk is characteristic of a cluttered mind, what does an empty desk mean?" ),
(     283, "If it isn't broken, fix it till it is." ),
(     284, "Me a skeptic? I hope you have proof." ),
(     285, "If you wish to live wisely, ignore sayings - including this one." ),
(     286, "Everyone has a right to be stupid. Some just abuse the privilege." ),
(     287, "Byron Elbows' two rules of human nature: No one is as weird as they think they are. Everyone is weirder than others think they are." ),
(     288, "Some people talk in their sleep. Lecturers talk while other people sleep. -Albert Camus" ),
(     289, "We have strange and wonderful relationship. You're strange and I'm wonderful." ),
(     290, "If it weren't for electricity we'd all be watching television by candlelight. -George Gobel" ),
(     291, "The imaginary friends I had as a kid dropped me because their friends thought I didn't exist. -Aaron Machado" ),
(     292, "I have not yet begun to procrastinate." ),
(     293, "Don't count your chickens before they cross the road. You don't get to control any outcome, only every choice you make along the way. -Stephen C Paul" ),
(     294, "The minute you settle for less than you deserve, you get even less than you settled for. -Maureen Dowd" ),
(     295, "Don't cry because it's over, smile because it happened." ),
(     296, "Lots of people are willing to die for the person they love, which is a pity, for it is a much grander thing to live for that person. -Jason Hurst" ),
(     297, "The trouble with a kitten is that eventually it becomes a cat. -Ogden Nash" ),
(     298, "Beware the fury of a patient man. -John Dryden" ),
(     299, "You can have everything in life you want if you will only help enough other people get what they want. -Zig Ziglar" ),
(     300, "One man with courage makes a majority. -Andrew Jackson" ),
(     301, "The greatest trick the devil ever pulled, was making everyone believe it didn't exist!" ),
(     302, "If you tell the truth, you don't have to remember anything. -Mark Twain" ),
(     303, "The secret of staying young is to live honestly, eat slowly, and lie about your age. -Lucille Ball" ),
(     304, "We are living in a world today where lemonade is made from artificial flavors and furniture polish is made from real lemons. -Alfred E. Newman" ),
(     305, "I was a vegetarian until I started leaning toward the sunlight. -Rita Rudner" ),
(     306, "My doctor told me to stop having intimate dinners for four. Unless there are three other people. -Orson Welles" ),
(     307, "A nickel will get you on the subway, but garlic will get you a seat. -old New York proverb" ),
(     308, "You've got to do your own growing, no matter how tall your grandfather was. -Irish proverb" ),
(     309, "I want to get a tattoo of myself on my entire body, only 2' taller. -Steven Wright" ),
(     310, "One does evil enough when one does nothing good. -German Proverb" ),
(     311, "Things equal out pretty well. Our dreams seldom come true, but then neither do our nightmares. -Charles Kennedy" ),
(     312, "A pessimist is one who makes difficulties of his opportunities and an optimist is one who makes opportunities of his difficulties. -Harry Truman" ),
(     313, "Have you ever noticed? Anybody going slower than you is an idiot, and anyone going faster than you is a maniac. -George Carlin" ),
(     314, "I'm not into working out. My philosophy: No pain, no pain. -Carol Leifer" ),
(     315, "I'm desperately trying to figure out why kamikaze pilots wore helmets. -Dave Edison" ),
(     316, "Anytime four New Yorkers get into a cab together without arguing, a bank robbery has just taken place. -Johnny Carson" ),
(     317, "The statistics on sanity are that one out of every four Americans is suffering from some form of mental illness. Think of your three best friends. If they are okay, then it's you. -Rita Mae Brown" ),
(     318, "I always wanted to be somebody, but I guess I should have been more specific. -Lily Tomlin" ),
(     319, "When we look into another's soul, we see ourselves reflected there. -Virginia Morrigan" ),
(     320, "He who binds himself to a joy, doth the winged life destroy. He who kisses the joy as it flys, live in eternity's sunrise. -William Blake" ),
(     321, "One person with a belief is equal to a force of ninety-nine with only interests. -John Stuart Mill" ),
(     322, "The future is like a corridor into which we can only see by the light coming from behind. -Edward Weyer Jr" ),
(     323, "Our scientific power has outrun our spiritual power. We have guided missiles and misguided men. -Martin Luther King, Jr." ),
(     324, "Pessimists have already begun to worry about what is going to replace automation. -John Tudor" ),
(     325, "Proverbs are mental gems gathered in the diamond districts of the mind. -W. R. Alger" ),
(     326, "What time hath scanted men in hair, he hath given them in wit. -William Shakespeare" ),
(     327, "Computers are useless. They can only give you answers. -Pablo Picasso" ),
(     328, "A single sunbeam is enough to drive away many shadows. -St. Francis of Assisi" ),
(     329, "Ideas must work through the brains and the arms of good and brave men, or they are no better than dreams. -Emerson" ),
(     330, "A man who wants to lead the orchestra must turn his back on the crowd. -James Crook" ),
(     331, "In the mountains of truth you never climb in vain. -Friedrich Nietzsche" ),
(     332, "Formal education will earn you a living, self-education will make you a fortune." ),
(     333, "If you want to feel rich, just count the things you have that money can't buy." ),
(     334, "Don't walk behind me, I may not lead. Don't walk in front of me, I may not follow. Just walk beside me and be my friend." ),
(     335, "Friends are flowers that never fade." ),
(     336, "How paramount the future is to the present when one is surrounded by children. -Charles Darwin" ),
(     337, "If you have not often felt the joy of doing a kind act, you have neglected much, and most of all yourself. -A. Neilen" ),
(     338, "That which you cannot give away, you do not possess. It possesses you. -Ivern Ball" ),
(     339, "Now and then it's good to pause in our pursuit of happiness and just be happy." ),
(     340, "The most valuable of all talents is that of never using two words when one will do. -Thomas Jefferson" ),
(     341, "Age is a question of mind over matter. If you don't mind, it doesn't matter. -Satchel Paige" ),
(     342, "To be successful, the first thing to do is fall in love with your work. -Mary Lauretta" ),
(     343, "The only honest measure of your success is what you are doing compared to your true potential. -Paul J. Meyer" ),
(     344, "Love is a deep well from which you may drink often, but into which you may fall but once. -Ellye Howell Glover" ),
(     345, "The probability that we may fail in the struggle ought not to deter us from the support of a cause we believe to be just. -Abraham Lincoln" ),
(     346, "The person who has lived the most is not the one who has lived the longest, but the one with the richest experiences. -Jean Jacques Rousseau" ),
(     347, "True friendship is like sound health; the value of it is seldom known until it is lost. -Charles Caleb Colton" ),
(     348, "Happy is he who dares courageously to defend what he loves. -Ovid" ),
(     349, "Education makes a people easy to lead, but difficult to drive; easy to govern, but impossible to enslave. -Lord Brougham" ),
(     350, "A dog with two homes is never any good. -Irish proverb" ),
(     351, "All things are possible until they are proved impossible - and even the impossible may only be so, as of now. -Pearl S. Buck" ),
(     352, "It is well to remember that the entire universe, with one trifling exception, is composed of others. -John Andrew Holmes" ),
(     353, "Never buy through your ears but through your eyes. -Irish proverb" ),
(     354, "Always and never are two words you should always remember never to use. -Wendell Johnson" ),
(     355, "Everyone is nice till the cow gets into the garden. -Irish proverb" ),
(     356, "The only true gift is a portion of yourself. -Ralph Waldo Emerson" ),
(     357, "The intelligent man is one who has successfully fulfilled many accomplishments, and is yet willing to learn more. -Ed Parker" ),
(     358, "Forget love, I'd rather fall in chocolate." ),
(     359, "The best horse doesn't always win the race. -Irish proverb" ),
(     360, "Motivation is like food for the brain. You cannot get enough in one sitting. It needs continual and regular top up's. -Peter Davies" ),
(     361, "Time is neutral and does not change things. With courage and initiative, leaders change things. -Jesse Jackson" ),
(     362, "It's better to be prepared for an opportunity and not have one than to have an opportunity and not be prepared. -Whitney Young" ),
(     363, "The fate of love is that it always seems too little or too much. -Amelia Barr" ),
(     364, "In prosperity our friends know us; in adversity we know our friends. -John Churton Collins" ),
(     365, "There is no psychiatrist in the world like a puppy licking your face. -Ben Williams" ),
(     366, "Life begins when a person first realizes how soon it will end. -Marcelene Cox" ),
(     367, "Millions saw the apple fall, but Newton was the one who asked why. -Bernard M. Baruch" ),
(     368, "Two dogs fight for a bone and a third runs away with it." ),
(     369, "A penny saved is a penny earned." ),
(     370, "He that would eat the kernel must crack the nut." ),
(     371, "Make hay while the sun shines." ),
(     372, "Do not halloo till you are out of the wood." ),
(     373, "Sweep before your own door first." ),
(     374, "A tree is known by its fruit." ),
(     375, "Birds of a feather flock together." ),
(     376, "One swallow doesn't make a summer." ),
(     377, "Learn to walk before you run." ),
(     378, "Don't cry before you are hurt." ),
(     379, "Brevity is the soul of wit." ),
(     380, "He who laughs last, laughs best." ),
(     381, "Four eyes see more than two." ),
(     382, "All men are not cast in the same mould." ),
(     383, "Two wrongs don't make a right." ),
(     384, "Once bitten, twice shy." ),
(     385, "Curses like chicken come home to roost." ),
(     386, "He who digs a pit for others, falls in himself." ),
(     387, "Who keeps company with wolves will learn to howl." ),
(     388, "He should have a long spoon who sups with the devil." ),
(     389, "Who gathers thistles, may expect pricks." ),
(     390, "He who pays the piper, calls the tune." ),
(     391, "A bad workman blames his tools." ),
(     392, "One good turn deserves another." ),
(     393, "Opportunity makes the thief." ),
(     394, "A drowning man will catch a straw." ),
(     395, "Better joy in a cottage than sorrow in a palace." ),
(     396, "Who loves to roam may lose his home." ),
(     397, "You can't make an omelet without breaking the eggs." ),
(     398, "As the call, so the echo." ),
(     399, "As you brew, so must you drink." ),
(     400, "Hope is a good breakfast but a bad supper." ),
(     401, "Prevention is better than cure." ),
(     402, "The end crowns the work." ),
(     403, "Teaching kids to count is fine, but teaching kids what counts is best. -Bob Talbert" ),
(     404, "Error of opinion may be tolerated where reason is left free to combat it. -Thomas Jefferson" ),
(     405, "The greatest way to live with honor in this world is to be what we pretend to be." ),
(     406, "Life is ours to be spent, not to be saved. - David Herbert Lawrence" ),
(     407, "Success in marriage is much more than finding the right person; it is a matter of being the right person." ),
(     408, "Just think how happy you'd be if you lost everything you have right now--and then got it back again." ),
(     409, "Where the pupil is willing; the teachers will appear." ),
(     410, "If a man empties his purse into his head, no one can take it away from him. An investment of knowledge always pays the best interest. -Benjamin Franklin" ),
(     411, "We can easily forgive a child who is afraid of the dark. The real tragedy of life is when men are afraid of the light. -Plato" ),
(     412, "Computers are useless. They can only give you answers. -Pablo Picasso" ),
(     413, "Blessed is he who expects nothing, for he shall never be disappointed. -Alexander Pope" ),
(     414, "Life's like driving a car at night. You never see further than your headlights, but you can make the whole trip that way. -E. L. Doctorow" ),
(     415, "At the Day of Judgment, we shall not be asked what we have read, but what we have done. -Thomas a Kempis" ),
(     416, "History is a gallery of pictures in which there are few originals and many copies. -Alexis de Tocqueville" ),
(     417, "We could never learn to be brave and patient, if there were only joy in the world. -Helen Keller" ),
(     418, "Money is a singular thing. It ranks with love as man's greatest source of joy and with death as his greatest source of anxiety. -John Kenneth Galbraith" ),
(     419, "If you have built castles in the air, your work need not be lost; that is where they should be. Now put the foundations under them. -Henry David Thoreau" ),
(     420, "A cloudy day is no match for a sunny disposition. -William Arthur Ward" ),
(     421, "If you think you are too small to be effective, you have never been in bed with a mosquito. -Bette Reeves" ),
(     422, "Life shrinks or expands in proportion to one's courage. -Anais Nin" ),
(     423, "Quotation is a serviceable substitute for wit. -Oscar Wilde" ),
(     424, "When a thing has been said and said well, have no scruples. Take it and copy it. -Mark Twain" ),
(     425, "We all know that art is not truth. Art is a lie that makes us realize the truth. -Pablo Picasso" ),
(     426, "Books are good enough in their own way, but they are a poor substitute for life. -Robert Louis Stevenson" ),
(     427, "Coffee has two virtues: it is wet and warm. -Dutch Proverb" ),
(     428, "Words ought to be a little wild for they are the assaults of thought on the unthinking. -John Maynard Keynes" ),
(     429, "Each of us literally chooses, by his way of attending to things, what sort of universe he shall appear to himself to inhabit. -William James" ),
(     430, "Asked to explain Zen - my puppy with the same name looks, and thumps his tail. -Jay Hackett" ),
(     431, "The truth knocks on the door and you say, 'Go away, I'm looking for the truth,' and so it goes away. Puzzling. -Robert M. Pirsig" ),
(     432, "The most beautiful things are those that madness prompts and reason writes. -Andre Gide" ),
(     433, "I am as my creator made me and since He is satisfied, so am I. -Minnie Smith" ),
(     434, "Dream as if you'll live forever, live as if you'll die today." ),
(     435, "Some roads aren't meant to be travelled alone." ),
(     436, "Look at everything as though you were seeing it either for the first or last time. -Betty Smith" ),
(     437, "True artists are almost the only men who do their work for pleasure. -Auguste Rodin" ),
(     438, "The amount of sleep required by the average person is about five minutes more. -Wilson Mizener" ),
(     439, "Education is what survives when what has been learned has been forgotten. -B. F. Skinner" ),
(     440, "Wise sayings often fall on barren ground; but a kind word is never thrown away. -Arthur Helps" ),
(     441, "As long as you live, keep learning how to live. -Seneca" ),
(     442, "It took me four years to paint like Raphael, but a lifetime to paint like a child. -Pablo Picasso" ),
(     443, "There are two lasting bequests we can give our children: one is roots. The other is wings. -Hodding Carter, Jr." ),
(     444, "It goes without saying that you should never have more children than you have car windows. -Erma Bombeck" ),
(     445, "Egotist:  A person more interested in himself than in me. -Ambrose Bierce" ),
(     446, "Editor:  One who sorts the wheat from the chaff and prints the chaff. -Adlai Stevenson" ),
(     447, "Life is like a box of chocolates...You never know what you're gonna get. -Forrest Gump" ),
(     448, "The U.S. Constitution doesn't guarantee happiness, only the pursuit of it. You have to catch up with it yourself. -Benjamin Franklin" ),
(     449, "An ounce of prevention is worth a pound of cure." ),
(     450, "Success is not the result of spontaneous combustion. You must set yourself on fire. -Reggie Leach" ),
(     451, "Happy is the man who knows what to remember of the past, what to enjoy in the present, and what to plan for the future. -A. Gibson" ),
(     452, "There is more faith in an honest doubt, believe me, than in half the creeds. -Alfred, Lord Tennyson" ),
(     453, "Children are natural Zen masters; their world is brand new in each and every moment. -John Bradshaw" ),
(     454, "The only Zen you find on the tops of mountains is the Zen you bring up there. -Robert M. Pirsig" ),
(     455, "Bad officials are elected by good citizens who do not vote. -George Jean Nathan" ),
(     456, "A bargain is something you cannot use at a price you cannot resist." ),
(     457, "A bus is a vehicle that runs twice as fast when you are after it as when you are in it." ),
(     458, "A city is a large community where people are lonesome together." ),
(     459, "A clean tie attracts the soup of the day." ),
(     460, "A closed mind is a good thing to lose." ),
(     461, "A closed mind is like a closed book; just a block of wood. -Chinese proverb" ),
(     462, "A Committee is a group of people who individually can do nothing, but as a group decide that nothing can be done." ),
(     463, "A diet is a selection of food that makes other people lose weight." ),
(     464, "Quotation is a serviceable substitute for wit. -Oscar Wilde" ),
(     465, "Some men go through a forest and see no firewood. -English proverb" ),
(     466, "The successful people are the ones who can think up stuff for the rest of the world to keep busy at. -Don Marquis" ),
(     467, "We must either find a way or make one. -Hannibal" ),
(     468, "A person who walks in another's tracks leaves no footprints." ),
(     469, "One sees great things from the valley, only small things from the peak. -G. K. Chesterton" ),
(     470, "Common sense is the collection of prejudices acquired by the age of eighteen. -Albert Einstein" ),
(     471, "What is originality? Undetected plagiarism. -William R. Inge" ),
(     472, "The true test of character is not how much we know how to do, but how we behave when we don't know what to do. -John Holt" ),
(     473, "The tyrant dies and his rule is over, the martyr dies and his rule begins. -Soren Kierkegaard" ),
(     474, "Success is not the result of spontaneous combustion. You must set yourself on fire. -Reggie Leach" ),
(     475, "There is no exercise better for the heart than reaching down and lifting people up." );

# ################################################################
# EOF: UTCMS_quot.sql
# ################################################################
